/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.discovery.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import jp.sourceforge.tsukuyomi.openid.discovery.Discovery;
import jp.sourceforge.tsukuyomi.openid.discovery.DiscoveryException;
import jp.sourceforge.tsukuyomi.openid.discovery.DiscoveryInformation;
import jp.sourceforge.tsukuyomi.openid.discovery.HtmlResolver;
import jp.sourceforge.tsukuyomi.openid.discovery.HtmlResult;
import jp.sourceforge.tsukuyomi.openid.discovery.Identifier;
import jp.sourceforge.tsukuyomi.openid.discovery.IdentifierException;
import jp.sourceforge.tsukuyomi.openid.discovery.IdentifierParser;
import jp.sourceforge.tsukuyomi.openid.discovery.UrlIdentifier;
import jp.sourceforge.tsukuyomi.openid.discovery.XriIdentifier;
import jp.sourceforge.tsukuyomi.openid.yadis.YadisResolver;
import jp.sourceforge.tsukuyomi.openid.yadis.YadisResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.resolve.Resolver;
import org.openxri.resolve.ResolverState;
import org.openxri.resolve.TrustType;
import org.openxri.resolve.exception.PartialResolutionException;
import org.openxri.xml.CanonicalID;
import org.openxri.xml.SEPType;
import org.openxri.xml.SEPUri;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryImpl
implements Discovery {
    private static final Log LOG = LogFactory.getLog(DiscoveryImpl.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private Resolver xriResolver = new Resolver();
    private YadisResolver yadisResolver;
    private HtmlResolver htmlResolver;

    @Override
    public List<DiscoveryInformation> discover(Identifier identifier) throws DiscoveryException, IdentifierException {
        List<Object> result = new ArrayList();
        if (identifier instanceof XriIdentifier) {
            LOG.info((Object)("Starting discovery on XRI identifier: " + identifier));
            XriIdentifier xriIdentifier = (XriIdentifier)identifier;
            try {
                TrustType trustAll = new TrustType("none");
                XRDS xrds = this.xriResolver.resolveAuthToXRDS(xriIdentifier.getXriIdentifier(), trustAll, true, new ResolverState());
                if (DEBUG) {
                    LOG.debug((Object)("Retrieved XRDS:\n" + xrds.dump()));
                }
                XRD xrd = xrds.getFinalXRD();
                CanonicalID canonical = xrd.getCanonicalidAt(0);
                if (this.isProviderAuthoritative(xrd.getProviderID(), canonical)) {
                    LOG.info((Object)("XRI resolution succeeded on " + identifier));
                    result = DiscoveryImpl.extractDiscoveryInformation(xrds, (XriIdentifier)identifier, this.xriResolver);
                }
                LOG.warn((Object)"ProviderID is not authoritative for the CanonicalID. Returning empty discovery result set.");
            }
            catch (Exception e) {
                throw new DiscoveryException("Cannot resolve XRI: " + identifier.toString(), e);
            }
        } else if (identifier instanceof UrlIdentifier) {
            LOG.info((Object)("Starting discovery on URL identifier: " + identifier));
            UrlIdentifier urlId = (UrlIdentifier)identifier;
            YadisResult yadis = this.yadisResolver.discover(urlId.getUrl().toString());
            if (0 == yadis.getStatus()) {
                LOG.info((Object)("Using Yadis normalized URL as claimedID: " + yadis.getNormalizedUrl()));
                result = DiscoveryImpl.extractDiscoveryInformation(yadis.getXrds(), new UrlIdentifier(yadis.getNormalizedUrl()));
            }
            if (result.size() == 0) {
                LOG.info((Object)"No OpenID service endpoints discovered through Yadis; attempting HTML discovery...");
                result = this.extractDiscoveryInformation(this.htmlResolver.discover(urlId));
            }
        } else {
            throw new DiscoveryException("Unknown identifier type: " + identifier.toString());
        }
        LOG.info((Object)("Discovered " + result.size() + " OpenID endpoints."));
        return result;
    }

    private List<DiscoveryInformation> extractDiscoveryInformation(HtmlResult htmlResult) throws DiscoveryException {
        DiscoveryInformation extracted;
        ArrayList<DiscoveryInformation> htmlList = new ArrayList<DiscoveryInformation>();
        if (htmlResult.getIdp2Endpoint() != null) {
            extracted = new DiscoveryInformation(htmlResult.getIdp2Endpoint(), htmlResult.getClaimedId(), htmlResult.getDelegate2(), "http://specs.openid.net/auth/2.0/signon");
            if (DEBUG) {
                LOG.debug((Object)("OpenID2-signon HTML discovery endpoint: " + extracted));
            }
            htmlList.add(extracted);
        }
        if (htmlResult.getIdp1Endpoint() != null) {
            extracted = new DiscoveryInformation(htmlResult.getIdp1Endpoint(), htmlResult.getClaimedId(), htmlResult.getDelegate1(), "http://openid.net/signon/1.1");
            if (DEBUG) {
                LOG.debug((Object)("OpenID1-signon HTML discovery endpoint: " + extracted));
            }
            htmlList.add(extracted);
        }
        return htmlList;
    }

    private boolean isProviderAuthoritative(String providerId, CanonicalID canonicalId) {
        if (canonicalId == null || canonicalId.getValue() == null) {
            return false;
        }
        String auth = canonicalId.getValue().substring(0, 1);
        XRD rootAuth = this.xriResolver.getAuthority(auth);
        if (!rootAuth.getProviderID().equals(providerId)) {
            return false;
        }
        int lastbang = canonicalId.getValue().lastIndexOf("!");
        String parent = lastbang > -1 ? canonicalId.getValue().substring(0, lastbang) : canonicalId.getValue();
        String parentNoPrefix = parent.startsWith("xri://") ? parent.substring(6) : parent;
        String providerIDNoPrefix = providerId.startsWith("xri://") ? providerId.substring(6) : providerId;
        return parentNoPrefix.equals(providerIDNoPrefix);
    }

    public static boolean extractDiscoveryInformationOpenID(Resolver xriResolver, ArrayList<DiscoveryInformation> out, XRD baseXRD, XriIdentifier identifier, String srvType, boolean wantCID) {
        try {
            XRDS tmpXRDS = xriResolver.selectServiceFromXRD(baseXRD, identifier.getXriIdentifier(), new TrustType(), srvType, null, true, new ResolverState());
            Identifier claimedIdentifier = null;
            XRD tmpXRD = tmpXRDS.getFinalXRD();
            if (wantCID) {
                CanonicalID canonID = tmpXRD.getCanonicalidAt(0);
                if (canonID == null) {
                    LOG.error((Object)("No CanonicalID found for " + srvType + " after XRI resolution of: " + identifier.getIdentifier()));
                    return false;
                }
                claimedIdentifier = IdentifierParser.parse(canonID.getValue());
                LOG.info((Object)("Using canonicalID as claimedID: " + claimedIdentifier.getIdentifier() + " for " + srvType));
            }
            for (Object s : tmpXRD.getSelectedServices().getList()) {
                Service srv = (Service)s;
                for (Object u : srv.getPrioritizedURIs()) {
                    try {
                        SEPUri sepURI = (SEPUri)u;
                        String urlString = xriResolver.constructURI(sepURI.getURI(), sepURI.getAppend(), identifier.getXriIdentifier());
                        URL opEndpointUrl = new URL(urlString);
                        DiscoveryInformation extracted = new DiscoveryInformation(opEndpointUrl, wantCID ? claimedIdentifier : null, null, srvType);
                        LOG.info((Object)("Added " + srvType + " endpoint: " + opEndpointUrl));
                        out.add(extracted);
                    }
                    catch (MalformedURLException mue) {
                        LOG.error((Object)("Error parsing URI in XRDS result for " + srvType), (Throwable)mue);
                    }
                }
            }
            return true;
        }
        catch (PartialResolutionException e) {
            LOG.error((Object)("XRI resolution failed for " + srvType), (Throwable)e);
        }
        catch (DiscoveryException e) {
            LOG.error((Object)("XRDS discovery failed for " + srvType), (Throwable)e);
        }
        catch (IdentifierException e) {
            LOG.error((Object)("XRDS discovery failed for " + srvType), (Throwable)e);
        }
        return false;
    }

    protected static List<DiscoveryInformation> extractDiscoveryInformation(XRDS xrds, Identifier identifier) throws DiscoveryException, IdentifierException {
        ArrayList<DiscoveryInformation> opSelectList = new ArrayList<DiscoveryInformation>();
        ArrayList<DiscoveryInformation> signonList = new ArrayList<DiscoveryInformation>();
        ArrayList<DiscoveryInformation> openid1 = new ArrayList<DiscoveryInformation>();
        XRD xrd = xrds.getFinalXRD();
        for (Object s : xrd.getPrioritizedServices()) {
            Service service = (Service)s;
            for (Object u : service.getPrioritizedURIs()) {
                DiscoveryInformation extracted;
                URL opEndpointUrl;
                try {
                    opEndpointUrl = ((SEPUri)u).getURI().toURL();
                }
                catch (MalformedURLException e) {
                    continue;
                }
                if (DiscoveryImpl.matchType(service, "http://specs.openid.net/auth/2.0/server")) {
                    extracted = new DiscoveryInformation(opEndpointUrl);
                    if (DEBUG) {
                        LOG.debug((Object)("OpenID2-server XRDS discovery result:\n" + extracted));
                    }
                    opSelectList.add(extracted);
                }
                if (DiscoveryImpl.matchType(service, "http://specs.openid.net/auth/2.0/signon")) {
                    Identifier claimedIdentifier = identifier;
                    CanonicalID canonicalId = xrd.getCanonicalidAt(0);
                    String providerId = xrd.getProviderID();
                    if (identifier instanceof XriIdentifier) {
                        if (canonicalId == null) {
                            throw new DiscoveryException("No CanonicalID found after XRI resolution of: " + identifier.getIdentifier());
                        }
                        if (providerId == null || providerId.length() == 0) {
                            throw new DiscoveryException("No Provider ID found after XRI resolution of: " + identifier.getIdentifier());
                        }
                        claimedIdentifier = IdentifierParser.parse(canonicalId.getValue());
                    }
                    DiscoveryInformation extracted2 = new DiscoveryInformation(opEndpointUrl, claimedIdentifier, DiscoveryImpl.getDelegate(service, false), "http://specs.openid.net/auth/2.0/signon");
                    if (DEBUG) {
                        LOG.debug((Object)("OpenID2-signon XRDS discovery result:\n" + extracted2));
                    }
                    signonList.add(extracted2);
                }
                if (!DiscoveryImpl.matchType(service, "http://openid.net/signon/1.0") && !DiscoveryImpl.matchType(service, "http://openid.net/signon/1.1")) continue;
                extracted = new DiscoveryInformation(opEndpointUrl, identifier, DiscoveryImpl.getDelegate(service, true), "http://openid.net/signon/1.1");
                if (DEBUG) {
                    LOG.debug((Object)("OpenID1-signon XRDS discovery result:\n" + extracted));
                }
                openid1.add(extracted);
            }
        }
        opSelectList.addAll(signonList);
        opSelectList.addAll(openid1);
        if (opSelectList.size() == 0) {
            LOG.info((Object)"No OpenID service types found in the XRDS.");
        }
        return opSelectList;
    }

    public static boolean matchType(Service service, String sVal) {
        for (int i = 0; i < service.getNumTypes(); ++i) {
            SEPType type = service.getTypeAt(i);
            if (!type.match(sVal)) continue;
            return true;
        }
        return false;
    }

    public static String getDelegate(Service service, boolean compatibility) {
        String nsPattern;
        String delegateTag;
        String delegate = null;
        if (compatibility) {
            delegateTag = "Delegate";
            nsPattern = "http://openid\\.net/xmlns/1\\.0";
        } else {
            delegateTag = "LocalID";
            nsPattern = "xri://\\$xrd\\*\\(\\$v\\*2\\.0\\)";
        }
        Vector delegateTags = service.getOtherTagValues(delegateTag);
        for (int i = 0; delegateTags != null && i < delegateTags.size(); ++i) {
            Element element = (Element)delegateTags.elementAt(i);
            if (!Pattern.matches(nsPattern, element.getNamespaceURI())) continue;
            delegate = element.getFirstChild().getNodeValue();
            if (!DEBUG) continue;
            LOG.debug((Object)("Found delegate: " + delegate));
        }
        return delegate;
    }

    protected static List<DiscoveryInformation> extractDiscoveryInformation(XRDS xrds, XriIdentifier identifier, Resolver xriResolver) throws DiscoveryException {
        ArrayList<DiscoveryInformation> endpoints = new ArrayList<DiscoveryInformation>();
        XRD xrd = xrds.getFinalXRD();
        DiscoveryImpl.extractDiscoveryInformationOpenID(xriResolver, endpoints, xrd, identifier, "http://specs.openid.net/auth/2.0/server", false);
        DiscoveryImpl.extractDiscoveryInformationOpenID(xriResolver, endpoints, xrd, identifier, "http://specs.openid.net/auth/2.0/signon", true);
        DiscoveryImpl.extractDiscoveryInformationOpenID(xriResolver, endpoints, xrd, identifier, "http://openid.net/signon/1.1", true);
        DiscoveryImpl.extractDiscoveryInformationOpenID(xriResolver, endpoints, xrd, identifier, "http://openid.net/signon/1.0", true);
        if (endpoints.size() == 0) {
            LOG.info((Object)"No OpenID service types found in the XRDS.");
        }
        return endpoints;
    }

    public void setYadisResolver(YadisResolver yadisResolver) {
        this.yadisResolver = yadisResolver;
    }

    public void setHtmlResolver(HtmlResolver htmlResolver) {
        this.htmlResolver = htmlResolver;
    }
}

