/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.sourceforge.tsukuyomi.openid.association.Association;
import jp.sourceforge.tsukuyomi.openid.association.AssociationException;
import jp.sourceforge.tsukuyomi.openid.discovery.DiscoveryException;
import jp.sourceforge.tsukuyomi.openid.message.Message;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.MessageExtension;
import jp.sourceforge.tsukuyomi.openid.message.Parameter;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.util.InternetDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthSuccess
extends Message {
    private static final Log LOG = LogFactory.getLog(AuthSuccess.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    protected static final List<String> REQUIRED_FIELDS = Arrays.asList("openid.mode", "openid.return_to", "openid.assoc_handle", "openid.signed", "openid.sig");
    protected static final List<String> OPTIONAL_FIELDS = Arrays.asList("openid.ns", "openid.op_endpoint", "openid.claimed_id", "openid.identity", "openid.response_nonce", "openid.invalidate_handle");
    protected static final String signRequired1 = "return_to,identity";
    protected static final String signRequired2 = "op_endpoint,claimed_id,identity,return_to,response_nonce,assoc_handle";
    protected static final String signRequired3 = "op_endpoint,return_to,response_nonce,assoc_handle";
    protected List<String> _signFields = new ArrayList<String>();
    protected List<String> _signExtensions = new ArrayList<String>();

    protected AuthSuccess(String opEndpoint, String claimedId, String delegate, boolean compatibility, String returnTo, String nonce, String invalidateHandle, Association assoc, boolean signNow) throws AssociationException {
        if (!compatibility) {
            this.set("openid.ns", "http://specs.openid.net/auth/2.0");
            this.setOpEndpoint(opEndpoint);
            this.setClaimed(claimedId);
            this.setNonce(nonce);
        }
        this.set("openid.mode", "id_res");
        this.setIdentity(delegate);
        this.setReturnTo(returnTo);
        if (invalidateHandle != null) {
            this.setInvalidateHandle(invalidateHandle);
        }
        this.setHandle(assoc.getHandle());
        this.buildSignedList();
        this.setSignature(signNow ? assoc.sign(this.getSignedText()) : "");
    }

    protected AuthSuccess(ParameterList params) {
        super(params);
    }

    public static AuthSuccess createAuthSuccess(String opEndpoint, String claimedId, String delegate, boolean compatibility, String returnTo, String nonce, String invalidateHandle, Association assoc, boolean signNow) throws MessageException, AssociationException {
        AuthSuccess resp = new AuthSuccess(opEndpoint, claimedId, delegate, compatibility, returnTo, nonce, invalidateHandle, assoc, signNow);
        if (!resp.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created positive auth response:\n" + resp.keyValueFormEncoding()));
        }
        return resp;
    }

    public static AuthSuccess createAuthSuccess(ParameterList params) throws MessageException {
        AuthSuccess resp = new AuthSuccess(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created positive auth response:\n" + resp.keyValueFormEncoding()));
        }
        return resp;
    }

    @Override
    public List<String> getRequiredFields() {
        return REQUIRED_FIELDS;
    }

    public boolean isVersion2() {
        return this.hasParameter("openid.ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("openid.ns"));
    }

    public void setMode(String mode) throws MessageException {
        if (!mode.equals("id_res") && !mode.equals("cancel")) {
            throw new MessageException("Unknown authentication mode: " + mode);
        }
        this.set("openid.mode", mode);
    }

    public String getMode() {
        return this.getParameterValue("openid.mode");
    }

    public void setOpEndpoint(String opEndpoint) {
        this.set("openid.op_endpoint", opEndpoint);
    }

    public String getOpEndpoint() {
        return this.getParameterValue("openid.op_endpoint");
    }

    public void setIdentity(String id) {
        this.set("openid.identity", id);
    }

    public String getIdentity() throws DiscoveryException {
        return this.getParameterValue("openid.identity");
    }

    public void setClaimed(String claimed) {
        this.set("openid.claimed_id", claimed);
    }

    public String getClaimed() {
        return this.getParameterValue("openid.claimed_id");
    }

    public void setReturnTo(String returnTo) {
        this.set("openid.return_to", returnTo);
        this.destinationUrl = returnTo;
    }

    public String getReturnTo() {
        return this.getParameterValue("openid.return_to");
    }

    public void setNonce(String nonce) {
        this.set("openid.response_nonce", nonce);
    }

    public String getNonce() {
        return this.getParameterValue("openid.response_nonce");
    }

    public void setInvalidateHandle(String handle) {
        this.set("openid.invalidate_handle", handle);
    }

    public String getInvalidateHandle() {
        return this.getParameterValue("openid.invalidate_handle");
    }

    public void setHandle(String handle) {
        this.set("openid.assoc_handle", handle);
    }

    public String getHandle() {
        return this.getParameterValue("openid.assoc_handle");
    }

    public void buildSignedList() {
        StringBuffer toSign = !this.isVersion2() ? new StringBuffer(signRequired1) : (this.hasParameter("openid.identity") ? new StringBuffer(signRequired2) : new StringBuffer(signRequired3));
        ArrayList<String> signList = new ArrayList<String>(Arrays.asList(toSign.toString().split(",")));
        for (String field : this._signFields) {
            if (signList.contains(field)) continue;
            toSign.append(",").append(field);
            signList.add(field);
        }
        ArrayList<String> extensionPrefixes = new ArrayList<String>();
        for (String extension : this._signExtensions) {
            String alias = this.getExtensionAlias(extension);
            if (alias == null) continue;
            extensionPrefixes.add(alias);
        }
        for (Parameter param : this.getParameters()) {
            String signName;
            int dotIndex;
            String paramName = param.getKey();
            if (!paramName.startsWith("openid.") || (dotIndex = (signName = paramName.substring(7)).indexOf(".")) <= 0 || !extensionPrefixes.contains(signName.substring(0, dotIndex)) || signList.contains(signName)) continue;
            toSign.append(",").append(signName);
            signList.add(signName);
        }
        if (DEBUG) {
            LOG.debug((Object)("Setting fields to be signed: " + toSign));
        }
        this.set("openid.signed", toSign.toString());
    }

    public void setSignFields(String userSuppliedList) {
        if (userSuppliedList != null) {
            this._signFields = Arrays.asList(userSuppliedList.split(","));
            this.buildSignedList();
        }
    }

    public void setSignExtensions(String[] extensions) {
        if (extensions != null) {
            this._signExtensions = Arrays.asList(extensions);
            this.buildSignedList();
        }
    }

    public void setSignExtension(String extensionNamespace) {
        if (!this._signExtensions.contains(extensionNamespace)) {
            this._signExtensions.add(extensionNamespace);
            this.buildSignedList();
        }
    }

    public List<String> getSignExtensions() {
        return this._signExtensions;
    }

    public void setSignature(String sig) {
        this.set("openid.sig", sig);
        if (DEBUG) {
            LOG.debug((Object)("Added signature: " + sig));
        }
    }

    public String getSignature() {
        return this.getParameterValue("openid.sig");
    }

    public String getSignList() {
        return this.getParameterValue("openid.signed");
    }

    public String getSignedText() {
        String[] signedParams;
        StringBuffer signedText = new StringBuffer("");
        for (String element : signedParams = this.getParameterValue("openid.signed").split(",")) {
            signedText.append(element);
            signedText.append(':');
            signedText.append(this.getParameterValue("openid." + element));
            signedText.append('\n');
        }
        return signedText.toString();
    }

    @Override
    public boolean isValid() {
        List<String> signedFields;
        boolean compatibility;
        if (!super.isValid()) {
            return false;
        }
        boolean bl = compatibility = !this.isVersion2();
        if (compatibility && this.hasParameter("openid.ns")) {
            LOG.warn((Object)"openid.ns should not be present in OpenID1 auth responses");
            return false;
        }
        if (!compatibility && !this.hasParameter("openid.op_endpoint")) {
            LOG.warn((Object)"openid.op_endpoint is required in OpenID auth responses");
            return false;
        }
        try {
            if (this.getReturnTo() != null) {
                new URL(this.getReturnTo());
            }
            if (this.getOpEndpoint() != null) {
                new URL(this.getOpEndpoint());
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"Error verifying auth response validity.", (Throwable)e);
            return false;
        }
        if (!"id_res".equals(this.getMode())) {
            LOG.warn((Object)("Invalid openid.mode value in auth response: " + this.getMode()));
            return false;
        }
        if (!this.hasParameter("openid.identity")) {
            if (compatibility) {
                LOG.warn((Object)"openid.identity is required in OpenID1 auth responses");
                return false;
            }
            boolean hasAuthExt = false;
            for (String typeUri : this.getExtensions()) {
                try {
                    MessageExtension extension = this.getExtension(typeUri);
                    if (!extension.providesIdentifier()) continue;
                    hasAuthExt = true;
                    break;
                }
                catch (MessageException ignore) {
                }
            }
            if (!hasAuthExt) {
                LOG.warn((Object)"no identifier specified in auth request");
                return false;
            }
            if (this.hasParameter("openid.claimed_id")) {
                LOG.warn((Object)"openid.claimed_id must be present if and only if openid.identity is present.");
                return false;
            }
        } else if (!compatibility && !this.hasParameter("openid.claimed_id")) {
            LOG.warn((Object)"openid.clamied_id must be present in OpenID2 auth responses");
            return false;
        }
        String nonce = this.getNonce();
        if (!compatibility) {
            if (nonce == null) {
                LOG.warn((Object)"openid.response_nonce is required in OpenID2 auth responses");
                return false;
            }
            InternetDateFormat _dateFormat = new InternetDateFormat();
            try {
                _dateFormat.parse(nonce.substring(0, 20));
            }
            catch (ParseException e) {
                LOG.error((Object)"Error parsing nonce in auth response.", (Throwable)e);
                return false;
            }
            if (nonce.length() > 255) {
                LOG.warn((Object)"nonce length must not exceed 255 characters");
                return false;
            }
        } else if (nonce != null) {
            LOG.warn((Object)"openid.response_nonce present in OpenID1 auth response");
        }
        if (!(signedFields = Arrays.asList(this.getParameterValue("openid.signed").split(","))).contains("return_to")) {
            LOG.warn((Object)"return_to must be signed");
            return false;
        }
        if (compatibility == signedFields.contains("response_nonce")) {
            LOG.warn((Object)"response_nonce must be present and signed only in OpenID2 auth responses");
        }
        if (compatibility == signedFields.contains("op_endpoint")) {
            LOG.warn((Object)"op_endpoint must be present and signed only in OpenID2 auth responses");
        }
        if (!compatibility && !signedFields.contains("assoc_handle")) {
            LOG.warn((Object)"assoc_handle must be signed in OpenID2 auth responses");
            return false;
        }
        if (this.hasParameter("openid.identity") && !signedFields.contains("identity")) {
            LOG.warn((Object)"openid.identity must be signed if present");
            return false;
        }
        if (this.hasParameter("openid.claimed_id") && !signedFields.contains("claimed_id")) {
            LOG.warn((Object)"openid.claimed_id must be signed if present");
            return false;
        }
        return true;
    }
}

