/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message.ax;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.Parameter;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.message.ax.AxMessage;
import jp.sourceforge.tsukuyomi.openid.message.ax.FetchRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchResponse
extends AxMessage {
    private static final Log LOG = LogFactory.getLog(FetchResponse.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();

    protected FetchResponse() {
        this.parameters.set(new Parameter("mode", "fetch_response"));
        if (DEBUG) {
            LOG.debug((Object)"Created empty fetch response.");
        }
    }

    public static FetchResponse createFetchResponse() {
        return new FetchResponse();
    }

    protected FetchResponse(ParameterList params) {
        this.parameters = params;
    }

    public static FetchResponse createFetchResponse(ParameterList params) throws MessageException {
        FetchResponse resp = new FetchResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid parameters for a fetch response");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created fetch response from parameter list:\n" + params));
        }
        return resp;
    }

    public static FetchResponse createFetchResponse(FetchRequest req, Map<String, String> userData) {
        FetchResponse resp = new FetchResponse();
        Map<String, Object> attributes = req.getAttributes();
        for (Map.Entry<String, Object> ent : attributes.entrySet()) {
            String alias = ent.getKey();
            String value = userData.get(alias);
            if (value == null) continue;
            if (value instanceof String) {
                resp.addAttribute(alias, (String)ent.getValue(), value);
                continue;
            }
            if (!(value instanceof List)) continue;
            Iterator values = ((List)((Object)value)).iterator();
            int max = req.getCount(alias);
            for (int count = 0; count < max && values.hasNext(); ++count) {
                String val = (String)values.next();
                if (val == null) {
                    --count;
                    continue;
                }
                resp.addAttribute(alias, (String)ent.getValue(), val);
            }
        }
        return resp;
    }

    public void addAttribute(String alias, String typeUri, String value) {
        int count = this.getCount(alias);
        String index = "";
        switch (count) {
            case 0: {
                this.parameters.set(new Parameter("type." + alias, typeUri));
                break;
            }
            case 1: {
                this.parameters.set(new Parameter("value." + alias + ".1", this.getParameterValue("value." + alias)));
                this.parameters.removeParameters("value." + alias);
                index = ".2";
                break;
            }
            default: {
                index = "." + Integer.toString(count + 1);
            }
        }
        this.parameters.set(new Parameter("value." + alias + index, value));
        this.setCount(alias, ++count);
        if (DEBUG) {
            LOG.debug((Object)("Added new attribute to fetch response; type: " + typeUri + " alias: " + alias + " count: " + count));
        }
    }

    public List<String> getAttributeValues(String alias) {
        ArrayList<String> values = new ArrayList<String>();
        if (!this.parameters.hasParameter("count." + alias)) {
            values.add(this.getParameterValue("value." + alias));
        } else {
            for (int i = 1; i <= this.getCount(alias); ++i) {
                values.add(this.getParameterValue("value." + alias + "." + Integer.toString(i)));
            }
        }
        return values;
    }

    public List<String> getAttributeAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        for (Parameter param : this.parameters.getParameters()) {
            String alias;
            String paramName = param.getKey();
            if (!paramName.startsWith("value.") || aliases.contains(alias = paramName.endsWith(".") ? paramName.substring(6, paramName.length() - 1) : paramName.substring(6))) continue;
            aliases.add(alias);
        }
        return aliases;
    }

    public Map<String, Object> getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (Parameter param : this.parameters.getParameters()) {
            String alias;
            String paramName = param.getKey();
            if (!paramName.startsWith("value.") || attributes.containsKey(alias = paramName.endsWith(".") ? paramName.substring(6, paramName.length() - 1) : paramName.substring(6))) continue;
            attributes.put(alias, this.getAttributeValues(alias));
        }
        return attributes;
    }

    public int getCount(String alias) {
        if (this.parameters.hasParameter("count." + alias)) {
            return Integer.parseInt(this.parameters.getParameterValue("count." + alias));
        }
        if (this.parameters.hasParameter("value." + alias)) {
            return 1;
        }
        return 0;
    }

    private void setCount(String alias, int count) {
        this.parameters.removeParameters("count." + alias);
        if (count > 1) {
            this.parameters.set(new Parameter("count." + alias, Integer.toString(count)));
        }
    }

    public void setUpdateUrl(String updateUrl) throws MessageException {
        try {
            new URL(updateUrl);
        }
        catch (MalformedURLException e) {
            throw new MessageException("Invalid update_url: " + updateUrl);
        }
        if (DEBUG) {
            LOG.debug((Object)("Setting fetch response update_url: " + updateUrl));
        }
        this.parameters.set(new Parameter("update_url", updateUrl));
    }

    public String getUpdateUrl() {
        return this.parameters.hasParameter("update_url") ? this.parameters.getParameterValue("update_url") : null;
    }

    private boolean isValid() {
        for (Parameter param : this.parameters.getParameters()) {
            String paramName = param.getKey();
            if (paramName.equals("mode") || paramName.startsWith("type.") || paramName.startsWith("count.") || paramName.startsWith("value.") || paramName.equals("update_url")) continue;
            LOG.warn((Object)("Invalid parameter name in fetch response: " + paramName));
            return false;
        }
        return this.checkAttributes();
    }

    private boolean checkAttributes() {
        for (String alias : this.getAttributeAliases()) {
            if (!this.parameters.hasParameter("type." + alias)) {
                LOG.warn((Object)("Type missing for attribute alias: " + alias));
                return false;
            }
            if (!this.parameters.hasParameter("count." + alias)) {
                if (this.parameters.hasParameter("value." + alias)) continue;
                LOG.warn((Object)("Value missing for attribute alias: " + alias));
                return false;
            }
            if (this.parameters.hasParameter("value." + alias)) {
                LOG.warn((Object)("Count parameter present for alias: " + alias + "; should use " + alias + ".[index] format"));
                return false;
            }
            int count = this.getCount(alias);
            for (int i = 1; i <= count; ++i) {
                if (this.parameters.hasParameter("value." + alias + "." + Integer.toString(i))) continue;
                LOG.warn((Object)("Value missing for alias: " + alias + "." + Integer.toString(i)));
                return false;
            }
        }
        return true;
    }
}

