/*
 * Copyright 2006-2007 Sxip Identity Corporation
 */

package jp.sourceforge.tsukuyomi.openid.rp;

import jp.sourceforge.tsukuyomi.openid.discovery.Identifier;
import jp.sourceforge.tsukuyomi.openid.message.Message;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;

/**
 * @author Marius Scurtescu, Johnny Bufu
 */
public class VerificationResult {
	/**
	 * Identifier on which authentication and verification were performed
	 * succesfully and which can be used henceforth by Relying Parties to
	 * identify the user.
	 * <p>
	 * Null if authentication or verification on the claimed identifier failed.
	 */
	private Identifier verifiedId;

	/**
	 * Optional parameter returned in a failure response to a immediate
	 * authentication request (AuthImmediateFailure).
	 */
	private String idpSetupUrl;

	/**
	 * The authentication response received from the server.
	 */
	private Message authResponse;

	/**
	 * An unstructured status / error message.
	 */
	private String statusMsg;

	/**
	 * Gets the verified identifier.
	 */
	public Identifier getVerifiedId() {
		return verifiedId;
	}

	/**
	 * Sets the verified identifier.
	 */
	public void setVerifiedId(Identifier verifiedId) {
		this.verifiedId = verifiedId;
	}

	/**
	 * Gets the optional IdP user_setup_url parameter, if one was returned in a
	 * failure response to a immediate authentication request.
	 * <p>
	 * Null if the response did not include the user_setup_url parameter.
	 */
	public String getIdpSetupUrl() {
		return idpSetupUrl;
	}

	/**
	 * Sets the IdP user_setup_url parameter, if one was returned in a failure
	 * response to a immediate authentication request.
	 */
	public void setIdpSetupUrl(String idpSetupUrl) throws MessageException {
		this.idpSetupUrl = idpSetupUrl;
	}

	/**
	 * Gets the authentication response message received from the server.
	 */
	public Message getAuthResponse() {
		return authResponse;
	}

	/**
	 * Sets the authentication response message received from the server.
	 */
	public void setAuthResponse(Message authResponse) {
		this.authResponse = authResponse;
	}

	public String getStatusMsg() {
		return this.statusMsg;
	}

	public void setStatusMsg(String statusMsg) {
		this.statusMsg = statusMsg;
	}
}
