/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.resolve;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class MimeType {
    public static final String PARAM_SEP = "sep";
    public static final String PARAM_REFS = "refs";
    public static final String PARAM_TRUST = "trust";
    public static final String XRDS_XML = "application/xrds+xml";
    public static final String XRD_XML = "application/xrd+xml";
    public static final String URI_LIST = "text/uri-list";
    protected String type = null;
    protected HashMap params = null;
    protected String original = null;

    protected MimeType(String type, HashMap params, String original) {
        this.type = type;
        this.params = params;
        this.original = original;
    }

    public MimeType(String type) {
        this(type, new HashMap(), type);
    }

    public String getParam(String key) {
        Object val = this.params.get(key);
        if (val == null) {
            return null;
        }
        return (String)val;
    }

    public Set paramKeys() {
        return this.params.keySet();
    }

    public boolean equals(MimeType m) {
        if (!this.type.equals(m.type)) {
            return false;
        }
        if (this.params.size() != m.params.size()) {
            return false;
        }
        Set keys = this.params.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String k = (String)i.next();
            String v1 = (String)this.params.get(k);
            String v2 = (String)m.params.get(k);
            if (v2 == null) {
                return false;
            }
            if (v1.equals(v2)) continue;
            return false;
        }
        return true;
    }

    public boolean isType(String mtype) {
        return this.type.equals(mtype.toLowerCase());
    }

    public boolean isSuperSetOf(MimeType m) {
        if (!this.type.equals(m.type)) {
            return false;
        }
        if (this.params.size() < m.params.size()) {
            return false;
        }
        Set keys = m.params.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String k = (String)i.next();
            String v1 = (String)this.params.get(k);
            String v2 = (String)m.params.get(k);
            if (v1 == null) {
                return false;
            }
            if (v1.equals(v2)) continue;
            return false;
        }
        return true;
    }

    public static MimeType parse(String typeStr) {
        if (typeStr == null) {
            return null;
        }
        String[] parts = typeStr.split("\\s*;\\s*");
        String typeVal = parts[0].trim().toLowerCase();
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].length() == 0) continue;
            String[] kvpair = parts[i].split("\\s*=\\s*");
            String val = kvpair.length > 1 ? kvpair[1] : "";
            params.put(kvpair[0].toLowerCase(), val.trim());
        }
        if (MimeType.isXriResMediaType(typeVal)) {
            MimeType.setXriResDefaultParams(params);
        }
        return new MimeType(typeVal, params, typeStr);
    }

    public boolean isValidXriResMediaType() {
        return MimeType.isXriResMediaType(this.type);
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.original;
    }

    public String toNormalizedString() {
        StringBuffer sb = new StringBuffer(this.type);
        Iterator ki = this.params.keySet().iterator();
        while (ki.hasNext()) {
            String key = (String)ki.next();
            String val = (String)this.params.get(key);
            sb.append(';');
            sb.append(key);
            sb.append('=');
            sb.append(val);
        }
        return sb.toString();
    }

    private static boolean isXriResMediaType(String v) {
        return v.equals(XRDS_XML) || v.equals(XRD_XML) || v.equals(URI_LIST);
    }

    private static void setXriResDefaultParams(HashMap params) {
        String val = null;
        val = (String)params.get(PARAM_TRUST);
        if (val == null) {
            params.put(PARAM_TRUST, "none");
        }
    }

    public static void main(String[] args) {
        MimeType m1 = MimeType.parse("application/xrdS+xml");
        MimeType m2 = MimeType.parse("application/xrds+xml;trust=none");
        MimeType m3 = MimeType.parse("application/xrds+xml;sep=true");
        MimeType m4 = MimeType.parse("application/xRds+xml;sep=true;refs=true;trust=none");
        MimeType m5 = MimeType.parse("application/Xrds+xml;trust=https");
        MimeType m6 = MimeType.parse("application/xrds+xml;trust=https;refs=true;refs=false");
        MimeType m7 = MimeType.parse("text/plain;trust=https;refs=true;refs=false");
        if (!m1.equals(m2)) {
            System.out.println("m1.equals(m2) = " + m1.equals(m2));
            System.out.println("m1 = " + m1.toNormalizedString());
            System.out.println("m2 = " + m2.toNormalizedString());
        }
        if (!m1.isSuperSetOf(m2)) {
            System.out.println("m1.isSuperSetOf(m2) = " + m1.isSuperSetOf(m2));
            System.out.println("m1 = " + m1.toNormalizedString());
            System.out.println("m2 = " + m2.toNormalizedString());
        }
        if (!m4.isSuperSetOf(m3)) {
            System.out.println("m4.isSuperSetOf(m3) = " + m4.isSuperSetOf(m3));
            System.out.println("m4 = " + m4.toNormalizedString());
            System.out.println("m3 = " + m3.toNormalizedString());
        }
        if (m2.equals(m5)) {
            System.out.println("m2.isSuperSetOf(m5) = " + m2.isSuperSetOf(m5));
            System.out.println("m2 = " + m2.toNormalizedString());
            System.out.println("m5 = " + m5.toNormalizedString());
        }
        if (m1.isSuperSetOf(m5)) {
            System.out.println("m1.isSuperSetOf(m5) = " + m1.isSuperSetOf(m5));
            System.out.println("m1 = " + m1.toNormalizedString());
            System.out.println("m5 = " + m5.toNormalizedString());
        }
        if (!m6.isSuperSetOf(m5)) {
            System.out.println("m6.isSuperSetOf(m5) = " + m6.isSuperSetOf(m5));
            System.out.println("m6 = " + m6.toNormalizedString());
            System.out.println("m5 = " + m5.toNormalizedString());
        }
        if (m6.isSuperSetOf(m7)) {
            System.out.println("m6.isSuperSetOf(m7) = " + m6.isSuperSetOf(m7));
            System.out.println("m6 = " + m6.toNormalizedString());
            System.out.println("m7 = " + m7.toNormalizedString());
        }
    }
}

