/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.seasar.extension.jdbc.AutoBatchUpdate;
import org.seasar.extension.jdbc.ConditionType;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.SetClause;
import org.seasar.extension.jdbc.WhereClause;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractAutoBatchUpdate;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.LongConversionUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoBatchUpdateImpl<T>
extends AbstractAutoBatchUpdate<T, AutoBatchUpdate<T>>
implements AutoBatchUpdate<T> {
    protected static final String UPDATE_STATEMENT = "update ";
    protected boolean includeVersion;
    protected final Set<String> includesProperties = CollectionsUtil.newHashSet();
    protected final Set<String> excludesProperties = CollectionsUtil.newHashSet();
    protected final List<PropertyMeta> targetProperties = CollectionsUtil.newArrayList();
    protected final SetClause setClause = new SetClause();
    protected final WhereClause whereClause = new WhereClause();

    public AutoBatchUpdateImpl(JdbcManagerImplementor jdbcManager, List<T> entities) {
        super(jdbcManager, entities);
    }

    @Override
    public AutoBatchUpdate<T> includesVersion() {
        this.includeVersion = true;
        return this;
    }

    @Override
    public AutoBatchUpdate<T> includes(String ... propertyNames) {
        this.includesProperties.addAll(Arrays.asList(propertyNames));
        return this;
    }

    @Override
    public AutoBatchUpdate<T> excludes(String ... propertyNames) {
        this.excludesProperties.addAll(Arrays.asList(propertyNames));
        return this;
    }

    @Override
    public AutoBatchUpdate<T> suppresOptimisticLockException() {
        this.suppresOptimisticLockException = true;
        return this;
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
        this.prepareTargetProperties();
        this.prepareSetClause();
        this.prepareWhereClause();
        this.prepareSql();
    }

    protected void prepareTargetProperties() {
        for (PropertyMeta propertyMeta : this.entityMeta.getAllColumnPropertyMeta()) {
            String propertyName = propertyMeta.getName();
            if (propertyMeta.isId() || !propertyMeta.getColumnMeta().isUpdatable() || propertyMeta.isVersion() && !this.includeVersion || !this.includesProperties.isEmpty() && !this.includesProperties.contains(propertyName) || this.excludesProperties.contains(propertyName)) continue;
            this.targetProperties.add(propertyMeta);
        }
    }

    protected void prepareSetClause() {
        for (PropertyMeta propertyMeta : this.targetProperties) {
            this.setClause.addSql(propertyMeta.getColumnMeta().getName());
        }
        if (!this.includeVersion && this.entityMeta.hasVersionPropertyMeta()) {
            PropertyMeta propertyMeta = this.entityMeta.getVersionPropertyMeta();
            String columnName = propertyMeta.getColumnMeta().getName();
            this.setClause.addSql(columnName, columnName + " + 1");
        }
    }

    protected void prepareWhereClause() {
        for (PropertyMeta propertyMeta : this.entityMeta.getIdPropertyMetaList()) {
            this.whereClause.addAndSql(ConditionType.EQ.getCondition(propertyMeta.getColumnMeta().getName(), null));
        }
        if (!this.includeVersion && this.entityMeta.hasVersionPropertyMeta()) {
            PropertyMeta propertyMeta = this.entityMeta.getVersionPropertyMeta();
            this.whereClause.addAndSql(ConditionType.EQ.getCondition(propertyMeta.getColumnMeta().getName(), null));
        }
    }

    @Override
    protected void prepareParams(T entity) {
        Object value;
        for (PropertyMeta propertyMeta : this.targetProperties) {
            value = FieldUtil.get((Field)propertyMeta.getField(), entity);
            this.addParam(value, propertyMeta);
        }
        for (PropertyMeta propertyMeta : this.entityMeta.getIdPropertyMetaList()) {
            value = FieldUtil.get((Field)propertyMeta.getField(), entity);
            this.addParam(value, propertyMeta);
        }
        if (!this.includeVersion && this.entityMeta.hasVersionPropertyMeta()) {
            PropertyMeta propertyMeta = this.entityMeta.getVersionPropertyMeta();
            Object value2 = FieldUtil.get((Field)propertyMeta.getField(), entity);
            this.addParam(value2, propertyMeta);
        }
    }

    @Override
    protected String toSql() {
        String tableName = this.entityMeta.getTableMeta().getFullName();
        StringBuilder buf = new StringBuilder(UPDATE_STATEMENT.length() + tableName.length() + this.setClause.getLength() + this.whereClause.getLength());
        return new String(buf.append(UPDATE_STATEMENT).append(tableName).append(this.setClause.toSql()).append(this.whereClause.toSql()));
    }

    @Override
    protected boolean isOptimisticLock() {
        return !this.includeVersion && this.entityMeta.hasVersionPropertyMeta();
    }

    @Override
    protected void incrementVersions() {
        if (this.includeVersion) {
            return;
        }
        Field field = this.entityMeta.getVersionPropertyMeta().getField();
        for (Object entity : this.entities) {
            if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                int version = IntegerConversionUtil.toPrimitiveInt((Object)FieldUtil.get((Field)field, entity)) + 1;
                FieldUtil.set((Field)field, entity, (Object)version);
                continue;
            }
            if (field.getType() != Long.TYPE && field.getType() != Long.class) continue;
            long version = LongConversionUtil.toPrimitiveLong((Object)FieldUtil.get((Field)field, entity)) + 1L;
            FieldUtil.set((Field)field, entity, (Object)version);
        }
    }
}

