/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.message;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.tsukuyomi.openid.message.AuthSuccess;
import jp.sourceforge.tsukuyomi.openid.message.MessageException;
import jp.sourceforge.tsukuyomi.openid.message.MessageExtension;
import jp.sourceforge.tsukuyomi.openid.message.MessageExtensionFactory;
import jp.sourceforge.tsukuyomi.openid.message.Parameter;
import jp.sourceforge.tsukuyomi.openid.message.ParameterList;
import jp.sourceforge.tsukuyomi.openid.message.ax.AxMessage;
import jp.sourceforge.tsukuyomi.openid.message.pape.PapeMessage;
import jp.sourceforge.tsukuyomi.openid.message.sreg.SRegMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message {
    private static final Log LOG = LogFactory.getLog(Message.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final String MODE_IDRES = "id_res";
    public static final String MODE_CANCEL = "cancel";
    public static final String MODE_SETUP_NEEDED = "setup_needed";
    public static final String OPENID2_NS = "http://specs.openid.net/auth/2.0";
    private ParameterList params = new ParameterList();
    private int extCounter = 0;
    private Map<String, String> extAliases = new HashMap<String, String>();
    private Map<String, MessageExtension> extesion = new HashMap<String, MessageExtension>();
    protected String destinationUrl;
    private static Map<String, Class<?>> extensionFactories = new HashMap();

    protected Message() {
    }

    protected Message(ParameterList params) {
        this();
        this.params = params;
        boolean hasSReg10 = false;
        for (Parameter parameter : this.params.getParameters()) {
            String key = parameter.getKey();
            if (key.startsWith("openid.ns.") && key.length() > 10) {
                this.extAliases.put(this.params.getParameter(key).getValue(), key.substring(10));
            }
            if (!key.startsWith("openid.sreg.")) continue;
            hasSReg10 = true;
        }
        if (hasSReg10 && !this.hasParameter("openid.ns")) {
            this.extAliases.put("http://openid.net/sreg/1.0", "sreg");
        }
        this.extCounter = this.extAliases.size();
    }

    public static Message createMessage() throws MessageException {
        Message message = new Message();
        if (!message.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created message:\n" + message.keyValueFormEncoding()));
        }
        return message;
    }

    public static Message createMessage(ParameterList params) throws MessageException {
        Message message = new Message(params);
        if (!message.isValid()) {
            throw new MessageException("Invalid set of parameters for the requested message type");
        }
        if (DEBUG) {
            LOG.debug((Object)("Created message from parameter list:\n" + message.keyValueFormEncoding()));
        }
        return message;
    }

    protected Parameter getParameter(String name) {
        return this.params.getParameter(name);
    }

    public String getParameterValue(String name) {
        return this.params.getParameterValue(name);
    }

    public boolean hasParameter(String name) {
        return this.params.hasParameter(name);
    }

    protected void set(String name, String value) {
        this.params.set(new Parameter(name, value));
    }

    protected List<Parameter> getParameters() {
        return this.params.getParameters();
    }

    public Map<String, String> getParameterMap() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (Parameter p : this.params.getParameters()) {
            params.put(p.getKey(), p.getValue());
        }
        return params;
    }

    public boolean isValid() {
        List<String> requiredFields = this.getRequiredFields();
        for (Parameter param : this.params.getParameters()) {
            if (param.isValid()) continue;
            LOG.warn((Object)("Invalid parameter: " + param));
            return false;
        }
        if (requiredFields == null) {
            return true;
        }
        for (String required : requiredFields) {
            if (this.hasParameter(required)) continue;
            LOG.warn((Object)("Required parameter missing: " + required));
            return false;
        }
        return true;
    }

    public List<String> getRequiredFields() {
        return null;
    }

    public String keyValueFormEncoding() {
        StringBuffer allParams = new StringBuffer("");
        for (Parameter parameter : this.params.getParameters()) {
            allParams.append(parameter.getKey());
            allParams.append(':');
            allParams.append(parameter.getValue());
            allParams.append('\n');
        }
        return allParams.toString();
    }

    public String wwwFormEncoding() {
        StringBuffer allParams = new StringBuffer("");
        for (Parameter parameter : this.params.getParameters()) {
            if (!parameter.getKey().startsWith("openid.")) {
                allParams.append("openid.");
            }
            try {
                allParams.append(URLEncoder.encode(parameter.getKey(), "UTF-8"));
                allParams.append('=');
                allParams.append(URLEncoder.encode(parameter.getValue(), "UTF-8"));
                allParams.append('&');
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        if (allParams.length() > 0) {
            allParams.deleteCharAt(allParams.length() - 1);
        }
        return allParams.toString();
    }

    public String getDestinationUrl(boolean httpGet) {
        if (this.destinationUrl == null) {
            throw new IllegalStateException("Destination URL not set; is this a received message?");
        }
        if (httpGet) {
            boolean hasQuery = this.destinationUrl.indexOf("?") > 0;
            String initialChar = hasQuery ? "&" : "?";
            return this.destinationUrl + initialChar + this.wwwFormEncoding();
        }
        return this.destinationUrl;
    }

    public static void addExtensionFactory(Class<? extends MessageExtensionFactory> clazz) throws MessageException {
        MessageExtensionFactory extensionFactory;
        try {
            extensionFactory = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new MessageException("Cannot instantiante message extension factory class: " + clazz.getName());
        }
        catch (IllegalAccessException e) {
            throw new MessageException("Cannot instantiante message extension factory class: " + clazz.getName());
        }
        if (DEBUG) {
            LOG.debug((Object)("Adding extension factory for " + extensionFactory.getTypeUri()));
        }
        extensionFactories.put(extensionFactory.getTypeUri(), clazz);
    }

    public static boolean hasExtensionFactory(String typeUri) {
        return extensionFactories.containsKey(typeUri);
    }

    public static MessageExtensionFactory getExtensionFactory(String typeUri) {
        MessageExtensionFactory extensionFactory;
        if (!Message.hasExtensionFactory(typeUri)) {
            return null;
        }
        try {
            Class<?> extensionClass = extensionFactories.get(typeUri);
            extensionFactory = (MessageExtensionFactory)extensionClass.newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting extension factory for " + typeUri));
            return null;
        }
        return extensionFactory;
    }

    public boolean hasExtension(String typeUri) {
        return this.extAliases.containsKey(typeUri);
    }

    public Set<String> getExtensions() {
        return this.extAliases.keySet();
    }

    public String getExtensionAlias(String extensionTypeUri) {
        return this.extAliases.get(extensionTypeUri) != null ? this.extAliases.get(extensionTypeUri) : null;
    }

    public void addExtension(MessageExtension extension) throws MessageException {
        String typeUri = extension.getTypeUri();
        if (this.hasExtension(typeUri)) {
            throw new MessageException("Extension already present: " + typeUri);
        }
        String alias = "ext" + Integer.toString(++this.extCounter);
        if ("http://openid.net/sreg/1.0".equals(typeUri)) {
            alias = "sreg";
        }
        this.extAliases.put(typeUri, alias);
        if (DEBUG) {
            LOG.debug((Object)("Adding extension; type URI: " + typeUri + " alias: " + alias));
        }
        this.set("openid.ns." + alias, typeUri);
        for (Parameter param : extension.getParameters().getParameters()) {
            String paramName = param.getKey().length() > 0 ? "openid." + alias + "." + param.getKey() : "openid." + alias;
            this.set(paramName, param.getValue());
        }
        if (this instanceof AuthSuccess && ((AuthSuccess)this).getSignExtensions().contains(extension)) {
            ((AuthSuccess)this).buildSignedList();
        }
    }

    private ParameterList getExtensionParams(String extensionTypeUri) {
        ParameterList extension = new ParameterList();
        if (this.hasExtension(extensionTypeUri)) {
            String extensionAlias = this.getExtensionAlias(extensionTypeUri);
            for (Parameter param : this.getParameters()) {
                String paramName = null;
                if (param.getKey().startsWith("openid." + extensionAlias + ".")) {
                    paramName = param.getKey().substring(8 + extensionAlias.length());
                }
                if (param.getKey().equals("openid." + extensionAlias)) {
                    paramName = "";
                }
                if (paramName == null) continue;
                extension.set(new Parameter(paramName, param.getValue()));
            }
        }
        return extension;
    }

    public MessageExtension getExtension(String typeUri) throws MessageException {
        if (!this.extesion.containsKey(typeUri)) {
            if (Message.hasExtensionFactory(typeUri)) {
                MessageExtensionFactory extensionFactory = Message.getExtensionFactory(typeUri);
                String mode = this.getParameterValue("openid.mode");
                MessageExtension extension = extensionFactory.getExtension(this.getExtensionParams(typeUri), mode.startsWith("checkid_"));
                this.extesion.put(typeUri, extension);
            } else {
                throw new MessageException("Cannot instantiate extension: " + typeUri);
            }
        }
        if (DEBUG) {
            LOG.debug((Object)("Extracting " + typeUri + " extension from message..."));
        }
        return this.extesion.get(typeUri);
    }

    static {
        extensionFactories.put("http://openid.net/srv/ax/1.0-draft4", AxMessage.class);
        extensionFactories.put("http://openid.net/sreg/1.0", SRegMessage.class);
        extensionFactories.put("http://specs.openid.net/extensions/pape/1.0", PapeMessage.class);
    }
}

