package example.action;

import java.util.Map;

import jp.sourceforge.tsukuyomi.openid.OpenIDConsumer;

import org.seasar.cubby.action.Action;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.action.Direct;
import org.seasar.cubby.action.Forward;
import org.seasar.cubby.action.RequestParameter;
import org.seasar.cubby.action.Validation;
import org.seasar.cubby.validator.DefaultValidationRules;
import org.seasar.cubby.validator.ValidationRule;
import org.seasar.cubby.validator.ValidationRules;
import org.seasar.cubby.validator.validators.RequiredValidator;

public class LoginAction extends Action {
    
    private class IdentifierValidator implements ValidationRule {
        public void apply(Map<String, Object[]> params, Object form,
                ActionErrors errors) {
            // findProvider で false が帰ってくると OP が見つけられない、
            // すなわち不正または対応していない OpenID とみなすことができる。
            if (!openIDConsumer.findProvider(openid_identifier)) {
                errors.add("OpenID Identifier が不正です。");
            }
        }
    }

    @RequestParameter
    public String openid_identifier;

    public OpenIDConsumer openIDConsumer;
    
    public ValidationRules validation = new DefaultValidationRules() {
        @Override
        public void initialize() {
            add("openid_identifier", new RequiredValidator());
            add(DATA_CONSTRAINT, new IdentifierValidator());
        }
    };
    
    public String verifiedId;

    @Validation(rules = "validation", errorPage = "main.jsp")
    public ActionResult auth() {
        // 内部で認証サーバに移動させるためのレスポンスを出力している
        openIDConsumer.request();

        // なので戻り値は Direct()
        return new Direct();
    }

    public ActionResult index() {
        // OpenID 入力ページ出力
        return new Forward("main.jsp");
    }

    public ActionResult verify() {
        // 結果の直接検証を行う
        verifiedId = openIDConsumer.verify();

        if (verifiedId == null) {
            // 戻り値が null の場合、検証エラー
            return new Forward("error.jsp");
        }
        
        return new Forward("success.jsp");
    }
}
