#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>
//----------------------------------------------------------
//Function for the event procedure
//----------------------------------------------------------
#include "shared_func.h"
#include <WSDkeyboard.h>

void edit_string(WSCbase* object){
  WSCstring str, message;
  long obj_type = object->getProperty(WSNuserValue);

  if (obj_type == BTN_CUT || obj_type == BTN_COPY) {
    str = textField->getSelectedString();
  } else if (obj_type == BTN_PASTE) {
    str = WSGIappKeyboard()->getSelectedString();
  } else {
    return;
  }

  if (str.getChars() > 0) {
    if (obj_type == BTN_CUT || obj_type == BTN_COPY) {
      WSGIappKeyboard()->setSelectedString(str);
      if (obj_type == BTN_CUT) {
        textField->deleteSelectedString();
      }
    } else if (obj_type == BTN_PASTE) {
      textField->replaceSelectedString(str);
    }

    if (obj_type == BTN_CUT) {
      message = "I𒆂̕؂܂";
    } else if (obj_type == BTN_COPY) {
      message = "I𒆂̕𕡎ʂ܂";
    } else if (obj_type == BTN_PASTE) {
      message = "\t܂";
    } else {
      message = "";
    }
    statusArea->setProperty(WSNlabelString, message);
  }

  return;
}
static WSCfunctionRegister  op("edit_string",(void*)edit_string);
