#define		LINUX
#undef		Solaris
#undef		FreeBSD
#undef		Win32
/*******************************************/
/* EEPROM write program to H8/300H         */
/*        Copyleft Yukio Mituiwa,2002      */
/* License is GPL2                         */
/* 	Update 2002,Dec,30 Satoshi Okubo   */
/* 	Update 2003,Jan,1  Yukio Mituiwa   */
/*******************************************/
#include	<stdio.h>
#include	<stdlib.h>
#include	<fcntl.h>
#ifndef		Win32
 #include	<unistd.h>
 #include	<string.h>
 #include	<libgen.h>
#endif
#define VER	"1.0.0"

/*
	Supported CPU ID 
*/
#define CPU3048         1
#define CPU3664         2
#define CPU3067         3
#define CPU3068         4
#define CPU3052         5
#define CPU3064         6
#define CPU7045         7
#define CPU3069         0x101

/*
	Define the serial port device
*/

#ifdef Win32
 #define        RSLINE  "com1"
#endif
#ifdef LINUX
 #define	RSLINE	"/dev/ttyS0"
#endif
#ifdef FreeBSD
 #define	RSLINE	"/dev/cuaa0"
#endif
#ifdef Solaris
 #define	RSLINE	"/dev/cua/b"
#endif

/*
	Wait timinig for each char send. In milli second.
*/
#define	WAIT_SEND	1

/*
	Debug Flag for default
		0:	No Debug mesages
		1:	Debug mesages
*/
#define	DEBUG	0

/*
	Buffer sizes
*/

#define	COMBUF_SIZE		512
#define	BOOT_COMBUF_SIZE	512

/* OS define this in <sys/param.h>, but incase it dosen't */
#ifndef        Win32
 #include	<sys/param.h>
#endif
#ifndef        MAXPATHLEN
 #define MAXPATHLEN    32
#endif

/* Error Level */
#define	MESSAGE	0
#define	WARNING	1
#define	FATAL	2

/* Error Code */
#define	ERR_TEST	0
#define	ERR_OPTION	1
#define	ERR_INPUTFILE	2
#define	ERR_OPENLINE	3
#define	ERR_INITLINE	4
#define	ERR_READLINE	5
#define	ERR_S_FORMAT	6
#define	ERR_H8_DATA	7
#define	ERR_CPU_TYPE	8
#define	ERR_EEPROM_WRITE	 9
#define	ERR_EEPROM_TRANS	10
#define	ERR_LINESPEED	11
#define	ERR_GET_3096ID	12
#define	ERR_BOOT_SUM	13
#define	ERR_ALREADY_QUERY	14
#define	ERR_SET_QUERYMODE	15
#define	ERR_DEV_CODE	16
#define	ERR_CLK_MODE	17
#define	ERR_SET_RATE	18
#define	ERR_WRITE	19

/* Bin SIZE	*/
#define 	BIN3048_SIZE	0x500
#define 	BIN3052_SIZE	0x500
#define 	BIN3064_SIZE	0x500
#define 	BIN3067_SIZE	0x500
#define 	BIN3068_SIZE	0x500
#define 	BIN3664_SIZE	0x500
#define 	BIN7045_SIZE	0x500
#define 	BIN3069_SIZE	0x500
/* ROM Start point	*/
#define 	ROM3048_START	0
#define 	ROM3052_START	0
#define 	ROM3064_START	0
#define 	ROM3067_START	0
#define 	ROM3068_START	0
#define 	ROM3664_START	0
#define 	ROM7045_START	0
/* ROM End point	*/
#define 	ROM3048_END	0x1ffff
#define 	ROM3052_END	0x5ffff
#define 	ROM3064_END	0x1ffff
#define 	ROM3067_END	0x1ffff
#define 	ROM3068_END	0x5ffff
#define 	ROM3664_END	0x7fff
#define 	ROM7045_END	0x3ffff

/*	Bit ragte set mode params	*/
#define	BIT_RATE_SET_MAX	256
#define	BIT_RATE_SET_MAX_3069	30	

#define	BIT_SET_CODE	0x00	/*	Code to setup bit rate	*/
#define	BIT_SET_CHEK	0x55	/*	command to check status	*/

#define	BIT_SET_FIN		0x00	/*	Signal from H8/300 rate set	*/
#define	BIT_SET_RES_3069	0xe6	/*	OK status for 3069	*/
#define	BIT_SET_RES		0xaa	/*	OK status for 3069	*/
#define	BIT_SET_RES_NG		0xff	/*	NG status	*/

/*	Boot Mode Command & response	*/
#define	QUERY_DEV_COM	0x20	/*	Query Device command	*/
#define	QUERY_DEV_RES	0x30	/*	Query Device response	*/
#define QUERY_DEV_DEV_CODE_SIZE 4

#define	SEL_DEV_COM	0x10	/*	Qeury, select device command	*/
#define	SEL_DEV_RES	0x06	/*	Qeury, select device response	*/
#define	SEL_DEV_ERR_RES	0x90	/*	Qeury, select device error response	*/
#define	SEL_DEV_ERR_SUM	0x11	/*	Qeury, select device error response,
					Check sum error */
#define	SEL_DEV_ERR_CODE	0x21	/*	Qeury, select device error response,
					Devi code  error */

#define	QUERY_CLK_COM	0x21	/*	Query clock mode command	*/
#define	QUERY_CLK_RES	0x31	/*	Query clock mode response	*/

#define	SEL_CLK_COM	0x11	/*	Query, select clock command	*/
#define	SEL_CLK_RES	0x06	/*	Query, select clock response	*/
#define	SEL_CLK_ERR_RES	0x91	/*	Query, select clock error response	*/
#define	SEL_CLK_ERR_SUM	0x11	/*	Query, select clock error response,
					Check sum error */
#define	SEL_CLK_ERR_MODE	0x22	/* Query, select clock error response,
					Illegal mode error */
#define	SEL_CLK_SIZE	1	/*	Query, select clock size	*/
#define	SEL_CLK_MODE	0	/*	Query, select clock MODE	*/

#define	QUERY_SCL_COM	0x22	/*	Query, scale command	*/
#define	QUERY_SCL_RES	0x32	/*	Query, scale response	*/

#define	QUERY_FRQ_COM	0x23	/*	Query, frequency command	*/
#define	QUERY_FRQ_RES	0x33	/*	Query, frequency response	*/

#define	QUERY_PAGE_SIZE_COM	0x27	/*	Query, get page size	*/
#define	QUERY_PAGE_SIZE_RES	0x37	/*	Query, get page size res	*/

#define	SET_RATE_COM	0x3f	/*	Query, set_rate command	*/
#define	SET_RATE_RES	0x06	/*	Query, set_rate response	*/
#define	SET_RATE_ERR_RES	0xbf	/*	Query, set_rate error response	*/
#define	SET_RATE_ERR_SUM	0x11	/*	Query, set_rate error,
					Check sum */
#define	SET_RATE_ERR_RATE	0x24	/*	Query, set_rate error,
					Illegal rate	*/
#define	SET_RATE_ERR_INP_FREQ	0x25	/*	Query, set_rate error,
					Illegal input frequency	*/
#define	SET_RATE_ERR_TIME	0x26	/*	Query, set_rate error,
					Illegal time	*/
#define	SET_RATE_ERR_FREQ	0x27	/*	Query, set_rate error,
					Illegal frequency	*/
#define	SET_RATE_CK_COM		0x06	/*	Query, check new rate command	*/
#define	SET_RATE_SIZE	7	/*	Query, set_rate size	*/

#define	QUERY_ERR_RES	0x80	/*	Query Error response	*/
#define	NON_ERR_RES	0x06	/*	NON error response	*/

#define	SWITCH_TO_ERASE_COM	0x40	/*	switch to erase mode	*/	
#define	SEL_WRITE_FORMAT	0x43	/*	select write format	*/
#define	WRITE_128_COM		0x50	/*	Write 128 bite	*/
#define	WRITE_128_ERR_ADD	0x28	/*	Address is out of range	*/
#define	WRITE_128_ERR_WRT	0x53	/*	Write error	*/
#define	READ_COM		0x52	/*	Read data	*/
#define	READ_RES		0x52	/*	Read response	*/
#define	READ_AREA		1	/*	0:User boot mat area
						1:User mat area	*/
#define	READ_COM_LEN		9	/*	Read command length	*/

static char bin3048[0x500] = {
0x7a,0x07,0x00,0xff,0xfe,0xfc,0x5e,0xff,0xf3,0x9c,0x40,0xf4,0x01,0x00,0x6d,0xf6,0x0f,
0xf6,0x7a,0x03,0x00,0xff,0xff,0xba,0x68,0x3a,0xca,0x10,0x68,0xba,0x7a,0x00,0x00,0xff,
0xff,0xbc,0x0b,0x83,0x68,0x0a,0xea,0x38,0x47,0x06,0x1a,0x80,0x88,0xff,0x40,0x26,0x68,
0x3a,0xea,0x40,0x47,0xee,0x7a,0x03,0x00,0xff,0xff,0xbc,0x68,0x3a,0xea,0xbf,0x68,0xba,
0x2b,0xbd,0x7a,0x00,0x00,0xff,0xff,0xba,0x68,0x0a,0xea,0xef,0x68,0x8a,0x17,0x53,0x0d,
0x30,0x17,0x70,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,0x0f,0xf6,0x7a,0x03,
0x00,0xff,0xff,0xba,0x68,0x3a,0xca,0x20,0x68,0xba,0x0b,0x83,0x68,0x3a,0x4c,0xfc,0x38,
0xbb,0x7a,0x03,0x00,0xff,0xff,0xbc,0x68,0x3a,0xea,0x7f,0x68,0xba,0x68,0x3a,0xea,0x04,
0x47,0xfa,0x7a,0x03,0x00,0xff,0xff,0xba,0x68,0x3a,0xea,0xdf,0x68,0xba,0x01,0x00,0x6d,
0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,0x0f,0xf6,0x7a,0x37,0x00,0x00,0x01,0x0c,0x01,0x00,
0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x5e,0xff,0xf3,0x0c,0x17,0x50,0x17,0x70,0x01,0x00,0x6f,
0xe0,0xfe,0xf4,0x6e,0x68,0xfe,0xf7,0x5e,0xff,0xf3,0x5e,0x5e,0xff,0xf3,0x0c,0x17,0x50,
0x0d,0x05,0x17,0x75,0x0c,0xd8,0x5e,0xff,0xf3,0x5e,0x0d,0xd2,0x0c,0xa2,0x0c,0x5a,0x0c,
0xd5,0x18,0xdd,0x0d,0x2d,0x5e,0xff,0xf3,0x0c,0x0c,0x8c,0x17,0x54,0x17,0x74,0x0c,0xc8,
0x5e,0xff,0xf3,0x5e,0x0a,0xc5,0x0d,0xd2,0x0c,0xa2,0x0c,0x5a,0x0c,0xd5,0x18,0xdd,0x0d,
0x2d,0x01,0x00,0x6f,0xe5,0xfe,0xfc,0x1a,0xd5,0x7a,0x04,0xff,0xff,0xff,0x00,0x0a,0xe4,
0x0a,0xd4,0x5e,0xff,0xf3,0x0c,0x68,0xc8,0x0b,0x05,0x7a,0x25,0x00,0x00,0x00,0xff,0x4f,
0xe6,0x1a,0xa2,0x01,0x00,0x6f,0xe2,0xfe,0xf8,0x1a,0xd5,0x0f,0xe2,0x0a,0xd2,0x01,0x00,
0x6f,0x64,0xfe,0xfc,0x0a,0xd4,0x6e,0x29,0xff,0x00,0x0f,0xc0,0x5e,0xff,0xf4,0x86,0x01,
0x00,0x6f,0x62,0xfe,0xf8,0x01,0xf0,0x64,0x02,0x01,0x00,0x6f,0xe2,0xfe,0xf8,0x01,0x00,
0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x01,0x46,0x06,0x68,0x48,0x5e,0xff,0xf3,
0x5e,0x0b,0x05,0x7a,0x25,0x00,0x00,0x00,0xff,0x4f,0xbc,0x01,0x00,0x6f,0x62,0xfe,0xf8,
0x46,0x04,0xf8,0x53,0x40,0x02,0xf8,0x46,0x6e,0xe8,0xff,0x00,0x58,0x00,0xff,0x3c,0x01,
0x00,0x6d,0xf6,0x0f,0xf6,0x1b,0x97,0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x0f,0x85,
0x6e,0xe9,0xff,0xff,0x18,0xcc,0x18,0x88,0x7a,0x25,0x00,0x01,0xef,0xff,0x42,0x22,0x0f,
0xd1,0xfa,0x0e,0x11,0xb1,0x8a,0xff,0x46,0xfa,0x7a,0x61,0x00,0x00,0x00,0x07,0x1a,0xa2,
0x8a,0x01,0x0c,0xa8,0x0c,0x9b,0x4f,0x06,0x10,0x08,0x8b,0xff,0x46,0xfa,0x40,0x2a,0x7a,
0x25,0x00,0x01,0xff,0xff,0x58,0x20,0x00,0xc0,0x0f,0xd1,0xfa,0x09,0x11,0xb1,0x8a,0xff,
0x46,0xfa,0x7a,0x61,0x00,0x00,0x00,0x07,0x1a,0xa2,0x8a,0x01,0x0c,0xac,0x0c,0x9b,0x4f,
0x06,0x10,0x0c,0x8b,0xff,0x46,0xfa,0xfa,0x40,0x3a,0x40,0x1a,0xb3,0x0b,0x03,0x7a,0x23,
0x00,0x00,0x00,0x13,0x43,0xf6,0x38,0x42,0x3c,0x43,0x6e,0x6a,0xff,0xff,0x68,0xda,0x1a,
0x91,0x7a,0x04,0x00,0xff,0xff,0x40,0x79,0x02,0xa5,0x79,0x6b,0xa2,0x00,0xff,0xff,0xa8,
0x2a,0x40,0xca,0x01,0x3a,0x40,0x1a,0xb3,0x1a,0xa2,0x8a,0x0f,0x7a,0x12,0x00,0x00,0x00,
0x0f,0x0f,0xa0,0x1f,0xa3,0x44,0x06,0x0b,0x03,0x1f,0x83,0x45,0xfa,0x68,0x4a,0xea,0xfe,
0x68,0xca,0x79,0x02,0xa5,0x00,0x6b,0xa2,0x00,0xff,0xff,0xa8,0x68,0x4a,0xca,0x04,0x68,
0xca,0x1a,0xb3,0x0b,0x03,0x7a,0x23,0x00,0x00,0x00,0x07,0x43,0xf6,0x68,0x5a,0x6e,0x6b,
0xff,0xff,0x1c,0xba,0x47,0x16,0x7a,0x03,0x00,0xff,0xff,0x40,0x68,0x3a,0xea,0xfb,0x68,
0xba,0x0b,0x01,0x7a,0x21,0x00,0x00,0x00,0x05,0x43,0x96,0x7a,0x03,0x00,0xff,0xff,0x40,
0x68,0x3a,0xea,0xfb,0x68,0xba,0x7a,0x21,0x00,0x00,0x00,0x06,0x46,0x06,0x1a,0x80,0x1b,
0x00,0x40,0x02,0x1a,0x80,0x01,0x00,0x6d,0x75,0x01,0x00,0x6d,0x74,0x0b,0x97,0x01,0x00,
0x6d,0x76,0x54,0x70};

static unsigned  char bin3052[0x500] = {
0x7a,0x07,0x00,0xff,0xff,0x0c,0x5e,0xff,0xe7,0x8c,0x40,0xf4,0x01,0x00,0x6d,0xf6,0x0f,
0xf6,0x7a,0x03,0x00,0xff,0xff,0xba,0x68,0x3a,0xca,0x10,0x68,0xba,0x0b,0x83,0x68,0x3a,
0xea,0x38,0x46,0x1c,0x68,0x3a,0x73,0x6a,0x47,0xf4,0x68,0x3a,0xea,0xbf,0x68,0xba,0x7a,
0x02,0x00,0xff,0xff,0xbd,0x68,0x2a,0xf2,0x00,0x0d,0x20,0x17,0x70,0x40,0x04,0x1a,0x80,
0x88,0xff,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,0x0f,0xf6,0x7a,0x03,0x00,
0xff,0xff,0xbc,0x68,0x3a,0x4c,0xfc,0x7a,0x02,0x00,0xff,0xff,0xbb,0x68,0xa8,0x7a,0x03,
0x00,0xff,0xff,0xbc,0x68,0x3a,0xea,0x7f,0x68,0xba,0x68,0x3a,0x73,0x2a,0x47,0xfa,0x01,
0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,0x0f,0xf6,0x7a,0x37,0x00,0x00,0x01,0x0c,
0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x7a,0x03,0x00,0xff,0xff,0xba,0x68,0x3a,0xca,
0x30,0x68,0xba,0x5e,0xff,0xe7,0x1c,0x0c,0x8a,0xf2,0x00,0x17,0x72,0x01,0x00,0x6f,0xe2,
0xfe,0xf4,0x6e,0x68,0xfe,0xf7,0x5e,0xff,0xe7,0x5c,0x5e,0xff,0xe7,0x1c,0x0c,0x8a,0xf2,
0x00,0x0d,0x25,0x17,0x75,0x0c,0xd8,0x5e,0xff,0xe7,0x5c,0x0d,0xd2,0x0c,0xa2,0x0c,0x5a,
0x0c,0xd5,0x18,0xdd,0x0d,0x2d,0x5e,0xff,0xe7,0x1c,0x0c,0x8a,0xf2,0x00,0x0d,0x24,0x17,
0x74,0x0c,0xc8,0x5e,0xff,0xe7,0x5c,0x0a,0xc5,0x0d,0xd2,0x0c,0xa2,0x0c,0x5a,0x0c,0xd5,
0x18,0xdd,0x0d,0x2d,0x01,0x00,0x6f,0xe5,0xfe,0xfc,0x1a,0xc4,0x0f,0xe5,0x7a,0x15,0xff,
0xff,0xff,0x00,0x5e,0xff,0xe7,0x1c,0x0f,0xd2,0x0a,0xc2,0x68,0xa8,0x0b,0x04,0x7a,0x24,
0x00,0x00,0x00,0xff,0x4f,0xec,0x0f,0xe1,0x7a,0x11,0xff,0xff,0xff,0x00,0x01,0x00,0x6f,
0x60,0xfe,0xfc,0x5e,0xff,0xe9,0x72,0x01,0x00,0x6f,0xe0,0xfe,0xf8,0x01,0x00,0x6f,0x60,
0xfe,0xfc,0x7a,0x10,0x00,0x00,0x00,0x80,0x0f,0xe1,0x7a,0x11,0xff,0xff,0xff,0x80,0x5e,
0xff,0xe9,0x72,0x0f,0x85,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x01,
0x46,0x1a,0x1a,0xc4,0x01,0x00,0x6f,0x62,0xfe,0xfc,0x0a,0xc2,0x68,0x28,0x5e,0xff,0xe7,
0x5c,0x0b,0x04,0x7a,0x24,0x00,0x00,0x00,0xff,0x4f,0xe8,0x01,0x00,0x6f,0x62,0xfe,0xf8,
0x46,0x08,0x0f,0xd5,0x46,0x04,0xfa,0x53,0x40,0x02,0xfa,0x46,0x6e,0xea,0xff,0x00,0x6e,
0x68,0xff,0x00,0x5e,0xff,0xe7,0x5c,0x58,0x00,0xff,0x22,0x01,0x00,0x6d,0xf6,0x0f,0xf6,
0x0f,0x81,0x7a,0x00,0x00,0xff,0xff,0xa8,0x79,0x02,0x5a,0xc0,0x69,0x82,0x7a,0x03,0x00,
0xff,0xff,0xf2,0x68,0x3a,0xea,0x7f,0x68,0xba,0x79,0x02,0xa5,0x7f,0x69,0x82,0x01,0x00,
0x6b,0x23,0x00,0xff,0xeb,0xe4,0x01,0x00,0x6b,0x22,0x00,0xff,0xeb,0xe8,0x0a,0xa3,0x68,
0x3a,0xca,0x10,0x68,0xba,0x1a,0xb3,0x0b,0x03,0x7a,0x23,0x00,0x00,0x00,0x63,0x4f,0xf6,
0x01,0x00,0x6b,0x23,0x00,0xff,0xeb,0xe4,0x01,0x00,0x6b,0x22,0x00,0xff,0xeb,0xe8,0x0a,
0xa3,0x68,0x3a,0xca,0x01,0x68,0xba,0x1a,0xb3,0x0f,0x92,0x0a,0x92,0x1f,0xa3,0x4c,0x0a,
0x0f,0x90,0x0a,0x90,0x0b,0x03,0x1f,0x83,0x4d,0xfa,0x01,0x00,0x6b,0x22,0x00,0xff,0xeb,
0xe4,0x01,0x00,0x6b,0x23,0x00,0xff,0xeb,0xe8,0x0a,0xb2,0x68,0x2b,0xeb,0xfe,0x68,0xab,
0x1a,0xb3,0x0b,0x03,0x7a,0x23,0x00,0x00,0x00,0x63,0x4f,0xf6,0x01,0x00,0x6b,0x22,0x00,
0xff,0xeb,0xe4,0x01,0x00,0x6b,0x23,0x00,0xff,0xeb,0xe8,0x0a,0xb2,0x68,0x2b,0xeb,0xef,
0x68,0xab,0x1a,0xb3,0x0b,0x03,0x7a,0x23,0x00,0x00,0x00,0x63,0x4f,0xf6,0x7a,0x03,0x00,
0xff,0xff,0xa8,0x79,0x02,0xa5,0x1f,0x69,0xb2,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,
0x6d,0xf6,0x0f,0xf6,0x7a,0x37,0x00,0x00,0x01,0x14,0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,
0xf5,0x01,0x00,0x6f,0xe0,0xfe,0xfc,0x01,0x00,0x6f,0xe1,0xfe,0xf8,0x7a,0x20,0x00,0x03,
0xff,0xff,0x42,0x04,0x1a,0xa2,0x40,0x14,0x01,0x00,0x6f,0x62,0xfe,0xfc,0x7a,0x22,0x00,
0x07,0xff,0xff,0x58,0x20,0x01,0xec,0x1a,0xa2,0x8a,0x01,0x01,0x00,0x6b,0xa2,0x00,0xff,
0xeb,0xe8,0x7a,0x02,0x00,0xff,0xff,0x40,0x01,0x00,0x6b,0xa2,0x00,0xff,0xeb,0xe4,0x01,
0x00,0x6b,0x23,0x00,0xff,0xeb,0xe8,0x0a,0xa3,0x68,0x3a,0xca,0x40,0x68,0xba,0x1a,0x91,
0x0f,0xe0,0x7a,0x10,0xff,0xff,0xff,0x80,0x0f,0x82,0x0a,0x92,0x01,0x00,0x6f,0x63,0xfe,
0xf8,0x0a,0x93,0x68,0x3b,0x68,0xab,0x0b,0x01,0x7a,0x21,0x00,0x00,0x00,0x7f,0x4f,0xe6,
0x1a,0xa2,0x01,0x00,0x6f,0xe2,0xfe,0xf4,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x0b,0x02,0x01,
0x00,0x6f,0xe2,0xfe,0xf4,0x1a,0xa2,0x01,0x00,0x6f,0xe2,0xfe,0xf0,0x1a,0x91,0x0f,0xe0,
0x7a,0x10,0xff,0xff,0xff,0x80,0x01,0x00,0x6f,0x62,0xfe,0xfc,0x0a,0x92,0x0f,0x83,0x0a,
0x93,0x68,0x3b,0x68,0xab,0x0b,0x01,0x7a,0x21,0x00,0x00,0x00,0x7f,0x4f,0xe6,0x1a,0x80,
0x88,0xc8,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x06,0x4e,0x04,0x1a,
0x80,0x88,0x1e,0x5e,0xff,0xe8,0xa2,0x01,0x00,0x6b,0x23,0x00,0xff,0xeb,0xe4,0x01,0x00,
0x6b,0x22,0x00,0xff,0xeb,0xe8,0x0a,0xa3,0x68,0x3a,0xca,0x04,0x68,0xba,0x1a,0xa2,0x0b,
0x02,0x7a,0x22,0x00,0x00,0x00,0x07,0x4f,0xf6,0x01,0x00,0x6f,0x65,0xfe,0xfc,0x1a,0x91,
0x0f,0xe2,0x7a,0x12,0xff,0xff,0xff,0x80,0x01,0x00,0x6f,0xe2,0xfe,0xec,0xfa,0xff,0x68,
0xda,0x1a,0xa2,0x0b,0x02,0x7a,0x22,0x00,0x00,0x00,0x03,0x4f,0xf6,0x68,0x5c,0x01,0x00,
0x6f,0x62,0xfe,0xf8,0x0a,0x92,0x68,0x2a,0x1c,0xac,0x47,0x0a,0x1a,0xa2,0x8a,0x01,0x01,
0x00,0x6f,0xe2,0xfe,0xf0,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x06,
0x4e,0x14,0x0f,0xe3,0x0a,0x93,0x01,0x00,0x6f,0x62,0xfe,0xec,0x0a,0x92,0x68,0x2a,0x14,
0xca,0x6e,0xba,0xff,0x00,0x01,0x00,0x6f,0x60,0xfe,0xec,0x0a,0x90,0x01,0x00,0x6f,0x63,
0xfe,0xf8,0x0a,0x93,0x0c,0xca,0x17,0x0a,0x68,0x3b,0x14,0xba,0x68,0x8a,0x0b,0x05,0x0b,
0x01,0x7a,0x21,0x00,0x00,0x00,0x7f,0x4f,0x8e,0x01,0x00,0x6b,0x23,0x00,0xff,0xeb,0xe4,
0x01,0x00,0x6b,0x22,0x00,0xff,0xeb,0xe8,0x0a,0xa3,0x68,0x3a,0xea,0xfb,0x68,0xba,0x01,
0x00,0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x06,0x4e,0x3e,0x1a,0x91,0x0f,0xe0,
0x7a,0x10,0xff,0xff,0xff,0x80,0x01,0x00,0x6f,0x62,0xfe,0xfc,0x0a,0x92,0x0f,0x83,0x0a,
0x93,0x68,0x3b,0x68,0xab,0x0b,0x01,0x7a,0x21,0x00,0x00,0x00,0x7f,0x4f,0xe6,0x1a,0x80,
0x88,0xc8,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x06,0x4e,0x04,0x1a,
0x80,0x88,0x1e,0x5e,0xff,0xe8,0xa2,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,
0x03,0xe8,0x4f,0x2a,0x01,0x00,0x6b,0x23,0x00,0xff,0xeb,0xe4,0x01,0x00,0x6b,0x22,0x00,
0xff,0xeb,0xe8,0x0a,0xa3,0x68,0x3a,0xea,0xbf,0x68,0xba,0x1a,0xa2,0x0b,0x02,0x7a,0x22,
0x00,0x00,0x00,0xc7,0x4f,0xf6,0x1a,0x80,0x1b,0x00,0x40,0x30,0x01,0x00,0x6f,0x62,0xfe,
0xf0,0x58,0x60,0xfe,0x5a,0x01,0x00,0x6b,0x22,0x00,0xff,0xeb,0xe4,0x01,0x00,0x6b,0x23,
0x00,0xff,0xeb,0xe8,0x0a,0xb2,0x68,0x2b,0xeb,0xbf,0x68,0xab,0x1a,0xa2,0x0b,0x02,0x7a,
0x22,0x00,0x00,0x00,0xc7,0x4f,0xf6,0x1a,0x80,0x01,0x00,0x6d,0x75,0x01,0x00,0x6d,0x74,
0x7a,0x17,0x00,0x00,0x01,0x14,0x01,0x00,0x6d,0x76,0x54,0x70};

static unsigned char bin3067[0x500] = {
0x7a,0x07,0x00,0xff,0xfa,0xfc,0x5e,0xff,0xf4,0xf8,0x40,0xf4,0x01,0x00,0x6d,0xf6,0x0f,
0xf6,0x7a,0x03,0x00,0xff,0xff,0xba,0x18,0xaa,0x68,0xba,0x1a,0xa2,0x0b,0x02,0x7a,0x22,
0x00,0x00,0x01,0x17,0x4f,0xf6,0x7a,0x03,0x00,0xff,0xff,0xba,0xfa,0x30,0x68,0xba,0x0b,
0x83,0x68,0x3a,0xea,0x87,0x68,0xba,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,
0x0f,0xf6,0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x0f,0x85,0x0f,0x94,0x1a,0x80,0x1f,
0xc0,0x4c,0x3c,0x7a,0x01,0x00,0xff,0xff,0xbc,0x68,0x1a,0xea,0x78,0x47,0xfa,0x7a,0x03,
0x00,0xff,0xff,0xbc,0x68,0x3a,0x73,0x6a,0x46,0x0a,0xfa,0xc7,0x68,0xba,0x1a,0x80,0x1b,
0x00,0x40,0x1c,0x0f,0xd3,0x0a,0x83,0x7a,0x02,0x00,0xff,0xff,0xbd,0x68,0x2a,0x68,0xba,
0x68,0x1a,0xea,0xbf,0x68,0x9a,0x0b,0x00,0x1f,0xc0,0x4d,0xca,0x1a,0x80,0x01,0x00,0x6d,
0x75,0x01,0x00,0x6d,0x74,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,0x0f,0xf6,
0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x0f,0x84,0x1a,0x80,0x1f,0x90,0x4c,0x24,0x7a,
0x03,0x00,0xff,0xff,0xbc,0x7a,0x05,0x00,0xff,0xff,0xbb,0x68,0x3a,0x4c,0xfc,0x0f,0xc2,
0x0a,0x82,0x68,0x2a,0x68,0xda,0x68,0x3a,0xea,0x7f,0x68,0xba,0x0b,0x00,0x1f,0x90,0x4d,
0xe8,0x7a,0x03,0x00,0xff,0xff,0xbc,0x68,0x3a,0x73,0x2a,0x47,0xfa,0x01,0x00,0x6d,0x75,
0x01,0x00,0x6d,0x74,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,0x0f,0xf6,0x7a,
0x37,0x00,0x00,0x01,0x10,0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x5e,0xff,0xf4,0x0c,
0x0f,0xe4,0x7a,0x14,0xff,0xff,0xff,0x00,0x1a,0x91,0x89,0x01,0x0f,0xc0,0x5e,0xff,0xf4,
0x40,0x6e,0x6a,0xff,0x00,0xf2,0x00,0x17,0x72,0x01,0x00,0x6f,0xe2,0xfe,0xf4,0x1a,0x91,
0x89,0x01,0x0f,0xc0,0x5e,0xff,0xf4,0xa4,0x0f,0xe2,0x7a,0x12,0xff,0xff,0xff,0x00,0x01,
0x00,0x6f,0xe2,0xfe,0xf0,0x1a,0x91,0x89,0x01,0x01,0x00,0x6f,0x60,0xfe,0xf0,0x5e,0xff,
0xf4,0x40,0x1a,0x91,0x89,0x01,0x01,0x00,0x6f,0x60,0xfe,0xf0,0x5e,0xff,0xf4,0xa4,0x0f,
0xe4,0x7a,0x14,0xff,0xff,0xff,0x01,0x1a,0x91,0x89,0x01,0x0f,0xc0,0x5e,0xff,0xf4,0x40,
0x1a,0x91,0x89,0x01,0x0f,0xc0,0x5e,0xff,0xf4,0xa4,0x6e,0x6b,0xff,0x00,0x0d,0xb2,0x0c,
0xa2,0x0c,0x3a,0x0c,0xb3,0x18,0xbb,0x0d,0x2b,0x7a,0x63,0x00,0x00,0xff,0x00,0x6e,0x6a,
0xff,0x01,0xf2,0x00,0x17,0x72,0x0a,0xa3,0x0d,0xb2,0x0c,0xa2,0x0c,0x3a,0x0c,0xb3,0x18,
0xbb,0x0d,0x2b,0x01,0x00,0x6f,0xe3,0xfe,0xfc,0x1a,0x91,0x81,0x01,0x01,0x00,0x6f,0x60,
0xfe,0xf0,0x5e,0xff,0xf4,0x40,0x1a,0xa2,0x01,0x00,0x6f,0xe2,0xfe,0xf8,0x1a,0xd5,0x01,
0x00,0x6f,0x64,0xfe,0xfc,0x0a,0xd4,0x01,0x00,0x6f,0x61,0xfe,0xf0,0x0a,0xd1,0x0f,0xc0,
0x5e,0xff,0xf6,0xdc,0x01,0x00,0x6f,0x62,0xfe,0xf8,0x01,0xf0,0x64,0x02,0x01,0x00,0x6f,
0xe2,0xfe,0xf8,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x01,0x46,0x0a,
0x1a,0x91,0x89,0x20,0x0f,0xc0,0x5e,0xff,0xf4,0xa4,0x7a,0x15,0x00,0x00,0x00,0x20,0x7a,
0x25,0x00,0x00,0x00,0xff,0x4f,0xb4,0x01,0x00,0x6f,0x62,0xfe,0xf8,0x46,0x04,0xfa,0x53,
0x40,0x02,0xfa,0x46,0x6e,0xea,0xff,0x00,0x1a,0x91,0x89,0x01,0x0f,0xe0,0x7a,0x10,0xff,
0xff,0xff,0x00,0x5e,0xff,0xf4,0xa4,0x58,0x00,0xff,0x0c,0x01,0x00,0x6d,0xf6,0x0f,0xf6,
0x0f,0x81,0x7a,0x00,0x00,0xff,0xff,0x8c,0x79,0x02,0x5a,0xc0,0x69,0x82,0x7a,0x03,0x00,
0xfe,0xe0,0x12,0x68,0x3a,0xea,0x7f,0x68,0xba,0x79,0x02,0xa5,0x7f,0x69,0x82,0x7a,0x03,
0x00,0xfe,0xe0,0x30,0x68,0x3a,0xca,0x10,0x68,0xba,0x1a,0xb3,0x0b,0x03,0x7a,0x23,0x00,
0x00,0x00,0x63,0x4f,0xf6,0x7a,0x02,0x00,0xfe,0xe0,0x30,0x68,0x2b,0xcb,0x01,0x68,0xab,
0x1a,0xb3,0x0f,0x92,0x0a,0x92,0x1f,0xa3,0x4c,0x0a,0x0f,0x90,0x0a,0x90,0x0b,0x03,0x1f,
0x83,0x4d,0xfa,0x7a,0x03,0x00,0xfe,0xe0,0x30,0x68,0x3a,0xea,0xfe,0x68,0xba,0x1a,0xb3,
0x0b,0x03,0x7a,0x23,0x00,0x00,0x00,0x13,0x4f,0xf6,0x7a,0x03,0x00,0xfe,0xe0,0x30,0x68,
0x3a,0xea,0xef,0x68,0xba,0x1a,0xb3,0x0b,0x03,0x7a,0x23,0x00,0x00,0x00,0x13,0x4f,0xf6,
0x7a,0x03,0x00,0xff,0xff,0x8c,0x79,0x02,0xa5,0x1f,0x69,0xb2,0x01,0x00,0x6d,0x76,0x54,
0x70,0x01,0x00,0x6d,0xf6,0x0f,0xf6,0x1b,0x97,0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,
0x01,0x00,0x6f,0xe0,0xff,0xfc,0x0f,0x95,0x7a,0x03,0x00,0xfe,0xe0,0x03,0xfa,0xff,0x68,
0xba,0x7a,0x03,0x00,0xfe,0xe0,0x30,0x68,0x3a,0xca,0x40,0x68,0xba,0x1a,0xa2,0x0b,0x02,
0x7a,0x22,0x00,0x00,0x00,0x13,0x4f,0xf6,0x1a,0xa2,0x01,0x00,0x6b,0xa2,0x00,0xff,0xf8,
0xee,0x7a,0x01,0x00,0xff,0xf8,0xca,0x01,0x00,0x6b,0x23,0x00,0xff,0xf8,0xee,0x0f,0xb0,
0x0a,0x90,0x0f,0xd2,0x0a,0xb2,0x68,0x2a,0x68,0x8a,0x0b,0x03,0x01,0x00,0x6b,0xa3,0x00,
0xff,0xf8,0xee,0x7a,0x23,0x00,0x00,0x00,0x1f,0x4f,0xda,0x1a,0xa2,0x01,0x00,0x6b,0xa2,
0x00,0xff,0xf8,0xf2,0x01,0x00,0x6b,0x22,0x00,0xff,0xf8,0xf2,0x0b,0x02,0x01,0x00,0x6b,
0xa2,0x00,0xff,0xf8,0xf2,0x1a,0xa2,0x01,0x00,0x6b,0xa2,0x00,0xff,0xf8,0xf6,0x01,0x00,
0x6b,0xa2,0x00,0xff,0xf8,0xee,0x7a,0x00,0x00,0xff,0xf8,0xca,0x01,0x00,0x6b,0x22,0x00,
0xff,0xf8,0xee,0x01,0x00,0x6f,0x63,0xff,0xfc,0x0a,0xa3,0x0a,0x82,0x68,0x2a,0x68,0xba,
0x01,0x00,0x6b,0x22,0x00,0xff,0xf8,0xee,0x0b,0x02,0x01,0x00,0x6b,0xa2,0x00,0xff,0xf8,
0xee,0x7a,0x22,0x00,0x00,0x00,0x1f,0x4f,0xd0,0x01,0x00,0x6b,0x22,0x00,0xff,0xf8,0xf2,
0x7a,0x00,0x00,0x00,0x01,0xf4,0x7a,0x22,0x00,0x00,0x00,0x04,0x4e,0x04,0x1a,0x80,0x88,
0x96,0x5e,0xff,0xf6,0x3c,0x7a,0x03,0x00,0xfe,0xe0,0x30,0x68,0x3a,0xca,0x04,0x68,0xba,
0x1a,0xa2,0x0b,0x02,0x7a,0x22,0x00,0x00,0x00,0x07,0x4f,0xf6,0x01,0x00,0x6f,0x64,0xff,
0xfc,0x1a,0xa2,0x01,0x00,0x6b,0xa2,0x00,0xff,0xf8,0xee,0xfa,0xff,0x68,0xca,0x1a,0xa2,
0x0b,0x02,0x7a,0x22,0x00,0x00,0x00,0x03,0x4f,0xf6,0x68,0x4b,0x6a,0xab,0x00,0xff,0xf8,
0xea,0x01,0x00,0x6b,0x22,0x00,0xff,0xf8,0xee,0x0a,0xd2,0x68,0x2a,0x1c,0xab,0x47,0x0c,
0x1a,0xa2,0x8a,0x01,0x01,0x00,0x6b,0xa2,0x00,0xff,0xf8,0xf6,0x01,0x00,0x6b,0x20,0x00,
0xff,0xf8,0xee,0x0f,0x81,0x7a,0x11,0x00,0xff,0xf8,0xca,0x0f,0xd3,0x0a,0x83,0x6a,0x2a,
0x00,0xff,0xf8,0xea,0x17,0x0a,0x68,0x3b,0x14,0xba,0x68,0x9a,0x0b,0x04,0x0b,0x00,0x01,
0x00,0x6b,0xa0,0x00,0xff,0xf8,0xee,0x7a,0x20,0x00,0x00,0x00,0x1f,0x4f,0x96,0x7a,0x03,
0x00,0xfe,0xe0,0x30,0x68,0x3a,0xea,0xfb,0x68,0xba,0x01,0x00,0x6b,0x22,0x00,0xff,0xf8,
0xf2,0x7a,0x22,0x00,0x00,0x01,0x93,0x4f,0x18,0x68,0x3a,0xea,0xbf,0x68,0xba,0x1a,0xa2,
0x0b,0x02,0x7a,0x22,0x00,0x00,0x00,0xc7,0x4f,0xf6,0x1a,0x80,0x1b,0x00,0x40,0x26,0x01,
0x00,0x6b,0x22,0x00,0xff,0xf8,0xf6,0x58,0x60,0xfe,0xb6,0x7a,0x03,0x00,0xfe,0xe0,0x30,
0x68,0x3a,0xea,0xbf,0x68,0xba,0x1a,0xa2,0x0b,0x02,0x7a,0x22,0x00,0x00,0x00,0xc7,0x4f,
0xf6,0x1a,0x80,0x01,0x00,0x6d,0x75,0x01,0x00,0x6d,0x74,0x0b,0x97,0x01,0x00,0x6d,0x76,
0x54,0x70};

static unsigned char bin3068[0x500] = {
0x7a,0x07,0x00,0xff,0xff,0x1c,0x5e,0xff,0xc8,0x18,0x40,0xf4,0x01,0x00,0x6d,0xf6,0x0f,
0xf6,0x7a,0x03,0x00,0xff,0xff,0xba,0x18,0xaa,0x68,0xba,0x1a,0xa2,0x0b,0x02,0x7a,0x22,
0x00,0x00,0x01,0x17,0x4f,0xf6,0x7a,0x03,0x00,0xff,0xff,0xba,0xfa,0x30,0x68,0xba,0x0b,
0x83,0x68,0x3a,0xea,0x87,0x68,0xba,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,
0x0f,0xf6,0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x0f,0x85,0x0f,0x94,0x1a,0x80,0x1f,
0xc0,0x4c,0x3c,0x7a,0x01,0x00,0xff,0xff,0xbc,0x68,0x1a,0xea,0x78,0x47,0xfa,0x7a,0x03,
0x00,0xff,0xff,0xbc,0x68,0x3a,0x73,0x6a,0x46,0x0a,0xfa,0xc7,0x68,0xba,0x1a,0x80,0x1b,
0x00,0x40,0x1c,0x0f,0xd3,0x0a,0x83,0x7a,0x02,0x00,0xff,0xff,0xbd,0x68,0x2a,0x68,0xba,
0x68,0x1a,0xea,0xbf,0x68,0x9a,0x0b,0x00,0x1f,0xc0,0x4d,0xca,0x1a,0x80,0x01,0x00,0x6d,
0x75,0x01,0x00,0x6d,0x74,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,0x0f,0xf6,
0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x0f,0x84,0x1a,0x80,0x1f,0x90,0x4c,0x24,0x7a,
0x03,0x00,0xff,0xff,0xbc,0x7a,0x05,0x00,0xff,0xff,0xbb,0x68,0x3a,0x4c,0xfc,0x0f,0xc2,
0x0a,0x82,0x68,0x2a,0x68,0xda,0x68,0x3a,0xea,0x7f,0x68,0xba,0x0b,0x00,0x1f,0x90,0x4d,
0xe8,0x7a,0x03,0x00,0xff,0xff,0xbc,0x68,0x3a,0x73,0x2a,0x47,0xfa,0x01,0x00,0x6d,0x75,
0x01,0x00,0x6d,0x74,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,0x0f,0xf6,0x7a,
0x37,0x00,0x00,0x01,0x0c,0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x5e,0xff,0xc7,0x2c,
0x0f,0xe4,0x7a,0x14,0xff,0xff,0xff,0x00,0x1a,0x91,0x89,0x01,0x0f,0xc0,0x5e,0xff,0xc7,
0x60,0x6e,0x6a,0xff,0x00,0xf2,0x00,0x17,0x72,0x01,0x00,0x6f,0xe2,0xfe,0xf8,0x1a,0x91,
0x89,0x01,0x0f,0xc0,0x5e,0xff,0xc7,0xc4,0x0f,0xe2,0x7a,0x12,0xff,0xff,0xff,0x00,0x01,
0x00,0x6f,0xe2,0xfe,0xf4,0x1a,0x91,0x89,0x01,0x01,0x00,0x6f,0x60,0xfe,0xf4,0x5e,0xff,
0xc7,0x60,0x1a,0x91,0x89,0x01,0x01,0x00,0x6f,0x60,0xfe,0xf4,0x5e,0xff,0xc7,0xc4,0x0f,
0xe4,0x7a,0x14,0xff,0xff,0xff,0x01,0x1a,0x91,0x89,0x01,0x0f,0xc0,0x5e,0xff,0xc7,0x60,
0x1a,0x91,0x89,0x01,0x0f,0xc0,0x5e,0xff,0xc7,0xc4,0x6e,0x68,0xff,0x00,0x0d,0x82,0x0c,
0xa2,0x0c,0x0a,0x0c,0x80,0x18,0x88,0x0d,0x28,0x0f,0x83,0x7a,0x63,0x00,0x00,0xff,0x00,
0x6e,0x6a,0xff,0x01,0xf2,0x00,0x17,0x72,0x0f,0xb0,0x0a,0xa0,0x0f,0x84,0x0d,0xc2,0x0c,
0xa2,0x0c,0x4a,0x0c,0xc4,0x18,0xcc,0x0d,0x2c,0x1a,0x91,0x81,0x01,0x01,0x00,0x6f,0x60,
0xfe,0xf4,0x5e,0xff,0xc7,0x60,0x01,0x00,0x6f,0x61,0xfe,0xf4,0x0f,0xc0,0x5e,0xff,0xca,
0x02,0x01,0x00,0x6f,0xe0,0xfe,0xfc,0x01,0x00,0x6f,0x62,0xfe,0xf8,0x7a,0x22,0x00,0x00,
0x00,0x01,0x46,0x0a,0x1a,0x91,0x89,0x80,0x0f,0xc0,0x5e,0xff,0xc7,0xc4,0x7a,0x14,0x00,
0x00,0x00,0x80,0x0f,0xe1,0x7a,0x11,0xff,0xff,0xff,0x80,0x0f,0xc0,0x5e,0xff,0xca,0x02,
0x0f,0x85,0x01,0x00,0x6f,0x62,0xfe,0xf8,0x7a,0x22,0x00,0x00,0x00,0x01,0x46,0x0a,0x1a,
0x91,0x89,0x80,0x0f,0xc0,0x5e,0xff,0xc7,0xc4,0x01,0x00,0x6f,0x62,0xfe,0xfc,0x46,0x08,
0x0f,0xd5,0x46,0x04,0xfa,0x53,0x40,0x02,0xfa,0x46,0x6e,0xea,0xff,0x00,0x1a,0x91,0x89,
0x01,0x0f,0xe0,0x7a,0x10,0xff,0xff,0xff,0x00,0x5e,0xff,0xc7,0xc4,0x58,0x00,0xff,0x06,
0x01,0x00,0x6d,0xf6,0x0f,0xf6,0x0f,0x81,0x7a,0x00,0x00,0xff,0xff,0x8c,0x79,0x02,0x5a,
0xc0,0x69,0x82,0x7a,0x03,0x00,0xfe,0xe0,0x12,0x68,0x3a,0xea,0x7f,0x68,0xba,0x79,0x02,
0xa5,0x7f,0x69,0x82,0x7a,0x03,0x00,0xfe,0xe0,0x30,0x68,0x3a,0xca,0x10,0x68,0xba,0x1a,
0xb3,0x0b,0x03,0x7a,0x23,0x00,0x00,0x00,0x63,0x4f,0xf6,0x7a,0x02,0x00,0xfe,0xe0,0x30,
0x68,0x2b,0xcb,0x01,0x68,0xab,0x1a,0xb3,0x0f,0x92,0x0a,0x92,0x1f,0xa3,0x4c,0x0a,0x0f,
0x90,0x0a,0x90,0x0b,0x03,0x1f,0x83,0x4d,0xfa,0x7a,0x03,0x00,0xfe,0xe0,0x30,0x68,0x3a,
0xea,0xfe,0x68,0xba,0x1a,0xb3,0x0b,0x03,0x7a,0x23,0x00,0x00,0x00,0x13,0x4f,0xf6,0x7a,
0x03,0x00,0xfe,0xe0,0x30,0x68,0x3a,0xea,0xef,0x68,0xba,0x1a,0xb3,0x0b,0x03,0x7a,0x23,
0x00,0x00,0x00,0x13,0x4f,0xf6,0x7a,0x03,0x00,0xff,0xff,0x8c,0x79,0x02,0xa5,0x1f,0x69,
0xb2,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,0x0f,0xf6,0x7a,0x37,0x00,0x00,
0x01,0x14,0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x01,0x00,0x6f,0xe0,0xfe,0xfc,0x01,
0x00,0x6f,0xe1,0xfe,0xf8,0x7a,0x03,0x00,0xfe,0xe0,0x30,0x68,0x3a,0xca,0x40,0x68,0xba,
0x1a,0x91,0x0f,0xe0,0x7a,0x10,0xff,0xff,0xff,0x80,0x0f,0x82,0x0a,0x92,0x01,0x00,0x6f,
0x63,0xfe,0xf8,0x0a,0x93,0x68,0x3b,0x68,0xab,0x0b,0x01,0x7a,0x21,0x00,0x00,0x00,0x7f,
0x4f,0xe6,0x1a,0xa2,0x01,0x00,0x6f,0xe2,0xfe,0xf4,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x0b,
0x02,0x01,0x00,0x6f,0xe2,0xfe,0xf4,0x1a,0xa2,0x01,0x00,0x6f,0xe2,0xfe,0xf0,0x1a,0x91,
0x0f,0xe0,0x7a,0x10,0xff,0xff,0xff,0x80,0x01,0x00,0x6f,0x62,0xfe,0xfc,0x0a,0x92,0x0f,
0x83,0x0a,0x93,0x68,0x3b,0x68,0xab,0x0b,0x01,0x7a,0x21,0x00,0x00,0x00,0x7f,0x4f,0xe6,
0x1a,0x80,0x88,0xc8,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x06,0x4e,
0x04,0x1a,0x80,0x88,0x1e,0x5e,0xff,0xc9,0x62,0x6a,0x2a,0x00,0xfe,0xe0,0x30,0xca,0x04,
0x6a,0xaa,0x00,0xfe,0xe0,0x30,0x1a,0xa2,0x0b,0x02,0x7a,0x22,0x00,0x00,0x00,0x07,0x4f,
0xf6,0x01,0x00,0x6f,0x65,0xfe,0xfc,0x1a,0x91,0x0f,0xe2,0x7a,0x12,0xff,0xff,0xff,0x80,
0x01,0x00,0x6f,0xe2,0xfe,0xec,0xfa,0xff,0x68,0xda,0x1a,0xa2,0x0b,0x02,0x7a,0x22,0x00,
0x00,0x00,0x03,0x4f,0xf6,0x68,0x5c,0x01,0x00,0x6f,0x62,0xfe,0xf8,0x0a,0x92,0x68,0x2a,
0x1c,0xac,0x47,0x0a,0x1a,0xa2,0x8a,0x01,0x01,0x00,0x6f,0xe2,0xfe,0xf0,0x01,0x00,0x6f,
0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x06,0x4e,0x14,0x0f,0xe3,0x0a,0x93,0x01,0x00,
0x6f,0x62,0xfe,0xec,0x0a,0x92,0x68,0x2a,0x14,0xca,0x6e,0xba,0xff,0x00,0x01,0x00,0x6f,
0x60,0xfe,0xec,0x0a,0x90,0x01,0x00,0x6f,0x63,0xfe,0xf8,0x0a,0x93,0x0c,0xca,0x17,0x0a,
0x68,0x3b,0x14,0xba,0x68,0x8a,0x0b,0x05,0x0b,0x01,0x7a,0x21,0x00,0x00,0x00,0x7f,0x4f,
0x8e,0x6a,0x2a,0x00,0xfe,0xe0,0x30,0xea,0xfb,0x6a,0xaa,0x00,0xfe,0xe0,0x30,0x01,0x00,
0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x06,0x4e,0x3e,0x1a,0x91,0x0f,0xe0,0x7a,
0x10,0xff,0xff,0xff,0x80,0x01,0x00,0x6f,0x62,0xfe,0xfc,0x0a,0x92,0x0f,0x83,0x0a,0x93,
0x68,0x3b,0x68,0xab,0x0b,0x01,0x7a,0x21,0x00,0x00,0x00,0x7f,0x4f,0xe6,0x1a,0x80,0x88,
0xc8,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x06,0x4e,0x04,0x1a,0x80,
0x88,0x1e,0x5e,0xff,0xc9,0x62,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x03,
0xe8,0x4f,0x20,0x6a,0x2a,0x00,0xfe,0xe0,0x30,0xea,0xbf,0x6a,0xaa,0x00,0xfe,0xe0,0x30,
0x1a,0xa2,0x0b,0x02,0x7a,0x22,0x00,0x00,0x00,0xc7,0x4f,0xf6,0x1a,0x80,0x1b,0x00,0x40,
0x24,0x01,0x00,0x6f,0x62,0xfe,0xf0,0x58,0x60,0xfe,0x78,0x7a,0x03,0x00,0xfe,0xe0,0x30,
0x68,0x3a,0xea,0xbf,0x68,0xba,0x1a,0xa2,0x0b,0x02,0x7a,0x22,0x00,0x00,0x00,0xc7,0x4f,
0xf6,0x1a,0x80,0x01,0x00,0x6d,0x75,0x01,0x00,0x6d,0x74,0x7a,0x17,0x00,0x00,0x01,0x14,
0x01,0x00,0x6d,0x76,0x54,0x70};

static unsigned char bin3664[0x500] = {
0x79,0x07,0xfd,0x7e,0x5e,0x00,0xf8,0x46,0x40,0xf6,0x6d,0xf6,0x0d,0x76,0x79,0x03,0xff,
0xaa,0x18,0xaa,0x68,0xba,0x19,0x22,0x79,0x03,0x00,0xc7,0x0b,0x02,0x1d,0x32,0x4f,0xfa,
0x79,0x03,0xff,0xaa,0xfa,0x30,0x68,0xba,0x0b,0x83,0x68,0x3a,0xfa,0x80,0x68,0xba,0x6d,
0x76,0x54,0x70,0x6d,0xf6,0x0d,0x76,0x6d,0xf4,0x6d,0xf5,0x0d,0x04,0x19,0x00,0x1d,0x10,
0x4c,0x3c,0x79,0x05,0xff,0xac,0x68,0x5a,0x73,0x6a,0x46,0x20,0x79,0x03,0xff,0xac,0x68,
0x3a,0xea,0x38,0x47,0x0c,0x68,0x3a,0xfa,0x40,0x68,0xba,0x79,0x00,0xff,0xff,0x40,0x1c,
0x79,0x02,0xff,0xac,0x68,0x2a,0x73,0x6a,0x47,0xe4,0x0d,0x42,0x09,0x02,0x79,0x03,0xff,
0xad,0x68,0x3b,0x68,0xab,0x0b,0x00,0x1d,0x10,0x4d,0xc8,0x6d,0x75,0x6d,0x74,0x6d,0x76,
0x54,0x70,0x6d,0xf6,0x0d,0x76,0x6d,0xf4,0x6d,0xf5,0x0d,0x04,0x19,0x33,0x1d,0x13,0x4c,
0x1a,0x79,0x00,0xff,0xac,0x79,0x05,0xff,0xab,0x68,0x0a,0x4c,0xfc,0x0d,0x42,0x09,0x32,
0x68,0x2a,0x68,0xda,0x0b,0x03,0x1d,0x13,0x4d,0xee,0x79,0x03,0xff,0xac,0x68,0x3a,0x73,
0x2a,0x47,0xfa,0x6d,0x75,0x6d,0x74,0x6d,0x76,0x54,0x70,0x6d,0xf6,0x0d,0x76,0x79,0x03,
0x00,0x84,0x19,0x37,0x6d,0xf4,0x6d,0xf5,0x5e,0x00,0xf7,0x8a,0x79,0x04,0xff,0x80,0x09,
0x64,0x79,0x01,0x00,0x01,0x0d,0x40,0x5e,0x00,0xf7,0xb6,0x79,0x01,0x00,0x01,0x0d,0x40,
0x5e,0x00,0xf8,0x0a,0x79,0x02,0xff,0x80,0x09,0x62,0x6f,0xe2,0xff,0x7c,0x79,0x01,0x00,
0x01,0x6f,0x60,0xff,0x7c,0x5e,0x00,0xf7,0xb6,0x79,0x01,0x00,0x01,0x6f,0x60,0xff,0x7c,
0x5e,0x00,0xf8,0x0a,0x79,0x04,0xff,0x81,0x09,0x64,0x79,0x01,0x00,0x01,0x0d,0x40,0x5e,
0x00,0xf7,0xb6,0x79,0x01,0x00,0x01,0x0d,0x40,0x5e,0x00,0xf8,0x0a,0x6e,0x6c,0xff,0x81,
0x0c,0xc4,0x18,0xcc,0x79,0x01,0x01,0x00,0x6f,0x60,0xff,0x7c,0x5e,0x00,0xf7,0xb6,0x6f,
0x61,0xff,0x7c,0x0d,0x40,0x5e,0x00,0xf9,0x96,0x6f,0xe0,0xff,0x7e,0x79,0x00,0x00,0x80,
0x09,0x40,0x0d,0x61,0x5e,0x00,0xf9,0x96,0x0d,0x05,0x79,0x01,0x01,0x00,0x0d,0x40,0x5e,
0x00,0xf8,0x0a,0x6f,0x62,0xff,0x7e,0x46,0x08,0x0d,0x55,0x46,0x04,0xfa,0x53,0x40,0x02,
0xfa,0x46,0x6e,0xea,0xff,0x80,0x79,0x01,0x00,0x01,0x79,0x00,0xff,0x80,0x09,0x60,0x5e,
0x00,0xf8,0x0a,0x5a,0x00,0xf8,0x7c,0x6d,0xf6,0x0d,0x76,0x0d,0x01,0x79,0x00,0xff,0xc0,
0xfa,0x5a,0x68,0x8a,0x79,0x03,0xff,0xc2,0xfa,0xff,0x68,0xba,0x1b,0x03,0xfa,0xf2,0x68,
0xba,0xfa,0xa6,0x68,0x8a,0x79,0x03,0xff,0x90,0x68,0x3a,0xca,0x10,0x68,0xba,0x19,0x22,
0x79,0x03,0x00,0x31,0x0b,0x02,0x1d,0x32,0x4f,0xfa,0x79,0x03,0xff,0x90,0x68,0x3a,0xca,
0x01,0x68,0xba,0x19,0x22,0x1d,0x12,0x4c,0x06,0x0b,0x02,0x1d,0x12,0x4d,0xfa,0x79,0x03,
0xff,0x90,0x68,0x3a,0xea,0xfe,0x68,0xba,0x19,0x22,0x79,0x03,0x00,0x04,0x0b,0x02,0x1d,
0x32,0x4f,0xfa,0x79,0x03,0xff,0x90,0x68,0x3a,0xea,0xef,0x68,0xba,0x19,0x22,0x79,0x03,
0x00,0x04,0x0b,0x02,0x1d,0x32,0x4f,0xfa,0x79,0x02,0xff,0xc0,0xfb,0xa2,0x68,0xab,0xfb,
0xaa,0x68,0xab,0x6d,0x76,0x54,0x70,0x6d,0xf6,0x0d,0x76,0x79,0x03,0x01,0x0e,0x19,0x37,
0x6d,0xf4,0x6d,0xf5,0x6f,0xe0,0xfe,0xfe,0x6f,0xe1,0xfe,0xfc,0x6f,0x65,0xfe,0xfe,0x79,
0x03,0xff,0x90,0x68,0x3a,0xca,0x40,0x68,0xba,0x19,0x22,0x0b,0x02,0x0d,0x22,0x4f,0xfa,
0x19,0x11,0x79,0x04,0x00,0x7f,0x79,0x00,0xff,0x80,0x09,0x60,0x0d,0x02,0x09,0x12,0x6f,
0x63,0xfe,0xfc,0x09,0x13,0x68,0x3b,0x68,0xab,0x0b,0x01,0x1d,0x41,0x4f,0xec,0x19,0x22,
0x6f,0xe2,0xfe,0xfa,0x79,0x03,0x00,0x7f,0x6f,0xe3,0xfe,0xf6,0x6f,0x64,0xfe,0xfa,0x0b,
0x04,0x6f,0xe4,0xfe,0xfa,0x19,0x22,0x6f,0xe2,0xfe,0xf8,0x19,0x11,0x79,0x00,0xff,0x80,
0x09,0x60,0x6f,0x62,0xfe,0xfe,0x09,0x12,0x0d,0x03,0x09,0x13,0x68,0x3b,0x68,0xab,0x0b,
0x01,0x6f,0x63,0xfe,0xf6,0x1d,0x31,0x4f,0xe8,0x79,0x02,0x00,0x06,0x79,0x00,0x00,0xc8,
0x6f,0x64,0xfe,0xfa,0x1d,0x24,0x4e,0x04,0x79,0x00,0x00,0x1e,0x5e,0x00,0xf9,0x0e,0x6a,
0x0a,0xff,0x90,0xca,0x04,0x6a,0x8a,0xff,0x90,0x19,0x22,0x79,0x03,0x00,0x03,0x0b,0x02,
0x1d,0x32,0x4f,0xfa,0x19,0x11,0x79,0x02,0xff,0x80,0x09,0x62,0x6f,0xe2,0xfe,0xf2,0x0d,
0x53,0x09,0x13,0xfa,0xff,0x68,0xba,0x19,0x22,0x0b,0x02,0x79,0x03,0x00,0x01,0x1d,0x32,
0x4f,0xf6,0x0d,0x52,0x09,0x12,0x68,0x2b,0x6f,0x62,0xfe,0xfc,0x09,0x12,0x68,0x2a,0x1c,
0xab,0x47,0x08,0x79,0x04,0x00,0x01,0x6f,0xe4,0xfe,0xf8,0x79,0x02,0x00,0x06,0x6f,0x63,
0xfe,0xfa,0x1d,0x23,0x4f,0x18,0x0d,0x60,0x09,0x10,0x6f,0x64,0xfe,0xf2,0x09,0x14,0x0d,
0x52,0x09,0x12,0x68,0x2a,0x68,0x4b,0x14,0xba,0x6e,0x8a,0xff,0x00,0x6f,0x60,0xfe,0xf2,
0x09,0x10,0x6f,0x63,0xfe,0xfc,0x09,0x13,0x0d,0x52,0x09,0x12,0x68,0x2a,0x17,0x0a,0x68,
0x3b,0x14,0xba,0x68,0x8a,0x0b,0x01,0x6f,0x64,0xfe,0xf6,0x1d,0x41,0x4e,0x04,0x5a,0x00,
0xfa,0x5a,0x6a,0x0a,0xff,0x90,0xea,0xfb,0x6a,0x8a,0xff,0x90,0x79,0x02,0x00,0x06,0x6f,
0x63,0xfe,0xfa,0x1d,0x23,0x4f,0x28,0x19,0x11,0x79,0x04,0x00,0x7f,0x79,0x00,0xff,0x00,
0x09,0x60,0x6f,0x62,0xfe,0xfe,0x09,0x12,0x0d,0x03,0x09,0x13,0x68,0x3b,0x68,0xab,0x0b,
0x01,0x1d,0x41,0x4f,0xec,0x79,0x00,0x00,0x0a,0x5e,0x00,0xf9,0x0e,0x79,0x02,0x03,0xe8,
0x6f,0x64,0xfe,0xfa,0x1d,0x24,0x4f,0x1c,0x6a,0x0a,0xff,0x90,0xea,0xbf,0x6a,0x8a,0xff,
0x90,0x19,0x22,0x79,0x03,0x00,0x63,0x0b,0x02,0x1d,0x32,0x4f,0xfa,0x79,0x00,0xff,0xff,
0x40,0x22,0x6f,0x62,0xfe,0xf8,0x47,0x04,0x5a,0x00,0xf9,0xf0,0x79,0x03,0xff,0x90,0x68,
0x3a,0xea,0xbf,0x68,0xba,0x19,0x22,0x79,0x03,0x00,0x63,0x0b,0x02,0x1d,0x32,0x4f,0xfa,
0x19,0x00,0x6d,0x75,0x6d,0x74,0x79,0x03,0x01,0x0e,0x09,0x37,0x6d,0x76,0x54,0x70};

static char bin3064[0x500] = {
0x7a,0x07,0x00,0xff,0xff,0x1c,0x5e,0xff,0xe8,0x18,0x40,0xf4,0x01,0x00,0x6d,0xf6,0x0f,
0xf6,0x7a,0x03,0x00,0xff,0xff,0xba,0x18,0xaa,0x68,0xba,0x1a,0xa2,0x0b,0x02,0x7a,0x22,
0x00,0x00,0x01,0x17,0x4f,0xf6,0x7a,0x03,0x00,0xff,0xff,0xba,0xfa,0x30,0x68,0xba,0x0b,
0x83,0x68,0x3a,0xea,0x87,0x68,0xba,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,
0x0f,0xf6,0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x0f,0x85,0x0f,0x94,0x1a,0x80,0x1f,
0xc0,0x4c,0x3c,0x7a,0x01,0x00,0xff,0xff,0xbc,0x68,0x1a,0xea,0x78,0x47,0xfa,0x7a,0x03,
0x00,0xff,0xff,0xbc,0x68,0x3a,0x73,0x6a,0x46,0x0a,0xfa,0xc7,0x68,0xba,0x1a,0x80,0x1b,
0x00,0x40,0x1c,0x0f,0xd3,0x0a,0x83,0x7a,0x02,0x00,0xff,0xff,0xbd,0x68,0x2a,0x68,0xba,
0x68,0x1a,0xea,0xbf,0x68,0x9a,0x0b,0x00,0x1f,0xc0,0x4d,0xca,0x1a,0x80,0x01,0x00,0x6d,
0x75,0x01,0x00,0x6d,0x74,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,0x0f,0xf6,
0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x0f,0x84,0x1a,0x80,0x1f,0x90,0x4c,0x24,0x7a,
0x03,0x00,0xff,0xff,0xbc,0x7a,0x05,0x00,0xff,0xff,0xbb,0x68,0x3a,0x4c,0xfc,0x0f,0xc2,
0x0a,0x82,0x68,0x2a,0x68,0xda,0x68,0x3a,0xea,0x7f,0x68,0xba,0x0b,0x00,0x1f,0x90,0x4d,
0xe8,0x7a,0x03,0x00,0xff,0xff,0xbc,0x68,0x3a,0x73,0x2a,0x47,0xfa,0x01,0x00,0x6d,0x75,
0x01,0x00,0x6d,0x74,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,0x0f,0xf6,0x7a,
0x37,0x00,0x00,0x01,0x0c,0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x5e,0xff,0xe7,0x2c,
0x0f,0xe4,0x7a,0x14,0xff,0xff,0xff,0x00,0x1a,0x91,0x89,0x01,0x0f,0xc0,0x5e,0xff,0xe7,
0x60,0x6e,0x6a,0xff,0x00,0xf2,0x00,0x17,0x72,0x01,0x00,0x6f,0xe2,0xfe,0xf8,0x1a,0x91,
0x89,0x01,0x0f,0xc0,0x5e,0xff,0xe7,0xc4,0x0f,0xe2,0x7a,0x12,0xff,0xff,0xff,0x00,0x01,
0x00,0x6f,0xe2,0xfe,0xf4,0x1a,0x91,0x89,0x01,0x01,0x00,0x6f,0x60,0xfe,0xf4,0x5e,0xff,
0xe7,0x60,0x1a,0x91,0x89,0x01,0x01,0x00,0x6f,0x60,0xfe,0xf4,0x5e,0xff,0xe7,0xc4,0x0f,
0xe4,0x7a,0x14,0xff,0xff,0xff,0x01,0x1a,0x91,0x89,0x01,0x0f,0xc0,0x5e,0xff,0xe7,0x60,
0x1a,0x91,0x89,0x01,0x0f,0xc0,0x5e,0xff,0xe7,0xc4,0x6e,0x68,0xff,0x00,0x0d,0x82,0x0c,
0xa2,0x0c,0x0a,0x0c,0x80,0x18,0x88,0x0d,0x28,0x0f,0x83,0x7a,0x63,0x00,0x00,0xff,0x00,
0x6e,0x6a,0xff,0x01,0xf2,0x00,0x17,0x72,0x0f,0xb0,0x0a,0xa0,0x0f,0x84,0x0d,0xc2,0x0c,
0xa2,0x0c,0x4a,0x0c,0xc4,0x18,0xcc,0x0d,0x2c,0x1a,0x91,0x81,0x01,0x01,0x00,0x6f,0x60,
0xfe,0xf4,0x5e,0xff,0xe7,0x60,0x01,0x00,0x6f,0x61,0xfe,0xf4,0x0f,0xc0,0x5e,0xff,0xea,
0x02,0x01,0x00,0x6f,0xe0,0xfe,0xfc,0x01,0x00,0x6f,0x62,0xfe,0xf8,0x7a,0x22,0x00,0x00,
0x00,0x01,0x46,0x0a,0x1a,0x91,0x89,0x80,0x0f,0xc0,0x5e,0xff,0xe7,0xc4,0x7a,0x14,0x00,
0x00,0x00,0x80,0x0f,0xe1,0x7a,0x11,0xff,0xff,0xff,0x80,0x0f,0xc0,0x5e,0xff,0xea,0x02,
0x0f,0x85,0x01,0x00,0x6f,0x62,0xfe,0xf8,0x7a,0x22,0x00,0x00,0x00,0x01,0x46,0x0a,0x1a,
0x91,0x89,0x80,0x0f,0xc0,0x5e,0xff,0xe7,0xc4,0x01,0x00,0x6f,0x62,0xfe,0xfc,0x46,0x08,
0x0f,0xd5,0x46,0x04,0xfa,0x53,0x40,0x02,0xfa,0x46,0x6e,0xea,0xff,0x00,0x1a,0x91,0x89,
0x01,0x0f,0xe0,0x7a,0x10,0xff,0xff,0xff,0x00,0x5e,0xff,0xe7,0xc4,0x58,0x00,0xff,0x06,
0x01,0x00,0x6d,0xf6,0x0f,0xf6,0x0f,0x81,0x7a,0x00,0x00,0xff,0xff,0x8c,0x79,0x02,0x5a,
0xc0,0x69,0x82,0x7a,0x03,0x00,0xfe,0xe0,0x12,0x68,0x3a,0xea,0x7f,0x68,0xba,0x79,0x02,
0xa5,0x7f,0x69,0x82,0x7a,0x03,0x00,0xfe,0xe0,0x30,0x68,0x3a,0xca,0x10,0x68,0xba,0x1a,
0xb3,0x0b,0x03,0x7a,0x23,0x00,0x00,0x00,0x63,0x4f,0xf6,0x7a,0x02,0x00,0xfe,0xe0,0x30,
0x68,0x2b,0xcb,0x01,0x68,0xab,0x1a,0xb3,0x0f,0x92,0x0a,0x92,0x1f,0xa3,0x4c,0x0a,0x0f,
0x90,0x0a,0x90,0x0b,0x03,0x1f,0x83,0x4d,0xfa,0x7a,0x03,0x00,0xfe,0xe0,0x30,0x68,0x3a,
0xea,0xfe,0x68,0xba,0x1a,0xb3,0x0b,0x03,0x7a,0x23,0x00,0x00,0x00,0x13,0x4f,0xf6,0x7a,
0x03,0x00,0xfe,0xe0,0x30,0x68,0x3a,0xea,0xef,0x68,0xba,0x1a,0xb3,0x0b,0x03,0x7a,0x23,
0x00,0x00,0x00,0x13,0x4f,0xf6,0x7a,0x03,0x00,0xff,0xff,0x8c,0x79,0x02,0xa5,0x1f,0x69,
0xb2,0x01,0x00,0x6d,0x76,0x54,0x70,0x01,0x00,0x6d,0xf6,0x0f,0xf6,0x7a,0x37,0x00,0x00,
0x01,0x14,0x01,0x00,0x6d,0xf4,0x01,0x00,0x6d,0xf5,0x01,0x00,0x6f,0xe0,0xfe,0xfc,0x01,
0x00,0x6f,0xe1,0xfe,0xf8,0x7a,0x03,0x00,0xfe,0xe0,0x30,0x68,0x3a,0xca,0x40,0x68,0xba,
0x1a,0x91,0x0f,0xe0,0x7a,0x10,0xff,0xff,0xff,0x80,0x0f,0x82,0x0a,0x92,0x01,0x00,0x6f,
0x63,0xfe,0xf8,0x0a,0x93,0x68,0x3b,0x68,0xab,0x0b,0x01,0x7a,0x21,0x00,0x00,0x00,0x7f,
0x4f,0xe6,0x1a,0xa2,0x01,0x00,0x6f,0xe2,0xfe,0xf4,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x0b,
0x02,0x01,0x00,0x6f,0xe2,0xfe,0xf4,0x1a,0xa2,0x01,0x00,0x6f,0xe2,0xfe,0xf0,0x1a,0x91,
0x0f,0xe0,0x7a,0x10,0xff,0xff,0xff,0x80,0x01,0x00,0x6f,0x62,0xfe,0xfc,0x0a,0x92,0x0f,
0x83,0x0a,0x93,0x68,0x3b,0x68,0xab,0x0b,0x01,0x7a,0x21,0x00,0x00,0x00,0x7f,0x4f,0xe6,
0x1a,0x80,0x88,0xc8,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x06,0x4e,
0x04,0x1a,0x80,0x88,0x1e,0x5e,0xff,0xe9,0x62,0x6a,0x2a,0x00,0xfe,0xe0,0x30,0xca,0x04,
0x6a,0xaa,0x00,0xfe,0xe0,0x30,0x1a,0xa2,0x0b,0x02,0x7a,0x22,0x00,0x00,0x00,0x07,0x4f,
0xf6,0x01,0x00,0x6f,0x65,0xfe,0xfc,0x1a,0x91,0x0f,0xe2,0x7a,0x12,0xff,0xff,0xff,0x80,
0x01,0x00,0x6f,0xe2,0xfe,0xec,0xfa,0xff,0x68,0xda,0x1a,0xa2,0x0b,0x02,0x7a,0x22,0x00,
0x00,0x00,0x03,0x4f,0xf6,0x68,0x5c,0x01,0x00,0x6f,0x62,0xfe,0xf8,0x0a,0x92,0x68,0x2a,
0x1c,0xac,0x47,0x0a,0x1a,0xa2,0x8a,0x01,0x01,0x00,0x6f,0xe2,0xfe,0xf0,0x01,0x00,0x6f,
0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x06,0x4e,0x14,0x0f,0xe3,0x0a,0x93,0x01,0x00,
0x6f,0x62,0xfe,0xec,0x0a,0x92,0x68,0x2a,0x14,0xca,0x6e,0xba,0xff,0x00,0x01,0x00,0x6f,
0x60,0xfe,0xec,0x0a,0x90,0x01,0x00,0x6f,0x63,0xfe,0xf8,0x0a,0x93,0x0c,0xca,0x17,0x0a,
0x68,0x3b,0x14,0xba,0x68,0x8a,0x0b,0x05,0x0b,0x01,0x7a,0x21,0x00,0x00,0x00,0x7f,0x4f,
0x8e,0x6a,0x2a,0x00,0xfe,0xe0,0x30,0xea,0xfb,0x6a,0xaa,0x00,0xfe,0xe0,0x30,0x01,0x00,
0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x06,0x4e,0x3e,0x1a,0x91,0x0f,0xe0,0x7a,
0x10,0xff,0xff,0xff,0x80,0x01,0x00,0x6f,0x62,0xfe,0xfc,0x0a,0x92,0x0f,0x83,0x0a,0x93,
0x68,0x3b,0x68,0xab,0x0b,0x01,0x7a,0x21,0x00,0x00,0x00,0x7f,0x4f,0xe6,0x1a,0x80,0x88,
0xc8,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x00,0x06,0x4e,0x04,0x1a,0x80,
0x88,0x1e,0x5e,0xff,0xe9,0x62,0x01,0x00,0x6f,0x62,0xfe,0xf4,0x7a,0x22,0x00,0x00,0x03,
0xe8,0x4f,0x20,0x6a,0x2a,0x00,0xfe,0xe0,0x30,0xea,0xbf,0x6a,0xaa,0x00,0xfe,0xe0,0x30,
0x1a,0xa2,0x0b,0x02,0x7a,0x22,0x00,0x00,0x00,0xc7,0x4f,0xf6,0x1a,0x80,0x1b,0x00,0x40,
0x24,0x01,0x00,0x6f,0x62,0xfe,0xf0,0x58,0x60,0xfe,0x78,0x7a,0x03,0x00,0xfe,0xe0,0x30,
0x68,0x3a,0xea,0xbf,0x68,0xba,0x1a,0xa2,0x0b,0x02,0x7a,0x22,0x00,0x00,0x00,0xc7,0x4f,
0xf6,0x1a,0x80,0x01,0x00,0x6d,0x75,0x01,0x00,0x6d,0x74,0x7a,0x17,0x00,0x00,0x01,0x14,
0x01,0x00,0x6d,0x76,0x54,0x70};

static char bin7045[0x500] = {
0xdf,0x04,0xd0,0x07,0x40,0x0b,0x20,0x0b,0xd0,0x01,0x40,0x2b,0x00,0x0b,0x00,0x09,0xff,
0xff,0xf0,0x00,0xff,0xff,0xf8,0x00,0xff,0xff,0xf3,0x50,0xff,0xff,0xf3,0x60,0xff,0xff,
0xf0,0xa0,0x00,0x09,0x00,0x09,0x00,0x09,0x00,0x09,0x00,0x09,0x00,0x09,0x2f,0xe6,0x6e,
0xf3,0x91,0x18,0x60,0x10,0xcb,0x10,0x21,0x00,0x92,0x15,0x71,0x03,0x60,0x20,0xc9,0x38,
0x20,0x08,0x8b,0x0b,0x60,0x20,0xc9,0x40,0x20,0x08,0x89,0xf7,0x60,0x20,0xc9,0xbf,0x22,
0x00,0x61,0x10,0xa0,0x03,0x60,0x1c,0x00,0x09,0x00,0x09,0x90,0x04,0x6f,0xe3,0x00,0x0b,
0x6e,0xf6,0x81,0xb2,0x81,0xb4,0x00,0xff,0x00,0x09,0x2f,0xe6,0x6e,0xf3,0x64,0x4c,0x92,
0x10,0x61,0x20,0x41,0x11,0x89,0xfc,0x91,0x0d,0x21,0x40,0x71,0x01,0x60,0x10,0xc9,0x7f,
0x21,0x00,0x00,0x09,0x60,0x10,0xc9,0x04,0x20,0x08,0x89,0xfb,0x6f,0xe3,0x00,0x0b,0x6e,
0xf6,0x81,0xb4,0x81,0xb3,0x00,0x09,0x2f,0x86,0x2f,0x96,0x2f,0xa6,0x2f,0xb6,0x2f,0xc6,
0x2f,0xd6,0x2f,0xe6,0x4f,0x22,0x93,0x54,0x3f,0x38,0xd1,0x2c,0x41,0x0b,0x6e,0xf3,0x91,
0x50,0x60,0x10,0xcb,0x30,0x21,0x00,0xd1,0x2a,0x41,0x0b,0x00,0x09,0x91,0x4a,0x31,0xec,
0x11,0x01,0xd1,0x28,0x41,0x0b,0xe4,0x01,0xdd,0x25,0x00,0x09,0x4d,0x0b,0x00,0x09,0x68,
0x03,0xd0,0x24,0x40,0x0b,0x64,0x8c,0x4d,0x0b,0x48,0x18,0x69,0x03,0xd1,0x21,0x41,0x0b,
0x64,0x9c,0x38,0x9c,0x6a,0x83,0x4a,0x18,0xe8,0x00,0x99,0x33,0x00,0x09,0x4d,0x0b,0x00,
0x09,0x61,0x03,0x60,0xe3,0x08,0x14,0x78,0x01,0x38,0x97,0x8f,0xf7,0xec,0x00,0xe8,0x00,
0xdb,0x18,0x99,0x26,0x64,0xa3,0x34,0x8c,0x65,0xe3,0x4b,0x0b,0x35,0x8c,0x78,0x20,0x38,
0x97,0x8f,0xf7,0x2c,0x0b,0x90,0x1d,0x00,0xee,0x88,0x01,0x8b,0x0b,0xe8,0x00,0xdb,0x0f,
0x99,0x16,0x60,0xa3,0x00,0x09,0x04,0x8c,0x4b,0x0b,0x64,0x4c,0x78,0x01,0x38,0x97,0x8f,
0xf9,0x60,0xa3,0x2c,0xc8,0x8d,0x01,0xe1,0x53,0xe1,0x46,0x2e,0x10,0x64,0xe0,0xd1,0x07,
0x41,0x0b,0x64,0x4c,0xaf,0xbe,0x00,0x09,0x01,0x04,0x81,0xb2,0x00,0xfc,0x00,0xff,0x01,
0x00,0x00,0x09,0xff,0xff,0xf0,0x0c,0xff,0xff,0xf0,0x30,0xff,0xff,0xf0,0x70,0xff,0xff,
0xf2,0x30,0x00,0x09,0x00,0x09,0x00,0x09,0x00,0x09,0x2f,0xe6,0x6e,0xf3,0x92,0x47,0x91,
0x47,0x22,0x11,0xd1,0x26,0x62,0x12,0xd1,0x26,0x61,0x12,0x60,0x23,0x03,0x1c,0xe7,0x10,
0x23,0x7b,0x01,0x34,0xe1,0x00,0x92,0x3c,0x71,0x01,0x00,0x09,0x31,0x27,0x8f,0xfd,0x71,
0x01,0xd1,0x1e,0x62,0x12,0xd1,0x1e,0x61,0x12,0x60,0x23,0x03,0x1c,0xe7,0x01,0x23,0x7b,
0x01,0x34,0xe1,0x00,0x92,0x2d,0x71,0x01,0x00,0x09,0x31,0x27,0x8f,0xfd,0x71,0x01,0xd1,
0x16,0x62,0x12,0xd1,0x16,0x61,0x12,0x60,0x23,0x03,0x1c,0x97,0x22,0x23,0x79,0x01,0x34,
0xe1,0x00,0xe2,0x27,0x71,0x01,0x00,0x09,0x31,0x27,0x8f,0xfd,0x71,0x01,0xd1,0x0e,0x62,
0x12,0xd1,0x0e,0x61,0x12,0x60,0x23,0x03,0x1c,0x97,0x13,0x23,0x79,0x01,0x34,0xe1,0x00,
0xe2,0x27,0x71,0x01,0x00,0x09,0x31,0x27,0x8f,0xfd,0x71,0x01,0x92,0x04,0x91,0x09,0x22,
0x11,0x6f,0xe3,0x00,0x0b,0x6e,0xf6,0x86,0x10,0xa5,0x79,0x00,0xc7,0x03,0x1f,0x00,0xfe,
0x00,0xef,0xa5,0x5f,0xff,0xff,0xf3,0x50,0xff,0xff,0xf3,0x54,0x00,0x09,0x00,0x09,0x2f,
0x86,0x2f,0x96,0x2f,0xa6,0x2f,0xb6,0x2f,0xe6,0x4f,0x22,0x7f,0xc0,0x6e,0xf3,0x68,0x43,
0xd1,0x3c,0x38,0x16,0x8d,0x03,0x6a,0x53,0xd2,0x3b,0xa0,0x06,0xe1,0x00,0xd1,0x3a,0x38,
0x16,0x8d,0x62,0xe0,0xff,0xd2,0x37,0xe1,0x01,0x22,0x12,0xd2,0x38,0x91,0x65,0x22,0x12,
0x60,0x10,0xcb,0x40,0x21,0x00,0xe0,0x00,0xe3,0x1f,0x62,0xe3,0x72,0x20,0x00,0x09,0x01,
0xac,0x02,0x14,0x0e,0x14,0x70,0x01,0x30,0x37,0x8f,0xf9,0xe9,0x1f,0xeb,0x00,0xe0,0x00,
0x00,0x09,0x01,0xec,0x08,0x14,0x70,0x01,0x30,0x97,0x8b,0xfa,0xd1,0x2c,0x41,0x0b,0x00,
0x09,0xd1,0x29,0x62,0x12,0xd1,0x26,0x61,0x12,0x60,0x23,0x03,0x1c,0xe7,0x04,0x23,0x7b,
0x01,0x34,0xe1,0x00,0xe2,0x0f,0x71,0x01,0x31,0x27,0x8f,0xfd,0x71,0x01,0x63,0x83,0xe0,
0x00,0xe5,0xff,0xe6,0x07,0x67,0xe3,0x77,0x20,0x00,0x09,0x23,0x50,0xe1,0x00,0x71,0x01,
0x00,0x09,0x31,0x67,0x8f,0xfd,0x71,0x01,0x62,0x30,0x01,0xac,0x32,0x10,0x89,0x00,0xeb,
0x01,0x62,0x2c,0x62,0x27,0x01,0x7c,0x21,0x2b,0x0e,0x14,0x70,0x01,0x30,0x97,0x8f,0xeb,
0x73,0x01,0xd1,0x14,0x62,0x12,0xd1,0x11,0x61,0x12,0x60,0x23,0x03,0x1c,0x97,0x19,0x23,
0x79,0x01,0x34,0x2b,0xb8,0x8f,0xbf,0xeb,0x00,0x91,0x12,0x60,0x10,0xc9,0xbf,0x21,0x00,
0xe1,0x00,0x92,0x0f,0x71,0x01,0x31,0x27,0x8f,0xfd,0x71,0x01,0xe0,0x00,0x7e,0x40,0x6f,
0xe3,0x4f,0x26,0x6e,0xf6,0x6b,0xf6,0x6a,0xf6,0x69,0xf6,0x00,0x0b,0x68,0xf6,0x85,0x80,
0x00,0xfb,0x01,0x8f,0x00,0x01,0xff,0xff,0xff,0xff,0xf3,0x54,0x00,0x03,0xff,0xff,0xff,
0xff,0xf3,0x50,0xff,0xff,0xf1,0x80,0x00,0x09,0x00,0x09,0x00,0x09,0x00,0x09,};

/*
	Debug Flag, "DEBUG" is define in put.h
*/
int	debug=DEBUG;

/*
	Program name is needed for Usage.
*/
char	programname[MAXPATHLEN];

/*
	Printout error message to stderr.
	Incase it is fatal error, exit with error code.
*/
void	error_print(int level,int error_code, char *s_message){

char	*message[]={
		/*	 0:ERR_TEST	*/
		"This is TEST error !\n",
		/*	 1:ERR_OPTION	*/
		"Option Error !\n",
		/*	 2:ERR_INPUTFILE	*/
		"Can not open the input file.\n",
		/*	 3:ERR_OPENLINE	*/
		"Can not open the line to the H8/OS system.\n",
		/*	 4:ERR_INITLINE	*/
		"Can not setup the line as required.\n",
		/*	 5:ERR_READLINE	*/
		"Can not get data form the line.\n",
		/*	 6:ERR_S_FORMAT	*/
		"This Line dosen't start with\"S\".\n",
		/*	 7:ERR_H8_DATA	*/
		"Data from H8/300 system something wrong.\n",
		/*	 8:ERR_CPU_TYPE	*/
		"Please set CPU type.\n",
		/*	 9:ERR_EEPROM_WRITE	*/
		"EEPROM Write failed.\n",
		/*	10:ERR_EEPROM_TRANS	*/
		"EEPROM writing program transfer failed!\n",
		/*	11:ERR_EEPROM_TRANS	*/
		"Try to Line speed setup out of rage.\n",
		/*	12:ERR_GET_3096ID	*/
		"Can not get CPU ID for 3069 from H8/300 borad.\n",
		/*	13:ERR_BOOT_SUM		*/
		"Check sum error on boot mode command.\n",
		/*	14:ERR_ALREADY_QUERY		*/
		"It seems the H8/300 system is already in Query mode.\n",
		/*	15:ERR_SET_QUERYMODE		*/
		"Can not to set line speed and put Query mode.\n",
		/*	16:ERR_DEV_CODE		*/
		"Can not select device.\n",
		/*	17:ERR_CLK_MODE		*/
		"Illegal Clock mode.\n",
		/*	18:ERR_SET_RATE		*/
		"Error to set line rate .\n",
		/*	19:WRITE_128_ERR_WRT		*/
		"Error to write data to EEPROM.\n",
		/*	DUMMY	*/
		"DUMMY\n"
	};

	switch(level){
		case	MESSAGE:
			fprintf(stderr,"MESSAGE:");
			fprintf(stderr,message[error_code]);
			if ( s_message != NULL ) fprintf(stderr,s_message);
			break;
		case	WARNING:
			fprintf(stderr,"WARNING:");
			fprintf(stderr,message[error_code]);
			if ( s_message != NULL ) fprintf(stderr,s_message);
			break;
		case	FATAL:
			fprintf(stderr,"FATAL:");
			fprintf(stderr,message[error_code]);
			if ( s_message != NULL ) fprintf(stderr,s_message);
			exit(error_code);
		default:
			fprintf(stderr,"Unknown error ,Level:%d, Error Code:%d\n",level,error_code);
			exit(error_code);
			break;
	}
}

#ifdef Win32
 #include	<windows.h>
 HANDLE		TheFd;
 DCB		dcb;
 OVERLAPPED	WOp;
 OVERLAPPED	ROp;

 int writecom(unsigned char *data, int size) {
	unsigned long num;

	WriteFile(TheFd, data, size, &num, &WOp);
	return num;
 }

 int getbyte() {
	char	buf[2];
	int		s;
/*
WINAPI
ReadFile(
    IN HANDLE hFile,
    OUT LPVOID lpBuffer,
    IN DWORD nNumberOfBytesToRead,
    OUT LPDWORD lpNumberOfBytesRead,
    IN LPOVERLAPPED lpOverlapped
    );
 */
	do {
		ReadFile(TheFd, (LPVOID)buf, (DWORD)1, (LPDWORD)&s, (LPOVERLAPPED)&ROp);
	} while(s < 1);
	return buf[0] & 0xff;
 }
#else
 #include <termios.h>
 struct termios TheTty;
 int TheFd;
 
 ssize_t writecom(unsigned char *data, size_t size) {
	size_t	num;

	num = write( TheFd, data, size);
	return num;
 }

 ssize_t readcom(unsigned char *data, size_t size) {
	size_t	num;

	num = read( TheFd, data, size);
	return num;
 }

 unsigned char getbyte(void) {
	char	buf[2];
	int	s;

	do {
		if((s = read(TheFd, buf, 1)) == -1) {
			error_print(FATAL,ERR_READLINE,NULL);
		}
	} while(s < 1);
	return (unsigned char)buf[0];
 }
#endif

void putbyte(int c) {
	unsigned char	buf[2];

	buf[0] = c;
	writecom(buf, 1);
}	

void bytecheck(int c, int data) {
	char	buf[COMBUF_SIZE];

	if(c != data) {
#ifdef Win32
		sprintf(buf, "H8 data should be %02X, but is %02X\n",data,c);
#else
		snprintf(buf,COMBUF_SIZE,"H8 data should be %02X, but is %02X\n",data,c);
#endif
		error_print(FATAL,ERR_H8_DATA,buf);
	}
}

void opencom(char *sPort, int rate) {
#ifdef Win32
	ZeroMemory(&WOp, sizeof(WOp));
	ZeroMemory(&ROp, sizeof(ROp));
	WOp.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	ROp.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	TheFd = CreateFile(sPort, GENERIC_READ | GENERIC_WRITE,
	                   0, NULL, OPEN_EXISTING, 0, NULL);
	if(TheFd == INVALID_HANDLE_VALUE) {
		fprintf(stderr, "%s open error!!\n", sPort );
		return -1;
	}
	dcb.DCBlength = sizeof(DCB);
	GetCommState(TheFd, &dcb);
	dcb.BaudRate = rate;
	dcb.ByteSize = 8;
	dcb.Parity = NOPARITY;
	dcb.StopBits = ONESTOPBIT;
	SetCommState(TheFd, &dcb);
#else
	int	ratedef;
	char	buf[256];
	
	ratedef = 2400;
	switch(rate) {
		case 2400: ratedef = B2400; break;
		case 4800: ratedef = B4800; break;
		case 9600: ratedef = B9600; break;
		case 19200: ratedef = B19200; break;
		case 38400: ratedef = B38400; break;
		case 57600: ratedef = B57600; break;
		case 115200: ratedef = B115200; break;
		default:
			snprintf(buf,sizeof(buf),"Try to set speed : %d [bps]\n",rate);
			error_print(FATAL,ERR_LINESPEED,buf);
	}
	if((TheFd=open( sPort , O_RDWR)) == -1){
		error_print(FATAL,ERR_OPENLINE,sPort);
	}
	tcsetpgrp(TheFd, getpgrp());
	tcgetattr(TheFd, &TheTty);
	cfsetispeed(&TheTty, ratedef);
	cfsetospeed(&TheTty, ratedef);
	/* Set terminal mode as follows:
	   Noncanonical mode - turn off ICANON.
	   Turn off signal-generation (ISIG)
	   	including BREAK character (BRKINT).
	   Turn off any possible preprocessing of input (IEXTEN).
	   Turn ECHO mode off.
	   Disable CR-to-NL mapping on input.
	   Disable input parity detection (INPCK).
	   Disable stripping of eighth bit on input (ISTRIP).
	   Disable flow control (IXON).
	   Use eight bit characters (CS8).
	   Disable parity checking (PARENB).
	   Disable any implementation-dependent output processing (OPOST).
	   One byte at a time input (MIN=1, TIME=0).
	*/

	TheTty.c_lflag &= ~( ECHO | ICANON | IEXTEN | ISIG );
	/* OK, why IEXTEN? If IEXTEN is on, the DISCARD character
	   is recognized and is not passed to the process. This 
	   character causes output to be suspended until another
	   DISCARD is received. The DSUSP character for job control,
	   the LNEXT character that removes any special meaning of
	   the following character, the REPRINT character, and some
	   others are also in this category.
	*/

	TheTty.c_iflag &= ~( BRKINT | ICRNL | INPCK | ISTRIP | IXON );
	/* If an input character arrives with the wrong parity, then INPCK
	   is checked. If this flag is set, then IGNPAR is checked
	   to see if input bytes with parity errors should be ignored.
	   If it shouldn't be ignored, then PARMRK determines what
	   character sequence the process will actually see.
	   
	   When we turn off IXON, the start and stop characters can be read.
	*/

	TheTty.c_cflag &= ~( PARENB | CSTOPB );
	/* CSIZE/CSTOPB is a mask that determines the number of bits per byte.
	   PARENB enables parity checking on input and parity generation
	   on output.
	*/

	TheTty.c_cflag |= CS8;
	/* Set 8 bits per character. */

	TheTty.c_oflag &= ~( OPOST );
	/* This includes things like expanding tabs to spaces. */
	TheTty.c_cc[VTIME] = 0;
	TheTty.c_cc[VMIN] = 1;

	TheTty.c_cflag |= HUPCL | CLOCAL ;
	if(tcsetattr(TheFd, TCSANOW, &TheTty ) == -1){
		error_print(FATAL,ERR_INITLINE,NULL);
	}
#endif
}

void closecom(void) {
#ifdef Win32
	CloseHandle(TheFd);
#else
	close(TheFd);
#endif
}

#ifdef Win32
 char* basename(char *name) {
 	int	p;
 
 	p = strlen(name);
 	while(--p > 0) {
 		if(name[p] == '\\' || name[p] == '/') return &(name[p+1]);
 	}
 	return name;
 }
#endif

int query_area(int *start, int *end) {
	char	status[0x100];
	int	s, i, n;

	putbyte(0x25);
	s = getbyte();
	bytecheck(s, 0x35);
	n = getbyte();
	for(i = 0;i < n;i++) status[i] = getbyte();
	getbyte();
	*start = 0;
	for(i = 0;i < 4;i++) {
		*start <<= 8;
		*start += status[i + 1] & 0xff;
	}
	*end = 0;
	for(i = 0;i < 4;i++) {
		*end <<= 8;
		*end += status[i + 5] & 0xff;
	}
	return 0;
}

int query_pagesize(void) {
	unsigned char	status[0x100];
	int	s, i, n;
	int	pagesize;
	unsigned char	sum;

	if(debug) printf("query_pagesize is called.");

	/*	Put command	*/
	putbyte(QUERY_PAGE_SIZE_COM);
	/*	Get & Cehck the response	*/
	sum = s = getbyte();
	bytecheck(s, QUERY_PAGE_SIZE_RES);
	/*	Get size	*/
	sum += n = getbyte();
	/*	Get data	*/
	for(i = 0;i < n;i++) sum += status[i] = getbyte();
	/*	Get SUM		*/
	sum += getbyte();
	if ( sum ) error_print(FATAL,ERR_BOOT_SUM,"Query Pagesize.\n");

	pagesize = (status[0] & 0xff) << 8;
	pagesize += status[1] & 0xff;

	if(debug) printf("Page size:%d Size:%d .\n",pagesize,n);
	if(debug) printf("query_pagesize is finished.\n");

	return pagesize;
}


int query_device(int cpuid,char *devcode) {
	unsigned char	status[BOOT_COMBUF_SIZE];
	int	res,size,devnum,sum,i,devsize,cur ;

	if(debug) printf("query_device is called.");

	for( i = 0 ; i < 64 ; i++){
		putbyte(QUERY_DEV_COM);

		sum = res = getbyte();	/*	get response	*/
		if ( res == QUERY_DEV_RES ){
			if(debug) printf("It seems works ok:%d\n",i);
			break;
		}
		if( res != QUERY_ERR_RES ){
			error_print(FATAL,ERR_TEST,"NOT ERROR CODE???\n");
		}
		getbyte();	/* dummy	*/
		if(debug) printf(".");
	}
	if(debug) printf("\n");
		
	bytecheck(res, QUERY_DEV_RES);	/*	Check the response	*/

	sum += size = getbyte();	/*	get size	*/
	if(debug) printf("RES:%x SIZE:%d\n",res,size);

	for(i = 0;i < size ;i++) {
		sum += status[i] = getbyte();
	}
	sum += getbyte();	/*	get check sum	*/
	sum &= 0xff;
	if(debug) printf("Now SUM:%x \n",sum);
	if ( sum ) error_print(FATAL,ERR_BOOT_SUM,"Query device.\n");

	devnum = status[0];
	cur = 1;
	for( i = 0; i < devnum ; i++ ){
		devsize= status[cur++];
		switch( cpuid ){
			case CPU3069:
				if( strncmp("HD64F3069",(char *)&status[cur + QUERY_DEV_DEV_CODE_SIZE  ],9) == 0 ){
					strncpy(devcode,(char *)&status[cur],QUERY_DEV_DEV_CODE_SIZE);
					return 0;
				}
				break;
			default:
				error_print(FATAL,ERR_GET_3096ID,NULL);
		}
		cur += devsize;	/* Set Next top	*/
	}

	error_print(FATAL,ERR_GET_3096ID,NULL);
	/* Program should not reach here though	*/
	return ERR_GET_3096ID;
}

int query_scale(unsigned char *scale) {
	int	s, i, n, num;
	unsigned char	sum;
	char	buf[128];

	if(debug) printf("query_scale is called.\n");

	/*	Put command	*/
	putbyte(QUERY_SCL_COM);
	/*	Get response	*/
	sum = s = getbyte();
	bytecheck(s, QUERY_SCL_RES);
	/*	Get size	*/
	sum += n = getbyte();
	/*	Get Num	*/
	sum += num = getbyte();
	/*	Get datas & SUM	*/
	for(i = 0;i < n ;i++) sum += scale[i] = getbyte();
	/*	Check checksum	*/
	if( sum != 0 ){
		sprintf(buf,"Check sum error while query_scale. :%d ??\n",sum);
		error_print(FATAL,ERR_BOOT_SUM,buf);
	}
	if( debug) printf("query_scale is finshed,successfully.\n");
	return num;
}

int query_freq(void) {
	unsigned char	status[BOOT_COMBUF_SIZE];
	int		i, n, m, s;
	unsigned char	sum;
	char	buf[128];

	if(debug) printf("query_freq is called.\n");

	/* put command	*/
	putbyte(QUERY_FRQ_COM);
	/* Get response	*/
	sum = s = getbyte();
	bytecheck(s, QUERY_FRQ_RES);
	/* Get size 	*/
	sum += n = getbyte();
	/* Get number	*/
	sum += m = getbyte();
	/* Get data, and sum	*/
	for(i = 0;i < n -1;i++){
		 sum += status[i] = getbyte();
		if(debug) printf("Freq %d:%d [kHz].\n",i,status[i]*100);
	}
	/* Get sum	*/
	sum += getbyte();

	if( sum != 0 ){
		sprintf(buf,"Check sum error while query_freq. :%d ??\n",sum);
		error_print(FATAL,ERR_BOOT_SUM,buf);
	}

	if( debug) printf("query_freq is finshed,successfully.\n");
	return 0;
}

int query_clock(void) {
	unsigned char	status[BOOT_COMBUF_SIZE];
	int		i, s, n, num;
	unsigned char	sum;

	if( debug ) printf("query_clock is called.\n");
	putbyte(QUERY_CLK_COM);
	/* Get response */
	sum = s = getbyte();
	bytecheck(s, QUERY_CLK_RES);
	/* Get size */
	sum += n = getbyte();
	/* Get number of modes */
	sum += num = getbyte();
	/* Read Modes and Sum */
	/* In case num == 0 , just read Sum */
	for(i = 0;i < n ;i++){
		sum += status[i] = getbyte();
/*
		if( debug ) printf(" Modes:%d ",status[i]);
*/
	}

	if( debug ) printf("Size:%d , Number of Modes:%d , Sum:%d\n",n,num,sum);
	/* Check check sum */
	if( sum != 0 ){
		sprintf((char *)status,"Check sum error while query_clock. : %d ??\n",sum);
		error_print(FATAL,ERR_BOOT_SUM,(char *)status);
	}

	/* Now return */
	if( debug) printf("query_clock is finshed,successfully.\n");
	return num;
}

int select_device(char *devcode) {
	unsigned char	sum;
	int		i, s;
	char	buf[256];

	if( debug) printf("slect_devicd is called\n");
	/* Put command	*/
	sum = SEL_DEV_COM;
	putbyte(SEL_DEV_COM);
	/* Put size	*/
	sum += QUERY_DEV_DEV_CODE_SIZE;
	putbyte(QUERY_DEV_DEV_CODE_SIZE);
	/* Put device code	*/
	for(i = 0;i < QUERY_DEV_DEV_CODE_SIZE;i++) {
		sum += devcode[i];
		putbyte(devcode[i]);
	}
	/* Put check Sum */
	sum = 0 - sum;
	putbyte(sum);
	/* Get response */
	s = getbyte();
	/* Check the response */
	if( s == SEL_DEV_RES ){
		/* OK Now we can selected success fully */
		if( debug) printf("select_device is finshed,successfully.\n");
		return 0;
	}

	/* Woom, it seems some probme here */
	bytecheck(s, SEL_DEV_ERR_RES);	/* check really get error response */
	/* Analyze the reason	*/
	s = getbyte();
	if( s == SEL_DEV_ERR_SUM ) {
		sprintf(buf,"CheckSum was:%x ???\n",sum);
		error_print(FATAL,ERR_BOOT_SUM,buf);
	}
	if( s == SEL_DEV_ERR_CODE ) {
		sprintf(buf,"When select device.:%s\n",devcode);
		error_print(FATAL,ERR_DEV_CODE,buf);
	}
	error_print(FATAL,ERR_DEV_CODE,"Unknown reason\n");
	return 0;
}

int select_clock(void) {
	unsigned char	sum;
	int		s,c;
	char	buf[128];

	if( debug) printf("slect_clock is called\n");

	/*	Send commnad to select clock	*/
	sum = SEL_CLK_COM;
	putbyte(SEL_CLK_COM);
	/* set size */
	sum += SEL_CLK_SIZE;
	putbyte(SEL_CLK_SIZE);
	/*	set mode 0 */
	sum += SEL_CLK_MODE;
	putbyte(SEL_CLK_MODE);
	/* put check sum	*/
	sum = 0 - sum;
	putbyte(sum);
	/* get response	*/
	s = getbyte();
	/* Check response */
	if ( s == SEL_CLK_ERR_RES ){
		c = getbyte();
		if ( c == SEL_CLK_ERR_SUM ) {
			sprintf(buf,"While slect_clock, SUM:%d\n",sum);
			error_print(FATAL,ERR_BOOT_SUM,buf);
		}
		if ( c == SEL_CLK_ERR_MODE ) {
			sprintf(buf,"Try to set MODE:%d\n",SEL_CLK_MODE);
			error_print(FATAL,ERR_BOOT_SUM,buf);
		}
	}
	bytecheck(s,SEL_CLK_RES);
	if( debug) printf("slect_clock is finshed,successfully.\n");
	return 0;
}

void simple_command(int com) {
	int	s;

	putbyte(com);
	s = getbyte();
	bytecheck(s, 0x06);
}

int set_rate(int bitrate, int freq) {
	unsigned char	sum,c,s;
	char	buf[128];
	int	freq_t;

	if( debug) printf("set_rate is called\n");

	freq_t = freq;
	/*	Put command	*/
	sum = SET_RATE_COM;
	putbyte(SET_RATE_COM);
	/*	Put size	*/
	sum += SET_RATE_SIZE;
	putbyte(SET_RATE_SIZE);
	/*	Set bit rate/100 */
	sum += 0;
	putbyte(0);
	sum += bitrate;
	putbyte(bitrate);
	/*	Set input frequency	*/
	sum += freq >> 8;
	putbyte(freq >> 8);
	sum += freq & 0xff;
	putbyte(freq & 0xff);
	/*	Set number of times	*/
	sum += 1;
	putbyte(1);
	/*	set time 1	*/
	sum += 1;
	putbyte(1);
	/*	set time 2	*/
	sum += 0;
	putbyte(0);
	/*	set	sum	*/
	sum = 0 - sum;
	putbyte(sum);

	/*	get response	*/
	s = getbyte();
	if( s == SET_RATE_ERR_RES ){
		/*	get reason	*/
		c = getbyte();
		switch (c ){
			case	SET_RATE_ERR_SUM:
				sprintf(buf,"While set_rate, SUM:%d\n",sum);
				error_print(FATAL,ERR_BOOT_SUM,buf);
				break;
			case	SET_RATE_ERR_RATE:
				sprintf(buf,"While set_rate, Can not set the rate:%d[bps]\n",bitrate*100);
				break;
			case	SET_RATE_ERR_INP_FREQ:
				sprintf(buf,"While set_rate, Can not accept the imput freq:%2.2d[MHz]\n",freq_t/100);
				break;
			default:
				sprintf(buf,"While set_rate, ERR_CODE:%x\n",c);
		}
		error_print(FATAL,ERR_SET_RATE,buf);
		return	-1;
	}
	bytecheck(s, SET_RATE_RES);
	if( debug) printf("set_rate is finshed,successfully.\n");

	return 0;
}

unsigned char put_long(int addr, unsigned char _sum) {
	unsigned char c, sum;

	sum = _sum;
	c = (addr >> 24) & 0xff;
	putbyte(c); sum += c;
	c = (addr >> 16) & 0xff;
	putbyte(c); sum += c;
	c = (addr >> 8) & 0xff;
	putbyte(c); sum += c;
	c = addr & 0xff;
	putbyte(c); sum += c;

	return sum;
}

/*
	Print out Usage
*/
void print_usage(){
	printf("%s  Version : %s ,Yukio Mituiwa\n",programname,VER);
	printf("This program follows GPL2.\n");
	printf("\n");
	printf("Usage:%s [options] -CPU_Type filename [devicename]\n",programname);
	printf("CPU_Type : Type of the CPU. Following CPU_Type is supported.\n");
	printf("            3048,3664,3067,3068,3052,3064,7045,7050,3069\n");
	printf("Filename  : Motrola \"S\" file to write to EEPROM on a H8/300H system .\n");
	printf("            For STDIN '-'\n");
	printf("DeviceName: The line which connected to H8/OS system.\n");
	printf("            Default is %s.\n",RSLINE);
	printf("Options:\n");
	printf("-fxx        CPU Speed. xx = [20|25].  Default is 25 [MHz].ly.\n");
	printf("            This option work with CPU_Type 3069 only.\n");
	printf("-d          Display debug information.\n");
	printf("-h          Display this information and exit.\n");
	printf("-v          Display this information and exit.\n");
}

/*
	Returen CPU ID from cpu_type strings.
	When can not find the CPU ID , this returns 0.
*/
int	get_cpu_id(char *cpu_type){

	int	i;

	i=atoi(cpu_type);

	if( debug) printf("get_cpu_id is called :%s\n",cpu_type);
	switch(i){
		case 3048:
			return	CPU3048;
			break;
		case 3664:
			return	CPU3664;
			break;
		case 3067:
			return	CPU3067;
			break;
		case 3068:
			return	CPU3068;
			break;
		case 3052:
			return	CPU3052;
			break;
		case 3064:
			return	CPU3064;
			break;
		case 7045:
			return	CPU7045;
			break;
		case 7050:
			return	CPU7045;
			break;
		case 3069:
			return	CPU3069;
			break;
		default:
			return	0;
	}
}

/*
	Main loop !
*/
int main(int argc, char **argv) {
	int		i, j, cpuid, addrsize;
	int		startrom, endrom;
	int		pagesize, pagebit;
	int		c, s, addr, h, freq;
	unsigned char	*data;
	unsigned char	sum, scale[COMBUF_SIZE];
	char		devcode[QUERY_DEV_DEV_CODE_SIZE+1];
	char		sPort[MAXPATHLEN];
	char		fileName[MAXPATHLEN];
	unsigned char	buffer[COMBUF_SIZE];
	char		numbuf[17];
	FILE		*fp;

	static unsigned char rombuf[0x80000], enable[0x8000];
	
/*	Set Programname.	*/
	strcpy(programname,basename(argv[0]));

/*	Set default RS LINE file name.	*/
	strcpy(sPort,RSLINE);


/*	Set default CPU speed	*/
	freq = 0;

/*	Set default CPU ID	*/
	cpuid = 0;

	fileName[0] = 0;
	fp = NULL;

	for(i = 1; i < argc ; i++){
		if(argv[i][0] == '-'){
			/* check if it is for STD input or not */
			if( strlen(argv[i]) == 1 ){
				/* Yes, we are going to get data from std. */
				fp = stdin;
				strncpy(fileName, "/dev/stdin",MAXPATHLEN);
				if(debug) printf("STD input !!\n");
			}else{
				switch(argv[i][1]){
				case 'f':
					freq = atoi(&(argv[i][2]));
					break;
				case 'v':
				case 'h':
					print_usage();
					exit(0);
					break;
				case 'd':
					debug = 1;
					break;
				case '3':
				case '7':
					cpuid = get_cpu_id(&(argv[i][1]));
					break;
				default:
					print_usage();
					error_print(FATAL,ERR_OPTION,NULL);
					break;
				}
			}
		}else{
			if(fileName[0] == 0 && fp == NULL){
				strncpy(fileName, argv[i],MAXPATHLEN);
			}else{
				strncpy(sPort   , argv[i],MAXPATHLEN);
			}
		}
	}
	if(debug) {	printf("filename:%s\n",fileName);
			printf("sPort   :%s\n",sPort);
			printf("Freq    :%d\n",freq);
			printf("CPU ID  :%d\n",cpuid);
	}

/*	Check if CPU has been spcified or not	*/
	if(cpuid == 0) {
		error_print(FATAL,ERR_CPU_TYPE,NULL);
	}
/*	Chek Freq for 3069	*/
	if(freq == 0) freq = 25;
	if( !(freq == 20 || freq == 25)) error_print(FATAL,ERR_OPTION,"Speed (-fxx) should be 20 or 25\n");

	opencom(sPort, 9600);
	if(cpuid > 0x100) {

		for(i = 0;i < BIT_RATE_SET_MAX_3069;i++) buffer[i] = BIT_SET_CODE;
		writecom(buffer, BIT_RATE_SET_MAX_3069);
		/*	get& check status	*/
		s = getbyte();
		if ( s == BIT_SET_FIN ){
			/* Now it seems changed from bit rate set mode to query mode	*/
			putbyte(BIT_SET_CHEK);
			s = getbyte();
			bytecheck(s, BIT_SET_RES_3069);
		} else{ if (s != QUERY_ERR_RES ){
				error_print(FATAL,ERR_SET_QUERYMODE,(char *)buffer);
			} else {
				s = getbyte();
				sprintf((char *)buffer,"Error code : %x\n",(int)s);
				error_print(WARNING,ERR_ALREADY_QUERY,(char *)buffer);
			}
		}
	} else {

		for(i = 0;i < BIT_RATE_SET_MAX;i++) buffer[i] = BIT_SET_CODE;
		writecom(buffer, BIT_RATE_SET_MAX);
		s = getbyte();
		bytecheck(s, BIT_SET_FIN);
		putbyte(BIT_SET_CHEK);
		s = getbyte();
		bytecheck(s, BIT_SET_RES);
	}
	pagesize = 256;
	switch(cpuid) {
	case CPU3067:
		startrom = ROM3067_START;
		endrom = ROM3067_END;
		memcpy(enable, bin3067, BIN3067_SIZE);
		fprintf(stderr,"H8/3067F is ready!  2001/11/19 Yukio Mituiwa.\n");
		break;
	case CPU3068:
		startrom = ROM3068_START;
		endrom = ROM3068_END;
		memcpy(enable, bin3068, BIN3068_SIZE);
		fprintf(stderr,"H8/3068F is ready!  2001/11/19 Yukio Mituiwa.\n");
		break;
	case CPU3064:
		startrom = ROM3064_START;
		endrom = ROM3064_END;
		memcpy(enable, bin3064, BIN3064_SIZE);
		fprintf(stderr,"H8/3064F is ready!  2002/4/13 Yukio Mituiwa.\n");
		break;
	case CPU3052:
		startrom = ROM3052_START;
		endrom = ROM3052_END;
		memcpy(enable, bin3052, BIN3052_SIZE);
		fprintf(stderr,"H8/3052F is ready!  2002/1/1 Yukio Mituiwa.\n");
		break;
	case CPU3048:
		startrom = ROM3048_START;
		endrom = ROM3048_END;
		memcpy(enable, bin3048, BIN3048_SIZE);
		fprintf(stderr,"H8/3048F is ready!  2001/2/1 Yukio Mituiwa.\n");
		break;
	case CPU3664:
		startrom = ROM3664_START;
		endrom = ROM3664_END;
		memcpy(enable, bin3664, BIN3664_SIZE);
		fprintf(stderr,"H8/3664F is ready!  2001/2/1 Yukio Mituiwa.\n");
		break;
	case CPU7045:
		startrom = ROM7045_START;
		endrom = ROM7045_END;
		memcpy(enable, bin7045, BIN7045_SIZE);
		fprintf(stderr,"SH/7045F or 7050F is ready!  2003/1/1 Yukio Mituiwa.\n");
		break;
	case CPU3069:
		fprintf(stderr,"H8/3069F is ");
		break;
	default:
		fprintf(stderr,"err");
		break;		
	}
	if(cpuid > 0x100) {
		query_device(cpuid, devcode);
		select_device(devcode);
		query_clock();
		select_clock();
		query_scale(scale);
		query_freq();
		set_rate(192, freq * 100);
		closecom();
		opencom(sPort, 19200);
		simple_command(SET_RATE_CK_COM);
		query_area(&startrom, &endrom);
		pagesize = query_pagesize();
		simple_command(SWITCH_TO_ERASE_COM);
		fprintf(stderr,"ready!  2002/5/20 Yukio Mituiwa.\n");
		simple_command(SEL_WRITE_FORMAT);
	} else {
		putbyte(0x05); getbyte();
		putbyte(0x00); getbyte();
		for(i = 0;i < BIN3069_SIZE;i++) {
			putbyte(enable[i]);
			getbyte();
		}
		c = getbyte();
		if(c == 0xaa) fprintf(stderr,"EEPROM writing program transfer successed.");
		else {
			error_print(FATAL,ERR_EEPROM_TRANS,NULL);
		}
	}
	pagebit = 0;
	for(i = 1;i < 0x10000;i <<= 1) {
		if(pagesize <= i) break;
		pagebit++;
	}
	if((fp = fopen(fileName,"r")) == NULL) {
		error_print(FATAL,ERR_INPUTFILE,fileName);
	}
	fprintf(stderr, "writing\n");
	for(i = 0;i <= endrom;i++) rombuf[i] = (char)0xff;
	for(i = 0;i <= (endrom >> pagebit);i++) enable[i] = 0;
	fscanf(fp,"%256s",buffer);
	while(!feof(fp)) {
		if(buffer[0] == 'S') {
			if(buffer[1] == '1') {
				addrsize = 1;
				data = buffer + 8;
			} else if(buffer[1] == '2') {
				addrsize = 2;
				data = buffer + 10;
			} else if(buffer[1] == '3') {
				addrsize = 3;
				data = buffer + 12;
			} else {
				error_print(WARNING,ERR_S_FORMAT,"Address Size seems wrong\n");
				fscanf(fp,"%256s",buffer);
				continue;
			}
			for(i = 0;i < 2;i++) numbuf[i] = buffer[i + 2];
			numbuf[i] = '\0';
			sscanf(numbuf,"%X",&s);
			s = s - 2 - addrsize;
			for(i = 0;i < (addrsize + 1) * 2;i++) numbuf[i] = buffer[i + 4];
			numbuf[i] = '\0';
			sscanf(numbuf,"%X",&addr);
			if(addr < startrom || (addr + s) > endrom) {
				error_print(WARNING,ERR_S_FORMAT,"Address is out of range. Skipping..\n");
				fscanf(fp,"%256s",buffer);
				continue;
			}
			for(i = 0;i < s;i++) {
				numbuf[0] = *(data++);
				numbuf[1] = *(data++);
				numbuf[2] = '\0';
				sscanf(numbuf,"%X",&h);
				rombuf[addr + i] = h;
				enable[(addr + i) >> pagebit] = 1;
			}
		}
		fscanf(fp,"%256s",buffer);
	}
	fclose(fp);
	if( debug) printf("Finish to read MOT file. Now all data in buffer.\n");
	if(cpuid < 0x100) {
		putbyte(1);
		c = getbyte();
		if(c != 1) {
			error_print(FATAL,ERR_EEPROM_WRITE,NULL);
		}
	}
	for(i = 0;i <= (endrom >> pagebit);i++) {
		if(enable[i] == 1) {
			if(cpuid > 0x100) {
				addr = i << pagebit;
				/* Write 128 byte */
				putbyte(WRITE_128_COM);
				sum = WRITE_128_COM;
				sum = put_long(addr, sum);
				for(j = 0;j < pagesize;j++) {
					putbyte(rombuf[i * pagesize + j]);
					sum += rombuf[i * pagesize + j] & 0xff;
				}
				sum = 0 - sum;
				putbyte(sum);
				s = getbyte();
				if( s != NON_ERR_RES ){
					switch( s ){
						case SEL_CLK_ERR_SUM:
							error_print(FATAL,ERR_BOOT_SUM,"While writing data\n");
							break;
						case WRITE_128_ERR_ADD:
							error_print(FATAL,ERR_WRITE,"Address is out of range.\n");
							break;
						case WRITE_128_ERR_WRT:
							error_print(FATAL,ERR_WRITE,"Can not wirte.May be device error.\n");
							break;
						default:
							error_print(FATAL,ERR_WRITE,"Some reason.\n");
					}
				}
				fprintf(stderr, ".");

/*				putbyte(READ_COM);
				sum = READ_COM;
				putbyte(READ_COM_LEN);
				sum += READ_COM_LEN;
				putbyte(READ_AREA);
				sum += READ_AREA;
				sum = put_long(addr, sum);
				sum = put_long(pagesize, sum);
				sum = 0 - sum;
				putbyte(sum);
				s = getbyte();
				bytecheck(s, READ_RES);
				for(j = 0;j < 4;j++) getbyte();
				for(j = 0;j < pagesize;j++) {
					if(j % 16 == 0) fprintf(stderr, "\n%05x : ", i * pagesize + j);
					fprintf(stderr, "%02x ", getbyte());
				}
				getbyte();*/
			} else {
				putbyte((i >> 8) & 0xff);
				getbyte();
				putbyte(i & 0xff);
				getbyte();
				for(j = 0;j < pagesize;j++) putbyte(rombuf[i * pagesize + j]);
				for(j = 0;j < pagesize;j++) {
					if(j % 16 == 0) fprintf(stderr, "\n%05x : ", i * pagesize + j);
					fprintf(stderr, "%02x ", getbyte());
				}
				c = getbyte();
				printf("[%c]\n", c);
				if(c != 'S') {
					error_print(FATAL,ERR_EEPROM_WRITE,NULL);
				}
			}
		}
	}
	if(cpuid > 0x100) {
		sum = WRITE_128_COM;
		putbyte(WRITE_128_COM);
		for(i = 0;i < 4;i++) {
			sum += 0xff;
			putbyte(0xff);
		}
		sum = 0 - sum;
		putbyte(sum);
		s = getbyte();
		if ( s != NON_ERR_RES ){
			switch( s ){
				case SEL_CLK_ERR_SUM:
					error_print(FATAL,ERR_BOOT_SUM,"While writing data\n");
					break;
				case WRITE_128_ERR_ADD:
					error_print(FATAL,ERR_WRITE,"Address is out of range.\n");
					break;
				case WRITE_128_ERR_WRT:
					error_print(FATAL,ERR_WRITE,"Can not wirte.May be device error.\n");
					break;
				default:
					error_print(FATAL,ERR_WRITE,"Some reason.\n");
			}
		}
	}
	fprintf(stderr,"\nEEPROM Writing is successed.\n");
	closecom();
	return 0;
}
