/* EBhE֌W */

#include "bootpack.h"

void make_window8(unsigned int *buf, int xsize, int ysize, char *title, char act)
{
	
	boxfill8(buf, xsize, COL8_000000, 0,         0,         xsize - 1, ysize - 1);
	boxfill8(buf, xsize, COL8_000000, 0,         0,         20       , ysize - 1);
	boxfill8(buf, xsize, COL8_C6C6C6, 1,        21,         xsize - 2, ysize - 2);
	
	make_wtitle8(buf, xsize, title, act);
	
	return;
}

void make_wtitle8(unsigned int *buf, int xsize, char *title, char act)
{
	static char closebtn[14][14] = {
		".....OOOO.....",
		"...OOQQQQOO...",
		"..OQQQQQQQQO..",
		".OQQQQQQQQQQO.",
		".OQQOOQQOOQQO.",
		"OQQQOOOOOOQQQO",
		"OQQQQOOOOQQQQO",
		"OQQQQOOOOQQQQO",
		"OQQQOOOOOOQQQO",
		".OQQOOQQOOQQO.",
		".OQQQQQQQQQQO.",
		"..OQQQQQQQQO..",
		"...OOQQQQOO...",
		".....OOOO....."
	};
	int x, y;
	int c, tc, tbc;
	if (act != 0) {
		tc = COL8_FFFFFF;
		tbc = COL8_333333;
	} else {
		tc = COL8_000000;
		tbc = COL8_FFFFFF;
	}
	boxfill8(buf, xsize, tbc, 1, 1, xsize - 2, 20);
	putfonts8_asc(buf, xsize, 24, 2, tc, title);
	for (y = 0; y < 14; y++) {
		for (x = 0; x < 14; x++) {
			c = closebtn[y][x];
			if (c == 'O') {
				c = COL8_000000;
			} else if (c == 'Q') {
				c = COL8_FF7F27;
			} else {
				c = COL8_333333;
			}
			buf[(4 + y) * xsize + (4 + x)] = c;
		}
	}
	return;
}

void putfonts8_asc_sht(struct SHEET *sht, int x, int y, int c, int b, char *s, int l)
{
	struct TASK *task = task_now();
	boxfill8(sht->buf, sht->bxsize, b, x, y, x + l * 8 - 1, y + 15);
	if (task->langmode != 0 && task->langbyte1 != 0) {
		putfonts8_asc(sht->buf, sht->bxsize, x, y, c, s);
		sheet_refresh(sht, x - 8, y, x + l * 8, y + 16);
	} else {
		putfonts8_asc(sht->buf, sht->bxsize, x, y, c, s);
		sheet_refresh(sht, x, y, x + l * 8, y + 16);
	}
	return;
}

void make_textbox8(struct SHEET *sht, int x0, int y0, int sx, int sy, int c)
{
	int x1 = x0 + sx, y1 = y0 + sy;
	boxfill8(sht->buf, sht->bxsize, COL8_848484, x0 - 2, y0 - 3, x1 + 1, y0 - 3);
	boxfill8(sht->buf, sht->bxsize, COL8_848484, x0 - 3, y0 - 3, x0 - 3, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x0 - 3, y1 + 2, x1 + 1, y1 + 2);
	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x1 + 2, y0 - 3, x1 + 2, y1 + 2);
	boxfill8(sht->buf, sht->bxsize, COL8_000000, x0 - 1, y0 - 2, x1 + 0, y0 - 2);
	boxfill8(sht->buf, sht->bxsize, COL8_000000, x0 - 2, y0 - 2, x0 - 2, y1 + 0);
	boxfill8(sht->buf, sht->bxsize, COL8_C6C6C6, x0 - 2, y1 + 1, x1 + 0, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, COL8_C6C6C6, x1 + 1, y0 - 2, x1 + 1, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, c,           x0 - 1, y0 - 1, x1 + 0, y1 + 0);
	return;
}

void change_wtitle8(struct SHEET *sht, char act)
{
	int x, y, xsize = sht->bxsize;
	int c, tc_new, tbc_new, tc_old, tbc_old, *buf = sht->buf;
	if (act != 0) {
		tc_new  = COL8_FFFFFF;
		tbc_new = COL8_000084;
		tc_old  = COL8_C6C6C6;
		tbc_old = COL8_848484;
	} else {
		tc_new  = COL8_C6C6C6;
		tbc_new = COL8_848484;
		tc_old  = COL8_FFFFFF;
		tbc_old = COL8_000084;
	}
	for (y = 3; y <= 20; y++) {
		for (x = 3; x <= xsize - 4; x++) {
			c = buf[y * xsize + x];
			if(!(x >= 4 && y >= 4 && x <= 4 + 13 && y <= 4 + 13)) {
				if (c == tc_old && x <= xsize - 22) {
					c = tc_new;
				} else if (c == tbc_old) {
					c = tbc_new;
				}
			}
			buf[y * xsize + x] = c;
		}
	}
	sheet_refresh(sht, 3, 3, xsize, 21);
	return;
}
