/*
 * Decompiled with CFR 0.152.
 */
package org.nihonsoft.turbosql.modules.pg.app.sqlanalyzer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.nihonsoft.turbosql.modules.pg.app.PostgreSQLDataObject;
import org.nihonsoft.turbosql.modules.pg.app.sqlanalyzer.OriginalRowsContainer;
import org.nihonsoft.turbosql.modules.pg.app.sqlanalyzer.ResultsModel;
import org.nihonsoft.turbosql.modules.pg.app.sqlanalyzer.RowBean;

public class SQLAnalyzerPanel
extends JPanel
implements TableModelListener {
    JTextArea command = new JTextArea(3, 1);
    JTextArea status = new JTextArea(6, 1);
    JTextField buttonStatus = new JTextField();
    JScrollPane resultsPane;
    JMenuBar menuBar = new JMenuBar();
    JMenuItem clearQueryItem = new JMenuItem("Clear query");
    JMenuItem exitItem = new JMenuItem("Exit");
    JButton executeButton = new JButton(new SQLBtnAction("execute"));
    JButton updateButton = new JButton(new SQLBtnAction("update"));
    JButton addButton = new JButton(new SQLBtnAction("add"));
    JButton deleteButton = new JButton(new SQLBtnAction("delete"));
    Connection connection;
    Statement statement;
    JTable table;
    ResultsModel model;
    String tableName = "";
    String[] columnNames;
    String statusAppendText = "";
    ChangeListener tableVerticalScrollBarChangeListener;
    boolean hasUpdateData = false;

    public SQLAnalyzerPanel(String driver, String url, String user, String password, String dataTypeMapper) {
        this.setBounds(0, 0, 400, 300);
        this.command.setToolTipText("Key SQL command and press the execute button");
        JPanel commandPanel = new JPanel();
        commandPanel.setLayout(new BorderLayout());
        commandPanel.add((Component)new JScrollPane(this.command), "North");
        JPanel buttonPanel = new JPanel();
        this.updateButton.setEnabled(false);
        this.addButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        buttonPanel.add(this.executeButton);
        buttonPanel.add(this.updateButton);
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.deleteButton);
        commandPanel.add((Component)buttonPanel, "Center");
        this.buttonStatus.setBackground(new Color(204, 204, 204));
        this.buttonStatus.setEditable(false);
        this.buttonStatus.setPreferredSize(new Dimension(200, 21));
        this.buttonStatus.setBorder(BorderFactory.createEmptyBorder());
        buttonPanel.add(this.buttonStatus);
        this.add((Component)commandPanel, "North");
        this.status.setWrapStyleWord(true);
        this.status.setBackground(new Color(204, 204, 204));
        this.status.setEditable(false);
        this.add((Component)new JScrollPane(this.status), "South");
        try {
            Class.forName(driver);
            this.connection = DriverManager.getConnection(url, user, password);
            this.statement = this.connection.createStatement();
            this.model = new ResultsModel();
            this.model.addTableModelListener(this);
            this.table = new JTable(this.model);
            this.resultsPane = new JScrollPane(this.table);
            this.table.setAutoResizeMode(0);
            this.table.setSurrendersFocusOnKeystroke(true);
            this.add((Component)this.resultsPane, "Center");
            JScrollBar temp_scrollbar = this.resultsPane.getVerticalScrollBar();
            BoundedRangeModel temp_model = temp_scrollbar.getModel();
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println(cnfe);
        }
        catch (SQLException sqle) {
            System.err.println(sqle);
        }
        this.setVisible(true);
    }

    public void executeSQL() {
        String query = this.command.getText();
        if (query == null) {
            return;
        }
        try {
            boolean dataChanged = false;
            if (this.statement.execute(query)) {
                this.model.setResultSet(this.statement.getResultSet());
                this.columnNames = this.model.getColumnNames();
                this.tableName = PostgreSQLDataObject.parseSQLStatement(query).getTableName();
                this.statusAppendText = this.statusAppendText + "Resultset has " + this.model.getRowCount() + " row(s)." + "\nNote: Only data from a single table can be modified.\nViews and data from multiple tables cannot be modified.";
                this.addButton.setEnabled(true);
                this.deleteButton.setEnabled(true);
            } else {
                this.model.setResultSet(null);
                this.statusAppendText = this.statusAppendText + "Affected " + this.statement.getUpdateCount() + " row(s).";
                this.addButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
            }
            this.updateButton.setEnabled(false);
            this.hasUpdateData = false;
        }
        catch (SQLException sqle) {
            String errorInfo = "";
            do {
                errorInfo = errorInfo + "Exception occured:\nMessage: " + sqle.getMessage();
            } while ((sqle = sqle.getNextException()) != null);
            this.statusAppendText = this.statusAppendText + errorInfo;
        }
        this.status.setText(this.statusAppendText);
        this.statusAppendText = "";
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.model.getDataChanged()) {
            this.updateButton.setEnabled(true);
            this.hasUpdateData = true;
        }
    }

    public String formatRowDataToString(Object[] rowData, String[] columnNames) {
        String temp_condition = "";
        String formatedString = "";
        int i = 0;
        while (i < columnNames.length) {
            temp_condition = rowData[i] == null ? columnNames[i] + " IS NULL" : columnNames[i] + "='" + rowData[i].toString() + "'";
            formatedString = i == 0 ? formatedString + " " + temp_condition : formatedString + " AND " + temp_condition;
            ++i;
        }
        return formatedString;
    }

    class SQLBtnAction
    extends AbstractAction {
        SQLBtnAction(String name) {
            super(name);
        }

        SQLBtnAction(String name, String tooltip) {
            this(name);
            if (tooltip != null) {
                this.putValue("ShortDescription", tooltip);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object source = actionEvent.getSource();
            if (source == SQLAnalyzerPanel.this.executeButton) {
                SQLAnalyzerPanel.this.buttonStatus.updateUI();
                SQLAnalyzerPanel.this.executeSQL();
                SQLAnalyzerPanel.this.buttonStatus.setText("Executed");
            } else if (source == SQLAnalyzerPanel.this.updateButton) {
                OriginalRowsContainer rowsContainer = SQLAnalyzerPanel.this.model.getOriginalRows();
                if (rowsContainer == null) {
                    SQLAnalyzerPanel.this.statusAppendText = "Updated 0 row(s).\n";
                    SQLAnalyzerPanel.this.executeSQL();
                    SQLAnalyzerPanel.this.updateButton.setEnabled(false);
                    return;
                }
                Object[] originalRows = rowsContainer.getOriginalRowsAllArray();
                Object[] changedRows = rowsContainer.getChangedRowsAllArray();
                int[] changedRowsIndex = rowsContainer.getChangedRowsIndexArray();
                int changedRowsCount = changedRows.length;
                String rowDataStr = "";
                int updatedCount = 0;
                int addedCount = 0;
                boolean hasAddedRows = false;
                int i = 0;
                while (i < changedRowsCount) {
                    String originalRowDataStr = "";
                    String changedRowDataStr = "";
                    Object[] originalRowData = ((RowBean)originalRows[i]).getRowData();
                    Object[] changedRowData = ((RowBean)changedRows[i]).getRowData();
                    try {
                        PreparedStatement pStatement;
                        if (changedRowsIndex[i] < SQLAnalyzerPanel.this.model.getOriginalRowsCount()) {
                            pStatement = PostgreSQLDataObject.getPreparedStatementForUpdate(SQLAnalyzerPanel.this.connection, SQLAnalyzerPanel.this.tableName, SQLAnalyzerPanel.this.columnNames, null, null, originalRowData, changedRowData);
                            if (pStatement != null) {
                                updatedCount += pStatement.executeUpdate();
                            }
                        } else {
                            hasAddedRows = true;
                            pStatement = PostgreSQLDataObject.getPreparedStatementForInsert(SQLAnalyzerPanel.this.connection, SQLAnalyzerPanel.this.tableName, SQLAnalyzerPanel.this.columnNames, null, null, originalRowData, changedRowData);
                            if (pStatement != null) {
                                addedCount += pStatement.executeUpdate();
                            }
                        }
                    }
                    catch (SQLException sqle) {
                        String errorInfo = "";
                        do {
                            errorInfo = errorInfo + "Exception occured:at" + SQLAnalyzerPanel.this.formatRowDataToString(SQLAnalyzerPanel.this.model.getRowDataAtIndex(changedRowsIndex[i]), SQLAnalyzerPanel.this.columnNames) + "\n" + "Message: " + sqle.getMessage();
                        } while ((sqle = sqle.getNextException()) != null);
                        SQLAnalyzerPanel.this.statusAppendText = SQLAnalyzerPanel.this.statusAppendText + errorInfo;
                    }
                    ++i;
                }
                SQLAnalyzerPanel.this.statusAppendText = SQLAnalyzerPanel.this.statusAppendText + "Updated " + updatedCount + " row(s)." + "\n";
                if (hasAddedRows) {
                    SQLAnalyzerPanel.this.statusAppendText = SQLAnalyzerPanel.this.statusAppendText + "Added " + addedCount + " row(s)." + "\n";
                }
                SQLAnalyzerPanel.this.executeSQL();
                rowsContainer.removeAllElements();
            } else if (source == SQLAnalyzerPanel.this.addButton) {
                SQLAnalyzerPanel.this.model.addNewRow();
                SQLAnalyzerPanel.this.updateButton.setEnabled(true);
                int newRowIndex = SQLAnalyzerPanel.this.table.getRowCount() - 1;
                SQLAnalyzerPanel.this.table.changeSelection(newRowIndex, 0, false, false);
            } else if (source == SQLAnalyzerPanel.this.deleteButton) {
                int[] selectedRows = SQLAnalyzerPanel.this.table.getSelectedRows();
                int deleteCount = 0;
                if (SQLAnalyzerPanel.this.hasUpdateData || SQLAnalyzerPanel.this.model.getCurrentRowsCount() != SQLAnalyzerPanel.this.model.getOriginalRowsCount()) {
                    JOptionPane.showConfirmDialog(SQLAnalyzerPanel.this.table, "Please update any changes made to the table first.", "Data Changed", -1, 2);
                    return;
                }
                if (selectedRows.length == 0) {
                    JOptionPane.showConfirmDialog(SQLAnalyzerPanel.this.table, "Please select row to delete.", "No rows selected", -1, 2);
                    return;
                }
                if (0 != JOptionPane.showConfirmDialog(SQLAnalyzerPanel.this.table, "Delete " + selectedRows.length + " row(s)?", "Delete Rows", 0, 2)) {
                    return;
                }
                int i = 0;
                while (i < selectedRows.length) {
                    Object[] rowData = SQLAnalyzerPanel.this.model.getRowDataAtIndex(selectedRows[i]);
                    try {
                        PreparedStatement pStatement = PostgreSQLDataObject.getPreparedStatementForDelete(SQLAnalyzerPanel.this.connection, SQLAnalyzerPanel.this.tableName, SQLAnalyzerPanel.this.columnNames, null, null, rowData, null);
                        if (pStatement != null) {
                            deleteCount += pStatement.executeUpdate();
                        }
                    }
                    catch (SQLException sqle) {
                        String errorInfo = "";
                        do {
                            errorInfo = errorInfo + "Exception occured:at" + SQLAnalyzerPanel.this.formatRowDataToString(SQLAnalyzerPanel.this.model.getRowDataAtIndex(selectedRows[i]), SQLAnalyzerPanel.this.columnNames) + "\n" + "Message: " + sqle.getMessage();
                        } while ((sqle = sqle.getNextException()) != null);
                        SQLAnalyzerPanel.this.statusAppendText = SQLAnalyzerPanel.this.statusAppendText + errorInfo;
                    }
                    ++i;
                }
                SQLAnalyzerPanel.this.statusAppendText = SQLAnalyzerPanel.this.statusAppendText + "Deleted " + deleteCount + " row(s)." + "\n";
                SQLAnalyzerPanel.this.executeSQL();
            }
        }
    }
}

