package org.nihonsoft.turbosql.modules.pg.app;

import javax.swing.tree.*;
import javax.swing.*;
import java.awt.*;
import java.net.*;

/*
 * turbosql component.
 *
 * Copyright (c) 2002, 2003, 2004
 *      Nihonsoft LLC.  All rights reserved.
 *
 * See the file "license.txt" for information on usage and redistribution
 * of this file.
 */

public class DBTreeCellRenderer extends DefaultTreeCellRenderer
{
    private JTree tree;
    
    // images
    //private String p_path = "/root/java/modules/turbosqlpg/org/nihonsoft/turbosql/modules/pg/app/";
    //private String p_path = "/org/nihonsoft/turbosql/modules/pg/app/";
    /*
    private String p_path = "";
    
    private String serverNodeImageURL = p_path + "servernode.gif";
    private String databaseNodeImageURL = p_path + "images/databasenode.gif";
    private String tableNodeImageURL = p_path + "images/tablenode.gif";
    private String viewNodeImageURL = p_path + "images/viewnode.gif";
     */
    
    private URL[] urls;
        
    //private URLClassLoader urlClassLoader;
    
    private ClassLoader urlClassLoader;
    
    private URL serverNodeImageURL;
    private URL databaseNodeImageURL;
    private URL tableNodeImageURL;
    private URL viewNodeImageURL;
    
    public DBTreeCellRenderer()
    {
        super();
        /*
        try
        {
            urls = new URL[]{new URL("file:///")};
        } // try
        catch(MalformedURLException mue)
        {
            System.err.println(mue.getMessage());
        } // catch(MalformedURLException mue)
         */
        
        //urlClassLoader = new URLClassLoader(urls);
        urlClassLoader = this.getClass().getClassLoader();
        serverNodeImageURL = urlClassLoader.getResource("org/nihonsoft/turbosql/modules/pg/app/images/servernode.gif");
        databaseNodeImageURL = urlClassLoader.getResource("org/nihonsoft/turbosql/modules/pg/app/images/databasenode.gif");
        tableNodeImageURL = urlClassLoader.getResource("org/nihonsoft/turbosql/modules/pg/app/images/tablenode.gif");
        viewNodeImageURL = urlClassLoader.getResource("org/nihonsoft/turbosql/modules/pg/app/images/viewnode.gif");
        
        /*
        System.out.println(urlClassLoader);
        System.out.println(serverNodeImageURL);
        System.out.println(databaseNodeImageURL);
        System.out.println(tableNodeImageURL);
        System.out.println(viewNodeImageURL);
         */
    } // public DBTreeCellRenderer
        
    public Component getTreeCellRendererComponent(JTree tree, Object value,
						  boolean sel,
						  boolean expanded,
						  boolean leaf, int row,
						  boolean hasFocus) {
	String stringValue = tree.convertValueToText(value, sel,
					  expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node =
                (DefaultMutableTreeNode)value;
        Object nodeObject = node.getUserObject();
        
        this.tree = tree;
	this.hasFocus = hasFocus;
	setText(stringValue);
	if(sel)
	    setForeground(getTextSelectionColor());
	else
	    setForeground(getTextNonSelectionColor());
	// There needs to be a way to specify disabled icons.
	if (!tree.isEnabled()) {
	    setEnabled(false);
            if(nodeObject instanceof ServerNodeObject)
            {
                setDisabledIcon(new ImageIcon(serverNodeImageURL));
            } // if(nodeObject instanceof ServerNodeObject)
            else if(nodeObject instanceof DatabaseNodeObject)
            {
                setDisabledIcon(new ImageIcon(databaseNodeImageURL));
            } // else if(nodeObject instanceof DatabaseNodeObject)
            else if(nodeObject instanceof TableNodeObject)
            {
                setDisabledIcon(new ImageIcon(tableNodeImageURL));
            } // else if(nodeObject instanceof DatabaseNodeObject)
            /*
            else if(nodeObject instanceof ViewNodeObject)
            {
                setDisabledIcon(new ImageIcon(viewNodeImageURL));
            } // else if(nodeObject instanceof DatabaseNodeObject)
             */
            else
            {
                setDisabledIcon(getClosedIcon());
            } // else
            
	    /*
            if (leaf) {
		setDisabledIcon(getLeafIcon());
	    } else if (expanded) {
		setDisabledIcon(getOpenIcon());
	    } else {
		setDisabledIcon(getClosedIcon());
	    }
             */
	}
	else {
	    setEnabled(true);
            if(nodeObject instanceof ServerNodeObject)
            {
                setIcon(new ImageIcon(serverNodeImageURL));
            } // if(nodeObject instanceof ServerNodeObject)
            else if(nodeObject instanceof DatabaseNodeObject)
            {
                setIcon(new ImageIcon(databaseNodeImageURL));
            } // else if(nodeObject instanceof DatabaseNodeObject)
            else if(nodeObject instanceof TableNodeObject)
            {
                setIcon(new ImageIcon(tableNodeImageURL));
            } // else if(nodeObject instanceof DatabaseNodeObject)
            /*
            else if(nodeObject instanceof ViewNodeObject)
            {
                setDisabledIcon(new ImageIcon(viewNodeImageURL));
            } // else if(nodeObject instanceof DatabaseNodeObject)
             */
            else
            {
                setIcon(getClosedIcon());
            } // else
            
            /*
	    if (leaf) {
		setIcon(getLeafIcon());
	    } else if (expanded) {
		setIcon(getOpenIcon());
	    } else {
		setIcon(getClosedIcon());
	    }
             */
	}
        setComponentOrientation(tree.getComponentOrientation());
	    
	selected = sel;

	return this;
    }
    
} // public class DBTreeCellRenderer extends DefaultTreeCellRenderer


