package org.nihonsoft.turbosql.modules.pg.app.dialogs;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.accessibility.*;

import org.nihonsoft.turbosql.modules.pg.app.*;
import org.nihonsoft.turbosql.modules.pg.app.sqlanalyzer.*;

/*
 * turbosql component.
 *
 * Copyright (c) 2002, 2003, 2004
 *      Nihonsoft LLC.  All rights reserved.
 *
 * See the file "license.txt" for information on usage and redistribution
 * of this file.
 */
public class DatabaseAddPane extends JComponent implements Accessible
{
    JDialog dialog;
    String name = "";
    String encoding = "";
    JPanel tabbedPanel1;
    JPanel contentPanel;
    JPanel buttonPanel;
    JLabel dbNameLabel;
    JTextField dbNameField;
    JLabel dbEncodingLabel;
    JComboBox dbEncodingComboBox;
    JButton okButton;
    JButton cancelButton;
    
    String serverIP;
    String serverPort;
    String username;
    String password;
    
    ActionListener refreshListener;
    
    public DatabaseAddPane(String serverIP, String serverPort, String username, String password, ActionListener refreshListener)
    {
        this.serverIP = serverIP;
        this.serverPort = serverPort;
        this.username = username;
        this.password = password;
        this.refreshListener = refreshListener;
    } // public DatabaseAddPane()
        
    public JDialog createDialog(Component parentComponent, String title)
    {
        dialog = new JDialog((JFrame)parentComponent, true);
        Container contentPane;
        tabbedPanel1 = new JPanel();
                
        //okButton = new JButton("Ok");
        JTabbedPane tabbedPane = new JTabbedPane();
        
        okButton = new JButton(new AbstractAction("Ok"){
            public void actionPerformed(ActionEvent e)
            {
                //PostgreSQLDataObject.createDatabase(serverIP, serverPort, username, password, dbName, dbEncoding, null, null);
                String errorMSG = PostgreSQLDataObject.createDatabase(serverIP, serverPort, username, password, dbNameField.getText(), (String) dbEncodingComboBox.getSelectedItem(), false, null);   // has to be false
                
                if(errorMSG == null)
                    return;
                if(!errorMSG.equals(""))
                {
                    JOptionPane.showMessageDialog(dialog, "Error: " + errorMSG);
                } // if(!errorMSG.equals(""))
                else                            // we finish it if there is no errorMSG
                {
                    if(refreshListener != null)
                        refreshListener.actionPerformed(null);
                    dialog.dispose();
                } // else
            } // public void actionPerformed(ActionEvent e)
        });
        
        cancelButton = new JButton(new AbstractAction("Cancel"){
            public void actionPerformed(ActionEvent e)
            {
                dialog.dispose();
            } // public void actionPerformed(ActionEvent e)
        });
        
        dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        
        buttonPanel = new JPanel();
        contentPanel = new JPanel(new GridLayout(2, 2));
        //contentPanel = new JPanel();
        //contentPanel.setPreferredSize(new Dimension(20, 20));
        
        dbNameLabel = new JLabel("Database Name: ");
        dbNameField = new JTextField();
        
        /*
        dbNameLabel.setBounds(0, 0, 150, 20);
        dbNameField.setBounds(0, 0, 150, 20);
        
        dbNameLabel.setPreferredSize(new Dimension(150, 20));
        dbNameField.setPreferredSize(new Dimension(150, 20));
        
        dbNameLabel.setSize(new Dimension(150, 20));
        dbNameField.setSize(new Dimension(150, 20));
         */
        
        dbEncodingLabel = new JLabel("Encoding: ");
        dbEncodingComboBox = new JComboBox(PostgreSQLDataObject.getDBEncodings());
        
        /*
        dbEncodingLabel.setBounds(0, 0, 150, 20);
        dbEncodingComboBox.setBounds(0, 0, 150, 20);
        
        dbEncodingLabel.setPreferredSize(new Dimension(150, 20));
        dbEncodingComboBox.setPreferredSize(new Dimension(150, 20));
        
        dbEncodingLabel.setSize(new Dimension(150, 20));
        dbEncodingComboBox.setSize(new Dimension(150, 20));
         */
        
        //dbNameField.setPreferredSize(new Dimension(100, 20));
        
        contentPanel.add(dbNameLabel);
        contentPanel.add(dbNameField);
        contentPanel.add(dbEncodingLabel);
        contentPanel.add(dbEncodingComboBox);
        
        
        
        tabbedPane.setBounds(0, 0, 100, 100);
        contentPanel.setPreferredSize(new Dimension(100, 100));
        
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        
        contentPane = dialog.getContentPane();
        
        tabbedPanel1.setLayout(new BorderLayout());
        //tabbedPanel1.setLayout(new GridLayout(2, 1));
        
        //--------------------------------------------------------------------
        /*
        String driver = "org.postgresql.Driver";
        String url = "jdbc:postgresql://127.0.0.1:5432/testpg";
        String user = "postgres";
        String password = "";
        String dataTypeMapper = "PostgreSQLDataTypeMapper";             // PostgreSQL-to-Java DataType mapping.
        contentPane.add(new SQLAnalyzerPanel(driver, url, user, password, dataTypeMapper), BorderLayout.NORTH);
         */
        //--------------------------------------------------------------------
        tabbedPanel1.add(contentPanel, BorderLayout.CENTER);
        tabbedPanel1.add(buttonPanel, BorderLayout.SOUTH);
        
        //tabbedPanel1.add(contentPanel);
        //tabbedPanel1.add(buttonPanel);
        
        tabbedPane.addTab("Properties", null, tabbedPanel1, "Propeties");
        tabbedPane.setSelectedIndex(0);
        //tabbedPane.setLayout(new FlowLayout());

        contentPane.add(tabbedPane);
        //contentPane.add(tabbedPanel1);
        //contentPane.setLayout(new GridLayout(1, 2));
        //contentPane.add(contentPanel);
        //contentPane.add(buttonPanel);       
        
        dialog.setBounds(0, 0, 300, 140);
        
        //dialog.getRootPane().add(panel);
        
        return dialog;
    } // public JDialog createDialog(Component parentComponent, String title)
    
    public static void main(String args[])
    {
        JFrame jFrame = new JFrame("test");
        jFrame.setBounds(0, 0, 100, 100);
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

        DatabaseAddPane pane = new DatabaseAddPane("192.168.168.235", "5432", "postgres", "pg.test", null);
        JDialog jDialog = pane.createDialog(jFrame, "test dialog");
        //dialog.setVisible(true);
        jDialog.show();
    } // public static void main(String args[])
} // public class DatabaseAddPane extends JComponent implements Accessible


