package org.nihonsoft.turbosql.modules.pg.app.dialogs;

/*
 * turbosql component.
 *
 * Copyright (c) 2002, 2003, 2004
 *      Nihonsoft LLC.  All rights reserved.
 *
 * See the file "license.txt" for information on usage and redistribution
 * of this file.
 */

public class RelationalTableColumnRowDataObject
{
    private boolean primaryKey;
    private boolean allow_nulls;
    
    // PostgreSQL specific
    private static String[] columnNames = {"PK", "Column Name", "Data Type", "Length", "Allow Nulls"};
    private static Object[] columnTypeArray = {Boolean.FALSE, new String(""), new String(""), new Integer(0), Boolean.FALSE};
    
    // timestampz removed and timestamp is changed to be supported. 2002-01-27 14:56.0
    private static String[] supportedDataTypes = {"serial", "serial8", "bool", "char", "date", "float4", "float8", "int2", "int4", "int8", "text", "time", "timestamp", "varchar"};
    private static String[] unsupportedDataTypes = {"SET", "abstime", "aclitem", "bit", "box", "bpchar", "bytea", "cid", "cidr", "circle", "inet", "int2vector", "interval", "line", "lseg", "macaddr", "money", "name", "numeric", "oid", "oidvector", "path", "point", "polygon", "refcursor", "regproc", "reltime", "smgr", "tid", "timez", "tinterval", "unknown", "varbit", "xid"};
    
    // note to use "relational" to mean the columns in the database
    private Boolean relationalColumnPrimaryKey;
    private String relationalColumnName;
    private String relationalColumnType;
    private Integer relationalColumnLength;
    private Boolean relationalColumnAllowNulls;
    
    //------------------------------------------------------------------------
    // modify here for adding column Properties
    private String relationalColumnDefaultValue;
    private String relationalColumnComment;
    private String relationalColumnNumericPrecision;
    //------------------------------------------------------------------------
    
    // note the nulls
    private Boolean defaultRelationalColumnPrimaryKey = Boolean.FALSE;
    private String defaultRelationalColumnName = null;
    private String defaultRelationalColumnType = null;
    private Integer defaultRelationalColumnLength = null;           // note this null
    private Boolean defaultRelationalColumnAllowNulls = Boolean.FALSE;
    
    //------------------------------------------------------------------------
    // modify here for adding column Properties
    // changed from null to "" for default values
    private String defaultRelationalColumnDefaultValue = "";
    private String defaultRelationalColumnComment = "";
    private String defaultRelationalColumnNumericPrecision = "";
    //------------------------------------------------------------------------
    
    /*
    private boolean relationalColumnPrimaryKeyEditable;
    private boolean relationalColumnNameEditable;
    private boolean relationalColumnTypeEditable;
    private boolean relationalColumnLengthEditable;
    private boolean relationalColumnAllowNullsEditable;
     */
    
    //private String defaultRelationalColumnDefaultValue = null;
    
    private boolean[] isEditable = {true, true, true, true, true};  // whether the column is editable.
    //------------------------------------------------------------------------
    // modify here for adding column Properties
    private boolean[] isPropertyEditable = {true, true, false}; // whether the property column is editable
    //------------------------------------------------------------------------
    
    private boolean dataChanged = false;
    
    public RelationalTableColumnRowDataObject()
    {
        relationalColumnPrimaryKey = defaultRelationalColumnPrimaryKey;
        relationalColumnName = defaultRelationalColumnName;
        relationalColumnType = defaultRelationalColumnType;
        relationalColumnLength = defaultRelationalColumnLength;
        relationalColumnAllowNulls = defaultRelationalColumnAllowNulls;
        
        //------------------------------------------------------------------------
        // modify here for adding column Properties
        relationalColumnDefaultValue = defaultRelationalColumnDefaultValue;
        relationalColumnComment = defaultRelationalColumnComment;
        relationalColumnNumericPrecision = defaultRelationalColumnNumericPrecision;
        //------------------------------------------------------------------------
    } // public RelationalTableColumnRowDataObject()
    
    // return true only if rowData is really changed
    public boolean isChanged()
    {
        if(!dataChanged)
            return false;
        else
        {
            boolean temp_dataChanged = false;
            
            if(!relationalColumnPrimaryKey.equals(defaultRelationalColumnPrimaryKey))
            {
                temp_dataChanged = true;
                //System.out.println("relationalColumnPrimaryKey changed");
            } // if(!relationalColumnPrimaryKey.equals(defaultRelationalColumnPrimaryKey))
            else if(relationalColumnName != defaultRelationalColumnName)
            {
                temp_dataChanged = true;
                //System.out.println("relationalColumnName changed");
            } // else if(relationalColumnName != defaultRelationalColumnName)
            else if(relationalColumnType != defaultRelationalColumnType)
            {
                temp_dataChanged = true;
                //System.out.println("relationalColumnType changed");
            } // else if(relationalColumnType != defaultRelationalColumnType)
            else if(relationalColumnLength != defaultRelationalColumnLength)
            {
                temp_dataChanged = true;
                //System.out.println("relationalColumnLength changed");
            } // else if(relationalColumnLength != defaultRelationalColumnLength)
            else if(!relationalColumnAllowNulls.equals(defaultRelationalColumnAllowNulls))
            {
                temp_dataChanged = true;
                //System.out.println("relationalColumnAllowNulls changed");
            } // else if(!relationalColumnAllowNulls.equals(defaultRelationalColumnAllowNulls))
            else if(!relationalColumnDefaultValue.equals(defaultRelationalColumnDefaultValue))
            {
                temp_dataChanged = true;
                //System.out.println("relationalColumnDefaultValue changed");
            } // else if(relationalColumnDefaultValue != defaultRelationalColumnDefaultValue)
            else if(!relationalColumnComment.equals(defaultRelationalColumnComment))
            {
                temp_dataChanged = true;
                //System.out.println("relationalColumnComment changed");
            } // else if(relationalColumnComment != defaultRelationalColumnComment)
            else if(!relationalColumnNumericPrecision.equals(defaultRelationalColumnNumericPrecision))
            {
                temp_dataChanged = true;
                //System.out.println("relationalColumnNumericPrecision changed");
            } // else if(relationalColumnNumericPrecision != defaultRelationalColumnNumericPrecision)
            
            return temp_dataChanged;
        } // else
    } // public boolean isChanged()
    
    public boolean isCellEditable(int column)
    {
        return isEditable[column];
    } // public boolean isCellEditable(int column)
    
    public boolean isPropertyCellEditable(int column)
    {
        return isPropertyEditable[column];
    } // public boolean isCellEditable(int column)
            
    public Object getValueAt(int column)
    {
        if(column == 0)
            return relationalColumnPrimaryKey;
        else if(column == 1)
            return relationalColumnName;
        else if(column == 2)
            return relationalColumnType;
        else if(column == 3)
            return relationalColumnLength;
        else if(column == 4)
            return relationalColumnAllowNulls;
        else
            return null;
    } // public Object getValueAt(int column) {
    
    //------------------------------------------------------------------------
    // modify here for adding column Properties
    public void setValueAt(Object value, int column)
    {
        dataChanged = true;             // this will indicate that we have to proccess this Object
        
        if(column == 0)
        {
            relationalColumnPrimaryKey = value == null ? null : (Boolean) value;
            if(relationalColumnPrimaryKey != null)
            {
                if(relationalColumnPrimaryKey.equals(Boolean.TRUE))
                {
                    relationalColumnAllowNulls = Boolean.FALSE;
                    isEditable[4] = false;                      // column allows null should not be allowed to be true
                } // if(relationalColumnPrimaryKey.equals(Boolean.TRUE))
                else
                    isEditable[4] = true;
            } // if(relationalColumnPrimaryKey != null)
            else
                isEditable[4] = true;
        } // if(column == 0)        // PK column
        else if(column == 1)
            relationalColumnName = value == null ? null : (String) value;
        else if(column == 2)
        {
            relationalColumnType = value == null ? null : (String) value;
            if(relationalColumnType != null)
            {
                if(relationalColumnType.equals("serial"))
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = false;                  // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnLength = new Integer(4);
                } // if(relationalColumnType.equals("serial"))
                else if(relationalColumnType.equals("serial8"))
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = false;                  // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnLength = new Integer(8);
                } // else if(relationalColumnType.equals("serial8"))
                else if(relationalColumnType.equals("bool"))
                {
                    isEditable[0] = false;                  // pk column
                    isEditable[3] = false;                  // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnPrimaryKey = Boolean.FALSE;        // cannot be a PK
                    relationalColumnLength = new Integer(1);
                } // else if(relationalColumnType.equals("bool"))
                else if(relationalColumnType.equals("char"))
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = true;                   // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnLength = new Integer(10);
                } // else if(relationalColumnType.equals("char"))
                else if(relationalColumnType.equals("date"))
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = false;                  // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnLength = new Integer(8);
                } // else if(relationalColumnType.equals("date"))
                else if(relationalColumnType.equals("float4"))
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = false;                  // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnLength = new Integer(4);
                } // else if(relationalColumnType.equals("date"))
                else if(relationalColumnType.equals("float8"))
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = false;                  // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnLength = new Integer(8);
                } // else if(relationalColumnType.equals("float8"))
                else if(relationalColumnType.equals("int2"))
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = false;                  // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnLength = new Integer(2);
                } // else if(relationalColumnType.equals("int2"))
                else if(relationalColumnType.equals("int4"))
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = false;                  // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnLength = new Integer(4);
                } // else if(relationalColumnType.equals("int4"))
                else if(relationalColumnType.equals("int8"))
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = false;                  // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnLength = new Integer(8);
                } // else if(relationalColumnType.equals("int8"))
                else if(relationalColumnType.equals("text"))
                {
                    isEditable[0] = false;                   // pk column
                    isEditable[3] = false;                  // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnPrimaryKey = Boolean.FALSE;        // cannot be a PK
                    relationalColumnLength = new Integer(16);
                } // else if(relationalColumnType.equals("text"))
                else if(relationalColumnType.equals("time"))
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = false;                  // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnLength = new Integer(8);
                } // else if(relationalColumnType.equals("time"))
                // timestampz removed and timestamp is changed to be supported. 2002-01-27 14:56.0
                else if(relationalColumnType.equals("timestamp"))
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = false;                  // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnLength = new Integer(8);
                } // else if(relationalColumnType.equals("timestamp"))
                else if(relationalColumnType.equals("varchar"))
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = true;                   // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnLength = new Integer(255);
                } // else if(relationalColumnType.equals("varchar"))
                else if(relationalColumnType.equals("numeric"))
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = true;                   // length column
                    isPropertyEditable[2] = true;          // Numeric Precision column
                    relationalColumnLength = new Integer(255);
                } // else if(relationalColumnType.equals("numeric"))
                else
                {
                    isEditable[0] = true;                   // pk column
                    isEditable[3] = true;                   // length column
                    isPropertyEditable[2] = false;          // Numeric Precision column
                    relationalColumnLength = null;
                } // else
                                
            } // if(relationalColumnType != null)
        } // else if(column == 2)
        else if(column == 3)
            relationalColumnLength = value == null ? null : (Integer) value;
        else if(column == 4)
            relationalColumnAllowNulls = value == null ? null : (Boolean) value;
    } // public void setValueAt(Object value, int column)
    //------------------------------------------------------------------------
    
    public static String[] getColumnNames()
    {
        return columnNames;
    } // public String getColumnNames()
    
    public static Object[] getColumnTypeArray()
    {
        return columnTypeArray;
    } // public Object[] columnTypeArray()
    
    //------------------------------------------------------------------------
    // PostgreSQL specific methods
    
    public static String[] getSupportedDataTypes()
    {
        return supportedDataTypes;
    } // public static String[] getSupportedDataTypes()
    
    public static String[] getUnsupportedDataTypes()
    {
        return unsupportedDataTypes;
    } // public static String getUnsupportedDataTypes()
    
    //------------------------------------------------------------------------
    
    //------------------------------------------------------------------------
    // modify here for adding column Properties
    public Object getPropertyValueAt(int propertyIndex)
    {
        if(propertyIndex == 0)
            return relationalColumnDefaultValue;
        else if(propertyIndex == 1)
            return relationalColumnComment;
        else if(propertyIndex == 2)
            return relationalColumnNumericPrecision;
        else
            return null;
    } // public RelationalTableColumnRowDataObject getRelationalTableColumnRowDataObject(int row)
    
    
    public void setPropertyValueAt(Object value, int propertyIndex)
    {
        if(propertyIndex == 0)
            relationalColumnDefaultValue = value == null ? null : (String) value;
        else if(propertyIndex == 1)
            relationalColumnComment = value == null ? null : (String) value;
        else if(propertyIndex == 2)
            relationalColumnNumericPrecision = value == null ? null : (String) value;
    } // public RelationalTableColumnRowDataObject getRelationalTableColumnRowDataObject(int row)
    //------------------------------------------------------------------------
    
    public boolean isLengthEditable()
    {
        return isEditable[3];
    } // public boolean isLengthEditable()
    
} // public class RelationalTableColumnRowDataObject


