/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.dtu;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import uk.org.retep.dtu.DElement;
import uk.org.retep.xml.core.XMLFactory;
import uk.org.retep.xml.core.XMLFactoryException;

public class DCollection
implements Collection {
    protected int num = 0;
    protected int max = 0;
    protected int inc;
    protected DElement[] elements;

    public DCollection() {
        this(10);
    }

    public DCollection(int n) {
        this.inc = n;
        this.elements = null;
    }

    public synchronized boolean add(Object object) {
        if (object instanceof DElement) {
            DElement dElement = (DElement)object;
            if (dElement.getID() > -1) {
                return false;
            }
            this.resize();
            dElement.setID(this.num);
            this.elements[this.num++] = dElement;
            return true;
        }
        return false;
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("Method addAll() not yet implemented.");
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this.num) {
            this.elements[n].setID(-1);
            ++n;
        }
        this.num = 0;
        this.max = 0;
        this.elements = null;
    }

    public synchronized boolean contains(Object object) {
        if (object instanceof DElement) {
            DElement dElement = (DElement)object;
            int n = dElement.getID();
            if (n < 0 || n >= this.num) {
                return false;
            }
            return this.elements[n].equals(dElement);
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        throw new UnsupportedOperationException("Method containsAll() not yet implemented.");
    }

    public synchronized DElement getElement(int n) {
        if (n < 0 || n >= this.num) {
            return null;
        }
        return this.elements[n];
    }

    public boolean isEmpty() {
        return this.num == 0;
    }

    public Iterator iterator() {
        return new iterator(this);
    }

    public synchronized boolean remove(Object object) {
        if (object instanceof DElement) {
            DElement dElement = (DElement)object;
            int n = dElement.getID();
            if (n < 0 || n >= this.num) {
                return false;
            }
            dElement.setID(-1);
            int n2 = n;
            int n3 = n + 1;
            while (n3 < this.num) {
                this.elements[n2] = this.elements[n3];
                this.elements[n2].setID(n2);
                ++n2;
                ++n3;
            }
            --this.num;
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException("Method removeAll() not yet implemented.");
    }

    public synchronized void repair() {
        int n = 0;
        while (n < this.num) {
            this.elements[n].setID(n);
            ++n;
        }
    }

    protected void resize() {
        if (this.num >= this.max) {
            this.max += this.inc;
            DElement[] dElementArray = new DElement[this.max];
            if (this.elements != null) {
                System.arraycopy(this.elements, 0, dElementArray, 0, this.elements.length);
            }
            this.elements = dElementArray;
        }
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException("Method retainAll() not yet implemented.");
    }

    public synchronized void saveXML(XMLFactory xMLFactory) throws IOException, XMLFactoryException {
        int n = 0;
        while (n < this.num) {
            this.elements[n].saveXML(xMLFactory);
            ++n;
        }
    }

    public int size() {
        return this.num;
    }

    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.num];
        System.arraycopy(this.elements, 0, objectArray, 0, this.num);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        throw new UnsupportedOperationException("Method toArray() not yet implemented.");
    }

    protected class iterator
    implements Iterator {
        protected DCollection c;
        protected int i;

        public iterator(DCollection dCollection2) {
            this.c = dCollection2;
            this.i = 0;
        }

        public boolean hasNext() {
            return this.i < this.c.size();
        }

        public Object next() {
            return this.c.getElement(this.i++);
        }

        public void remove() {
        }
    }
}

