/*
 * Decompiled with CFR 0.152.
 */
package jp.turbosql.modules.sketcher.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.turbosql.modules.sketcher.app.Constants;
import jp.turbosql.modules.sketcher.app.SketchFrame2;

class FontDialog
extends JDialog
implements Constants,
ActionListener,
ListSelectionListener {
    private SketchFrame2 window;
    private Font font;
    private int fontStyle;
    private int fontSize;
    private JButton ok;
    private JButton cancel;
    private JList fontList;
    private JComboBox chooseSize;
    private JLabel fontDisplay;

    public FontDialog(SketchFrame2 window) {
        this.window = window;
        this.font = window.getCurrentFont();
        this.fontStyle = this.font.getStyle();
        this.fontSize = this.font.getSize();
        JPanel buttonPane = new JPanel();
        this.ok = this.createButton("OK");
        buttonPane.add(this.ok);
        this.cancel = this.createButton("Cancel");
        buttonPane.add(this.cancel);
        this.getContentPane().add((Component)buttonPane, "South");
        JPanel dataPane = new JPanel();
        dataPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagLayout gbLayout = new GridBagLayout();
        dataPane.setLayout(gbLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel label = new JLabel("Choose a Font");
        constraints.fill = 2;
        constraints.gridwidth = 0;
        gbLayout.setConstraints(label, constraints);
        dataPane.add(label);
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = e.getAvailableFontFamilyNames();
        this.fontList = new JList<String>(fontNames);
        this.fontList.setValueIsAdjusting(true);
        this.fontList.setSelectionMode(0);
        this.fontList.setSelectedValue(this.font.getFamily(), true);
        this.fontList.addListSelectionListener(this);
        JScrollPane chooseFont = new JScrollPane(this.fontList);
        chooseFont.setMinimumSize(new Dimension(300, 100));
        JPanel display = new JPanel();
        this.fontDisplay = new JLabel("Sample Size: x X y Y z Z");
        this.fontDisplay.setPreferredSize(new Dimension(300, 100));
        display.add(this.fontDisplay);
        JSplitPane splitPane = new JSplitPane(0, true, chooseFont, display);
        gbLayout.setConstraints(splitPane, constraints);
        dataPane.add(splitPane);
        JPanel sizePane = new JPanel();
        label = new JLabel("Choose point size");
        sizePane.add(label);
        String[] sizeList = new String[]{"8", "10", "12", "14", "16", "18", "20", "22", "24"};
        this.chooseSize = new JComboBox<String>(sizeList);
        this.chooseSize.setSelectedItem(Integer.toString(this.fontSize));
        this.chooseSize.addActionListener(this);
        sizePane.add(this.chooseSize);
        gbLayout.setConstraints(sizePane, constraints);
        dataPane.add(sizePane);
        JRadioButton bold = new JRadioButton("Bold", (this.fontStyle & 1) > 0);
        JRadioButton italic = new JRadioButton("Italic", (this.fontStyle & 2) > 0);
        bold.addItemListener(new StyleListener(1));
        italic.addItemListener(new StyleListener(2));
        JPanel stylePane = new JPanel();
        stylePane.add(bold);
        stylePane.add(italic);
        gbLayout.setConstraints(stylePane, constraints);
        dataPane.add(stylePane);
        this.getContentPane().add((Component)dataPane, "Center");
        this.pack();
        this.setVisible(false);
    }

    JButton createButton(String label) {
        JButton button = new JButton(label);
        button.setPreferredSize(new Dimension(80, 20));
        button.addActionListener(this);
        return button;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.ok) {
            this.window.setCurrentFont(this.font);
            this.setVisible(false);
        } else if (source == this.cancel) {
            this.setVisible(false);
        } else if (source == this.chooseSize) {
            this.fontSize = Integer.parseInt((String)this.chooseSize.getSelectedItem());
            this.font = this.font.deriveFont((float)this.fontSize);
            this.fontDisplay.setFont(this.font);
            this.fontDisplay.repaint();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.font = new Font((String)this.fontList.getSelectedValue(), this.fontStyle, this.fontSize);
            this.fontDisplay.setFont(this.font);
            this.fontDisplay.repaint();
        }
    }

    class StyleListener
    implements ItemListener {
        private int style;

        public StyleListener(int style) {
            this.style = style;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                FontDialog.this.fontStyle |= this.style;
            } else {
                FontDialog.this.fontStyle &= ~this.style;
            }
            FontDialog.this.font = FontDialog.this.font.deriveFont(FontDialog.this.fontStyle);
            FontDialog.this.fontDisplay.setFont(FontDialog.this.font);
            FontDialog.this.fontDisplay.repaint();
        }
    }
}

