/*
 * Decompiled with CFR 0.152.
 */
package jp.turbosql.modules.sketcher.app;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import jp.turbosql.modules.sketcher.app.Constants;
import jp.turbosql.modules.sketcher.app.Element;
import jp.turbosql.modules.sketcher.app.Sketcher;

class SketchView
extends JComponent
implements Observer,
Constants,
ActionListener {
    private Sketcher theApp;
    private Element highlightElement;
    private JPopupMenu elementPopup = new JPopupMenu("Element");
    private JMenuItem moveItem;
    private JMenuItem deleteItem;
    private JMenuItem rotateItem;
    private JMenuItem sendToBackItem;
    private int mode = 0;
    private Element selectedElement;

    public SketchView(Sketcher theApp) {
        this.theApp = theApp;
        MouseHandler handler = new MouseHandler();
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        this.moveItem = this.elementPopup.add("Move");
        this.deleteItem = this.elementPopup.add("Delete");
        this.rotateItem = this.elementPopup.add("Rotate");
        this.sendToBackItem = this.elementPopup.add("Send-to-back");
        this.moveItem.addActionListener(this);
        this.deleteItem.addActionListener(this);
        this.rotateItem.addActionListener(this);
        this.sendToBackItem.addActionListener(this);
    }

    public void paint(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        Iterator elements = this.theApp.getModel().getIterator();
        while (elements.hasNext()) {
            Element element = (Element)elements.next();
            element.draw(g2D);
        }
    }

    public void update(Observable observable, Object rectangle) {
        if (rectangle == null) {
            this.repaint();
        } else {
            this.repaint((Rectangle)rectangle);
        }
    }

    private Element createElement(Point start, Point end) {
        switch (this.theApp.getWindow().getElementType()) {
            case 101: {
                return new Element.Line(start, end, this.theApp.getWindow().getElementColor());
            }
            case 102: {
                return new Element.Rectangle(start, end, this.theApp.getWindow().getElementColor());
            }
            case 103: {
                return new Element.Circle(start, end, this.theApp.getWindow().getElementColor());
            }
            case 104: {
                return new Element.Curve(start, end, this.theApp.getWindow().getElementColor());
            }
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.moveItem) {
            this.mode = 1;
            this.selectedElement = this.highlightElement;
        } else if (source == this.deleteItem) {
            if (this.highlightElement != null) {
                this.theApp.getModel().remove(this.highlightElement);
                this.highlightElement = null;
            }
        } else if (source == this.rotateItem) {
            this.mode = 2;
            this.selectedElement = this.highlightElement;
        } else if (source == this.sendToBackItem && this.highlightElement != null) {
            this.theApp.getModel().remove(this.highlightElement);
            this.theApp.getModel().add(this.highlightElement);
            this.highlightElement.setHighlighted(false);
            this.highlightElement = null;
            this.repaint();
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        private Point start;
        private Point last;
        private Element tempElement;
        private Graphics2D g2D;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            this.start = e.getPoint();
            int modifier = e.getModifiers();
            if ((modifier & 0x10) != 0) {
                this.g2D = (Graphics2D)SketchView.this.getGraphics();
                this.g2D.setXORMode(SketchView.this.getBackground());
                this.g2D.setPaint(SketchView.this.theApp.getWindow().getElementColor());
            }
        }

        public void mouseDragged(MouseEvent e) {
            this.last = e.getPoint();
            int modifier = e.getModifiers();
            if ((modifier & 0x10) != 0 && SketchView.this.theApp.getWindow().getElementType() != 105 && SketchView.this.mode == 0) {
                if (this.tempElement == null) {
                    this.tempElement = SketchView.this.createElement(this.start, this.last);
                } else {
                    this.tempElement.draw(this.g2D);
                    this.tempElement.modify(this.start, this.last);
                }
                this.tempElement.draw(this.g2D);
            } else if (SketchView.this.mode == 1 && SketchView.this.selectedElement != null) {
                SketchView.this.selectedElement.draw(this.g2D);
                SketchView.this.selectedElement.move(this.last.x - this.start.x, this.last.y - this.start.y);
                SketchView.this.selectedElement.draw(this.g2D);
                this.start = this.last;
            } else if (SketchView.this.mode == 2 && SketchView.this.selectedElement != null) {
                SketchView.this.selectedElement.draw(this.g2D);
                SketchView.this.selectedElement.rotate(this.getAngle(SketchView.this.selectedElement.getPosition(), this.start, this.last));
                SketchView.this.selectedElement.draw(this.g2D);
                this.start = this.last;
            }
        }

        public void mouseReleased(MouseEvent e) {
            int modifier = e.getModifiers();
            if ((modifier & 4) != 0) {
                this.start = e.getPoint();
                if (SketchView.this.highlightElement == null) {
                    SketchView.this.theApp.getWindow().getPopup().show((Component)e.getSource(), this.start.x, this.start.y);
                } else {
                    SketchView.this.elementPopup.show((Component)e.getSource(), this.start.x, this.start.y);
                }
                this.start = null;
            } else if ((modifier & 0x10) != 0 && SketchView.this.theApp.getWindow().getElementType() != 105 && SketchView.this.mode == 0) {
                if (this.tempElement != null) {
                    SketchView.this.theApp.getModel().add(this.tempElement);
                    this.tempElement = null;
                }
            } else if (SketchView.this.mode == 1 || SketchView.this.mode == 2) {
                if (SketchView.this.selectedElement != null) {
                    SketchView.this.repaint();
                }
                SketchView.this.mode = 0;
            }
            if (this.g2D != null) {
                this.g2D.dispose();
                this.g2D = null;
            }
            this.last = null;
            this.start = null;
            this.tempElement = null;
            SketchView.this.selectedElement = null;
        }

        public void mouseClicked(MouseEvent e) {
            int modifier = e.getModifiers();
            if ((modifier & 0x10) != 0 && SketchView.this.theApp.getWindow().getElementType() == 105) {
                this.start = e.getPoint();
                String text = JOptionPane.showInputDialog((Component)e.getSource(), "Enter Text:", "Dialog for Text Element", -1);
                if (text != null) {
                    this.g2D = (Graphics2D)SketchView.this.getGraphics();
                    Font font = SketchView.this.theApp.getWindow().getCurrentFont();
                    this.tempElement = new Element.Text(font, text, this.start, SketchView.this.theApp.getWindow().getElementColor(), font.getStringBounds(text, this.g2D.getFontRenderContext()).getBounds());
                    if (this.tempElement != null) {
                        SketchView.this.theApp.getModel().add(this.tempElement);
                    }
                    this.tempElement = null;
                    this.g2D.dispose();
                    this.g2D = null;
                    this.start = null;
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            Point currentCursor = e.getPoint();
            Iterator elements = SketchView.this.theApp.getModel().getIterator();
            while (elements.hasNext()) {
                Element element = (Element)elements.next();
                if (!element.getBounds().contains(currentCursor)) continue;
                if (element == SketchView.this.highlightElement) {
                    return;
                }
                this.g2D = (Graphics2D)SketchView.this.getGraphics();
                if (SketchView.this.highlightElement != null) {
                    SketchView.this.highlightElement.setHighlighted(false);
                    SketchView.this.highlightElement.draw(this.g2D);
                }
                element.setHighlighted(true);
                SketchView.this.highlightElement = element;
                element.draw(this.g2D);
                this.g2D.dispose();
                this.g2D = null;
                return;
            }
            if (SketchView.this.highlightElement != null) {
                this.g2D = (Graphics2D)SketchView.this.getGraphics();
                SketchView.this.highlightElement.setHighlighted(false);
                SketchView.this.highlightElement.draw(this.g2D);
                SketchView.this.highlightElement = null;
                this.g2D.dispose();
                this.g2D = null;
            }
        }

        double getAngle(Point position, Point start, Point last) {
            double perp = Line2D.ptLineDist(position.x, position.y, last.x, last.y, start.x, start.y);
            double hypotenuse = position.distance(start);
            if (hypotenuse == 0.0) {
                hypotenuse = 1.0;
            }
            return (double)(-Line2D.relativeCCW(position.x, position.y, start.x, start.y, last.x, last.y)) * Math.asin(perp / hypotenuse);
        }
    }
}

