/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.beanbuilder.test;

import java.io.File;
import java.io.FileOutputStream;
import uk.org.retep.app.Constants;
import uk.org.retep.app.Workspace;
import uk.org.retep.beanbuilder.data.EntityBean;
import uk.org.retep.beanbuilder.data.Field;
import uk.org.retep.beanbuilder.data.Project;
import uk.org.retep.xml.core.XMLWriter;

public class CreateTestData {
    static final String[] fields = new String[]{"uuid", "title", "cert", "region", "aspect", "time", "comment"};
    static final String primkey = fields[0];

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Workspace workspace = Workspace.getInstance();
        workspace.setFile(Constants.DEFAULT_WORKSPACE);
        Project project = new Project();
        project.setFile(new File("dvd-prj.xml"));
        project.setTitle("A DVD/CD/Video database");
        project.setAuthor("Peter Mount");
        project.setPackageName("uk.org.retep.test.dvdlib");
        EntityBean entityBean = new EntityBean();
        entityBean.setDescription("Stores details about a DVD in the library");
        entityBean.setName("DVD");
        project.addBean(entityBean);
        entityBean.reset();
        int n = 0;
        while (n < fields.length) {
            object = new Field();
            ((Field)object).setName(fields[n]);
            ((Field)object).setType("java.lang.String");
            entityBean.addField((Field)object);
            ++n;
        }
        entityBean.setPrimaryKey(entityBean.getField(primkey));
        System.out.println("Writing " + project.getFile().getAbsolutePath());
        object = new XMLWriter(new FileOutputStream(project.getFile()));
        project.writeXML((XMLWriter)object);
        ((XMLWriter)object).close();
        System.out.println("Writing " + workspace.getFile().getAbsolutePath());
        object = new XMLWriter(new FileOutputStream(workspace.getFile()));
        workspace.writeXML((XMLWriter)object);
        ((XMLWriter)object).close();
    }
}

