/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.Timer;
import uk.org.retep.swing.ImageLibrary;

public class SplashScreen {
    protected static SplashScreen ACTIVE;
    protected JWindow window;
    protected Timer timer;
    protected JProgressBar pb;

    public static SplashScreen getInstance() {
        return ACTIVE;
    }

    public SplashScreen() {
        this(false);
    }

    public SplashScreen(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(ImageLibrary.getImageIcon("images/retep/splash.gif"));
        jPanel.add("Center", jLabel);
        if (bl) {
            this.pb = new JProgressBar();
            jPanel.add("South", this.pb);
        }
        this.init(jPanel);
    }

    public SplashScreen(Component component) {
        this.init(component);
    }

    public void setProgress(int n) {
        if (this.pb != null) {
            this.pb.setValue(n);
        }
    }

    public void setMaximum(int n) {
        if (this.pb != null) {
            this.pb.setMaximum(n);
        }
    }

    private void init(Component component) {
        ACTIVE = this;
        this.window = new JWindow();
        this.window.getContentPane().add(component);
        this.window.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SplashScreen.hideSplash();
            }
        });
        this.window.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.window.getSize().width;
        int n2 = this.window.getSize().height;
        int n3 = dimension.width - n >> 1;
        int n4 = dimension.height - n2 >> 1;
        ((Component)this.window).setBounds(n3, n4, n, n2);
    }

    public void showSplash(int n) {
        ((Component)this.window).setVisible(true);
        this.timer = new Timer(n, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SplashScreen.hideSplash();
            }
        });
        this.timer.start();
    }

    public boolean isVisible() {
        return this.window.isVisible();
    }

    public static void hideSplash() {
        SplashScreen splashScreen = SplashScreen.getInstance();
        if (splashScreen != null) {
            ((Component)splashScreen.window).setVisible(false);
            splashScreen.window.dispose();
            if (splashScreen.timer != null) {
                splashScreen.timer.stop();
            }
            ACTIVE = null;
        }
    }

    public static void toFront() {
        SplashScreen splashScreen = SplashScreen.getInstance();
        if (splashScreen != null) {
            splashScreen.window.toFront();
        }
    }
}

