/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JEditorPane;
import uk.org.retep.swing.ExceptionDialog;
import uk.org.retep.swing.util.DocumentPrinter;

public class WebBrowser
extends JEditorPane {
    private List history = new ArrayList();
    private int historyIndex;
    private List listeners = new ArrayList();

    public WebBrowser() {
        this.setEditable(false);
    }

    public WebBrowser(URL uRL) {
        this();
        this.display(uRL);
    }

    public URL back() {
        --this.historyIndex;
        if (this.historyIndex < 0) {
            this.historyIndex = 0;
        }
        return this.displayPage((URL)this.history.get(this.historyIndex));
    }

    public URL forward() {
        ++this.historyIndex;
        if (this.historyIndex >= this.history.size()) {
            this.historyIndex = this.history.size() - 1;
        }
        return this.displayPage((URL)this.history.get(this.historyIndex));
    }

    public boolean hasPast() {
        return this.historyIndex > 0;
    }

    public boolean hasFuture() {
        return this.historyIndex < this.history.size() - 1;
    }

    public void display(URL uRL) {
        if (this.displayPage(uRL) != null) {
            this.history.add(uRL);
            this.historyIndex = this.history.size() - 1;
            this.fireWebBrowserListeners();
        }
    }

    private URL displayPage(URL uRL) {
        try {
            this.setPage(uRL);
            this.fireWebBrowserListeners();
            return uRL;
        }
        catch (IOException iOException) {
            ExceptionDialog.show(iOException);
            return null;
        }
    }

    public String getPageURL() {
        URL uRL = super.getPage();
        if (uRL == null) {
            return "";
        }
        return uRL.toString();
    }

    public String getTitle() {
        return (String)this.getDocument().getProperty("title");
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(new DocumentPrinter(this));
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                ExceptionDialog.show(printerException);
            }
        }
    }

    public void addWebBrowserListener(WebBrowserListener webBrowserListener) {
        if (!this.listeners.contains(webBrowserListener)) {
            this.listeners.add(webBrowserListener);
        }
    }

    public void removeWebBrowserListener(WebBrowserListener webBrowserListener) {
        if (this.listeners.contains(webBrowserListener)) {
            this.listeners.remove(webBrowserListener);
        }
    }

    public void fireWebBrowserListeners() {
        System.out.println("fire: " + this.historyIndex + " " + this.history.size());
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((WebBrowserListener)iterator.next()).browserUpdate(this);
        }
    }

    public static interface WebBrowserListener {
        public void browserUpdate(WebBrowser var1);
    }
}

