/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing.model.table;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class MapTableModel
extends AbstractTableModel
implements Map {
    private static final String[] COLS = new String[]{"Key", "Value"};
    public static final int KEY = 0;
    public static final int VALUE = 1;
    private Map map;
    private Object[] rowCache = null;
    private int cacheSize = 0;
    private boolean valuesEditable;
    private String[] cols = new String[COLS.length];

    public MapTableModel() {
        this(null);
    }

    public MapTableModel(Map map) {
        System.arraycopy(COLS, 0, this.cols, 0, this.cols.length);
        this.setMap(map);
    }

    public void setColumnName(int n, String string) {
        this.cols[n] = string;
        this.fireTableStructureChanged();
    }

    private Object getKey(int n) {
        Set set;
        int n2;
        if (n < 0 | n >= (n2 = (set = this.map.keySet()).size())) {
            throw new IllegalArgumentException("Invalid row: " + n + " [ 0..." + n2 + "]");
        }
        this.rowCache = this.rowCache == null || this.rowCache.length < n2 ? set.toArray() : set.toArray(this.rowCache);
        return this.rowCache[n];
    }

    public void setMap(Map treeMap) {
        if (treeMap == null) {
            treeMap = new TreeMap();
        }
        this.map = treeMap;
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }

    public Map getMap() {
        return this.map;
    }

    public void setValuesEditable(boolean bl) {
        this.valuesEditable = bl;
    }

    public boolean isValuesEditable() {
        return this.valuesEditable;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 1 && this.isValuesEditable();
    }

    public String getColumnName(int n) {
        return this.cols[n];
    }

    public int getColumnCount() {
        return COLS.length;
    }

    public Object getValueAt(int n, int n2) {
        Object object = this.getKey(n);
        switch (n2) {
            case 0: {
                return object;
            }
            case 1: {
                return this.map.get(object);
            }
        }
        throw new IllegalArgumentException("Bad column number " + n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                throw new IllegalArgumentException("Can't edit the keys yet");
            }
            case 1: {
                if (this.isValuesEditable()) {
                    this.map.put(this.getKey(n), object);
                    this.fireTableCellUpdated(n, n2);
                    break;
                }
                throw new IllegalArgumentException("Values are not editable");
            }
            default: {
                throw new IllegalArgumentException("Bad column number " + n2);
            }
        }
    }

    public int getRowCount() {
        return this.map.size();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public Object get(Object object) {
        return this.map.get(object);
    }

    public Object put(Object object, Object object2) {
        Object object3 = this.map.put(object, object2);
        this.fireTableDataChanged();
        return object3;
    }

    public Object remove(Object object) {
        Object v = this.map.remove(object);
        this.fireTableDataChanged();
        return v;
    }

    public void putAll(Map map) {
        this.map.putAll(map);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.map.clear();
        this.fireTableDataChanged();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object object) {
        return this.map.equals(object);
    }
}

