/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.org.retep.swing.ExceptionDialog;
import uk.org.retep.swing.FileChooser;
import uk.org.retep.swing.util.GenericFileFilter;
import uk.org.retep.tools.Tool;
import uk.org.retep.tools.ToolData;
import uk.org.retep.util.EmptyIterator;
import uk.org.retep.util.StringUtils;
import uk.org.retep.xml.core.XML;
import uk.org.retep.xml.core.XMLUtils;
import uk.org.retep.xml.core.XMLWriter;
import uk.org.retep.xml.util.XMLFileFilter;

public class ToolManager
implements XML {
    private static ToolManager SINGLETON = new ToolManager();
    private static final String[] stateFields = new String[]{"x", "y", "width", "height", "icon", "maximum"};
    private Properties props = new Properties();
    private Vector tools = new Vector();
    HashMap toolNames = new HashMap();
    private HashMap tooldata = new HashMap();
    private HashMap fileFilters = new HashMap();
    private XMLFileFilter xmlfilter = new XMLFileFilter();
    private HashMap treeData = new HashMap();
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("Tools");
    DefaultTreeModel model = new DefaultTreeModel(this.root);
    private JDesktopPane desktop;
    static /* synthetic */ Class class$java$io$File;

    public static ToolManager getInstance() {
        return SINGLETON;
    }

    private ToolManager() {
        Object object;
        try {
            object = this.getClass().getResourceAsStream("Tools.properties");
            this.props.load((InputStream)object);
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            ExceptionDialog.show(iOException);
        }
        object = FileChooser.getInstance();
        ((JFileChooser)object).addChoosableFileFilter(this.xmlfilter);
        StringTokenizer stringTokenizer = new StringTokenizer(this.props.getProperty("tools"));
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            this.tools.add(string);
            this.tooldata.put(string, new TreeMap());
            this.toolNames.put(this.props.getProperty(string + ".tool"), string);
            String string2 = this.props.getProperty(string + ".xml");
            if (string2 != null) {
                this.props.setProperty("xml." + string2, string);
            }
            String string3 = this.props.getProperty(string + ".filetypes");
            FileFilter fileFilter = this.xmlfilter;
            if (string3 != null) {
                String string4 = this.props.getProperty(string + ".filedesc", this.getToolName(string));
                fileFilter = new GenericFileFilter(string4, string3);
                ((JFileChooser)object).addChoosableFileFilter(fileFilter);
            }
            this.fileFilters.put(string, fileFilter);
        }
    }

    public FileFilter getFileFilter() {
        return this.xmlfilter;
    }

    public FileFilter getFileFilter(String string) {
        return (FileFilter)this.fileFilters.get(string);
    }

    public FileFilter getFileFilter(Tool tool) {
        return this.getFileFilter(this.getToolName(tool));
    }

    public void setFileFilter() {
        FileChooser.getInstance().setFileFilter(this.xmlfilter);
    }

    public void setFileFilter(String string) {
        FileChooser.getInstance().setFileFilter(this.getFileFilter(string));
    }

    public void setFileFilter(Tool tool) {
        this.setFileFilter(this.getToolName(tool));
    }

    public void setDesktop(JDesktopPane jDesktopPane) {
        this.desktop = jDesktopPane;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public void addData(String string, ToolData toolData) {
        TreeMap treeMap = (TreeMap)this.tooldata.get(string);
        if (treeMap != null) {
            TreeMap treeMap2 = treeMap;
            synchronized (treeMap2) {
                String string2 = toolData.getTitle();
                if (treeMap.containsKey(string2) && !treeMap.get(string2).equals(toolData)) {
                    toolData.setTitle(StringUtils.getUniqueKey(treeMap, string2));
                }
                treeMap.put(toolData.getTitle(), toolData);
                this.updateTree(string);
            }
        }
    }

    public void addData(Tool tool, ToolData toolData) {
        this.addData(this.getToolName(tool), toolData);
    }

    public void removeData(String string, String string2) {
        TreeMap treeMap = (TreeMap)this.tooldata.get(string);
        if (treeMap != null) {
            TreeMap treeMap2 = treeMap;
            synchronized (treeMap2) {
                ToolData toolData = (ToolData)treeMap.get(string2);
                if (toolData.getTool() != null) {
                    toolData.getTool().closeTool();
                }
                treeMap.remove(string2);
                this.updateTree(string);
            }
        }
    }

    public void removeData(String string, ToolData toolData) {
        this.removeData(string, toolData.getTitle());
    }

    public void removeData(Tool tool, String string) {
        this.removeData(this.getToolName(tool), string);
    }

    public void removeData(Tool tool, ToolData toolData) {
        this.removeData(this.getToolName(tool), toolData);
    }

    public Iterator getToolData() {
        Vector vector = new Vector();
        Iterator iterator = this.getTools();
        while (iterator.hasNext()) {
            TreeMap treeMap = (TreeMap)this.tooldata.get(iterator.next());
            if (treeMap == null) continue;
            TreeMap treeMap2 = treeMap;
            synchronized (treeMap2) {
                Iterator iterator2 = treeMap.keySet().iterator();
                while (iterator2.hasNext()) {
                    vector.add(treeMap.get(iterator2.next()));
                }
            }
        }
        return ((AbstractList)vector).iterator();
    }

    public Iterator getToolData(String string) {
        TreeMap treeMap = (TreeMap)this.tooldata.get(string);
        if (treeMap != null) {
            TreeMap treeMap2 = treeMap;
            synchronized (treeMap2) {
                Iterator iterator = treeMap.keySet().iterator();
                return iterator;
            }
        }
        return new EmptyIterator();
    }

    public ToolData getToolData(String string, String string2) {
        TreeMap treeMap = (TreeMap)this.tooldata.get(string);
        if (treeMap != null && string2 != null) {
            TreeMap treeMap2 = treeMap;
            synchronized (treeMap2) {
                ToolData toolData = (ToolData)treeMap.get(string2);
                return toolData;
            }
        }
        return null;
    }

    public Iterator getToolData(Tool tool) {
        return this.getToolData(this.getToolName(tool));
    }

    public ToolData getToolData(Tool tool, String string) {
        return this.getToolData(this.getToolName(tool), string);
    }

    public String getToolName(Tool tool) {
        return (String)this.toolNames.get(tool.getClass().getName());
    }

    public String getToolName(String string) {
        return this.props.getProperty(string + ".displayname");
    }

    public Class getToolClass(String string) {
        try {
            return Class.forName(this.props.getProperty(string + ".class"));
        }
        catch (Exception exception) {
            ExceptionDialog.show(exception);
            return null;
        }
    }

    public Class getTool(String string) {
        try {
            return Class.forName(this.props.getProperty(string + ".tool"));
        }
        catch (Exception exception) {
            ExceptionDialog.show(exception);
            return null;
        }
    }

    public Iterator getTools() {
        return ((AbstractList)this.tools).iterator();
    }

    public String getToolByDisplayName(String string) {
        String string2 = null;
        Iterator iterator = this.getTools();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!this.getToolName(string3).equals(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    public void writeXML(XMLWriter xMLWriter) {
        this.writeXML(xMLWriter, "TOOLS");
    }

    public void writeXML(XMLWriter xMLWriter, String string) {
        xMLWriter.startTag(string);
        Iterator iterator = this.tooldata.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Iterator iterator2 = this.getToolData(string2);
            if (!iterator2.hasNext()) continue;
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                ToolData toolData = this.getToolData(string2, string3);
                File file = toolData.getFile();
                if (file == null) continue;
                xMLWriter.startTag(this.getXMLFromTool(string2));
                Tool tool = toolData.getTool();
                if (tool != null && tool instanceof Component) {
                    XMLUtils.saveState(xMLWriter, (Component)((Object)tool));
                }
                xMLWriter.addContent(file.getAbsolutePath());
                xMLWriter.closeTag();
            }
        }
        xMLWriter.closeTag();
    }

    public static ToolManager decodeXML(Element element) throws SAXException {
        ToolManager toolManager = ToolManager.getInstance();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                String string = toolManager.getToolFromXML(node.getNodeName());
                try {
                    Tool tool;
                    ToolData toolData = toolManager.readFile(string, new File(XMLUtils.getText((Element)node)));
                    if (XMLUtils.hasState((Element)node) && (tool = toolManager.openToolImpl(string, toolData, false)) instanceof Component) {
                        Component component = (Component)((Object)tool);
                        XMLUtils.restoreState((Element)node, component);
                        component.setVisible(true);
                    }
                }
                catch (IOException iOException) {
                    ExceptionDialog.show(iOException);
                }
            }
            ++n;
        }
        return toolManager;
    }

    public Tool openTool(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ToolData toolData = (ToolData)this.getToolClass(string).newInstance();
        if (toolData != null) {
            toolData.setTitle("untitled");
            this.addData(string, toolData);
            return this.openToolImpl(string, toolData, true);
        }
        throw new IllegalArgumentException("The tool " + string + " cannot be opened");
    }

    public Tool openTool(String string, ToolData toolData) {
        return this.openToolImpl(string, toolData, true);
    }

    private Tool openToolImpl(String string, ToolData toolData, boolean bl) {
        Tool tool;
        block16: {
            if (toolData == null) {
                return null;
            }
            tool = toolData.getTool();
            try {
                if (tool == null) {
                    tool = (Tool)this.getTool(string).newInstance();
                    tool.setToolData(toolData);
                    if (tool instanceof JInternalFrame && this.desktop != null) {
                        JInternalFrame jInternalFrame = (JInternalFrame)((Object)tool);
                        jInternalFrame.pack();
                        Dimension dimension = this.desktop.getSize();
                        Dimension dimension2 = jInternalFrame.getSize();
                        Point point = jInternalFrame.getLocation();
                        if (dimension2.width > dimension.width) {
                            dimension2.width = dimension.width;
                        }
                        if (dimension2.height > dimension.height) {
                            dimension2.height = dimension.height;
                        }
                        if (point.x + dimension2.width > dimension.width) {
                            point.x = dimension.width - dimension2.width;
                        }
                        if (point.y + dimension2.height > dimension.height) {
                            point.y = dimension.height - dimension2.height;
                        }
                        jInternalFrame.setLocation(point);
                        jInternalFrame.setSize(dimension2);
                        this.desktop.add(jInternalFrame);
                        jInternalFrame.setVisible(bl);
                        jInternalFrame.toFront();
                    } else if (tool instanceof Frame) {
                        Frame frame = (Frame)((Object)tool);
                        frame.pack();
                        ((Component)frame).setVisible(bl);
                        frame.toFront();
                    }
                    break block16;
                }
                if (tool instanceof JInternalFrame && this.desktop != null) {
                    JInternalFrame jInternalFrame = (JInternalFrame)((Object)tool);
                    if (jInternalFrame.isIcon()) {
                        try {
                            jInternalFrame.setIcon(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                    jInternalFrame.toFront();
                    break block16;
                }
                if (tool instanceof Frame) {
                    ((Frame)((Object)tool)).toFront();
                }
            }
            catch (Exception exception) {
                ExceptionDialog.show(exception);
            }
        }
        return tool;
    }

    public void close(ToolData toolData) {
        Tool tool = toolData.getTool();
        if (tool == null && toolData.isModified()) {
            tool = this.openToolImpl(this.findTool(toolData), toolData, false);
        }
        if (tool != null) {
            tool.closeTool();
        }
        this.removeData(this.findTool(toolData), toolData);
    }

    public String getTool(File file) {
        Iterator iterator = this.fileFilters.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            FileFilter fileFilter = this.getFileFilter(string);
            if (!fileFilter.accept(file)) continue;
            return string;
        }
        return null;
    }

    public ToolData readFile(String string, File file) throws IOException, SAXException {
        ToolData toolData = null;
        Class clazz = this.getToolClass(string);
        if (clazz != null) {
            try {
                Object[] objectArray = new Object[1];
                Class[] classArray = new Class[]{class$java$io$File == null ? (class$java$io$File = ToolManager.class$("java.io.File")) : class$java$io$File};
                objectArray[0] = file;
                Method method2 = clazz.getMethod("loadData", classArray);
                toolData = (ToolData)method2.invoke(null, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (toolData == null) {
            toolData = this.readFileImpl(string, XMLUtils.parseXML(new FileInputStream(file)));
        }
        if (toolData != null) {
            toolData.setFile(file);
            ToolManager.getInstance().addData(string, toolData);
        }
        return toolData;
    }

    public ToolData readFile(File file) throws IOException, SAXException {
        Element element = XMLUtils.parseXML(new FileInputStream(file));
        ToolData toolData = this.readFileImpl(this.getToolFromXML(element.getNodeName()), element);
        if (toolData != null) {
            toolData.setFile(file);
        }
        return toolData;
    }

    private ToolData readFileImpl(String string, Element element) {
        try {
            Object object;
            Class clazz = this.getToolClass(string);
            if (clazz != null && (object = XMLUtils.decodeNode(element, clazz)) instanceof ToolData) {
                return (ToolData)object;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            ExceptionDialog.show(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionDialog.show(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ExceptionDialog.show(noSuchMethodException);
        }
        return null;
    }

    public String getToolFromXML(String string) {
        return this.props.getProperty("xml." + string, string);
    }

    public String getXMLFromTool(String string) {
        return this.props.getProperty(string + ".xml", string);
    }

    public String getXMLFromTool(Tool tool) {
        return this.getXMLFromTool(this.getToolName(tool));
    }

    public DefaultTreeModel refreshTree() {
        this.root.removeAllChildren();
        Iterator iterator = this.getTools();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.getToolName(string));
            this.root.add(defaultMutableTreeNode);
            this.updateTree(string);
        }
        return this.model;
    }

    public void updateTree(String string) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        String string2 = this.getToolName(string);
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            object = (String)defaultMutableTreeNode2.getUserObject();
            if (!((String)object).equals(string2)) continue;
            defaultMutableTreeNode = defaultMutableTreeNode2;
            break;
        }
        if (defaultMutableTreeNode != null) {
            defaultMutableTreeNode.removeAllChildren();
            object = this.getToolData(string);
            while (object.hasNext()) {
                ToolData toolData = this.getToolData(string, (String)object.next());
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(toolData.getTitle());
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
            this.model.reload(defaultMutableTreeNode);
        }
    }

    public String findTool(ToolData toolData) {
        Iterator iterator = this.getTools();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TreeMap treeMap = (TreeMap)this.tooldata.get(string);
            if (treeMap == null || !treeMap.containsValue(toolData)) continue;
            return string;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

