/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.tools.prop;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import uk.org.retep.tools.AbstractToolData;
import uk.org.retep.tools.ToolData;
import uk.org.retep.tools.prop.PropertyModel;
import uk.org.retep.util.StringUtils;

public class Properties
extends AbstractToolData {
    public static final String EMPTY = "";
    java.util.Properties props = new java.util.Properties();
    java.util.Properties defaults = new java.util.Properties();
    Vector order = new Vector();
    Hashtable xref = new Hashtable();
    private String header = "";
    private String footer = "";
    private Vector listeners = new Vector();

    public Properties() {
        this.clear();
    }

    public Properties(File file) throws IOException {
        this.load(file);
        this.setModified(false);
    }

    public Properties(java.util.Properties properties) {
        this.clear();
        this.setDefaults(properties);
        this.setModified(false);
    }

    public void clear() {
        ((Hashtable)this.props).clear();
        this.order.clear();
        this.xref.clear();
        this.setHeader(EMPTY);
        this.setFooter(EMPTY);
        this.setModified(true);
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            ((PropertyModel)iterator.next()).fireTableDataChanged();
        }
    }

    public boolean contains(Object object) {
        return ((Hashtable)this.props).contains(object);
    }

    public boolean containsKey(Object object) {
        return ((Hashtable)this.props).containsKey(object);
    }

    public boolean containsValue(Object object) {
        return ((Hashtable)this.props).containsValue(object);
    }

    public void remove(Object object) {
        int n = this.getPropertyPosition((String)object);
        ((Hashtable)this.props).remove(object);
        this.xref.remove(object);
        this.order.remove(object);
        this.setModified(true);
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            ((PropertyModel)iterator.next()).fireTableRowsDeleted(n, n);
        }
    }

    public void rename(String string, String string2) {
        if (!((Hashtable)this.props).containsKey(string)) {
            return;
        }
        String string3 = this.props.getProperty(string);
        ((Hashtable)this.props).remove(string);
        this.props.setProperty(string2, string3);
        Object v = this.xref.get(string);
        this.xref.remove(v);
        this.xref.put(string2, v);
        this.order.set(this.order.indexOf(string), string2);
        this.setModified(true);
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            ((PropertyModel)iterator.next()).fireTableCellUpdated(this.getPropertyPosition(string2), 0);
        }
    }

    public void setHeader(String string) {
        this.header = StringUtils.fixComment(string);
        this.setModified(true);
    }

    public String getHeader() {
        return this.header;
    }

    public void setFooter(String string) {
        this.footer = StringUtils.fixComment(string);
        this.setModified(true);
    }

    public String getFooter() {
        return this.footer;
    }

    public void setProperty(String string, String string2) {
        this.setProperty(-1, string, string2);
    }

    /*
     * Unable to fully structure code
     */
    public String setProperty(int var1_1, String var2_2, String var3_3) {
        var4_4 = this;
        synchronized (var4_4) {
            block10: {
                block9: {
                    v0 = var5_5 = this.props.containsKey(var2_2) == false;
                    if (!var5_5) break block9;
                    this.props.setProperty(var2_2, var3_3);
                    this.xref.put(var2_2, "");
                    if (var1_1 < 0) {
                        this.order.add(var2_2);
                    } else {
                        this.order.insertElementAt(var2_2, var1_1);
                    }
                    var6_6 = this.getPropertyPosition(var2_2);
                    var7_8 = this.listeners.iterator();
                    while (var7_8.hasNext()) {
                        ((PropertyModel)var7_8.next()).fireTableRowsInserted(var6_6, var6_6);
                    }
                    break block10;
                }
                if (var1_1 >= 0) {
                    var2_2 = StringUtils.getUniqueKey(this.props, var2_2);
                    this.xref.put(var2_2, "");
                    this.order.insertElementAt(var2_2, var1_1);
                }
                this.props.setProperty(var2_2, var3_3);
                var6_6 = this.getPropertyPosition(var2_2);
                var7_9 = this.listeners.iterator();
                if (var1_1 < 0) ** GOTO lbl37
                while (var7_9.hasNext()) {
                    ((PropertyModel)var7_9.next()).fireTableRowsInserted(var6_6, var6_6);
                }
                break block10;
lbl-1000:
                // 1 sources

                {
                    ((PropertyModel)var7_9.next()).fireTableCellUpdated(var6_6, 1);
lbl37:
                    // 2 sources

                    ** while (var7_9.hasNext())
                }
            }
            this.setModified(true);
            var6_7 = var2_2;
            return var6_7;
        }
    }

    public void moveProperty(String string, int n) {
        if (n < 0 || n > this.order.size()) {
            throw new IllegalArgumentException("Index out of bounds " + n);
        }
        int n2 = this.getPropertyPosition(string);
        if (n2 == n) {
            return;
        }
        this.order.remove(n2);
        if (n2 < n) {
            --n;
        }
        this.order.insertElementAt(string, n);
        int n3 = n2;
        int n4 = n;
        if (n3 > n4) {
            n3 = n;
            n4 = n2;
        }
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            ((PropertyModel)iterator.next()).fireTableRowsUpdated(n3, n4);
        }
    }

    public String getProperty(String string) {
        String string2 = this.props.getProperty(string);
        if (string2 == null) {
            string2 = this.defaults.getProperty(string);
        }
        return string2;
    }

    public String getProperty(String string, String string2) {
        return this.props.getProperty(string, string2);
    }

    public boolean isDefault(String string) {
        return this.props.getProperty(string) == null && this.defaults.getProperty(string) != null;
    }

    public int getPropertyPosition(String string) {
        return this.order.indexOf(string);
    }

    public Enumeration getKeys() {
        return ((Hashtable)this.props).elements();
    }

    public String getKey(int n) {
        Properties properties = this;
        synchronized (properties) {
            if (n < 0 || n > this.order.size()) {
                throw new IllegalArgumentException("Index out of bounds");
            }
            String string = (String)this.order.elementAt(n);
            return string;
        }
    }

    public int getSize() {
        return this.order.size();
    }

    public String getComment(String string) {
        return (String)this.xref.get(string);
    }

    public void setComment(String string, String string2) {
        Properties properties = this;
        synchronized (properties) {
            if (!((Hashtable)this.props).containsKey(string)) {
                return;
            }
            this.xref.put(string, StringUtils.fixComment(string2));
            this.setModified(true);
        }
    }

    public void setDefaults(java.util.Properties properties) {
        this.defaults = properties;
    }

    public java.util.Properties getDefaults() {
        return this.defaults;
    }

    /*
     * Unable to fully structure code
     */
    public void load(File var1_1) throws IOException {
        this.clear();
        this.setFile(var1_1);
        var2_2 = new FileReader(var1_1);
        var3_3 = new BufferedReader(var2_2);
        var4_4 = new StringBuffer();
        var5_5 = true;
        while (true) {
            if ((var6_6 = var3_3.readLine()) == null) {
                var3_3.close();
                var2_2.close();
                if (var4_4.length() > 0) {
                    this.setFooter(var4_4.toString());
                }
                this.setModified(false);
                return;
            }
            if (var6_6.length() == 0) {
                if (var5_5) {
                    this.setHeader(var4_4.toString());
                    var4_4.setLength(0);
                    var5_5 = false;
                    continue;
                }
                var4_4.append('\n');
                continue;
            }
            var7_7 = var6_6.charAt(0);
            if (var7_7 != '#' && var7_7 != '!') ** GOTO lbl36
            var4_4.append(var6_6).append('\n');
            continue;
lbl-1000:
            // 1 sources

            {
                var8_9 = var3_3.readLine();
                if (var8_9 == null) {
                    var8_9 = new String("");
                }
                var9_11 = var6_6.substring(0, var6_6.length() - 1);
                var10_12 = StringUtils.findNonWhitespace(var8_9);
                var8_9 = var8_9.substring(var10_12, var8_9.length());
                var6_6 = new String(var9_11 + var8_9);
lbl36:
                // 2 sources

                ** while (StringUtils.continueLine((String)var6_6))
            }
lbl37:
            // 1 sources

            var8_8 = var6_6.length();
            var9_10 = StringUtils.findNonWhitespace(var6_6);
            if (var9_10 == var8_8) {
                if (!var5_5) continue;
                this.setHeader(var4_4.toString());
                var4_4.setLength(0);
                var5_5 = false;
                continue;
            }
            var10_12 = StringUtils.findKeySeparator(var6_6, var9_10);
            var11_13 = StringUtils.findNonWhitespace(var6_6, var10_12);
            var11_13 = StringUtils.findKeyValue(var6_6, var11_13);
            var12_14 = StringUtils.decodeUnicode(var6_6.substring(var9_10, var10_12));
            var13_15 = StringUtils.decodeUnicode(var10_12 < var8_8 ? var6_6.substring(var11_13, var8_8) : "");
            this.setProperty(var12_14, var13_15);
            this.setComment(var12_14, var4_4.toString());
            var4_4.setLength(0);
        }
    }

    public void save() throws IOException {
        this.save(this.getFile());
    }

    public void save(File file) throws IOException {
        if (file == null) {
            throw new IOException("Cannot save to null");
        }
        this.setFile(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.store(fileOutputStream);
        fileOutputStream.close();
    }

    public void store(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        if (this.header != null && !this.header.equals(EMPTY)) {
            StringUtils.writeln(bufferedWriter, this.header);
        }
        Enumeration enumeration = this.order.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)((Hashtable)this.props).get(string);
            String string3 = this.getComment(string);
            if (string3 != null && !string3.equals(EMPTY)) {
                bufferedWriter.write(10);
                bufferedWriter.write(string3);
            }
            StringUtils.writeln(bufferedWriter, StringUtils.encodeUnicode(string, true) + "=" + StringUtils.encodeUnicode(string2, false));
        }
        if (this.footer != null && !this.footer.equals(EMPTY)) {
            bufferedWriter.write(10);
            StringUtils.writeln(bufferedWriter, this.footer);
        }
        bufferedWriter.flush();
        this.setModified(false);
    }

    public static ToolData loadData(File file) throws IOException {
        return new Properties(file);
    }

    public String toString() {
        return this.getFile().getName();
    }

    public void addPropertyModel(PropertyModel propertyModel) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(propertyModel)) {
                this.listeners.add(propertyModel);
            }
        }
    }

    public void removePropertyModel(PropertyModel propertyModel) {
        this.listeners.remove(propertyModel);
    }
}

