/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.tools.prop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.org.retep.swing.FileChooser;
import uk.org.retep.swing.ImageLibrary;
import uk.org.retep.tools.AbstractTool;
import uk.org.retep.tools.ToolData;
import uk.org.retep.tools.ToolManager;
import uk.org.retep.tools.prop.Properties;
import uk.org.retep.tools.prop.PropertyModel;

public class PropertyFrame
extends AbstractTool {
    private static final String NEW = "new";
    Properties data;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    TitledBorder titledBorder1;
    BorderLayout borderLayout2 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextPane comment = new JTextPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTable table = new JTable();
    PropertyModel model = new PropertyModel(this);
    JToolBar jToolBar1 = new JToolBar();
    ImageIcon ic_save = ImageLibrary.getImageIcon("images/general/Save24.gif");
    ImageIcon ic_saveas = ImageLibrary.getImageIcon("images/general/SaveAs24.gif");
    ImageIcon ic_search = ImageLibrary.getImageIcon("images/general/Search24.gif");
    ImageIcon ic_print = ImageLibrary.getImageIcon("images/general/Print24.gif");
    ImageIcon ic_delrow = ImageLibrary.getImageIcon("images/table/RowDelete24.gif");
    ImageIcon ic_insbef = ImageLibrary.getImageIcon("images/table/RowInsertBefore24.gif");
    ImageIcon ic_insaft = ImageLibrary.getImageIcon("images/table/RowInsertAfter24.gif");
    ImageIcon ic_copy = ImageLibrary.getImageIcon("images/general/Copy24.gif");
    ImageIcon ic_moveup = ImageLibrary.getImageIcon("images/navigation/Up24.gif");
    ImageIcon ic_movedn = ImageLibrary.getImageIcon("images/navigation/Down24.gif");
    JButton b_save = new JButton();
    JButton b_saveas = new JButton();
    JButton b_search = new JButton();
    JButton b_print = new JButton();
    JButton b_insaft = new JButton();
    JButton b_insbef = new JButton();
    JButton b_delrow = new JButton();
    JButton b_copy = new JButton();
    JButton b_moveup = new JButton();
    JButton b_movedn = new JButton();

    public PropertyFrame() {
        try {
            this.jbInit();
            this.table.setModel(this.model);
            this.validateToolbar(null);
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    PropertyFrame.this.validateToolbar(null);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Comment");
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setBorder(this.titledBorder1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.comment.setText("jTextPane1");
        this.comment.setMinimumSize(new Dimension(6, 80));
        this.jScrollPane1.setMinimumSize(new Dimension(24, 80));
        this.jScrollPane1.setPreferredSize(new Dimension(80, 80));
        this.b_saveas.setToolTipText("Save As");
        this.b_saveas.setIcon(this.ic_saveas);
        this.b_saveas.setMargin(new Insets(2, 2, 2, 2));
        this.b_saveas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyFrame.this.saveas(actionEvent);
            }
        });
        this.b_search.setToolTipText("Search");
        this.b_search.setIcon(this.ic_search);
        this.b_search.setMargin(new Insets(2, 2, 2, 2));
        this.b_save.setToolTipText("Save");
        this.b_save.setIcon(this.ic_save);
        this.b_save.setMargin(new Insets(2, 2, 2, 2));
        this.b_save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyFrame.this.save(actionEvent);
            }
        });
        this.b_print.setToolTipText("Print");
        this.b_print.setIcon(this.ic_print);
        this.b_print.setMargin(new Insets(2, 2, 2, 2));
        this.b_insaft.setMargin(new Insets(2, 2, 2, 2));
        this.b_insaft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyFrame.this.insertAfter(actionEvent);
            }
        });
        this.b_insaft.setToolTipText("Insert After");
        this.b_insaft.setIcon(this.ic_insaft);
        this.b_insbef.setMargin(new Insets(2, 2, 2, 2));
        this.b_insbef.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyFrame.this.insertBefore(actionEvent);
            }
        });
        this.b_insbef.setToolTipText("Insert Before");
        this.b_insbef.setIcon(this.ic_insbef);
        this.b_delrow.setMargin(new Insets(2, 2, 2, 2));
        this.b_delrow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyFrame.this.deleteRow(actionEvent);
            }
        });
        this.b_delrow.setToolTipText("Delete");
        this.b_delrow.setIcon(this.ic_delrow);
        this.b_copy.setMargin(new Insets(2, 2, 2, 2));
        this.b_copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyFrame.this.copyRow(actionEvent);
            }
        });
        this.b_copy.setToolTipText("Duplicate");
        this.b_copy.setIcon(this.ic_copy);
        this.b_moveup.setMargin(new Insets(2, 2, 2, 2));
        this.b_moveup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyFrame.this.moveRowUp(actionEvent);
            }
        });
        this.b_moveup.setToolTipText("Move Up");
        this.b_moveup.setIcon(this.ic_moveup);
        this.b_movedn.setMargin(new Insets(2, 2, 2, 2));
        this.b_movedn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyFrame.this.moveRowDown(actionEvent);
            }
        });
        this.b_movedn.setToolTipText("Move Down");
        this.b_movedn.setIcon(this.ic_movedn);
        this.jToolBar1.setFloatable(false);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jScrollPane2, "Center");
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jToolBar1.add((Component)this.b_save, null);
        this.jToolBar1.add((Component)this.b_saveas, null);
        this.jToolBar1.add((Component)this.b_search, null);
        this.jToolBar1.add((Component)this.b_print, null);
        this.jToolBar1.add((Component)this.b_delrow, null);
        this.jToolBar1.add((Component)this.b_insbef, null);
        this.jToolBar1.add((Component)this.b_insaft, null);
        this.jToolBar1.add((Component)this.b_copy, null);
        this.jToolBar1.add((Component)this.b_moveup, null);
        this.jToolBar1.add((Component)this.b_movedn, null);
        this.jScrollPane2.getViewport().add((Component)this.table, null);
        this.jScrollPane1.getViewport().add((Component)this.comment, null);
    }

    public void setToolData(ToolData toolData) {
        if (this.data != null) {
            this.data.removePropertyModel(this.model);
        }
        super.setToolData(toolData);
        this.data = (Properties)this.getToolData();
        this.validateToolbar(null);
        if (this.data != null) {
            this.setTitle("Properties: " + this.data.getTitle());
            this.data.addPropertyModel(this.model);
            this.setEnabled(true);
        } else {
            this.setTitle("Properties: no data");
            this.setEnabled(false);
        }
    }

    protected void validateToolbar(MouseEvent mouseEvent) {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedRowCount();
        int n3 = this.table.getRowCount();
        boolean bl = this.data != null;
        boolean bl2 = bl && this.data.getFile() != null;
        boolean bl3 = bl && this.data.isModified();
        boolean bl4 = n2 == 1;
        boolean bl5 = n2 > 1;
        int[] nArray = bl5 ? this.table.getSelectedRows() : null;
        boolean bl6 = (bl4 && n == 0) | (bl5 && nArray[0] == 0);
        boolean bl7 = (bl4 && n == n3 - 1) | (bl5 && nArray[nArray.length - 1] == n3 - 1);
        this.b_save.setEnabled(bl2 & bl3);
        this.b_saveas.setEnabled(bl);
        this.b_search.setEnabled(false);
        this.b_print.setEnabled(false);
        this.b_delrow.setEnabled(bl4 | bl5);
        this.b_insaft.setEnabled(bl4);
        this.b_insbef.setEnabled(bl4);
        this.b_copy.setEnabled(bl4 | bl5);
        this.b_moveup.setEnabled(bl4 | bl5 && !bl6);
        this.b_movedn.setEnabled(bl4 | bl5 && !bl7);
        this.comment.setEnabled(bl4 & bl);
        this.comment.setOpaque(bl4 & bl);
        if (bl4 & bl) {
            this.comment.setText(this.data.getComment(this.data.getKey(n)));
        } else {
            this.comment.setText("");
        }
    }

    private void deleteRow(ActionEvent actionEvent) {
        if (this.data == null) {
            return;
        }
        int n = this.table.getSelectedRowCount();
        if (n == 1) {
            this.data.remove(this.data.getKey(this.table.getSelectedRow()));
            this.validateToolbar(null);
        } else if (n > 1) {
            int[] nArray = this.table.getSelectedRows();
            int n2 = nArray.length - 1;
            while (n2 > -1) {
                this.data.remove(this.data.getKey(nArray[n2]));
                --n2;
            }
            this.validateToolbar(null);
        }
    }

    private void insertBefore(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        this.data.setProperty(n, NEW, "");
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.clearSelection();
        this.table.editCellAt(n, 0);
    }

    private void insertAfter(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow() + 1;
        this.data.setProperty(n, NEW, "");
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.clearSelection();
        this.table.editCellAt(n, 0);
    }

    private void copyRow(ActionEvent actionEvent) {
        if (this.data == null) {
            return;
        }
        int n = this.table.getSelectedRowCount();
        if (n == 1) {
            int n2 = this.table.getSelectedRow();
            String string = this.data.getKey(n2);
            String string2 = this.data.getProperty(string);
            String string3 = this.data.setProperty(n2 + 1, string, string2);
            this.data.setComment(string3, this.data.getComment(string));
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            listSelectionModel.clearSelection();
            listSelectionModel.addSelectionInterval(n2 + 1, n2 + 1);
            this.table.editCellAt(n2 + 1, 0);
        } else if (n > 1) {
            Object object;
            int[] nArray = this.table.getSelectedRows();
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                if (nArray[n4] > n3) {
                    n3 = nArray[n4];
                }
                ++n4;
            }
            ++n3;
            int n5 = 0;
            while (n5 < n) {
                object = this.data.getKey(nArray[n5]);
                String string = this.data.getProperty((String)object);
                String string4 = this.data.setProperty(n3 + n5, (String)object, string);
                this.data.setComment(string4, this.data.getComment((String)object));
                ++n5;
            }
            object = this.table.getSelectionModel();
            object.clearSelection();
            object.addSelectionInterval(n3, n3 + n - 1);
        }
    }

    private void moveRowUp(ActionEvent actionEvent) {
        if (this.data == null) {
            return;
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        int n = this.table.getSelectedRowCount();
        if (n == 1) {
            int n2 = this.table.getSelectedRow();
            this.data.moveProperty(this.data.getKey(n2), n2 - 1);
            listSelectionModel.clearSelection();
            listSelectionModel.addSelectionInterval(n2 - 1, n2 - 1);
        } else if (n > 1) {
            int[] nArray = this.table.getSelectedRows();
            int n3 = 0;
            while (n3 < n) {
                this.data.moveProperty(this.data.getKey(nArray[n3]), nArray[n3] - 1);
                ++n3;
            }
            listSelectionModel.clearSelection();
            int n4 = 0;
            while (n4 < n) {
                int n5 = nArray[n4] - 1;
                listSelectionModel.addSelectionInterval(n5, n5);
                ++n4;
            }
        }
    }

    private void moveRowDown(ActionEvent actionEvent) {
        if (this.data == null) {
            return;
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        int n = this.table.getSelectedRowCount();
        if (n == 1) {
            int n2 = this.table.getSelectedRow();
            this.data.moveProperty(this.data.getKey(n2), n2 + 2);
            listSelectionModel.clearSelection();
            listSelectionModel.addSelectionInterval(n2 + 1, n2 + 1);
        } else if (n > 1) {
            int[] nArray = this.table.getSelectedRows();
            int n3 = n - 1;
            while (n3 > -1) {
                this.data.moveProperty(this.data.getKey(nArray[n3]), nArray[n3] + 2);
                --n3;
            }
            listSelectionModel.clearSelection();
            int n4 = 0;
            while (n4 < n) {
                int n5 = nArray[n4] + 1;
                listSelectionModel.addSelectionInterval(n5, n5);
                ++n4;
            }
        }
    }

    private void save(ActionEvent actionEvent) {
        try {
            this.data.save();
            this.validateToolbar(null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void saveas(ActionEvent actionEvent) {
        FileChooser fileChooser = FileChooser.getInstance();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setSelectedFile(this.data.getFile());
        ToolManager.getInstance().setFileFilter(this);
        if (fileChooser.showSaveDialog(this) == 0) {
            this.data.setFile(fileChooser.getSelectedFile());
            this.save(actionEvent);
        }
    }
}

