/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.tools.prop;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import uk.org.retep.tools.prop.Properties;
import uk.org.retep.tools.prop.PropertyFrame;

public class PropertyModel
extends AbstractTableModel {
    private static final String[] COLS = new String[]{"Property", "Value"};
    private PropertyFrame parent;

    public PropertyModel(PropertyFrame propertyFrame) {
        this.parent = propertyFrame;
    }

    public int getColumnCount() {
        return COLS.length;
    }

    public String getColumnName(int n) {
        return COLS[n];
    }

    public int getRowCount() {
        Properties properties = (Properties)this.parent.getToolData();
        if (properties == null) {
            return 0;
        }
        return properties.getSize();
    }

    public Object getValueAt(int n, int n2) {
        Properties properties = (Properties)this.parent.getToolData();
        if (properties == null || n >= properties.getSize()) {
            throw new IllegalArgumentException("Row range! " + n);
        }
        String string = properties.getKey(n);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                string = properties.getProperty(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("Column range! " + n2);
            }
        }
        return string;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public void setValueAt(Object object, int n, int n2) {
        Properties properties = (Properties)this.parent.getToolData();
        if (properties == null || n >= properties.getSize()) {
            throw new IllegalArgumentException("Row range! " + n);
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("Only Strings allowed!");
        }
        String string = properties.getKey(n);
        String string2 = (String)object;
        switch (n2) {
            case 0: {
                if (properties.containsKey(string2)) break;
                properties.rename(string, string2);
                break;
            }
            case 1: {
                properties.setProperty(string, string2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Column range! " + n2);
            }
        }
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        super.fireTableChanged(tableModelEvent);
        this.parent.validateToolbar(null);
    }
}

