/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.compiler;

import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import uk.org.retep.util.compiler.AbstractCompiler;

public class JavaSource
extends AbstractCompiler {
    public static final char CLASSSEPCHAR = '.';
    public static final String CLASSSEP = ".";
    public static final int CLASS = 0;
    public static final int INTERFACE = 2;
    public static final int PUBLIC = 4;
    public static final int PRIVATE = 8;
    public static final int STATIC = 16;
    public static final int ABSTRACT = 32;
    public static final int FINAL = 64;
    public static final int SET = 128;
    public static final int GET = 256;
    public static final int EJBGET = 512;
    TreeMap imports = new TreeMap();
    TreeMap constr = new TreeMap();
    TreeMap methods = new TreeMap();
    TreeMap fields = new TreeMap();
    TreeMap innerclass = new TreeMap();
    Vector impls = null;
    Vector comment = null;
    private String name;
    private String packageName;
    private boolean publicClass = true;
    private boolean abstractClass = false;
    private boolean interfaces;
    private boolean singleton;

    public JavaSource() {
    }

    public JavaSource(String string) {
        super(string);
    }

    public void setName(String string) {
        if (string.lastIndexOf(CLASSSEP) > -1) {
            this.setPackageName(JavaSource.getPackageName(string));
            string = JavaSource.getClassName(string);
        }
        super.setName(string);
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPublicClass(boolean bl) {
        this.publicClass = bl;
    }

    public boolean isPublicClass() {
        return this.publicClass;
    }

    public void setAbstractClass(boolean bl) {
        this.abstractClass = bl;
    }

    public boolean isAbstractClass() {
        return this.abstractClass;
    }

    public void setInterface(boolean bl) {
        this.interfaces = bl;
    }

    public boolean isInterface() {
        return this.interfaces;
    }

    private static String getPackageName(String string) {
        return string.substring(0, string.lastIndexOf(CLASSSEP));
    }

    private static String getClassName(String string) {
        return string.substring(string.lastIndexOf(CLASSSEP) + 1);
    }

    public void addImport(String string) {
        this.imports.put(string, string);
    }

    public void addInterface(String string) {
        this.addInterface(string, false);
    }

    public void addInterface(String string, boolean bl) {
        this.impls = AbstractCompiler.add(this.impls, this.addClass(string, bl));
    }

    public String addClass(String string) {
        return this.addClass(string, false);
    }

    private String addClass(String string, boolean bl) {
        if (bl | string.indexOf(46) < 0) {
            return string;
        }
        this.addImport(string);
        return JavaSource.getClassName(string);
    }

    public method addConstructor(int n) {
        return this.addConstructor(n, "");
    }

    public method addConstructor(int n, String string) {
        method method2 = new method(n, this.getName(), string);
        this.constr.put(JavaSource.getMethodName(this.getName(), string), method2);
        return method2;
    }

    public method getConstructor() {
        return this.getConstructor("");
    }

    public method getConstructor(String string) {
        return (method)this.constr.get(JavaSource.getMethodName(this.getName(), string));
    }

    public field getField(String string) {
        return (field)this.fields.get(string);
    }

    public field addField(int n, String string, String string2) {
        return this.addField(n, string, string2, null);
    }

    public field addField(int n, String string, String string2, String string3) {
        return this.addField(n, string, string2, string3, false);
    }

    public field addField(int n, String string, String string2, String string3, boolean bl) {
        field field2 = new field(n, this.addClass(string2, bl), string, string3);
        this.fields.put(string, field2);
        return field2;
    }

    public method addMethod(int n, String string, String string2) {
        return this.addMethod(n, string, string2, "void");
    }

    public method addMethod(int n, String string, String string2, String string3) {
        return this.addMethod(n, string, string2, string3, false);
    }

    public method addMethod(int n, String string, String string2, String string3, boolean bl) {
        method method2 = new method(n, string, string2, this.addClass(string3, bl));
        this.methods.put(JavaSource.getMethodName(string, string2), method2);
        return method2;
    }

    public method getMethod(String string) {
        return this.getMethod(string, "");
    }

    public method getMethod(String string, String string2) {
        return (method)this.methods.get(JavaSource.getMethodName(string, string2));
    }

    public void addInnerClass(JavaSource javaSource) {
        this.innerclass.put(javaSource.getName(), javaSource);
    }

    private static String getMethodName(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        return string + ":" + string2;
    }

    private void optimiseImports() {
        String string = "java.lang.*";
        this.imports.put(string, string);
        Iterator iterator = this.imports.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.endsWith(".*") || !this.imports.containsKey(JavaSource.getPackageName(string2) + ".*")) continue;
            iterator.remove();
        }
        this.imports.remove(string);
    }

    public void write(Vector vector) throws IOException {
        this.write(vector, false);
    }

    public void write(Vector vector, boolean bl) throws IOException {
        String string;
        Iterator<Object> iterator;
        boolean bl2 = !bl;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            vector.add("// Warning! this file was generated by retepTools - BEWARE if editing this file");
            vector.add("// Source created " + new Date());
            vector.add("");
            vector.add("package " + this.getPackageName() + ";");
            vector.add("");
            this.optimiseImports();
            iterator = this.imports.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                vector.add("import " + string + ";");
            }
        }
        vector.add("");
        AbstractCompiler.writeComment(vector, this.comment);
        stringBuffer.setLength(0);
        stringBuffer.append("");
        if (this.isPublicClass()) {
            stringBuffer.append("public ");
        }
        if (this.isAbstractClass() && bl2) {
            stringBuffer.append("abstract ");
        }
        stringBuffer.append(this.isInterface() ? "interface " : "class ");
        stringBuffer.append(this.getName());
        if (this.impls != null) {
            iterator = ((AbstractList)this.impls).iterator();
            stringBuffer.append(" implements");
            string = " ";
            while (iterator.hasNext()) {
                stringBuffer.append(string).append(iterator.next());
                string = ", ";
            }
        }
        vector.add(stringBuffer.toString());
        vector.add("{");
        iterator = this.fields.keySet().iterator();
        while (iterator.hasNext()) {
            ((field)this.fields.get(iterator.next())).write(vector);
        }
        iterator = this.constr.keySet().iterator();
        while (iterator.hasNext()) {
            ((method)this.constr.get(iterator.next())).write(vector);
        }
        iterator = this.methods.keySet().iterator();
        while (iterator.hasNext()) {
            ((method)this.methods.get(iterator.next())).write(vector);
        }
        iterator = this.innerclass.keySet().iterator();
        while (iterator.hasNext()) {
            ((JavaSource)this.innerclass.get(iterator.next())).write(vector, true);
        }
        vector.add("}");
    }

    public File getFile(File file) {
        String string = this.getPackageName() + CLASSSEP + this.getName();
        string = string.replace('.', File.separatorChar);
        return new File(file, string + ".java");
    }

    private static void addModifier(StringBuffer stringBuffer, int n) {
        if ((n & 4) == 4) {
            stringBuffer.append("public ");
        }
        if ((n & 8) == 8) {
            stringBuffer.append("private ");
        }
        if ((n & 0x10) == 16) {
            stringBuffer.append("static ");
        }
        if ((n & 0x20) == 32) {
            stringBuffer.append("abstract ");
        }
        if ((n & 0x40) == 64) {
            stringBuffer.append("final ");
        }
    }

    public method createSingleton() {
        field field2 = this.addField(88, "SINGLETON", this.getName(), "new " + this.getName() + "()", true);
        field2.comment("The singleton instance");
        method method2 = this.addMethod(20, "getInstance", "", this.getName()).comment("@return the singleton instance of this class");
        method2.append("return SINGLETON;");
        return this.addConstructor(8, "").comment("Private constructor. Use " + this.getName() + ".getInstance()");
    }

    public void createXML() {
        this.createXML(this.getName());
    }

    public void createXML(String string) {
        this.addImport("org.w3c.dom.Attr");
        this.addImport("org.w3c.dom.Element");
        this.addImport("org.w3c.dom.Node");
        this.addImport("org.w3c.dom.NodeList");
        this.addImport("org.w3c.dom.SAXException");
        this.addImport("uk.org.retep.xml.core.XMLUtils");
        this.addImport("uk.org.retep.xml.core.XMLWriter");
        this.addInterface("uk.org.retep.xml.core.XML");
        this.addField(84, "ELEMENT", "String", "\"" + string + "\"");
        method method2 = this.addMethod(4, "writeXML", "XMLWriter out");
        method2.comment("Writes XML using a default element name").comment("@param out XMLWriter");
        method2.append("writeXML(out,ELEMENT);");
        method2 = this.addMethod(4, "writeXML", "XMLWriter out, String tag");
        method2.comment("Writes XML using a specified element name").comment("@param out XMLWriter");
        method2.comment("@param tag XML element name");
        method2 = this.addMethod(20, "decodeXML", "Element root", this.getName());
        method2.comment("Decodes the parsed DOM model").comment("@param root The Element that represents this object");
    }

    public class method {
        int type;
        String name;
        String args;
        String ret;
        Vector content;
        Vector comment;

        private method(int n, String string, String string2) {
            this(n, string, string2, (String)null);
        }

        private method(int n, String string, String string2, String string3) {
            this.type = n;
            this.name = string;
            this.args = string2;
            this.ret = string3;
            this.content = new Vector();
        }

        public method clearCode() {
            this.content.clear();
            return this;
        }

        public method clearComment() {
            this.comment = null;
            return this;
        }

        public method append(String string) {
            this.content.add(string);
            return this;
        }

        public method append() {
            return this.append("");
        }

        public method appendComment(String string) {
            this.content.add("// " + string);
            return this;
        }

        public method appendTry() {
            return this.append("try {");
        }

        public method appendCatch(String string) {
            return this.append("} catch(" + string + ") {");
        }

        public method appendCatchDialog(String string) {
            String string2 = string.substring(string.indexOf(" ") + 1);
            JavaSource.this.addClass("uk.org.retep.swing.ExceptionDialog");
            return this.appendCatch(string).append("ExceptionDialog.show(" + string2 + ");");
        }

        public method appendWhile(String string) {
            return this.append("while(" + string + ") {");
        }

        public method appendIf(String string) {
            return this.append("if(" + string + ") {");
        }

        public method appendElse() {
            return this.append("} else {");
        }

        public method appendElseIf(String string) {
            return this.appendClose().append("else if(" + string + ") {");
        }

        public method appendSwitch(String string) {
            return this.append("switch" + string + ")").appendOpen();
        }

        public method appendCase(String string) {
            return this.append("case " + string + ":");
        }

        public method appendBreak() {
            return this.append("break;").append();
        }

        public method appendDefault() {
            return this.append("default;");
        }

        public method appendOpen() {
            return this.append("{");
        }

        public method appendClose() {
            return this.append("}");
        }

        public method appendFor(String string, String string2, String string3) {
            return this.append("for(" + string + ";" + string2 + ";" + string3 + ") " + "{");
        }

        public method comment(String string) {
            this.comment = AbstractCompiler.add(this.comment, string);
            return this;
        }

        public method comment() {
            return this.comment("");
        }

        public void write(Vector vector) {
            vector.add("");
            AbstractCompiler.writeComment(vector, this.comment);
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = (this.type & 0x20) == 32;
            JavaSource.addModifier(stringBuffer, this.type);
            if (this.ret != null) {
                stringBuffer.append(this.ret).append(" ");
            }
            stringBuffer.append(this.name).append("(");
            if (this.args != null) {
                stringBuffer.append(this.args);
            }
            stringBuffer.append(")");
            if (bl) {
                stringBuffer.append(";");
            } else {
                stringBuffer.append(" ").append("{");
            }
            vector.add(stringBuffer.toString());
            if (!bl) {
                vector.addAll(this.content);
                vector.add("}");
            }
        }
    }

    public class field {
        int type;
        String obj;
        String name;
        String value;
        Vector comment = null;

        private field(int n, String string, String string2, String string3) {
            this.type = n;
            this.obj = string;
            this.name = string2;
            this.value = string3;
        }

        public field setValue(String string) {
            this.value = string;
            return this;
        }

        public field setMask(int n) {
            this.type = n;
            return this;
        }

        public field comment(String string) {
            this.comment = AbstractCompiler.add(this.comment, string);
            return this;
        }

        public field comment() {
            return this.comment("");
        }

        public void write(Vector vector) {
            vector.add("");
            AbstractCompiler.writeComment(vector, this.comment);
            StringBuffer stringBuffer = new StringBuffer();
            JavaSource.addModifier(stringBuffer, this.type);
            stringBuffer.append(this.obj).append(" ").append(this.name);
            if (this.value != null) {
                stringBuffer.append(" = ").append(this.value);
            }
            stringBuffer.append(";");
            vector.add(stringBuffer.toString());
            if ((this.type & 0x380) != 0) {
                method method2 = null;
                String string = this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
                if ((this.type & 0x80) == 128) {
                    method2 = JavaSource.this.addMethod(4, "set" + string, this.obj + " a" + string, "void");
                    method2.comment("Sets the " + this.name + " property");
                    method2.comment("@param a" + string + " the new value");
                    method2.append(this.name + " = a" + string + ";");
                }
                if ((this.type & 0x100) == 256) {
                    method2 = "boolean".equals(this.obj) ? JavaSource.this.addMethod(4, "is" + string, "", this.obj) : JavaSource.this.addMethod(4, "get" + string, "", this.obj);
                }
                if ((this.type & 0x200) == 512) {
                    method2 = JavaSource.this.addMethod(4, "get" + string, "", this.obj);
                }
                if ((this.type & 0x100) == 256 || (this.type & 0x200) == 512) {
                    method2.comment("Gets the current value of the " + this.name + " property");
                    method2.comment("@return the current value of " + this.name);
                    method2.append("return " + this.name + ";");
                }
            }
        }
    }
}

