/*
 * Copyright (c) 2002 Sosnoski Software Solutions, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

import java.io.*;

import javax.xml.parsers.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * Test driver class. Just creates a parser and parses the sample document,
 * then prints stock summary information at the end.
 *
 * @author Dennis M. Sosnoski
 * @version 1.0
 */

public class TestDriver
{
	/**
	 * Main method to run test.
	 */
	
	public static void main(String[] argv) {
		
		// set up JAXP parser creation
		SAXParserFactory spf = SAXParserFactory.newInstance();
		spf.setValidating(false);
		spf.setNamespaceAware(true);
		try {
			
			// parse the document
			SAXParser parser = spf.newSAXParser();
			DefaultHandler handler = new TradeStreamHandler();
			InputSource source = new InputSource
				(new FileReader("trades.xml"));
			parser.parse(source, handler);
			
			// report information from document
			System.out.println("Completed parse");
			StockTrack stock = StockTrack.getTrack("SUNW");
			System.out.println(" SUNW traded " + stock.getShareVolume() +
				" shares at prices ranging from " + stock.getLowPrice() +
				" to " + stock.getHighPrice());
			stock = StockTrack.getTrack("MSFT");
			System.out.println(" MSFT traded " + stock.getShareVolume() +
				" shares at prices ranging from " + stock.getLowPrice() +
				" to " + stock.getHighPrice());
			OptionTrack option = OptionTrack.getTrack("SUNW", true, 9, 100);
			System.out.println(" SUNW September 100 call traded options on " +
				option.getOptionVolume() + " shares at prices ranging from " + 
				option.getLowPrice() + " to " + option.getHighPrice());
				
		} catch (Exception ex) {
			ex.printStackTrace(System.err);
			System.exit(0);
		}
	}
}
