/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.examples.modules.minicomposer;

import java.awt.Image;
import java.beans.*;

import org.openide.TopManager;
import org.openide.execution.Executor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class InternalPlayerBeanInfo extends SimpleBeanInfo {
    public BeanInfo[] getAdditionalBeanInfo() {
        try {
            return new BeanInfo[] {Introspector.getBeanInfo(Executor.class)};
        } catch (IntrospectionException ie) {
            TopManager.getDefault().getErrorManager().notify(ie);
            return null;
        }
    }
    public BeanDescriptor getBeanDescriptor() {
        BeanDescriptor desc = new BeanDescriptor(InternalPlayer.class);
        desc.setDisplayName(NbBundle.getMessage(InternalPlayerBeanInfo.class, "LBL_InternalPlayer"));
        desc.setShortDescription(NbBundle.getMessage(InternalPlayerBeanInfo.class, "HINT_InternalPlayer"));
        return desc;
    }
    public Image getIcon(int type) {
        if (type == BeanInfo.ICON_COLOR_16x16 || type == BeanInfo.ICON_MONO_16x16) {
            return Utilities.loadImage("org/netbeans/examples/modules/minicomposer/InternalPlayerIcon.gif");
        } else {
            return null;
        }
    }
}
