package org.jboss.web.catalina;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import org.w3c.dom.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import org.xml.sax.HandlerBase;

import java.util.Stack;

import org.apache.catalina.util.xml.XmlAction;
import org.apache.catalina.util.xml.XmlMapper;

/** This is a step toward supporting elements of the catalina server.xml config
 as child elements of the jboss.jcml mbean/config extended configuration element.

 * @author  Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.1 $
 */
public class ConfigHandler
{
   
   /** Creates new ConfigHandler */
    public ConfigHandler()
    {
    }

    /** Handle the Connector configuration elements.
    @param config, the mbean/config jboss.jcml element
    @param root, the object to which the Connectors will be added using
       addConnector
    @param debug, a flag indicating if the XmlMapper debug level should be set
    */
    public void applyHostConfig(Element config, Object root, boolean debug)
      throws Exception
    {
       if( config == null )
          return;
       //getLogger
       // Create an XmlMapper utility
        XmlMapper mapper = new XmlMapper();
        if (debug)
            mapper.setDebug(999);
        mapper.setValidating(false);
        // Establish the mapping rules for Connectors
        mapper.addRule("Connector", mapper.objectCreate
                       ("org.apache.catalina.connector.http.HttpConnector",
                        "className"));
        mapper.addRule("Connector", mapper.setProperties());
        mapper.addRule("Connector", mapper.addChild
                       ("addConnector", "org.apache.catalina.Connector"));
        mapper.addRule("Connector/Factory", mapper.objectCreate
                       ("org.apache.catalina.net.DefaultServerSocketFactory",
                        "className"));
        mapper.addRule("Connector/Factory",
                       mapper.setProperties());
        mapper.addRule("Connector/Factory", mapper.addChild
                       ("setFactory",
                        "org.apache.catalina.net.ServerSocketFactory"));
        mapper.addRule("Server/Service/Connector/Listener", mapper.objectCreate
                       (null, "className"));
        mapper.addRule("Server/Service/Connector/Listener",
                       mapper.setProperties());
        mapper.addRule("Server/Service/Connector/Listener", mapper.addChild
                       ("addLifecycleListener",
                        "org.apache.catalina.LifecycleListener"));

        //InputStream is = createElementStream(config);
        //mapper.readXml(is, root);
            Stack st=mapper.getObjectStack();
            st.push( root );
        try {
        	String id="EmbeddedCatalinaServiceSX:Config";
            if(config.getNextSibling()!=null) {
              System.out.println(id+" XML Element have multiple childs. followers will be ignored!");
            }
            domElementToSax(config,mapper,id,debug?System.out:null);
        } catch (SAXParseException spe) {
            System.out.println("PARSE error in "+spe.getSystemId()+" at line " +
                               spe.getLineNumber() + " column " +
                               spe.getColumnNumber());
            System.out.println(spe.toString());
            throw spe;
        } catch (SAXException se) {
            System.out.println("ERROR reading dom as sax in "+getClass().getName());
            System.out.println("At " + se.getMessage());
            System.out.println();
            Exception ex1=se.getException();
            throw ex1;
        }
    }

    /** This is hacky as it depends on the Element.toString() which is
     not documented as returning the complete xml document text, but
     appears to to work. I can't believe there isn't a standard way to
     reparse a document from a given DOM node or to at least generate
     a text file!
     alain.coetmeur@caissedesdepots.fr: this does not work with xerces !
     */
   /* private InputStream createElementStream(Element config) 
    {
       String xmlFrag = config.toString();
       // debug!!
       if(debug)
         System.out.println(getClass().getName()+" Catalina Config Element class="+config.getClass().getName()+" XML fragment="+xmlFrag);
       byte[] bytes = xmlFrag.getBytes();
       return new ByteArrayInputStream(bytes);
    }*/
    
    /**
     * alain.coetmeur@caissedesdepots.fr: convers a DOM element into a sax event stream...
     * the best would be to use JAXP/TRAX API and use indentity transformer who can do that in 5 lines...
     * however this require to install TRAX API and a provider like xalan (with xerces)...
     * soon this will became normal, but today many prefer to let TRAX as a module by module option
     *
     * anyway this function is practical but should be moved to a "utility" package
     */
    public static void domElementToSax( Node root, org.xml.sax.HandlerBase handler, String id, PrintStream debugOut) throws SAXException
    {
      boolean debug=debugOut!=null;
      Stack nodeStack=new Stack();
      org.xml.sax.helpers.LocatorImpl l=new org.xml.sax.helpers.LocatorImpl();
      l.setColumnNumber(0) ;
      l.setLineNumber(0);
      l.setPublicId(id) ;
      l.setSystemId(id) ;
      handler.setDocumentLocator(l);
      if(debug) debugOut.println("start doc...");
      handler.startDocument();
      if(debug) debugOut.println("push root");
      nodeStack.push(root);
      while(!nodeStack.empty())
      {
        if(debug) debugOut.println("stack peek node");
 	Node node=(Node)(nodeStack.peek());
 	StringBuffer path=new StringBuffer();
 	path.append(id).append(":");
 	for(int i=0;i<nodeStack.size();i++) {
 	  String nm=((Node)(nodeStack.elementAt(i))).getNodeName();
 	  path.append("/");
 	  if(nm==null) {
 	    path.append("{"+nodeStack.elementAt(i).getClass().getName()+"}");
 	  } else {
 	    path.append(nm);
 	  };
 	}
        l.setPublicId(path.toString()) ;
        l.setSystemId(path.toString()) ;
        l.setColumnNumber(nodeStack.size());
        l.setLineNumber(l.getLineNumber()+1);
        if(debug) debugOut.println(path.toString()+": "+l.getLineNumber()+"/"+l.getColumnNumber());
      	if(node.getNodeType()==Node.ELEMENT_NODE ) {
	  org.w3c.dom.Element el=(org.w3c.dom.Element)node;
	  org.w3c.dom.NamedNodeMap attrMap=el.getAttributes();
	  int len=attrMap.getLength();
	  org.xml.sax.helpers.AttributeListImpl saxAttr=new org.xml.sax.helpers.AttributeListImpl();
	  if(debug) debugOut.println("element:"+el.getTagName());
	  for(int i=0;i<len;i++)
	  {
	  	Attr a=(Attr)(attrMap.item(i));
    	        if(debug) debugOut.println("attrib:"+a.getName()+"="+a.getValue());
	  	saxAttr.addAttribute(a.getName(),"CDATA" , a.getValue()) ;
	  }
          handler.startElement(el.getTagName(), saxAttr) ;
        } else if(node.getNodeType()==Node.ATTRIBUTE_NODE   ) {
	  org.w3c.dom.Attr attr=(org.w3c.dom.Attr)node;
          handler.error( new SAXParseException(
             "raw Attr not supported ",l ));
        } else if(node.getNodeType()==Node.CDATA_SECTION_NODE  ) {
	  org.w3c.dom.CDATASection txt=(org.w3c.dom.CDATASection)node;
	  char [] content=txt.getData().toCharArray();
	  int len=txt.getLength();
 	  if(debug) debugOut.println("cdata:"+txt.getData());
          handler.characters(content, 0, len) ;
        } else if(node.getNodeType()==Node.TEXT_NODE  ) {
	  org.w3c.dom.Text txt=(org.w3c.dom.Text)node;
	  char [] content=txt.getData().toCharArray();
	  int len=txt.getLength();
 	  if(debug) debugOut.println("text:"+txt.getData());
	  int beg=0;
	  int end=beg;
	  boolean white=false;
	  while(end<len) {
	    beg=end;
	    white=Character.isWhitespace(content[beg]);
	    while(end<len && Character.isWhitespace(content[end])==white) end++;
	    if(white) {
 	      handler.ignorableWhitespace (content, beg, end-beg);
   	      if(debug) debugOut.println("text: ignorableWhitespace="+beg+".."+end);
	    } else {
              handler.characters(content, beg, end-beg) ;
   	      if(debug) debugOut.println("text: characters="+beg+".."+end);
	    }
	  }
 	  if(beg>0)
 	   handler.ignorableWhitespace (content, 0, beg);
          if(beg-end>0)handler.characters(content, beg, end-beg) ;
 	  if(end<len)
 	   handler.ignorableWhitespace (content, end, len-end);
        } else if(node.getNodeType()==Node.PROCESSING_INSTRUCTION_NODE) {
	  org.w3c.dom.ProcessingInstruction pi=(org.w3c.dom.ProcessingInstruction)node;
	  if(debug) debugOut.println("process instruction:"+pi.getTarget()+","+pi.getData());
	  handler.processingInstruction(pi.getTarget(), pi.getData())   ;
        } else if(node.getNodeType()==Node.NOTATION_NODE ) {	
	  org.w3c.dom.Notation not=(org.w3c.dom.Notation)node;
	  if(debug) debugOut.println("notation:");
          handler.notationDecl(not.getNodeName(),not.getPublicId(), not.getSystemId()) ;
        } else if(node.getNodeType()==Node.ENTITY_REFERENCE_NODE  ) {	
	  org.w3c.dom.EntityReference eref=(org.w3c.dom.EntityReference)node;
	  if(debug) debugOut.println("entityref:");
 	  //handle.unparsedEntityDecl(eref.getNodeName(), eref.getPublicId(), eref.getSystemId(), eref.getNotationName()) 
          handler.error( new SAXParseException(
             "EntityReference not supported ",l ));
        } else if(node.getNodeType()==Node.ENTITY_NODE  ) {	 
	  org.w3c.dom.Entity eref=(org.w3c.dom.Entity)node;
	  if(debug) debugOut.println("entity:");
           //InputSource is=resolveEntity(eref.getPublicId(), eref.getSystemId()) ;
           handler.error( new SAXParseException(
             "Entity not supported ",l ));
        } else if(node.getNodeType()==Node.DOCUMENT_TYPE_NODE   ) {
	  org.w3c.dom.DocumentType doctype=(org.w3c.dom.DocumentType)node;
	  if(debug) debugOut.println("doctype:");
        } else if(node.getNodeType()==Node.DOCUMENT_NODE   ) {	 
	  org.w3c.dom.Document doc=(org.w3c.dom.Document)node;        	
	  if(debug) debugOut.println("doc:");
        } else if(node.getNodeType()==Node.DOCUMENT_FRAGMENT_NODE    ) {	 
	  org.w3c.dom.DocumentFragment docfrag=(org.w3c.dom.DocumentFragment)node;
	  if(debug) debugOut.println("docfrag:");
        } else if(node.getNodeType()==Node.COMMENT_NODE   ) {	 
	  org.w3c.dom.Comment cmt=(org.w3c.dom.Comment)node;
	  if(debug) debugOut.println("comment:");
 	} else {
	  handler.warning(new SAXParseException("unknown node type#"+node.getNodeType(), l)) ;
	}
        Node child=node.getFirstChild();
        if(child!=null) {
            if(debug) debugOut.println("push child"+child.getNodeName());
            nodeStack.push(child);
        } else {
          Node nextNode=null;
          while(!nodeStack.empty() && nextNode==null) {
            node=(Node)(nodeStack.pop());
            if(debug) debugOut.println("pop node:"+node.getNodeName());
            if(node.getNodeType()==Node.ELEMENT_NODE ) {
	     org.w3c.dom.Element el=(org.w3c.dom.Element)node;
             if(debug) debugOut.println("element:/"+el.getTagName());
             handler.endElement(el.getTagName()) ;
            }
            if(node!=root)  {      
              nextNode=node.getNextSibling(); 
              if(debug) debugOut.println("get next sibling:"+nextNode);
            }
          }
          if(nextNode!=null) {
              if(debug) debugOut.println("push nextnode:"+nextNode.getNodeName());
              nodeStack.push(nextNode);
            }
        } 
      }
      handler.endDocument();
      if(debug) debugOut.println("end doc...");
      
    }
}
