import java.sql.*;

public class EssentialJDBC
{
    Connection connection;
    Statement statement;
    String sourceURL = "jdbc:postgresql://192.168.168.235:5432/testdb";
    String queryIDAndName = "SELECT authid, lastname, firstname FROM authors";
    String queryWildcard = "SELECT * FROM books";
    
    public static void main(String[] args)
    {
        EssentialJDBC SQLExample = new EssentialJDBC();         // Create application object
        
        SQLExample.getResultsByColumnName();
        SQLExample.getResultsByColumnPosition();
        SQLExample.getAllColumns();
        SQLExample.closeConnection();
    } // public static void main(String[] args)
    
    public EssentialJDBC()
    {
        // Constructor to establish the connection and create a Statement object...
        try
        {
            Class.forName("org.postgresql.Driver");
            connection = DriverManager.getConnection(sourceURL, "postgres", "pg.test");
            statement = connection.createStatement();
        } // try
        catch(SQLException sqle)
        {
            System.err.println("Error creating connection");
            System.err.println(sqle.toString());
        } // catch(SQLException sqle)
        catch(ClassNotFoundException cnfe)
        {
            System.err.println(cnfe.toString());
        } // catch(ClassNotFoundException cnfe)
        
    } // public EssentialJDBC()
    
    void getResultsByColumnName()
    {
        // Execute wildcard query and output selected columne...
        
    } // void getResultsByColumnName()
    
    void getResultsByColumnPosition()
    {
        // Execute ID and name query and output results...
    } // void getResultsByColumnPosition()
    
    void getAllColumns()
    {
        // Execute wildcard query and output all columns...
        try
        {
            ResultSet authorResults = statement.executeQuery(queryWildcard);
            
            ResultSetMetaData metadata = authorResults.getMetaData();
            int columns = metadata.getColumnCount();
            int row = 0;
            while(authorResults.next())
            {
                System.out.print("\nRow " + (++row) + ") ");
                for(int i = 1; i <= columns; i++)
                    System.out.print((i>1?", ":" ") + authorResults.getString(i));
            } // while(authorResults.next())
            
            authorResults.close();
        } // try
        catch (SQLException ex)
        {
            System.out.println("\nSQLException------------------\n");
            System.out.println("SQLState: " + ex.getSQLState());
            System.out.println("Message : " + ex.getMessage());
        } // catch (SQLException ex)
    } // void getAllColumns()
    
    void closeConnection()
    {
        if(connection != null)
        try
        {
            connection.close();
            connection = null;
        }
        catch (SQLException ex)
        {
            System.out.println("\nSQLException------------------\n");
            System.out.println("SQLState: " + ex.getSQLState());
            System.out.println("Message : " + ex.getMessage());
        } // catch (SQLException ex)
    } // void closeConnection()
    
} // public class EssentialJDBC