import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import java.sql.*;
import javax.swing.event.TableModelListener;
import javax.swing.event.*;

public class InteractiveSQL extends JFrame implements ActionListener, TableModelListener
{
    //JTextField command = new JTextField();              // Input area for SQL
    JTextArea command = new JTextArea(3,1);
    JTextArea status = new JTextArea(6, 1);             // Output area for status and errors
    JTextField buttonStatus = new JTextField();
    JScrollPane resultsPane;
        
    JMenuBar menuBar = new JMenuBar();                          // The menu bar
    JMenuItem clearQueryItem = new JMenuItem("Clear query") ;   // Clear SQL item
    JMenuItem exitItem = new JMenuItem("Exit");                 // Exit item
    JButton executeButton = new JButton(new InteractiveSQL.SQLBtnAction("execute"));
    JButton updateButton = new JButton(new InteractiveSQL.SQLBtnAction("update"));
    JButton addButton = new JButton(new InteractiveSQL.SQLBtnAction("add"));
    JButton deleteButton = new JButton(new InteractiveSQL.SQLBtnAction("delete"));
    
    Connection connection;                              // Connection to the database
    Statement statement;                                 // Statement object for queries
    JTable table;                                       // Table
    ResultsModel model;                                 // Table model for resultset
        
    //boolean dataChanged = false;
    
    String tableName = "";                              // Name of the table
    String[] columnNames;                               // Name of the columns
    //boolean statusAppend = false;                       // Append to the status
    String statusAppendText = "";                             // Text to be appended.
    
    ChangeListener tableVerticalScrollBarChangeListener;      // for vertical adjustment
    boolean hasUpdateData = false;                              // flag to indicate if there is any data to update
    
    public InteractiveSQL(String driver, String url, String user, String password, String dataTypeMapper)
    {
        super("InteractiveSQL");                        // call base constructor
        setBounds(0, 0, 400, 300);                      // Set window bounds
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);     // Close window operation
        addWindowListener(new WindowHandler());         // Listener for window close
        
        // Add the input for SQL statments at the top
        command.setToolTipText("Key SQL command and press the execute button");
        //command.addActionListener(this);
        JPanel commandPanel = new JPanel();
        commandPanel.setLayout(new BorderLayout());
        //command.setBounds(0, 0, 200, 20);
        commandPanel.add(new JScrollPane(command), BorderLayout.NORTH);
        JPanel buttonPanel = new JPanel();
        updateButton.setEnabled(false);
        addButton.setEnabled(false);
        deleteButton.setEnabled(false);
        buttonPanel.add(executeButton);
        buttonPanel.add(updateButton);
        buttonPanel.add(addButton);
        buttonPanel.add(deleteButton);
        commandPanel.add(buttonPanel, BorderLayout.CENTER);
        buttonStatus.setBackground(new Color(204, 204, 204));
        buttonStatus.setEditable(false);
        buttonStatus.setPreferredSize(new Dimension(200,21));
        buttonStatus.setBorder(BorderFactory.createEmptyBorder());
        buttonPanel.add(buttonStatus);
        //commandPanel.add(buttonStatus, BorderLayout.SOUTH);
        getContentPane().add(commandPanel, BorderLayout.NORTH);
        
        // Add the status reporting area at the bottom
        //status.setLineWrap(true);
        status.setWrapStyleWord(true);
        status.setBackground(new Color(204, 204, 204));
        status.setEditable(false);
        getContentPane().add(new JScrollPane(status), BorderLayout.SOUTH);
        /*
        // Create the menubar from the menu items
        JMenu fileMenu = new JMenu("File");             // Create File menu
        fileMenu.setMnemonic('F');                      // Create shortcut
        clearQueryItem.addActionListener(this);
        exitItem.addActionListener(this);
        fileMenu.add(clearQueryItem);                   // Add clear query item
        fileMenu.add(exitItem);                         // Add exit item
        menuBar.add(fileMenu);                          // Add menu to the menubar
        setJMenuBar(menuBar);                           // Add menubar to the window
        */
        
        // Establish a database connection and set up the table
        try
        {
            Class.forName(driver);                      // Load the driver
            connection = DriverManager.getConnection(url, user, password);
            statement = connection.createStatement();
            
            model = new ResultsModel();                 // Create a table model
            
            model.addTableModelListener(this);
            
            table = new JTable(model);           // Create a table from the model
            resultsPane = new JScrollPane(table);       // Create scrollpane for table
            table.setAutoResizeMode(table.AUTO_RESIZE_OFF);
            table.setSurrendersFocusOnKeystroke(true);      // gives focus to the cell once the user starts typing
            /*
            table.addMouseListener(new MouseAdapter(){
                
            });
             */
            
            /*
            ListSelectionModel rowSM = table.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener()
            {
                public void valueChanged(ListSelectionEvent e)
                {
                    //Ignore extra messages.
                    if (e.getValueIsAdjusting()) return;
        
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (lsm.isSelectionEmpty()) {
                    ...//no rows are selected
                } 
                else 
                {
                    int selectedRow = lsm.getMinSelectionIndex();
                    int selectedColumn = 
                    ...//selectedRow is selected
                } // else
                }
            });
             */



            //model.addTableModelListener();
            //resultsPane2 = new JScrollPane(resultsPane);
            //resultsPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
            //table.setDefaultEditor();
            getContentPane().add(resultsPane, BorderLayout.CENTER);
            
            // Adjustment for adding
            
            JScrollBar temp_scrollbar = resultsPane.getVerticalScrollBar();
            BoundedRangeModel temp_model = temp_scrollbar.getModel();
            
            // Annonymous Class for moving to the maximum for the vertical scrollbar for the table;
            /*
            tableVerticalScrollBarChangeListener = new ChangeListener(){
                
                //private int max_value = 0;
                boolean rowAdded = false;
                
                //public void rowAdded()
                //{
                //    rowAdded = true;
                //} // public ChangeListener()
                
                public void stateChanged(ChangeEvent e)
                {
                    //temp_scrollbar.setValue(temp_scrollbar.getMaximum());
                                        
                    if(e == null)
                    {
                        rowAdded = true;
                        return;
                    } // if(e == null)
                    
                    BoundedRangeModel temp_model = (BoundedRangeModel)e.getSource();
                    //temp_model.g
                    
                    if(rowAdded)
                    {
                        temp_model.setValue(temp_model.getMaximum());
                        rowAdded = false;
                        //max_value = temp_model.getMaximum();
                    } // if(max_value !=temp_model.getMaximum())
                } // public void stateChanged(ChangeEvent)
            };
            temp_model.addChangeListener(tableVerticalScrollBarChangeListener);
             */
            
        } // try
        catch(ClassNotFoundException cnfe)
        {
            System.err.println(cnfe);                   // Driver not found
        } // catch(ClassNotFoundException cnfe)
        catch(SQLException sqle)
        {
            System.err.println(sqle);                   // error connection to database
        } // catch(SQLException sqle)
        
        pack();
        setVisible(true);
    } // public InteractiveSQL(String driver, String url, String user, String password)
    
    public static void main(String[] args)
    {
        // Create the application object
        //InteractiveSQL theApp = new InteractiveSQL("org.postgresql.Driver", "jdbc:postgresql://192.168.168.235:5432/testdb", "postgres", "pg.test");
        
        
        String driver = "org.postgresql.Driver";
        String url = "jdbc:postgresql://192.168.168.235:5432/testdb2";
        String user = "postgres";
        String password = "pg.test";
        String dataTypeMapper = "PostgreSQLDataTypeMapper";             // PostgreSQL-to-Java DataType mapping.
        
        /*        
        String driver = "com.thinweb.tds.Driver";
        String url = "jdbc:twtds:sqlserver://192.168.168.232/mobylon";
        String user = "sa";
        String password = "beta2";
        String dataTypeMapper = "MSSQLDataTypeMapper";
         */
                
        // Up to 4 arguments in the sequence database url, driver url, user_id, password
        
        switch(args.length)
        {
            case 5:                                 // Start here for five arguments
                dataTypeMapper = args[4];
                // Fall through to the next case
            case 4:                                 // Start here for four arguments
                password = args[3];
                // Fall through to the next case
            case 3:                                 // Start here for three arguments
                user = args[2];
                // Fall through to the next case
            case 2:                                 // Start here for two arguments
                driver = args[1];
                // Fall through to the next case
            case 1:                                 // Start here for one arguments
                url = args[0];
        } // switch(args.length)
        
        InteractiveSQL theApp = new InteractiveSQL(driver, url, user, password, dataTypeMapper);
        
    } // public static void main(String[] args)
    
    public void executeSQL()
    {
        String query = command.getText();           // Get the SQL statement
        if(query == null)                           // If there's nothing we are done
            return;
        try
        {
            boolean dataChanged = false;
            if(statement.execute(query))
            {
                model.setResultSet(statement.getResultSet());
                columnNames = model.getColumnNames();
                tableName = PostgreSQLDataObject.parseSQLStatement(query).getTableName();
                //status.setText(statusAppendText + "Resultset has " + model.getRowCount() + " row(s)."
                //    + "\nNote: Only data from a single table can be modified.\nViews and data from multiple tables cannot be modified.");
                statusAppendText = statusAppendText + "Resultset has " + model.getRowCount() + " row(s)."
                    + "\nNote: Only data from a single table can be modified.\nViews and data from multiple tables cannot be modified.";
                addButton.setEnabled(true);
                deleteButton.setEnabled(true);
            } // if(statement.execute(query))
            else
            {
                model.setResultSet(null);
                //status.setText(statusAppendText + "Affected " + statement.getUpdateCount() + " row(s).");
                statusAppendText = statusAppendText + "Affected " + statement.getUpdateCount() + " row(s).";
                addButton.setEnabled(false);
                deleteButton.setEnabled(false);
            } // else
            
            updateButton.setEnabled(false);         // should always go to false after there is new data.
            hasUpdateData = false;
            // statusAppendText = "";
        } // try
        catch(SQLException sqle)
        {
            String errorInfo = "";
            do
            {
                errorInfo += "Exception occured:"
                    + "\n" + "Message: " + sqle.getMessage()
                    //+ "\n" + "Localized Message: " + sqle.getLocalizedMessage()
                    //+ "\n" + "SQL state: " + sqle.getSQLState()
                    //+ "\n" + "Vendor code: " + sqle.getErrorCode()
                    ;
            } while((sqle = sqle.getNextException()) != null); // do
            //status.setText(errorInfo);      // Display error message
            
            statusAppendText = statusAppendText + errorInfo;
        } // catch(SQLException sqle)
        // Display all messages from here.
        status.setText(statusAppendText);
        statusAppendText = "";
        
    } // public void executeSQL()
    
    public void actionPerformed(ActionEvent e)
    {
        Object source = e.getSource();
        if(source == command)                       // Enter key for text field input
            executeSQL();
        else if(source == clearQueryItem)           // Clear query menu item
            command.setText("");                    // Clear SQL entry
        else if(source == exitItem)                 // Exit menu item
        {
            dispose();                              // Release the window resources
            System.exit(0);                         // End the application
        } // else if(source == exitItem)
    } // public void actionPerformed(ActionEvent e)
    
    public void tableChanged(javax.swing.event.TableModelEvent tableModelEvent)
    {
        if(model.getDataChanged())
        {
            updateButton.setEnabled(true);
            hasUpdateData = true;
        } // if(model.getDataChanged())
    } // public void tableChanged(javax.swing.event.TableModelEvent tableModelEvent)
    
    public String formatRowDataToString(Object[] rowData, String[] columnNames)
    {
        String temp_condition = "";             // used in the WHERE
        String formatedString = "";
        // get the list of columns with changed data
        for(int i = 0; i < columnNames.length; i++)
        {
            if(rowData[i] == null)
                temp_condition = columnNames[i] + " IS NULL";
            else
                temp_condition = columnNames[i] + "='" + rowData[i].toString() + "'";
                //if(originalRowData[i].getClass().equals(new BigDecimal(0).getClass()))
                //    temp_condition = columnNames[i] + "=\'?\'";
                //else
                    //temp_condition = columnNames[i] + "=?";
            if(i == 0)
               formatedString = formatedString + " " + temp_condition;
            else
                formatedString = formatedString + " AND " + temp_condition;
        } // for(int i = 0; i < columnNames.length; i++)
        return formatedString;
    } // public String formatRowDataToString()
    
    class WindowHandler extends WindowAdapter
    {
        // Handler for window closing event
        public void windowClosing(WindowEvent e)
        {
            dispose();                                  // Release the window resources
            System.exit(0);                             // End the application
        } // public void window(WindowEvent e)
    } // class WindowHandler  extends WindowAdapter
    
    class SQLBtnAction extends AbstractAction
    {
        
        SQLBtnAction(String name)
        {
            super(name);
            //String iconFileName = p_path + "images/open.gif";
            //if(new File(iconFileName).exists())
                //putValue(SMALL_ICON, new ImageIcon(iconFileName));           
        } // UpdateAction(String name)
        
        SQLBtnAction(String name, String tooltip)
        {
            this(name);
            if(tooltip != null)
                putValue(SHORT_DESCRIPTION, tooltip);
        } // FileAction(String name, String toolTip)
        
        public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
            //status.setText("executing...");
            Object source = actionEvent.getSource();
            if(source == executeButton)                       // Enter key for text field input
            {
                //buttonStatus.setText("executing...");
                //try
                //{
                    buttonStatus.updateUI();
                //} // try
                //catch(InterruptedException ie)
                //{
                //    ;
                //} // catch(InterruptedException);
                executeSQL();
                buttonStatus.setText("Executed");
            } // if(source == executeButton)
            else if(source == updateButton)
            {
                //table.changeSelection(0, 0, false, false);
                //table.editingStopped(null);
                //table.clearSelection();
                OriginalRowsContainer rowsContainer = model.getOriginalRows();
                
                if(rowsContainer == null)
                {
                    statusAppendText = "Updated 0 row(s)." + "\n";
                    executeSQL();                               
                    updateButton.setEnabled(false);
                    return;
                } // if(rowsContainer.getChangedRowsCount() == 0)
                
                Object[] originalRows = rowsContainer.getOriginalRowsAllArray();
                Object[] changedRows = rowsContainer.getChangedRowsAllArray();
                int[] changedRowsIndex = rowsContainer.getChangedRowsIndexArray();
                int changedRowsCount = changedRows.length;
                //RowBean originalRowBean;
                //RowBean changedRowBean;
                Object[] originalRowData;
                Object[] changedRowData;
                String rowDataStr = "";
                int updatedCount = 0;
                int addedCount = 0;
                boolean hasAddedRows = false;
                
                // Get all the changed rows and update each of them.
                for(int i = 0; i < changedRowsCount; i++)
                {
                    String originalRowDataStr = "";
                    String changedRowDataStr = "";
                    originalRowData = ((RowBean) originalRows[i]).getRowData();
                    changedRowData = ((RowBean) changedRows[i]).getRowData();
                    
                    /*
                    for(int j = 0; j < originalRowData.length; j++)
                    {
                        if(originalRowData[j] != null)
                            originalRowDataStr = originalRowDataStr + "   " + originalRowData[j].toString();
                        else
                            originalRowDataStr = originalRowDataStr + "   " + "null";
                        if(changedRowData[j] != null)
                            changedRowDataStr = changedRowDataStr +  "   " + changedRowData[j].toString();
                        else
                            changedRowDataStr = changedRowDataStr +  "   " + "null";
                    } // for(int j = 0; j < originalRowData.length; j++)
                    rowDataStr = rowDataStr + "Original: " + originalRowDataStr + "\n" + "Changed: " + changedRowDataStr + "\n\n";
                
                */
                try
                {
                    if(changedRowsIndex[i] < model.getOriginalRowsCount())              // If it is less than the original rows count, it is added column.
                    {
                        PreparedStatement pStatement = PostgreSQLDataObject.getPreparedStatementForUpdate(connection, tableName, columnNames, null, null, originalRowData, changedRowData);
                        if(pStatement != null)
                            updatedCount += pStatement.executeUpdate();
                    } // if(i < model.getOriginalRowsCount)
                    else
                    {
                        hasAddedRows = true;
                        /*
                        for(int j = 0; j < originalRowData.length; j++)
                        {
                            if(originalRowData[j] != null)
                                originalRowDataStr = originalRowDataStr + "   " + originalRowData[j].toString();
                            else
                                originalRowDataStr = originalRowDataStr + "   " + "null";
                            if(changedRowData[j] != null)
                                changedRowDataStr = changedRowDataStr +  "   " + changedRowData[j].toString();
                            else
                                changedRowDataStr = changedRowDataStr +  "   " + "null";
                        } // for(int j = 0; j < originalRowData.length; j++)
                        rowDataStr = rowDataStr + "Original: " + originalRowDataStr + "\n" + "Changed: " + changedRowDataStr + "\n\n";
                        System.out.println(rowDataStr);
                         */
                        
                        PreparedStatement pStatement = PostgreSQLDataObject.getPreparedStatementForInsert(connection, tableName, columnNames, null, null, originalRowData, changedRowData);
                        if(pStatement != null)
                            addedCount += pStatement.executeUpdate();                
                    } // else
                    
                } // try
                catch (SQLException sqle)
                {
                    //System.err.println("from execute()" + sqle);
                    String errorInfo = "";
                    do
                    {
                        errorInfo += "Exception occured:" + "at" + formatRowDataToString(model.getRowDataAtIndex(changedRowsIndex[i]), columnNames)
                        + "\n" + "Message: " + sqle.getMessage();
                    } while((sqle = sqle.getNextException()) != null); // do
                    
                    statusAppendText = statusAppendText + errorInfo;
                } // catch (SQLException sqle)
                    
                } // for(int i = 0; i < changedRowsCount; i++)
                
                //status.setText(statusAppendText + "Updated " + updatedCount + " row(s).");
                statusAppendText = statusAppendText + "Updated " + updatedCount + " row(s)." + "\n";
                if(hasAddedRows)
                    statusAppendText = statusAppendText + "Added " + addedCount + " row(s)." + "\n";
                executeSQL();
                
                //status.setText(rowDataStr);
                rowsContainer.removeAllElements();
                //updateButton.setEnabled(false);
            } // else if(source == updateButton)
            else if(source == addButton)                       // Enter key for text field input
            {
                int newRowIndex;
                model.addNewRow();
                updateButton.setEnabled(true);
                newRowIndex = table.getRowCount() - 1;
                //table.editCellAt(newRowIndex, 0);               // move focus to the new row
                
                table.changeSelection(newRowIndex, 0, false, false);
                
                //((DefaultTableCellRenderer)table.getCellRenderer(newRowIndex, 0)).setNextFocusableComponent(((DefaultTableCellRenderer)table.getCellRenderer(newRowIndex, 1)));
                //table.get
                //((DefaultTableCellRenderer)table.getCellRenderer(newRowIndex, 0)).requestDefaultFocus();
                //model.fireTableDataChanged();
                //table.firePropertyChange(null, 0, 0);
                //temp_scrollbar.setValue(temp_scrollbar.getMaximum());
                //model.addNewRow();
                
                //----------------------------------------------------
                // Come back to fix later. Use inner class instead of annonymous class
                //tableVerticalScrollBarChangeListener.stateChanged(null);
                //----------------------------------------------------
            } // else if(source == addButton)
            else if(source == deleteButton)                       // Enter key for text field input
            {
                int[] selectedRows = table.getSelectedRows();       // get the selected rows
                Object[] rowData;                                   // row data
                int deleteCount = 0;                                // number of rows deleted
                                
                // Don't do anything if the user made changes to the table
                if(hasUpdateData || (model.getCurrentRowsCount() != model.getOriginalRowsCount()))
                {
                    JOptionPane.showConfirmDialog(table, "Please update any changes made to the table first.", "Data Changed", JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE);
                    return;
                } // if(hasUpdateData)
                if(selectedRows.length == 0)                        // do nothing if no rows are selected
                {
                    JOptionPane.showConfirmDialog(table, "Please select row to delete.", "No rows selected", JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE);
                    return;
                } // if(selectedRows.length == 0)
                if(!(JOptionPane.YES_OPTION == JOptionPane.showConfirmDialog(table, "Delete " + selectedRows.length + " row(s)?", "Delete Rows", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE)))
                    return;
                for(int i = 0; i < selectedRows.length; i++)
                {
                    rowData = model.getRowDataAtIndex(selectedRows[i]);
                    
                    try
                    {
                        PreparedStatement pStatement = PostgreSQLDataObject.getPreparedStatementForDelete(connection, tableName, columnNames, null, null, rowData, null);
                        if(pStatement != null)
                            deleteCount += pStatement.executeUpdate();
                    } // try
                    catch (SQLException sqle)
                    {
                        //System.err.println("from execute()" + sqle);
                        String errorInfo = "";
                        do
                        {
                            errorInfo += "Exception occured:"+ "at" + formatRowDataToString(model.getRowDataAtIndex(selectedRows[i]), columnNames)
                            + "\n" + "Message: " + sqle.getMessage();
                        } while((sqle = sqle.getNextException()) != null); // do
                        statusAppendText = statusAppendText + errorInfo;
                    } // catch (SQLException sqle)
                } // for(int i = 0; i < selectedRows.length; i++)
                
                statusAppendText = statusAppendText + "Deleted " + deleteCount + " row(s)." + "\n";
                executeSQL();                               
            } // else if(source == deleteButton)
            
            //status.setText("executed.");
            //model.save(status);
            /*
            String name = (String) getValue(NAME);
            if(name.equals(saveAction.getValue(NAME)))
            {
                //int result = files.showSaveDialog(SketchFrame2.this);
                saveOperation();
            } // if(name.equals(saveAction.getValue(NAME)))
            else if(name.equals(saveAsAction.getValue(NAME)))
            {
                File file = showDialog("Save Sketch As", "Save", "Save the sketch", 's', modelFile == null ? new File(files.getCurrentDirectory(), filename) : modelFile);
                if(file != null)
                {
                    if(file.exists() && !file.equals(modelFile))
                        if(JOptionPane.NO_OPTION == JOptionPane.showConfirmDialog(SketchFrame2.this, file.getName() + " exists. Overwrite?", "Confirm Save As", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE)) // Overwrite warning, No file selected
                            return;
                    saveSketch(file);
                } // if(file != null)
                return;
            } // else if(name.equals(saveAsAction.getValue(NAME)))
            else if(name.equals(openAction.getValue(NAME)))
            {
                checkForSave();
                
                File file = showDialog("Open Sketch File", "Open", "Read a sketch from file", 'o', null); // Dialog window title, button label, Button tooltip text, Shortcut character, No file selected, If a file was selected, then read it
                if(file != null)
                    openSketch(file);
            } // else if(name.equals(openAction.getValue(NAME)))
            else if(name.equals(newAction.getValue(NAME)))
            {
                checkForSave();
                theApp.insertModel(new SketchModel());              // Insert new empty sketch
                modelFile = null;                                   // No file for it
                filename = DEFAULT_FILENAME;                        // Default name
                setTitle(frameTitle + files.getCurrentDirectory() + "\\" + filename);
                sketchChanged = false;                              // Not changed yet
            } // else if(name.equals(newAction.getValue(NAME)))
            else if(name.equals(printAction.getValue(NAME)))
            {
                
            } // else if(name.equals(printAction.getValue(NAME)))
            else if(name.equals(closeAction.getValue(NAME)))
            {
                checkForSave();
                System.exit(0);
            } // else if(name.equals(closeAction.getValue(NAME)))
            */
        }
        
    } // class FileAction extends AbstractAction
    
} // public class InteractiveSQL extends JFrame
