package jp.turbosql.examples.modules.minicomposer;

import org.openide.loaders.*;
import org.openide.filesystems.*;
import org.openide.cookies.*;
import org.openide.util.*;
import org.openide.nodes.*;

public class ScoreDataObject extends MultiDataObject
{
    private static final long serialVersionUID = 5776214949118746290L;
    
    public ScoreDataObject(org.openide.filesystems.FileObject pf, ScoreDataLoader loader) throws DataObjectExistsException
    {
        super(pf, loader);
        CookieSet cookies = getCookieSet();
        cookies.add(new ScoreEditorSupport(this));
        cookies.add(new ScoreExec(this));
    } // public ScoreDataObject(FileOject pf, ScoreDataLoader loader) throws DataObjectExistsException
    
    public HelpCtx getHelpCtx()
    {
        return new HelpCtx("jp.turbosql.examples.modules.minicomposer");
    } // public HelpCtx getHelpCtx()
    
    protected Node createNodeDelegate()
    {
        return new ScoreDataNode(this);
    } // protected Node createNodeDelegate()
    
    void addSaveCookie(SaveCookie save)
    {
        getCookieSet().add(save);
    } // void addSaveCookie(SaveCookie save)
    
    void removeSaveCookie(SaveCookie save)
    {
        getCookieSet().remove(save);
    } // void removeSaveCookie(SaveCookie save)
    
} // public class ScoreDataObject extends MultiDataObject

