/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.examples.modules.minicomposer;

import java.io.*;
import java.util.*;

import javax.sound.sampled.*;

import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.compiler.*;
import org.openide.compiler.Compiler;
import org.openide.filesystems.*;

public class SampledAudioCompilerGroup extends CompilerGroup {
    private final Set compilers = new HashSet(); // Set<SampledAudioCompiler>
    public void add(Compiler c) {
        compilers.add((SampledAudioCompiler)c);
    }
    public boolean start() {
        boolean ok = true;
        Iterator it = compilers.iterator();
        while (it.hasNext()) {
            SampledAudioCompiler c = (SampledAudioCompiler)it.next();
            FileObject score = c.getScoreFile();
            FileObject au = FileUtil.findBrother(score, ScoreDataLoader.STANDARD_AU_EXT);
            try {
                if (au == null) {
                    au = score.getParent().createData(score.getName(), ScoreDataLoader.STANDARD_AU_EXT);
                }
            } catch (IOException ioe) {
                TopManager.getDefault().getErrorManager().notify(ErrorManager.INFORMATIONAL, ioe);
                fireErrorEvent(new ErrorEvent(this, score, 0, 0, ioe.toString(), ""));
                ok = false;
                continue;
            }
            try {
                InputStream is = score.getInputStream();
                try {
                    FileLock lock = au.lock();
                    try {
                        OutputStream os = au.getOutputStream(lock);
                        try {
                            fireProgressEvent(new ProgressEvent(this, au, ProgressEvent.TASK_WRITING));
                            LineInFromScore line = new LineInFromScore(Score.parse(new InputStreamReader(is)));
                            AudioInputStream ais = new LineInFromScore.ScoreAudioInputStream(line, ComposerSettings.getDefault().getSampleRate());
                            AudioSystem.write(ais, AudioFileFormat.Type.AU, os);
                        } finally {
                            os.close();
                        }
                    } finally {
                        lock.releaseLock();
                    }
                } finally {
                    is.close();
                }
            } catch (IOException ioe) {
                TopManager.getDefault().getErrorManager().notify(ErrorManager.INFORMATIONAL, ioe);
                fireErrorEvent(new ErrorEvent(this, au, 0, 0, ioe.toString(), ""));
                ok = false;
            }
        }
        return ok;
    }
}
