/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.examples.modules.minicomposer;

import java.io.IOException;

import org.openide.cookies.*;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.text.DataEditorSupport;
import org.openide.windows.CloneableOpenSupport;

public class ScoreEditorSupport extends DataEditorSupport implements EditorCookie, EditCookie, PrintCookie {
    public ScoreEditorSupport(ScoreDataObject obj) {
        super(obj, new ScoreEnv(obj));
    }
    protected boolean canClose() {
        ScoreOpenSupport sos = (ScoreOpenSupport)getDataObject().getCookie(ScoreOpenSupport.class);
        if (sos != null && sos.isOpen() && !getDataObject().isModified()) {
            sos.close();
            return true;
        } else {
            return superCanClose();
        }
    }
    // For access from ScoreOpenSupport:
    boolean superCanClose() {
        return super.canClose();
    }
    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        ScoreDataObject obj = (ScoreDataObject)getDataObject();
        if (obj.getCookie(SaveCookie.class) == null) {
            obj.addSaveCookie(new Save());
            obj.setModified(true);
        }
        return true;
    }
    protected void notifyUnmodified() {
        super.notifyUnmodified();
        ScoreDataObject obj = (ScoreDataObject)getDataObject();
        SaveCookie save = (SaveCookie)obj.getCookie(SaveCookie.class);
        if (save != null) {
            obj.removeSaveCookie(save);
            obj.setModified(false);
        }
    }
    private class Save implements SaveCookie {
        public void save() throws IOException {
            saveDocument();
            getDataObject().setModified(false);
        }
    }
    private static class ScoreEnv extends DataEditorSupport.Env {
        private static final long serialVersionUID = 85639662675875L;
        public ScoreEnv(ScoreDataObject obj) {
            super(obj);
        }
        protected FileObject getFile() {
            return getDataObject().getPrimaryFile();
        }
        protected FileLock takeLock() throws IOException {
            return ((ScoreDataObject)getDataObject()).getPrimaryEntry().takeLock();
        }
        public CloneableOpenSupport findCloneableOpenSupport() {
            return (ScoreEditorSupport)getDataObject().getCookie(ScoreEditorSupport.class);
        }
    }
}
