/*
 * GazoogleOpenSupport.java
 *
 * Created on Friday, 13 July 2001 1430 MDT
 */

package com.example.nb.tutorial.chapter_5;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import javax.swing.JOptionPane;

import org.openide.TopManager;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

/**
 *
 * @author  adams
 * @version 1.0
 */
public class GazoogleOpenSupport implements OpenCookie 
{

    /** Creates new GazoogleOpenSupport */
    public GazoogleOpenSupport() 
    {
    }

    /** Open the gazoogle file */
    public void open() 
    {
        // before doing anything, switch to our new Workspace:
        WindowManager wm = TopManager.getDefault().getWindowManager();
        Workspace tutorial = wm.findWorkspace("tutorial"); //NOI18N
        if (tutorial != null)
        {
            tutorial.activate();
        }
        
        // get the array of activated nodes, meaning the ones that are selected:
        Node nodeArray[] = TopManager.getDefault().getWindowManager().getRegistry().getActivatedNodes();
        for (int n=0; n<nodeArray.length; n++)
        {
            // the following method call is vital and, as far as I know,
            // undocumented even by NetBeans standards!  this call buys us
            // a way to get our hands on the primary file for the selected node:
            DataObject cookie = (DataObject)nodeArray[n].getCookie(DataObject.class);
            FileObject fo = cookie.getPrimaryFile();
            try
            {
                // get contents of the gazoogle:
                BufferedReader br = new BufferedReader(new InputStreamReader(fo.getInputStream()));
                String gazoogle = "";
                String nextLine = br.readLine();
                while (nextLine != null)
                {
                    gazoogle += nextLine + "\n";
                    nextLine = br.readLine();
                }
                JOptionPane.showMessageDialog(null, gazoogle, "Gazoogle", JOptionPane.INFORMATION_MESSAGE);
            } catch (Exception e) {
              JOptionPane.showMessageDialog(null, e.getMessage(), "Failure", JOptionPane.ERROR_MESSAGE);
            }
        }
    }
    
}

