/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microopenide.systems, Inc. All Rights Reserved.
 */

package org.netbeans.mymodules.newmenuitem;

import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.TopManager;

import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import java.io.IOException;

/** Simple action. Creates a subfolder and an empty file (NewSource.java) */
/** Missing Icon Resource*/

public class CreateFile extends CallableSystemAction {
   // generated
    private static final long serialVersionUID = 6105821673293585672L;

    public String getName () {
        return NbBundle.getBundle (CreateFile.class).getString ("LBL_CreateFile");
    }

    public HelpCtx getHelpCtx () {
        // In a real situation could map to installed JavaHelp...
        return HelpCtx.DEFAULT_HELP;
    }

    public void performAction () {        
        //This example creates a subfolder and then a new, empty file within that subfolder:         
        Repository repo = TopManager.getDefault().getRepository();
        FileObject folder=repo.find("org.netbeans.mymodules.newmenuitem", null, null);
        // from an existing file system
        try {
          FileObject subfolder=folder.createFolder("sub");
          FileObject newfile=subfolder.createData("NewSource", "java");
        } catch (IOException ioe) {
          ioe.printStackTrace ();
        }             
    }

    protected String iconResource()
    {
        return "/org/netbeans/mymodules/newmenuitem/images/icon.gif"; //NOI18N
    }
    
}
