package jp.turbosql.modules.sketcher.app;

import javax.swing.*;
import javax.swing.border.*;
import java.util.Random;
import java.awt.*;
import java.awt.event.*;
/*
 * Lottery.java
 *
 * Created on 2002/02/06, 17:36
 */

/**
 *
 * @author  root
 */
public class Lottery extends javax.swing.JApplet {

    final static int numberCount = 6;
    final static int minValue = 1;
    final static int maxValue = 49;
    static int[] values = new int[maxValue-minValue+1];
    static
    {
        for(int i = 0; i < values.length; i++)
            values[i] = i + minValue;
    }
    private Selection[] luckyNumbers = new Selection[numberCount];
    
    final public static int PICK_LUCKY_NUMBERS = 1;
    final public static int COLOR = 2;
    
    Color flipColor = new Color(Color.yellow.getRGB()^Color.red.getRGB());
    
    Color startColor = new Color(Color.yellow.getRGB());
    
    private static Random choice = new Random();
    
    private JButton pickButton = new JButton("Lucky Numbers!");
    private JButton colorButton = new JButton("Color");
    
    /** Creates a new instance of Lottery */
    public Lottery() {
    }

    public void init()
    {
        Container content = getContentPane();
        content.setLayout(new GridLayout(0, 1));
        
        JPanel buttonPane = new JPanel();
        
        buttonPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(Color.cyan, Color.blue), "ä"));
        int[] choices = getNumbers();
        
        MouseHandler mouseHandler = new MouseHandler();
        for(int i = 0; i < numberCount; i++)
        {
            luckyNumbers[i] = new Selection(choices[i]);
            luckyNumbers[i].addMouseListener(mouseHandler);
            buttonPane.add(luckyNumbers[i]);
        } // for(int i = 0; i < numberCount; i++)
        
        content.add(buttonPane);
        
        JPanel controlPane = new JPanel(new FlowLayout(FlowLayout.CENTER, 5, 10));
        
        /*
        JButton button;
        Dimension buttonSize = new Dimension(100, 20);
        
        controlPane.add(button = new JButton("Lucky Numbers!"));
        button.setBorder(BorderFactory.createRaisedBevelBorder());
        button.addActionListener(new HandleControlButton(PICK_LUCKY_NUMBERS));
        button.setPreferredSize(buttonSize);
        
        controlPane.add(button = new JButton("Color"));
        button.setBorder(BorderFactory.createRaisedBevelBorder());
        button.addActionListener(new HandleControlButton(COLOR));
        button.setPreferredSize(buttonSize);
        */
       
        Dimension buttonSize = new Dimension(100, 20);
        
        pickButton.setPreferredSize(buttonSize);
        pickButton.setBorder(BorderFactory.createRaisedBevelBorder());
        
        colorButton.setPreferredSize(buttonSize);
        colorButton.setBorder(BorderFactory.createRaisedBevelBorder());
        
        HandleControlButton controlHandler = new Lottery.HandleControlButton();
        
        //pickButton.addActionListener(controlHandler);
        //colorButton.addActionListener(controlHandler);
        
        pickButton.addActionListener(new ActionListener()
                                        {
                                            public void actionPerformed(ActionEvent e)
                                            {
                                                int[] numbers = getNumbers();
                                                for(int i = 0; i < numberCount; i++)
                                                    luckyNumbers[i].setValue(numbers[i]);
                                            } // public void actionPerformed(ActionEvent e)
                                        } // new ActionListener()
                                        );
        
        colorButton.addActionListener(new ActionListener()
                                        {
                                            public void actionPerformed(ActionEvent e)
                                            {
                                                Color color = new Color(flipColor.getRGB()^luckyNumbers[0].getBackground().getRGB());
                                                for(int i = 0; i < numberCount; i++)
                                                    luckyNumbers[i].setBackground(color);
                                            } // public void actionPerformed(ActionEvent e)
                                        } // new ActionListner()
                                        );
                                        
        controlPane.add(pickButton);
        controlPane.add(colorButton);
        
        content.add(controlPane);
    } // public void init()
    
    static int[] getNumbers()
    {
        int[] numbers = new int[numberCount];
        int candidate = 0;
        for(int i = 0; i < numberCount; i++)
        {
            search:
            for(;;)
            {
                candidate = values[choice.nextInt(values.length)];
                for(int j = 0; j < i ; j++)
                    if(candidate==numbers[j])
                        continue search;
                
                numbers[i] = candidate;
                break;
            } // for(;;)
        } // for(int i = 0; i < numberCount; i++)
        
        return numbers;
        
    } // static int[] getNumbers()
    
    class Selection extends JButton implements ActionListener
    {
        private int value;
        
        public Selection(int value)
        {
            super(Integer.toString(value));
            this.value = value;
            setBackground(startColor);
            setBorder(BorderFactory.createRaisedBevelBorder());
            setPreferredSize(new Dimension(80, 20));
            addActionListener(this);
        } // public Selection(int value)
        
        public void actionPerformed(ActionEvent e)
        {
            int candidate = 0;
            for(;;)
            {
                candidate = values[choice.nextInt(values.length)];
                if(isCurrentSelection(candidate))
                    continue;
                setValue(candidate);
                return;
            } // V
        } // public void actionPerformed(ActionEvent e)
        
        public void setValue(int value)
        {
            setText(Integer.toString(value));
            this.value = value;
        } // public void setValue(int value)
        
        boolean hasValue(int possible)
        {
            return value == possible;
        } // boolean hasValue(int possible)
        
        boolean isCurrentSelection(int possible)
        {
            for(int i = 0; i < numberCount; i++)
                if(luckyNumbers[i].hasValue(possible))
                    return true;
            return false;
        } // boolean isCurrentSelection(int possible)
    } // class Selection extends JButton implments ActionListener
    
    /*   
    class HandleControlButton implements ActionListener
    {
        private int buttonID;
        
        public HandleControlButton(int buttonID)
        {
            this.buttonID = buttonID;
        } // public HandleControlButton(int buttonID)
        
        public void actionPerformed(ActionEvent e)
        {
            switch(buttonID)
            {
                case PICK_LUCKY_NUMBERS:
                    int[] numbers = getNumbers();
                    for(int i = 0; i < numberCount; i++)
                        luckyNumbers[i].setValue(numbers[i]);
                    break;
                case COLOR:
                    Color color = new Color(flipColor.getRGB()^luckyNumbers[0].getBackground().getRGB());
                    for(int i = 0; i < numberCount; i++)
                        luckyNumbers[i].setBackground(color);
                    break;
            } // switch(buttonID)
        } // public void actionPerformed(ActionEvent e)
    } // class HandlerControlButton implments ActionListner
    */
    
    class HandleControlButton implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            Object source = e.getSource();
             
            if(source == pickButton)
            {
                int[] numbers = getNumbers();
                for(int i = 0; i < numberCount; i++)
                    luckyNumbers[i].setValue(numbers[i]);
            } // if(source == pickButtom)
            else if(source == colorButton)
            {
                Color color = new Color(flipColor.getRGB()^luckyNumbers[0].getBackground().getRGB());
                for(int i = 0; i < numberCount; i++)
                    luckyNumbers[i].setBackground(color);
            } // else if(source == colorButton)
        } // public void actionPerformed(ActionEvent e)
    } // class HandleControlButton implements ActionListner
    
    class MouseHandler extends MouseAdapter
    {
        Cursor handCursor = new Cursor(Cursor.HAND_CURSOR);
        Cursor defaultCursor = new Cursor(Cursor.DEFAULT_CURSOR);
        
        public void mouseEntered(MouseEvent e)
        {
            e.getComponent().setCursor(handCursor);
        } // public void mouseEntered(MouseEvent e)
        
        public void mouseExited(MouseEvent e)
        {
            e.getComponent().setCursor(defaultCursor);
        } // public void mouseExited(MouseEvent e)
        
    } // class MouseHandler extends MouseAdapter
} // public class Lottery extends javax.swing.JApplet {
