package jp.turbosql.modules.sketcher.app;

import javax.swing.*;
import java.util.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.event.*;

class SketchView extends JComponent implements Observer, Constants, ActionListener
{
    private Sketcher theApp;
    
    private Element highlightElement;
    
    private JPopupMenu elementPopup = new JPopupMenu("Element");
    private JMenuItem moveItem, deleteItem, rotateItem, sendToBackItem;
    
    private int mode = NORMAL;    
    private Element selectedElement;
    
    public SketchView(Sketcher theApp)
    {
        this.theApp = theApp;
        MouseHandler handler = new MouseHandler();
        addMouseListener(handler);
        addMouseMotionListener(handler);
        
        moveItem = elementPopup.add("Move");
        deleteItem = elementPopup.add("Delete");
        rotateItem = elementPopup.add("Rotate");
        sendToBackItem = elementPopup.add("Send-to-back");
        
        moveItem.addActionListener(this);
        deleteItem.addActionListener(this);
        rotateItem.addActionListener(this);
        sendToBackItem.addActionListener(this);
    } // public SketchView(Sketcher theApp)
    
    public void paint(Graphics g)
    {
        Graphics2D g2D = (Graphics2D) g;
        Iterator elements = theApp.getModel().getIterator();
        Element element;
        
        while(elements.hasNext())
        {
            element = (Element) elements.next();
            //g2D.setPaint(element.getColor());
            //g2D.draw(element.getShape());
            element.draw(g2D);
        } // while(elements.hasNext())
    } //public void paint(Graphics g)
    
    public void update(java.util.Observable observable, Object rectangle) {
        if(rectangle == null)
            repaint();
        else
            repaint((Rectangle) rectangle);
    } // public void update(java.util.Observable observable, Object obj) {
     
    class MouseHandler extends MouseInputAdapter
    {
        private Point start;
        private Point last;
        private Element tempElement;
        private Graphics2D g2D;
        
        public void mousePressed(MouseEvent e)
        {
            start = e.getPoint();
            int modifier = e.getModifiers();
            
            if((modifier & e.BUTTON1_MASK) != 0)
            {
                g2D = (Graphics2D) getGraphics();
                g2D.setXORMode(getBackground());
                g2D.setPaint(theApp.getWindow().getElementColor());
            } // if((modifier & e.BUTTON1_MASK) != 0)
        } // public void mousePressed(MouseEvent e)
        
        public void mouseDragged(MouseEvent e)
        {
            last = e.getPoint();
            int modifier = e.getModifiers();
            
            if((modifier & e.BUTTON1_MASK) != 0 && (theApp.getWindow().getElementType() != TEXT) && (mode == NORMAL))
            {
                if(tempElement == null)
                    tempElement = createElement(start, last);
                else
                {
                    //g2D.draw(tempElement.getShape());
                    tempElement.draw(g2D);
                    tempElement.modify(start, last);
                } // else
                //g2D.draw(tempElement.getShape());
                tempElement.draw(g2D);
            } // if((modifier & e.BUTTON1_MASK) != 0)
            else if(mode == MOVE && selectedElement != null)
            {
                selectedElement.draw(g2D);
                selectedElement.move(last.x - start.x, last.y - start.y);
                selectedElement.draw(g2D);
                start = last;
            } // else if(mode == MOVE && selectedElement != null)
            else if(mode == ROTATE && selectedElement != null)
            {
                selectedElement.draw(g2D);
                selectedElement.rotate(getAngle(selectedElement.getPosition(), start, last));
                
                selectedElement.draw(g2D);
                start = last;
            } // else if(mode == ROTATE && selectedElement != null)
        } // public void mouseDragged(MouseEvent e)
        
        public void mouseReleased(MouseEvent e)
        {
            int modifier = e.getModifiers();
            
            /*
            if(e.isPopupTrigger())
            {
                start = e.getPoint();
                theApp.getWindow().getPopup().show((Component) e.getSource(), start.x, start.y);
                
                start = null;
            } // if(e.isPopupTrigger())
            */
            if((modifier & e.BUTTON3_MASK) != 0)
            {
                start = e.getPoint();
                
                if(highlightElement == null)
                    theApp.getWindow().getPopup().show((Component) e.getSource(), start.x, start.y);
                else
                    elementPopup.show((Component) e.getSource(), start.x, start.y);
                
                start = null;
            } // if(e.isPopupTrigger())    
            else if((modifier & e.BUTTON1_MASK) != 0 && (theApp.getWindow().getElementType() != TEXT) && (mode == NORMAL))
            {
                if(tempElement != null)
                {
                    theApp.getModel().add(tempElement);
                    tempElement = null;
                } // if(tempElement != null)                              
            } // if((modifier & e.BUTTON1_MASK) != 0)
            else if(mode == MOVE || mode == ROTATE)
            {
                if(selectedElement != null)
                    repaint();
                mode = NORMAL;
            } // else if(mode == MOVE || mode == ROTATE)
                
            if(g2D != null)
            {
                g2D.dispose();
                g2D = null;
            } // if(g2D != null)
            start = last = null;
            selectedElement = tempElement = null;
        } // public void mouseReleased(MouseEvent e)
        
        public void mouseClicked(MouseEvent e)
        {
            int modifier = e.getModifiers();
            if((modifier & e.BUTTON1_MASK) != 0 && (theApp.getWindow().getElementType() == TEXT))
            {
                start = e.getPoint();
                String text = JOptionPane.showInputDialog((Component) e.getSource(), "Enter Text:", "Dialog for Text Element", JOptionPane.PLAIN_MESSAGE);
                if(text != null)
                {
                    g2D = (Graphics2D)getGraphics();
                    Font font = theApp.getWindow().getCurrentFont();
                    
                    tempElement = new Element.Text(font, text, start, theApp.getWindow().getElementColor(), font.getStringBounds(text, g2D.getFontRenderContext()).getBounds());
                    
                    if(tempElement != null)
                        theApp.getModel().add(tempElement);
                    tempElement = null;
                    g2D.dispose();
                    g2D = null;
                    start = null;
                } // if(text != null)
            } // if((modifier & e.BUTTON1_MASK) != 0 && (theApp.getWindow().getElementType() == TEXT))
        } // public void mouseClicked(MouseEvent e)
        
        public void mouseMoved(MouseEvent e)
        {
            Point currentCursor = e.getPoint();
            Iterator elements = theApp.getModel().getIterator();
            Element element;
            
            while(elements.hasNext())
            {
                element = (Element) elements.next();
                if(element.getBounds().contains(currentCursor))
                {
                    if(element==highlightElement)
                        return;
                    g2D = (Graphics2D)getGraphics();
                    if(highlightElement != null)
                    {
                        highlightElement.setHighlighted(false);
                        highlightElement.draw(g2D);
                    } // if(highlightElement != null)
                    element.setHighlighted(true);
                    highlightElement = element;
                    element.draw(g2D);
                    g2D.dispose();
                    g2D = null;
                    return;
                } // if(element.getBounds().contains(currentCursor))
            } // while(elements.hasNext())
            
            if(highlightElement != null)
            {
                g2D = (Graphics2D)getGraphics();
                highlightElement.setHighlighted(false);
                highlightElement.draw(g2D);
                highlightElement = null;
                g2D.dispose();
                g2D = null;
            } // if(highlightElement != null)
        } // public void mouseMoved(MouseEvent e)
        
        double getAngle(Point position, Point start, Point last)
        {
            double perp = Line2D.ptLineDist(position.x, position.y, last.x, last.y, start.x, start.y);
            
            double hypotenuse = position.distance(start);
            if(hypotenuse == 0.0)
                hypotenuse = 1.0;
            
            return -Line2D.relativeCCW(position.x, position.y, start.x, start.y, last.x, last.y) * Math.asin(perp/hypotenuse);
            
        } // double getAngle(Point position, Point start, Point last)
        
    } // class MouseHandler extends MouseInputAdapter
     
    private Element createElement(Point start, Point end)
    {
        switch(theApp.getWindow().getElementType())
        {
            case LINE:
                return new Element.Line(start, end, theApp.getWindow().getElementColor());
            case RECTANGLE:
                return new Element.Rectangle(start, end, theApp.getWindow().getElementColor());
            case CIRCLE:
                return new Element.Circle(start, end, theApp.getWindow().getElementColor());
            case CURVE:
                return new Element.Curve(start, end, theApp.getWindow().getElementColor());
        } // switch(theApp.getWindow().getElementType())
        return null;
    }
    
    public void actionPerformed(java.awt.event.ActionEvent e) {
        Object source = e.getSource();
        if(source == moveItem)
        {
            mode = MOVE;
            selectedElement = highlightElement;
        } // if(source == moveItem)
        else if(source == deleteItem)
        {
            if(highlightElement != null)
            {
                theApp.getModel().remove(highlightElement);
                highlightElement = null;
            } // if(highlightElement != null)
        } // else if(source == deleteItem)
        else if(source == rotateItem)
        {
            mode = ROTATE;
            selectedElement = highlightElement;
        } // else if(source == rotateItem)
        else if(source == sendToBackItem)
        {
            if(highlightElement != null)
            {
                theApp.getModel().remove(highlightElement);
                theApp.getModel().add(highlightElement);
                highlightElement.setHighlighted(false);
                highlightElement = null;
                repaint();
            } // if(highlightElement != null)
        } // else if(source == sendToBackItem)
    }
    
 // private Element createElement(Point start, Point end)
} // class SketchView extends JComponent implements Observer
