package jp.turbosql.modules.sketcher.app;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import org.openide.windows.TopComponent;

public class Sketcher extends TopComponent
{
    private static SketchFrame2 window;
    private static Sketcher theApp;
    private static SketchModel sketch;
    private static SketchView view;
    
    public static void main(String[] args)
    {
        theApp = new Sketcher();
        theApp.init();
    } // public static void main(String[] args)
    
    //DatabaseBrowse frame;
    public Sketcher()
    {
        init();
        /*
        frame = new DatabaseBrowse();
	frame.setVisible(true); //necessary as of kestrel
        add(frame);
        try {
            frame.setSelected(true);
        } catch (java.beans.PropertyVetoException e) {}
         */
    } // public DemoWindow()
    
    public void init()
    {
        window = new SketchFrame2("Sketcher", this);
        Toolkit theKit = window.getToolkit();
        Dimension wndSize = theKit.getScreenSize();
        
        add(window);
        
        window.setBounds(wndSize.width/6, wndSize.height/6, 2*wndSize.width/3, 2*wndSize.height/3);
        
        //window.addWindowListener(new WindowHandler());
        
        sketch = new SketchModel();
        view = new SketchView(this);
        sketch.addObserver((Observer)view);
        window.getContentPane().add(view, BorderLayout.CENTER);
        
        window.setVisible(true);
        
        sketch.addObserver((Observer)window);
    } // public void init()
    
    public SketchFrame2 getWindow()
    {
        return window;
    } // public SketchFrame getWindow()
    
    public SketchModel getModel()
    {
        return sketch;
    } // public SketchModel getModel()
    
    public SketchView getView()
    {
        return view;
    } // public SketchView getView()
    
    public void insertModel(SketchModel newSketch)
    {
        sketch = newSketch;
        sketch.addObserver((Observer) view);
        sketch.addObserver((Observer) window);
        view.repaint();
    } // public void insertModel(SketchModel newSketch)
    
    class WindowHandler extends WindowAdapter
    {
        public void windowClosing(WindowEvent e)
        {
            window.checkForSave();
            window.dispose();                       // Release the window resources
            System.exit(0);                         // End the application
        } // public void windowClosing(WindowEvent e)
    } // class WindowHandler extends WindowAdapter
} // public class Sketcher


