/*
 * ExplorerAction.java
 *
 * Created on 12 July 2001 1517 MDT
 */

package jp.turbosql.modules.sketcher.ide;

import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

import jp.turbosql.modules.sketcher.app.*;

/**
 *
 * @author  adams
 * @version 1.0
 */
public class ExplorerAction extends CallableSystemAction
{

    /** Creates new ExplorerAction */
    public ExplorerAction() {
    }

    public String getName() 
    {
        return "Pop Explorer Now!"; //NOI18N
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource()
    {
        return "/jp/turbosql/modules/sketcher/ide/explore16.gif"; //NOI18N
    }
    
    /**
     * This method will do nothing more than pop an explorer
     * for now.  more to come later!
     */
    public void performAction () 
    {
        // almost always need one of these:
        TopManager tm = TopManager.getDefault();

        // switch to the tutorial workspace 
        // before popping the explorer:
        WindowManager wm = tm.getWindowManager();
        Workspace tutorial = wm.findWorkspace("tutorial"); //NOI18N
        if (tutorial != null)
        {
            tutorial.activate();
        }
        
        // get a node to explore (see OpenAPI javadocs), then call
        // convenience method in TopManager.NodeOperation to explore:
        //Node nodeToExplore = tm.getPlaces().nodes().repository();
        //tm.getNodeOperation().explore(nodeToExplore);
        
        //DemoWindow dWin = new DemoWindow();
        Sketcher dWin = new Sketcher();
        dWin.open();
    }
}

