/*
 * GazoogleDuplicateSupport.java
 *
 * Created on Friday, 13 July 2001 1430 MDT
 */

package jp.turbosql.modules.sketcher.ide;

import java.io.IOException;
import javax.swing.JOptionPane;

import org.openide.TopManager;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

/**
 *
 * @author  adams
 * @version 1.0
 */
public class GazoogleDuplicateSupport implements DuplicateCookie 
{

    /** Creates new GazoogleOpenSupport */
    public GazoogleDuplicateSupport() 
    {
    }

    /** Invokes the duplicate action  */
    public void duplicate() 
    {
        // get the array of activated nodes, meaning the ones that are selected:
        Node nodeArray[] = TopManager.getDefault().getWindowManager().getRegistry().getActivatedNodes();
        for (int n=0; n<nodeArray.length; n++)
        {
            // the following method call is vital and, as far as I know,
            // undocumented even by NetBeans standards!  this call buys us
            // a way to get our hands on the primary file for the selected node:
            DataObject cookie = (DataObject)nodeArray[n].getCookie(DataObject.class);
            FileObject fo = cookie.getPrimaryFile();
            String dupeFileName = fo.getName() + "Copy";
            try
            {
                // conveniently, NetBeans OpenAPI has a copy() method:
                fo.copy(fo.getParent(), dupeFileName, fo.getExt());
            }
            catch (IOException ioe)
            {
              JOptionPane.showMessageDialog(null, ioe.getMessage(), "Failure", JOptionPane.ERROR_MESSAGE);
            }
        }
    }
}