package module1;

import java.awt.Image;
import java.beans.*;

import org.openide.TopManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/** Description of {@link MyDataLoader}.
 *
 * @author root
 */
public class MyDataLoaderBeanInfo extends SimpleBeanInfo {
    
    // If you have additional properties:
    /*
    public PropertyDescriptor[] getPropertyDescriptors () {
        try {
            PropertyDescriptor myProp = new PropertyDescriptor ("myProp", MyDataLoader.class);
            myProp.setDisplayName (NbBundle.getMessage (MyDataLoaderBeanInfo.class, "PROP_myProp"));
            myProp.setShortDescription (NbBundle.getMessage (MyDataLoaderBeanInfo.class, "HINT_myProp"));
            return new PropertyDescriptor[] { myProp };
        } catch (IntrospectionException ie) {
            TopManager.getDefault ().getErrorManager ().notify (ie);
            return null;
        }
    }
     */
    
    public BeanInfo[] getAdditionalBeanInfo() {
        try {
            // I.e. MultiFileLoader.class or UniFileLoader.class.
            return new BeanInfo[] { Introspector.getBeanInfo(MyDataLoader.class.getSuperclass()) };
        } catch (IntrospectionException ie) {
            TopManager.getDefault().getErrorManager().notify(ie);
            return null;
        }
    }
    
    public Image getIcon(int type) {
        if (type == BeanInfo.ICON_COLOR_16x16 || type == BeanInfo.ICON_MONO_16x16) {
            return Utilities.loadImage("__PACKAGE_NAME_SLASHES$DataLoaderBeanInfo$DataIcon$MyIcon__.gif");
        } else {
            return Utilities.loadImage("__PACKAGE_NAME_SLASHES$DataLoaderBeanInfo$DataIcon32$MyIcon32__.gif");
        }
    }
    
}
