package jp.turbosql.modules.at.app;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import javax.swing.border.*;
import javax.swing.text.html.*;
import java.io.*;
import java.util.*;

//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

import jp.turbosql.modules.at.app.ui.*;
import jp.turbosql.modules.at.app.tomcat4.*;

public class TomcatPanel extends JPanel implements ActionListener, TreeSelectionListener
{
    private ClassLoader urlClassLoader;         // for getting images
    
    // for controling the server
    private JButton startButton;
    private JButton stopButton;
    private JButton restartButton;
    //private JButton refreshButton;
    private JButton saveButton;
    
    private JTextArea status = new JTextArea(3, 30);
    
    private JTree atTree;                                   // Tree to display the metadata
    private JScrollPane treePane;                           // Scroll pane holding the tree
    
    JScrollPane infoPane;                                  // Scroll pane holding the table
    JEditorPane editorPane;                                 // editor pane for diplaying html
    
    private JScrollPane statusPane;                         // Scroll pane holding the status
    
    private boolean isATTreeLoaded = false;          // indicate whether the tree is loaded
    private boolean isDataModified = false;         // to indicate whether we should save or not.
    
    private DefaultMutableTreeNode serverNode;                  // Root node for the database tree
    private DefaultTreeModel atTreeModel;                   // Model for the database metadata
    
    private ServerXMLObject xmlObject;                  // xml object
    
    private JPopupMenu defaultPanelPopup = new JPopupMenu("General");       // default menu
    
    private RefreshAction refreshListener;      // used to refresh the tree
    
    //private JTree oldATTree;               // a reference to the oldTree, used for refreshing.
       
    public TomcatPanel()
    {
        urlClassLoader = this.getClass().getClassLoader();
        
        refreshListener = new RefreshAction();
        
        xmlObject = new ServerXMLObject(refreshListener);
        
        setLayout(new BorderLayout());
        
        // Create the North Section ------------------------------------------
        startButton = new JButton(new ImageIcon(urlClassLoader.getResource("jp/turbosql/modules/at/app/images/media/Play16.gif")));
        startButton.setText("Start server");
        startButton.setToolTipText("Start server");
        startButton.addActionListener(new AbstractAction(){
            public void actionPerformed(ActionEvent e)
            {
                if(startServer() != 0)
                    status.setText("Failed to start server.");
                else
                    status.setText("Server started.");
            } // public void actionPerformed(ActionEvent e)
        });
        stopButton = new JButton(new ImageIcon(urlClassLoader.getResource("jp/turbosql/modules/at/app/images/general/Stop16.gif")));
        stopButton.setText("Stop server");
        stopButton.addActionListener(new AbstractAction(){
            public void actionPerformed(ActionEvent e)
            {
                if(stopServer() != 0)
                    status.setText("Failed to stop server.");
                else
                    status.setText("Server stopped.");
            } // public void actionPerformed(ActionEvent e)
        });
        stopButton.setToolTipText("Stop server");
        restartButton = new JButton(new ImageIcon(urlClassLoader.getResource("jp/turbosql/modules/at/app/images/media/StepForward16.gif")));
        restartButton.setText("Restart server");
        restartButton.setToolTipText("Restart server");
        restartButton.addActionListener(new AbstractAction(){
            public void actionPerformed(ActionEvent e)
            {
                if(restartServer() != 0)
                    status.setText("Failed to restart server.");
                else
                    status.setText("Server restarted.");
            } // public void actionPerformed(ActionEvent e)
        });
        //refreshButton = new JButton(new ImageIcon(urlClassLoader.getResource("jp/turbosql/modules/at/app/images/general/Refresh16.gif")));
        //refreshButton.setText("Refresh from file");
        //refreshButton.setToolTipText("Refresh server");
        saveButton = new JButton(new ImageIcon(urlClassLoader.getResource("jp/turbosql/modules/at/app/images/general/Save16.gif")));
        saveButton.setText("Save changes");
        saveButton.setToolTipText("Save changes");
        saveButton.addActionListener(new AbstractAction(){
            public void actionPerformed(ActionEvent e)
            {
                if(savingSequence() != 0)
                    status.setText("Failed to save changes.");
                else
                    status.setText("changes saved.");
            } // public void actionPerformed(ActionEvent e)
        });
                
        Box controlPane = Box.createHorizontalBox();
        controlPane.add(startButton);
        controlPane.add(stopButton);
        controlPane.add(restartButton);
        //controlPane.add(refreshButton);
        controlPane.add(saveButton);
        saveButton.setEnabled(false);
        
        Box northPane = Box.createVerticalBox();
        northPane.add(controlPane);
        
        add(northPane, BorderLayout.NORTH);
        
        //--------------------------------------------------------------------
        // create the south pane---------------------------------------------
        // Add message area
        status.setText("");
        status.setEditable(false);              // No user input
        status.setLineWrap(true);               // Lines wrap
        status.setWrapStyleWord(true);          // on word boundaries
        status.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
        statusPane = new JScrollPane(status);
        statusPane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        //getContentPane().add(statusPane, BorderLayout.SOUTH); // for frame
        add(statusPane, BorderLayout.SOUTH);
        //--------------------------------------------------------------------
        
        //--------------------------------------------------------------------
        // create the center pane---------------------------------------------
        // Create tree to go in left split pane
        
        serverNode = xmlObject.getRootNode();
                
        atTreeModel = new DefaultTreeModel(serverNode);     // take the serverNode after it has been created
        atTree = new JTree(atTreeModel);
        //atTree.setRootVisible(false);
        //model.setRoot();
        if(serverNode != null)
            isATTreeLoaded = true;      // if we get this far, the tree should already be loaded.
        else
        {
            isATTreeLoaded = true;
            status.setText("Error loading server.xml");
        } // else
        treePane = new JScrollPane(atTree);
        treePane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        treePane.setPreferredSize(new Dimension(400, 100));
        
        // Create table to go in right split pane
        
        String tempFileName;
        if(Locale.getDefault().getLanguage().equals("ja"))
            tempFileName = "atwelcome_ja.html";
        else
            tempFileName = "atwelcome.html";
        String fileContentsStr = getContentsStringFromFile("jp/turbosql/modules/at/app/html/" + tempFileName, Locale.getDefault().getLanguage());
        
        editorPane = new JEditorPane();
        editorPane.addHyperlinkListener(new HyperlinkHandler());
        editorPane.setEditorKit(new HTMLEditorKit());
        editorPane.setEditable(false);
        
        editorPane.setText(fileContentsStr);
        
        infoPane = new JScrollPane(editorPane);
        infoPane.setPreferredSize(new Dimension(500, 100));
        infoPane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        //infoPane.add(editorPane);
        //infoPane.setVisible(true);
        //infoPane.setLayout(new ScrollPaneLayout());
        //editorPane.setPreferredSize(new Dimension(500, 100));
        //editorPane.setVisible(true);
        //editorPane.set
        
        JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
                                              true,                     // Continuous relayout
                                              treePane,                 // Left pane content
                                              infoPane);               // Right pane content
        add(splitPane, BorderLayout.CENTER);
        splitPane.setDividerLocation(400);                              // Left pane 150 pixels wide
        
        defaultPanelPopup.add(new GenericAction("No action"));
        
        // Add event listeners
        atTree.addTreeSelectionListener(this);
                
        atTree.addMouseListener(new TreeMouseHandler());
        atTree.addTreeSelectionListener(new TreeSelectionHandler());
        
        GenericMouseHandler mouseHandler = new GenericMouseHandler();
        editorPane.addMouseListener(mouseHandler);
        status.addMouseListener(mouseHandler);
               
        setVisible(true);                       // Set window visible
        //--------------------------------------------------------------------
    } // public TomcatPanel()
    
    public void actionPerformed(ActionEvent e)
    {
        
    } // public void actionPerformed(ActionEvent e)
    
    public void valueChanged(TreeSelectionEvent e)
    {
        
    } // public void valueChanged(TreeSelectionEvent e)
    
    // Build the JTree to be displayed graphically
     // public void processNode(Node node)
    
     // public static String getTypeName(int type)
    
    public String getContentsStringFromFile(String url, String language) {
        BufferedReader buffReader;
        String fileContentsStr = "";
        String thisLine;
        try {
            if(language.equals("ja")) {
                buffReader = new BufferedReader(new InputStreamReader(urlClassLoader.getResource(url).openStream(), "JISAutoDetect"));
            } // if(language.equals("ja"))
            else
                buffReader = new BufferedReader(new InputStreamReader(urlClassLoader.getResource(url).openStream()));
            if(buffReader.ready()) {
                while((thisLine = buffReader.readLine()) != null) {
                    fileContentsStr = fileContentsStr + thisLine + "\n";
                } // while((thisLine = buffReader.readLine()) != null)
            } // if(buffReader.read())
        } // try
        catch(IOException ioe) {
            ;
        } // catch(IOException ioe)
        return fileContentsStr;
    }
    
    public void treeDoubleClick(int row, TreePath path) {
        ;
    }
    
    /*
    public void treePopupTrigger(int row, Component comp, int x, int y) {
        int[] selectedRows = atTree.getSelectionRows();
        boolean rowSelected = false;
        JPopupMenu popup = new JPopupMenu();
        //--------------------------------------------------------------------
        // select current row only if it has not been selected
        if(row != -1) {
            
            if((selectedRows != null)) {
                //System.out.println("some rows selected");
                for(int i = 0; i < selectedRows.length; i++)
                    if(selectedRows[i] == row) {
                        rowSelected = true;
                        //System.out.println("Already selected row: " + row);
                    } // if(selectedRows[i] == row)
                if(!rowSelected) {
                    atTree.setSelectionRow(row);
                    //System.out.println("Selected row: " + row);
                } // if(!rowSelected)
                //----------------------------------------------------------------
                // process all selected rows
            } // if((selectedRows != null))
            else
                atTree.setSelectionRow(row);
            
            if(isHomogeneousNodeSelection(atTree.getSelectionPaths())) {
                TreePath treePath = atTree.getPathForRow(row);
                Object userObject = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                NodeObject nodeObject;
                if(userObject instanceof String)
                    defaultPanelPopup.show(comp, x, y);
                else {
                    String[] actionList;
                    
                    nodeObject = (NodeObject) userObject;
                    actionList = xmlObject.getPopupMenuNodeActionList(nodeObject);
                    for(int i = 0; i < actionList.length; i++)
                        popup.add(new GenericAction(actionList[i]));
                    
                    popup.show(comp, x, y);
                } // else
                //----------------------------------------------------------------
            } // if(isHomogeneous(dbTree.getSelectionPaths()))
            else
                defaultPanelPopup.show(comp, x, y);             // maybe changed to accomodate selection among multiple node types
        } // if(row != -1)
        else
            defaultPanelPopup.show(comp, x, y);
        //System.out.println("Pop!");
    }
     */
    
    public void treePopupTrigger(int row, Component comp, int x, int y)
    {
        int[] selectedRows = atTree.getSelectionRows();
        boolean rowSelected = false;
        JPopupMenu popup = new JPopupMenu();
        //--------------------------------------------------------------------
        // select current row only if it has not been selected
        if(row != -1)
        {
            
            if((selectedRows != null))
            {
                //System.out.println("some rows selected");
                for(int i = 0; i < selectedRows.length; i++)
                    if(selectedRows[i] == row)
                    {
                        rowSelected = true;
                        //System.out.println("Already selected row: " + row);
                    } // if(selectedRows[i] == row)
                if(!rowSelected)
                {
                    atTree.setSelectionRow(row);
                    //System.out.println("Selected row: " + row);
                } // if(!rowSelected)
                //----------------------------------------------------------------
                // process all selected rows
            } // if((selectedRows != null))
            else
                atTree.setSelectionRow(row);
            
            int[] newSelectedRows = atTree.getSelectionRows();
            
            if(newSelectedRows.length == 1)     // only one row selected
            {
                TreePath treePath = atTree.getPathForRow(row);
                Object userObject = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                NodeObject nodeObject;
                if(userObject instanceof String)
                    defaultPanelPopup.show(comp, x, y);
                else
                {
                    String[] actionList;
                
                    nodeObject = (NodeObject) userObject;
                    actionList = xmlObject.getPopupMenuNodeActionList(nodeObject);
                    for(int i = 0; i < actionList.length; i++)
                    {
                        if(actionList[i].equals("JSeparator"))
                            popup.add(new JSeparator());
                        else
                            popup.add(new GenericAction(actionList[i]));                        
                    } // for(int i = 0; i < actionList.length; i++)
                    
                    popup.show(comp, x, y);                        
                } // else                
                //----------------------------------------------------------------
            } // if(newSelectedRows.length == 1)
            else
            {
                if(isHomogeneousNodeSelection(atTree.getSelectionPaths()))
                {
                    TreePath treePath = atTree.getPathForRow(row);
                    Object userObject = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                    NodeObject nodeObject;
                    if(userObject instanceof String)
                        defaultPanelPopup.show(comp, x, y);
                    else
                    {
                        String[] actionList;
                
                        nodeObject = (NodeObject) userObject;
                        actionList = xmlObject.getPopupMenuMultipleNodeActionList(nodeObject);
                        for(int i = 0; i < actionList.length; i++)
                        {
                            if(actionList[i].equals("JSeparator"))
                                popup.add(new JSeparator());
                            else
                                popup.add(new GenericAction(actionList[i]));                        
                        } // for(int i = 0; i < actionList.length; i++)
                    
                        popup.show(comp, x, y);                        
                    } // else                
                //----------------------------------------------------------------
                } // if(isHomogeneous(dbTree.getSelectionPaths()))
                else
                    defaultPanelPopup.show(comp, x, y);             // maybe changed to accomodate selection among multiple node types
            } // else            
        } // if(row != -1)
        else 
            defaultPanelPopup.show(comp, x, y);
    } // public void treePopupTrigger(int row, TreePath path)
    
    public void treeSingleClick(int row, TreePath path)
    {
        ;
    } // public void treeSingleClick(int row, TreePath path)
    
    public void treeSingleSelect(int row, TreePath path)
    {
        //System.out.println("treeSingleSelect");
        //System.out.println(Locale.getDefault().getLanguage());
        // "<HTML><H1><FONT color=\"ff0000\">Test! </FONT></H1><A href=\"http://www.ximnet.com\">link</A></HTML>"
        //editorPane.setText("<HTML><IMG SRC=\""+ urlClassLoader.getResource("jp/turbosql/modules/db/app/images/viewnode.gif") +"\"></IMG><H1><FONT color=ff0000>Test! </FONT></H1><A href=\"http://www.ximnet.com\">link</A>졪</HTML>");
        //System.out.println(urlClassLoader.getResource("jp/turbosql/modules/db/app/images/viewnode.gif"));
        //editorPane.setText("<HTML><H1><FONT color=\"ff0000\">Test! </FONT></H1><A href=\"http://www.ximnet.com\">link</A></HTML>");
        
        String htmlStr = xmlObject.getNodePropertyInHTML(this, atTree);
        
        if(htmlStr != null)
            editorPane.setText(htmlStr);
        
    } // public void treeSingleSelect(int row, TreePath path)
    
    public void refreshEditorPane()
    {
        String htmlStr = xmlObject.getNodePropertyInHTML(this, atTree);
        
        if(htmlStr != null)
            editorPane.setText(htmlStr);
    } // public void refreshEditorPane()
    
    public boolean isHomogeneousNodeSelection(TreePath[] treePaths)
    {
        boolean isHomogeneous = true;
        //Object[] userObjects = new Objects[treePath.length];
        Object firstObject = ((DefaultMutableTreeNode) treePaths[0].getLastPathComponent()).getUserObject().getClass();
        for(int i = 1; i < treePaths.length; i++)
            if(!(firstObject.equals(((DefaultMutableTreeNode) treePaths[i].getLastPathComponent()).getUserObject().getClass())))
                isHomogeneous = false;
        //for(int i = 0; i < treePaths.length; i++)
        //System.out.println(((DefaultMutableTreeNode) treePaths[i].getLastPathComponent()).getUserObject().getClass());
        return isHomogeneous;
    } // public boolean isHomogeneousNodeSelection(TreePath[] treePaths)
    
    public int saveChanges()
    {
        return xmlObject.writeToFile();
    } // public void saveChanges()
    
    public int savingSequence()
    {
        if(isDataModified)
        {
            if(saveChanges() == 0)
            {
                if(JOptionPane.showConfirmDialog(this, "Restart server?", "msg",JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION)
                    restartServer();
                isDataModified = false;
             saveButton.setEnabled(false);
                return 0;
            } // if(xmlObject.writeToFile() == 0)
            else
                return 1;
        } // if(isDataModified)
        else
            return 0;
    } // public boolean savingSequence()
    
    public int startServer()
    {
        return executeCommand("service tomcat4 start");
    } // public boolean startServer()
    
    public int stopServer()
    {
        return executeCommand("service tomcat4 stop");
    } // public boolean stopServer()
    
    public int restartServer()
    {
        return executeCommand("service tomcat4 restart");        
    } // public boolean restartServer()
    
    public boolean isServerRunning()
    {
        return true;
    } // public boolean isServerRunning()
    
    public int executeCommand(String commandSTR)
    {
        int exitValue = 0;
        
        try
        {
            //String [] cmd = {"cmd.exe","/c","dir"} ;
            Process m ;
            String S = "" ;

            m = Runtime.getRuntime().exec(commandSTR) ;
            m.waitFor();

            //BufferedReader in = new BufferedReader(new InputStreamReader(m.getInputStream()));

            //while((S=in.readLine()) != null)
            //{
            //    System.out.println(S) ;
            //}
            //System.out.println("exit code: " + m.exitValue());
            exitValue = m.exitValue();
        }
        catch(Exception ex)
        {
            ex.printStackTrace () ;
        }
        
        return exitValue;
    } // public int executeCommand(String commandSTR)
    
    public int exitApplication()
    {
        if(isDataModified)
        {
            int option = JOptionPane.showConfirmDialog(this, "Save Changes?", "msg",JOptionPane.YES_NO_CANCEL_OPTION);
            if(option == JOptionPane.YES_OPTION)
                return savingSequence();
            else if(option == JOptionPane.CANCEL_OPTION)
                return -1;      // abort exit
            else
                return 0;
        } // if(isDataModified)
        else
                return 0;
    }
    
    public int getParentRowToExpand(TreePath treePath) {
        //(DefaultMutableTreeNode)treePath.getLastPathComponent();
        TreePath parentPath = treePath.getParentPath();
        if(parentPath == null)          // if there is no parent, we don't need to expand this path
            return -1;
        // we need to compare the entire path
        //Object parentUserObject = ((DefaultMutableTreeNode) parentPath.getLastPathComponent()).getUserObject();
        int parentRow = -1;         // -1 means currently not visible
        
        //TreePath[] visibleTreePaths = new TreePath[dbTree.getRowCount()];
        
        //System.out.println("Row Count: " + dbTree.getRowCount());
        //System.out.println("parentUserObject: " + parentUserObject);
        
        for(int i = 0; i < atTree.getRowCount(); i++) {
            //System.out.println("visibleDBUserObject: " + ((DefaultMutableTreeNode) dbTree.getPathForRow(i).getLastPathComponent()).getUserObject());
            // Note: We only compare the strings of the Object, if they are the same, we will treat it as the row to expand
            //if(parentUserObject.toString().equals(((DefaultMutableTreeNode) dbTree.getPathForRow(i).getLastPathComponent()).getUserObject().toString()))
            // we need to compare the entire path
            if(parentPath.toString().equals(atTree.getPathForRow(i).toString())) {
                //System.out.println("parentPath: " + parentPath.toString());
                //System.out.println("dbTree.getPathForRow("+ i + "): " + dbTree.getPathForRow(i).toString());
                //System.out.print("Row to expand: " + i);
                parentRow = i;
                break;
            } // if(parentUserObject.equals(((DefaultMutableTreeNode) dbTree.getPathForRow(i).getLastPathComponent()).getUserObject()))
        } // for(int i = 0; i < visibleTreePaths.length; i++)
        
        return parentRow;
    }
    
 // public int exitApplication()
//---------------------------------------------------------------------------
// Inner Classes for database actions
    class GenericAction extends AbstractAction
    {
        String name;
        String actionType;
        
        public GenericAction(String name, String actionType)
        {  
            super(name);
            this.name = name;
            this.actionType = actionType;
        } // public DatabaseAction(String name)
        
        public GenericAction(String name)
        {
            this(name, null);
        } // public GenericAction(String name)
        
        public String getName()
        {
            return name;
        } // public String getName()

        public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
            //if(actionType == null)
            //    System.out.println("No action or null action");
            xmlObject.performAction((Component) actionEvent.getSource(), name, atTree, refreshListener);
            // short-cut, just refresh after every action.
            //refreshConnection();
        }
        
    } // class GenericAction extends AbstractAction
    
    
    class RefreshAction extends AbstractAction
    {
        public void actionPerformed(java.awt.event.ActionEvent actionEvent)
        {
            //oldATTree = atTree.setModel();
            //----------------------------------------------------------------
            TreePath[] visibleTreePaths = new TreePath[atTree.getRowCount()];
            TreePath firstSelectedTreePath = atTree.getSelectionPath();     // we keep track of the previously selected path
        
            for(int i = 0; i < visibleTreePaths.length; i++)
            {
                visibleTreePaths[i] = atTree.getPathForRow(i);
            } // for(int i = 0; i < visibleTreePaths.length; i++)
            //----------------------------------------------------------------
            
            xmlObject.refreshInMemoryTree();
            atTreeModel.setRoot(xmlObject.getRootNode());
            //System.out.println(actionEvent.getActionCommand());
            
            //----------------------------------------------------------------
            for(int i = 0; i < visibleTreePaths.length; i++)
            {
                //dbTree.expandPath(visibleTreePaths[i]);
                //System.out.println(visibleTreePaths[i].toString());
                //dbTree.makeVisible(visibleTreePaths[i]);
                int row = getParentRowToExpand(visibleTreePaths[i]);
                     
                // might cause dead lock??
                if(row != -1)
                {
                    if(!atTree.isExpanded(row))
                        atTree.expandRow(row);
                    // Not all the rows will be expanded if the rows do not expand fast enough.
                    // to be fixed later 06/12/2002
                    //System.out.println("Row to expand: " + row);
                    //System.out.println("Row expanded: " + dbTree.isExpanded(row));
                    /*
                    while(!dbTree.isExpanded(row))
                    {
                        //dbTree.expandRow(row);
                        dbTree.expandRow(row);
                    } // while(!dbTree.isExpanded(row))
                    */
                } // if(row != -1)
            } // for(int i = 0; i < visibleTreePaths.length; i++)
            //----------------------------------------------------------------
            
            atTree.setSelectionPath(firstSelectedTreePath);     // we reset the selected path
            refreshEditorPane();        // we refresh the HTML showed in the editorPane
            
            if(!isDataModified)
            {
                if(actionEvent.getActionCommand().equals("data modified"))
                {
                    status.setText("Please save your changes.");
                    isDataModified = true;
                    saveButton.setEnabled(true);
                } // if(actionEvent.getActionCommand().equals("data modified")
            } // if(!isDataModified)
        } // public void actionPerformed(java.awt.event.ActionEvent actionEvent)        
    } // class RefreshAction extends AbstractAction
    
    /*
    class SaveAction extends AbstractAction
    {
        public void actionPerformed(java.awt.event.ActionEvent actionEvent)
        {
            
        } // public void actionPerformed(java.awt.event.ActionEvent actionEvent)        
    } // class SaveAction extends AbstractAction
     */
//---------------------------------------------------------------------------
    
    class TreeSelectionHandler implements TreeSelectionListener
    {
        
        public void valueChanged(TreeSelectionEvent e)
        {
            int[] selRows = atTree.getSelectionRows();
            
            if(isATTreeLoaded)
            {
                if(selRows != null)
                {
                    if(selRows.length == 1)                 // only one row is selected
                    {
                        treeSingleSelect(selRows[0], atTree.getSelectionPath());
                        //System.out.println("List Selected");
                    } // if(selRows.length == 1)
                    else
                        editorPane.setText("");               // clear the infoPane
                        //infoPane.removeAll();               // clear the editorPane
                } // if(selRows != null)
            } // if(isDBTreeLoaded)
        } // public void valueChanged(TreeSelectionEvent e)
        
    } // class TreeSelectionHandler implements TreeSelectionListener
    
    class HyperlinkHandler implements HyperlinkListener
    {
        /*        
        public HyperlinkHandler()
        {
            webBrowser = new BrowserLauncher();
        } // public HyperlinkHandler()
         */
        
        public void hyperlinkUpdate(HyperlinkEvent e)
        {
            if(e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED))
            {
                //System.out.println(e.getURL().getProtocol());
                // Do nothing if we don't know the protocol
                if(e.getURL() == null)
                    return;
                if(e.getURL().getProtocol().equals("http"))
                {
                    try
                    {
                        BrowserLauncher.openURL(e.getURL().toString());
                    } // try
                    catch(IOException ioe)
                    {
                        ;
                    } // catch(IOException ioe)
                } // if(e.getURL().getProtocol().equals("http"))
            } // if(e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED))
            
        } // public void hyperlinkUpdate(HyperlinkEvent e)
        
    } // // class HyperlinkHandler implements HyperlinkListener
    
    class TreeMouseHandler extends MouseAdapter
    {
        
        private Point start;
        
        public void mousePressed(MouseEvent e) {
            int selRow = atTree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = atTree.getPathForLocation(e.getX(), e.getY());
            if(e.isPopupTrigger())
                //if((modifier & e.BUTTON3_MASK) != 0)
            {
                start = e.getPoint();
                //theApp.getWindow().getPopup().show((Component) e.getSource(), start.x, start.y);
                treePopupTrigger(selRow, (Component) e.getSource(), start.x, start.y);
                
                start = null;
            } // if(e.isPopupTrigger())
            else if(selRow != -1) {
                if(e.getClickCount() == 1) {
                    treeSingleClick(selRow, selPath);
                }
                else if(e.getClickCount() == 2) {
                    treeDoubleClick(selRow, selPath);
                }
            }
            /*
            if(selRow != -1)
            {
                treeSelect(selRow, selPath);
            } // if(selRow != -1)
             */
        }
        
        public void mouseReleased(MouseEvent e) {
            int modifier = e.getModifiers();
            
            if(e.isPopupTrigger())
                //if((modifier & e.BUTTON3_MASK) != 0)
            {
                start = e.getPoint();
                int selRow = atTree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = atTree.getPathForLocation(e.getX(), e.getY());
                //theApp.getWindow().getPopup().show((Component) e.getSource(), start.x, start.y);
                treePopupTrigger(selRow, (Component) e.getSource(), start.x, start.y);
                
                start = null;
            } // if(e.isPopupTrigger())
        }
        
    } // class TreeMouseHandler extends MouseAdapter
    
    class GenericMouseHandler extends MouseAdapter
    {
        public void mousePressed(MouseEvent e)
        {
            if(e.isPopupTrigger())
                popupTrigger((Component) e.getSource(), e.getX(), e.getY());
        } // public void mousePressed(MouseEvent e)
        
        public void mouseReleased(MouseEvent e)
        {
            if(e.isPopupTrigger())
                popupTrigger((Component) e.getSource(), e.getX(), e.getY());
        } // public void mouseReleased(MouseEvent e)
        
        public void popupTrigger(Component comp, int x, int y)
        {
            defaultPanelPopup.show(comp, x, y);
        } // public void popupTrigger()
    } // class GenericMouseHandler extends MouseAdapter

} // public class TomcatPanel extends JPanel