package jp.turbosql.modules.at.app.dialogs;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.accessibility.*;
import java.util.*;

//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

import jp.turbosql.modules.at.app.*;

public class AttributeRemovePane extends JComponent implements Accessible
{
    JDialog dialog;
    String attrName = "";
    String attrValue = "";
    JPanel tabbedPanel1;
    JPanel contentPanel;
    JPanel buttonPanel;
    //JLabel attrNameLabel;
    //JTextField attrNameField;
    //JLabel attrValueLabel;
    //JTextField attrValueField;
    Vector propertyCheckBoxVector;
    Vector propertyLabelVector;
    
    JButton okButton;
    JButton cancelButton;
    
    ActionListener refreshListener;
    
    ElementNodeObject elementNodeObject;
    Node nodeObject;
    NamedNodeMap namedNodeMap;
    
    int adjustedHeight = 0;
    
    public AttributeRemovePane(ElementNodeObject elementNodeObject, ActionListener refreshListener)
    {
        this.elementNodeObject = elementNodeObject;
        this.refreshListener = refreshListener;
        this.nodeObject = (Node) elementNodeObject.getUserObject();
        propertyCheckBoxVector = new Vector();
        propertyLabelVector = new Vector();
    } // public DatabaseAddPane()
        
    public JDialog createDialog(Component parentComponent, String title)
    {
        dialog = new JDialog((JFrame)parentComponent, true);
        Container contentPane;
        tabbedPanel1 = new JPanel();
                             
        //okButton = new JButton("Ok");
        JTabbedPane tabbedPane = new JTabbedPane();
        
        namedNodeMap = nodeObject.getAttributes();
        int attrCount = namedNodeMap.getLength();
        
        int extraHeight = 21 * attrCount;
        extraHeight += adjustedHeight;
        
        okButton = new JButton(new AbstractAction("Ok"){
            public void actionPerformed(ActionEvent e)
            {                
                //System.out.println("namedNodeMap.getLength(): " + namedNodeMap.getLength());
                int attrCount = namedNodeMap.getLength();
                for(int i = 0; i < attrCount; i++)
                {
                    //System.out.println("Checked");
                    if(((JCheckBox) (propertyCheckBoxVector.get(i))).isSelected())
                    {
                        String errorMSG = elementNodeObject.removeAttr(((JLabel) propertyLabelVector.get(i)).getText());
                        //System.out.println("Removed");
                
                        if(errorMSG == null)
                            return;
                        if(!errorMSG.equals(""))
                        {
                            JOptionPane.showMessageDialog(dialog, "Error: " + errorMSG);
                        } // if(!errorMSG.equals(""))
                        //else                            // we finish it if there is no errorMSG
                        //{
                            
                        //} // else
                    } //if(((JCheckBox) (propertyCheckBoxVector.get(i))).isSelected())
                    
                } // for(int i = 0; i < attrCount; i++)
                            
                if(refreshListener != null)
                                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
                dialog.dispose();
            } // public void actionPerformed(ActionEvent e)
        });
        
        cancelButton = new JButton(new AbstractAction("Cancel"){
            public void actionPerformed(ActionEvent e)
            {
                dialog.dispose();
            } // public void actionPerformed(ActionEvent e)
        });
        
        dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
               
        NamedNodeMap namedNodeMap = nodeObject.getAttributes();
               
        buttonPanel = new JPanel();
        contentPanel = new JPanel(new GridLayout(attrCount + 1, 2));        // + 1 for the title
        
        contentPanel.add(new JLabel("Attribute", JLabel.CENTER));
        contentPanel.add(new JLabel("REMOVE ?", JLabel.CENTER));
        
        for(int i = 0; i < attrCount; i++)
        {
            JLabel attrLabel = new JLabel(namedNodeMap.item(i).getNodeName());
            JCheckBox attrRemoveCheckBox = new JCheckBox();
            //attrRemoveCheckBox.setBackground(Color.white);
            attrLabel.setFont(new Font("Default", Font.PLAIN, 12));
            attrRemoveCheckBox.setHorizontalAlignment(JCheckBox.CENTER);
            
            propertyLabelVector.add(attrLabel);
            propertyCheckBoxVector.add(attrRemoveCheckBox);
            contentPanel.add(attrLabel);
            contentPanel.add(attrRemoveCheckBox);
            
        } // for(int i = 0; i < attrCount; i++)
        
        /*
        attrNameLabel = new JLabel("Attribute Name: ");
        attrNameField = new JTextField();
                
        attrValueLabel = new JLabel("Attribute Value: ");
        attrValueField = new JTextField();
        
        contentPanel.add(attrNameLabel);
        contentPanel.add(attrNameField);
        contentPanel.add(attrValueLabel);
        contentPanel.add(attrValueField);
        */
        
        
        tabbedPane.setBounds(0, 0, 100, 100 + extraHeight);
        contentPanel.setPreferredSize(new Dimension(100, 100 + extraHeight));
        
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        
        contentPane = dialog.getContentPane();
        
        tabbedPanel1.setLayout(new BorderLayout());
        
        tabbedPanel1.add(contentPanel, BorderLayout.CENTER);
        tabbedPanel1.add(buttonPanel, BorderLayout.SOUTH);
                
        tabbedPane.addTab("Remove Attribute", null, tabbedPanel1, "Remove Attribute");
        tabbedPane.setSelectedIndex(0);
        
        contentPane.add(tabbedPane);
        
        dialog.setBounds(0, 0, 300, 140 + extraHeight);
        
        return dialog;
    } // public JDialog createDialog(Component parentComponent, String title)
    
    public static void main(String args[])
    {
        JFrame jFrame = new JFrame("test");
        jFrame.setBounds(0, 0, 100, 100);
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

        AttributeAddPane pane = new AttributeAddPane(null, null);
        JDialog jDialog = pane.createDialog(jFrame, "test dialog");
        //dialog.setVisible(true);
        jDialog.show();
    } // public static void main(String args[])
} // public class AttributeRemovePane extends JComponent implements Accessible


