package jp.turbosql.modules.at.app.dialogs;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.accessibility.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

// depreciated, we will use GenericPropertyPane directly.
public class WithTextPropertyPane extends GenericPropertyPane
{
    String originalTextValue = "";
    JTextField textValueField;
    Document doc;
    Node originalTextNode;
       
    public WithTextPropertyPane(Node nodeObject, Document doc, ActionListener refreshListener, Node originalTextNode)
    {
        this(nodeObject, doc, refreshListener, "Properties", originalTextNode);
    } // public GenericPropertyPane(Node nodeObject, ActionListener refreshListener)
    
    public WithTextPropertyPane(Node nodeObject, Document doc, ActionListener refreshListener, String tabTitle, Node originalTextNode)
    {
        super(nodeObject, doc, true, refreshListener, tabTitle, originalTextNode);
        this.doc = doc;
        this.originalTextNode = originalTextNode;
    } // public WithTextPropertyPane(Node nodeObject, ActionListener refreshListener)
    
    // only one text value allowed.
    // can only be called once
    public void addTextValue(String textValue)
    {
        this.originalTextValue = textValue;
        
        JPanel horizontalPanel = new JPanel(new GridLayout(1, 2));
        JLabel propertyLabel = new JLabel("VALUE");
        textValueField = new JTextField(textValue);
        
        textValueField.setPreferredSize(new Dimension(120, 21));
        
        horizontalPanel.add(propertyLabel);
        horizontalPanel.add(textValueField);
        
        adjustedHeight += 21;
        
        verticalBox.add(horizontalPanel);
    } // public void addTextValue(String textValue)
    
    public JDialog createDialog(Component parentComponent, String title) {
        int width = 360, height = 100;
        dialog = new JDialog((JFrame)parentComponent, true);
        Container contentPane = dialog.getContentPane();
        dialog.setTitle(title);
        
        int extraHeight = 21 * propertyLabelVector.size();
        extraHeight += adjustedHeight;
        
        //contentPanel.setBounds(new Rectangle(new Dimension(width, height + extraHeight)));
        okButton.addActionListener(new AbstractAction("Ok"){
            public void actionPerformed(ActionEvent e) {
                //PostgreSQLDataObject.createDatabase(serverIP, serverPort, username, password, dbName, dbEncoding, null, null);
                /*
                String errorMSG = PostgreSQLDataObject.createDatabase(serverIP, serverPort, username, password, dbNameField.getText(), (String) dbEncodingComboBox.getSelectedItem(), false, null);   // has to be false
                 
                if(errorMSG == null)
                    return;
                if(!errorMSG.equals(""))
                {
                    JOptionPane.showMessageDialog(dialog, "Error: " + errorMSG);
                } // if(!errorMSG.equals(""))
                else                            // we finish it if there is no errorMSG
                {
                    if(refreshListener != null)
                        refreshListener.actionPerformed(null);
                    dialog.dispose();
                } // else
                 */
                
                /*
                if(isPropertiesChanged()) {
                    if(nodeObject != null) {
                        int count = propertyLabelVector.size();
                        NamedNodeMap namedNodeMap = nodeObject.getAttributes();
                        for(int i = 0; i < count; i++) {
                            //propertyValueComponentVector.get(i);
                            Node tempNode;
                            
                            if(namedNodeMap != null) {
                                tempNode = namedNodeMap.getNamedItem(((JLabel) propertyLabelVector.get(i)).getText());
                                if(tempNode != null) {
                                    tempNode.setNodeValue(getPropertyValueForPropertyName(((JLabel) propertyLabelVector.get(i)).getText()));
                                } // if(tempNode != 0)                                
                            } // if(namedNodeMap != null)
                        } // for(int i = 0; i < count; i++)
                                                               
                        if(!textValueField.getText().equals(originalTextValue))
                        {
                            if(originalTextNode != null)
                                nodeObject.replaceChild(doc.createTextNode(textValueField.getText()), originalTextNode);
                            else
                                nodeObject.appendChild(doc.createTextNode(textValueField.getText()));
                        } // if(!textValueField.getText().equals(originalTextValue))
                        
                        if(refreshListener != null)
                            refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
                    } // if(nodeObject != null)
                } // if(isPropertiesChanged())
                */
                //else
                //    System.out.println("Not changed");
                
                if(performOKAction() == 0)
                {                    
                    if(!textValueField.getText().equals(originalTextValue))
                    {
                        if(originalTextNode != null)
                            nodeObject.replaceChild(doc.createTextNode(textValueField.getText()), originalTextNode);
                        else
                            nodeObject.appendChild(doc.createTextNode(textValueField.getText()));
                    } // if(!textValueField.getText().equals(originalTextValue))
                    if(refreshListener != null)
                        refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
                } // if(performOKAction() == 0)
                
                dialog.dispose();
            } // public void actionPerformed(ActionEvent e)
        });
        
        contentPane.add(contentPanel);
        cancelButton.addActionListener(new AbstractAction("Cancel"){
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            } // public void actionPerformed(ActionEvent e)
        });
        dialog.setBounds(new Rectangle(new Dimension(width, height + extraHeight)));
        
        return dialog;
    }
    
    public boolean isPropertiesChanged() {
        int count = propertyLabelVector.size();
        boolean hasChanged = false;
        
        for(int i = 0; i < count; i++) {
            String originalPropertyValue = (String) originalPropertyValueVector.get(i);
            Object propertyValueComponent = propertyValueComponentVector.get(i);
            if(propertyValueComponent instanceof JComboBox) {
                if(!((String) ((JComboBox) propertyValueComponent).getSelectedItem()).equals(originalPropertyValue)) {
                    hasChanged = true;
                    break;
                } // if(!((String) ((JComboBox) propertyValueComponent).getSelectedItem()).equals(originalPropertyValue))
            } // if(propertyValueComponent instanceof JComboBox)
            else        // it is a JTextField
            {
                if(!((JTextField) propertyValueComponent).getText().equals(originalPropertyValue)) {
                    hasChanged = true;
                    break;
                } // if(!((JTextField) propertyValueComponent).getText().equals(originalPropertyValue))
            } // else
        } // for(int i = 0; i < count; i++)
        
        if(!textValueField.getText().equals(originalTextValue))
            hasChanged = true;
        
        return hasChanged;
    }
    
} // public WithTextPropertyPane extends GenericPropertyPane


