package jp.turbosql.modules.at.app.tomcat4;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

import jp.turbosql.modules.at.app.*;
import jp.turbosql.modules.at.app.dialogs.*;
import jp.turbosql.modules.at.app.wizards.*;

public class AliasElementNodeObject extends ElementNodeObject
{
    protected String nodeActionList_deleteAliasAction = "Delete Alias";
    protected String[] nodeActionList = {nodeActionList_addAttributesAction, nodeActionList_removeAttributesAction, nodeActionList_viewAttributesAction, nodeActionList_deleteAliasAction};
    protected String multipleNodeActionList_viewAttributesAction = "Do nothing";
    protected String[] multipleNodeActionList = {multipleNodeActionList_viewAttributesAction};
    
    protected String[] allAttr = {};                         // holds all the attributes
    protected boolean[] requiredAttr = {};                    // required attributes
    protected String[] attrDefaultValue = {};                    // attributes values
    
    protected boolean hasTextElement = true;
    
    public AliasElementNodeObject(String objectName, Object userObject)
    {
        super(objectName, userObject);
                
        super.nodeActionList = nodeActionList;
        super.multipleNodeActionList = multipleNodeActionList;
        
        super.allAttr = allAttr;
        super.requiredAttr = requiredAttr;
        super.attrDefaultValue = attrDefaultValue;
        super.hasTextElement = hasTextElement;
    } // public AliasElementNodeObject()
    
    public AliasElementNodeObject(String objectName)     // overloaded constructor
    {
        this(objectName, null);
    } // public AliasElementNodeObject()
    
    public AliasElementNodeObject()
    {
        this(null, null);
    } // public AliasElementNodeObject()
    
    // Only Handle the one we want to
    public void performSingleNodeAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        if(actionName.equals(nodeActionList_deleteAliasAction))
        {
            String message = "Delete Alias Element?";
             
            performDeleteElementAction(message, parentComponent, actionName, jTree, refreshListener);
            //System.out.println("add Host");
        } // if(actionName.equals(nodeActionList_addHostAction))
        else if(actionName.equals(nodeActionList_addAttributesAction) || actionName.equals(nodeActionList_removeAttributesAction) || actionName.equals(nodeActionList_viewAttributesAction)) // we delegate to the ihe parent class
            super.performSingleNodeAction(parentComponent, actionName, jTree, refreshListener);
        else
            super.performSingleNodeAction(parentComponent, actionName, jTree, refreshListener);
    } // public void performSingleNodeAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
} // public class AliasElementNodeObject extends ElementNodeObject