package jp.turbosql.modules.at.app.tomcat4;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------
import jp.turbosql.modules.at.app.wizards.*;

// the GenericWizardlet provides alot of methods we can use directly
public class ContextElementWizardlet extends GenericWizardlet
{
    protected String[] allAttr = {"className", "cookies", "crossContext", "docBase", "override", "path", "privileged", "reloadable", "useNaming", "wrapperClass", "debug", "workDir"};                         // holds all the attributes
    protected boolean[] requiredAttr = {false, false, false, true, false, true, false, false, false, false, false, false};                    // required attributes
    protected String[] attrDefaultValue = {"", "", "", "", "", "", "", "", "", "", "", ""};                    // attributes values
    protected boolean[] hasComboBoxValues = {false, false, true, false, true, false, true, true, true, false, false, false};
    protected String[][] comboBoxValues = {null, null, {"", "false", "true"}, null, null, null, {"", "false", "true"}, {"", "false", "true"}, {"", "false", "true"}, null, null, null};
    protected boolean[] useFileChooser = {false, false, false, true, false, true, false, false, false, false, false, true};
    protected boolean[] chooseOnlyDirectories = {false, false, false, true, false, true, false, false, false, false, false, true};
    
    public ContextElementWizardlet(Document doc)
    {
        super();
        super.allAttr = allAttr;
        super.requiredAttr = requiredAttr;
        super.attrDefaultValue = attrDefaultValue;
        super.hasComboBoxValues = hasComboBoxValues;
        super.comboBoxValues = comboBoxValues;
        super.useFileChooser = useFileChooser;
        super.chooseOnlyDirectories = chooseOnlyDirectories;
        this.doc = doc;
        doAllAttrProcessing();
    } // public ContextElementWizardlet(Document)
    
    public Object createUserObject()
    {
        Node contextElementNode = doc.createElement("Context");
        NamedNodeMap namedNodeMap = contextElementNode.getAttributes();
        
        //getPropertyValueForPropertyName(String propertyName)
        for(int i = 0; i < allAttr.length; i++)
        {
            String attrValue = getPropertyValueForPropertyName(allAttr[i]);
            
            if(!attrValue.equals(""))
            {
                Node attr = doc.createAttribute(allAttr[i]);
                attr.setNodeValue(attrValue);
                namedNodeMap.setNamedItem(attr);
            } // if(!attrValue.equals(""))
        } // for(int i = 0; i < allAttr.length; i++)
        
        userObject = contextElementNode;
        return userObject;
    } // public Object createUserObject()
    
    public String getStepName()
    {
        return "Enter Context Attributes";
    } // public String getStepName()
} // public class ContextElementWizardlet extends Wizardlet