package jp.turbosql.modules.at.app.tomcat4;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

import jp.turbosql.modules.at.app.*;
import jp.turbosql.modules.at.app.dialogs.*;
import jp.turbosql.modules.at.app.wizards.*;

public class HostElementNodeObject extends ElementNodeObject
{
    //protected Node hostElementNode;
    
    protected String nodeActionList_AddAliasAction = "Add Alias", nodeActionList_AddContextAction = "Add Context", nodeActionList_AddValveAction = "Add Valve", nodeActionList_AddLoggerAction = "Add Logger", nodeActionList_deleteHostAction = "Delete Host";
    protected String[] nodeActionList = {nodeActionList_addAttributesAction, nodeActionList_removeAttributesAction, nodeActionList_viewAttributesAction, "JSeparator", nodeActionList_AddAliasAction, nodeActionList_AddContextAction, nodeActionList_AddValveAction, nodeActionList_AddLoggerAction, nodeActionList_deleteHostAction};
    protected String multipleNodeActionList_viewAttributesAction = "Do nothing";
    protected String[] multipleNodeActionList = {multipleNodeActionList_viewAttributesAction};
    
    protected String[] allAttr = {"appBase", "className", "name", "debug", "unpackWARs"};                         // holds all the attributes
    protected boolean[] requiredAttr = {true, false, true, false, false};                    // required attributes
    protected String[] attrDefaultValue = {"", "", "", "", ""};                    // attributes values
    
    protected boolean hasTextElement = false;
    
    public HostElementNodeObject(String objectName, Object userObject)
    {
        super(objectName, userObject);
                
        super.nodeActionList = nodeActionList;
        super.multipleNodeActionList = multipleNodeActionList;
        
        super.allAttr = allAttr;
        super.requiredAttr = requiredAttr;
        super.attrDefaultValue = attrDefaultValue;
        super.hasTextElement = hasTextElement;
        //this.hostElementNode = (Node) userObject;
    } // public HostElementNodeObject()
    
    public HostElementNodeObject(String objectName)     // overloaded constructor
    {
        this(objectName, null);
    } // public HostElementNodeObject()
    
    public HostElementNodeObject()
    {
        this(null, null);
    } // public HostElementNodeObject()
    
    // Only Handle the one we want to
    public void performSingleNodeAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        if(actionName.equals(nodeActionList_deleteHostAction))
        {
            String message = "Delete Host Element?";
             
            performDeleteElementAction(message, parentComponent, actionName, jTree, refreshListener);
            //System.out.println("add Host");
        } // if(actionName.equals(nodeActionList_addHostAction))
        else if(actionName.equals(nodeActionList_AddAliasAction))
        {
            performAddAliasAction(parentComponent, actionName, jTree, refreshListener);
        } // else if(actionName.equals(nodeActionList_deleteAliasAction))
        else if(actionName.equals(nodeActionList_AddContextAction))
        {
            performAddContextAction(parentComponent, actionName, jTree, refreshListener);
        } // else if(actionName.equals(nodeActionList_deleteContextAction))        
        else if(actionName.equals(nodeActionList_AddValveAction))
        {
            performAddValveAction(parentComponent, actionName, jTree, refreshListener);
        } // else if(actionName.equals(nodeActionList_AddValveAction))
        else if(actionName.equals(nodeActionList_AddLoggerAction))
        {
            performAddLoggerAction(parentComponent, actionName, jTree, refreshListener);
        } // else if(actionName.equals(nodeActionList_AddLoggerAction))
        else if(actionName.equals(nodeActionList_addAttributesAction) || actionName.equals(nodeActionList_removeAttributesAction) || actionName.equals(nodeActionList_viewAttributesAction)) // we delegate to the ihe parent class
            super.performSingleNodeAction(parentComponent, actionName, jTree, refreshListener);
        else
            super.performSingleNodeAction(parentComponent, actionName, jTree, refreshListener);
    } // public void performSingleNodeAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
    protected void performAddAliasAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        AliasElementWizardlet aliasElementWizardlet = new AliasElementWizardlet(doc);
        Wizardlet[] wizardlets = {aliasElementWizardlet};
        WizardControllerPane wizardControllerPane = new WizardControllerPane(wizardlets);
        JDialog dialog = wizardControllerPane.createDialog(parentComponent, "Wizard");
        //System.out.println(wizardControllerPane.getNormalFinish());
        dialog.show();
        
        //System.out.println(wizardControllerPane.getNormalFinish());
        if(wizardControllerPane.getNormalFinish())
        {                      
            Node aliasElementNode = (Node) aliasElementWizardlet.createUserObject();
            
            nodeObject.appendChild(aliasElementNode);
            
            if(refreshListener != null)
                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
        } // if(wizardControllerPane.getNormalFinish())
    } // protected void performAddAliasAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
    protected void performAddValveAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        ValveElementWizardlet valveElementWizardlet = new ValveElementWizardlet("org.apache.catalina.valves.AccessLogValve", doc);
        Wizardlet[] wizardlets = {valveElementWizardlet};
        WizardControllerPane wizardControllerPane = new WizardControllerPane(wizardlets);
        JDialog dialog = wizardControllerPane.createDialog(parentComponent, "Wizard");
        //System.out.println(wizardControllerPane.getNormalFinish());
        dialog.show();
        
        //System.out.println(wizardControllerPane.getNormalFinish());
        if(wizardControllerPane.getNormalFinish())
        {                      
            Node valveElementNode = (Node) valveElementWizardlet.createUserObject();
            
            nodeObject.appendChild(valveElementNode);
            
            if(refreshListener != null)
                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
        } // if(wizardControllerPane.getNormalFinish())
    } // protected void performAddValveAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
    protected void performAddLoggerAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        LoggerElementWizardlet loggerElementWizardlet = new LoggerElementWizardlet("org.apache.catalina.logger.FileLogger", doc);
        Wizardlet[] wizardlets = {loggerElementWizardlet};
        WizardControllerPane wizardControllerPane = new WizardControllerPane(wizardlets);
        JDialog dialog = wizardControllerPane.createDialog(parentComponent, "Wizard");
        //System.out.println(wizardControllerPane.getNormalFinish());
        dialog.show();
        
        //System.out.println(wizardControllerPane.getNormalFinish());
        if(wizardControllerPane.getNormalFinish())
        {                      
            Node loggerElementNode = (Node) loggerElementWizardlet.createUserObject();
            
            nodeObject.appendChild(loggerElementNode);
            
            if(refreshListener != null)
                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
        } // if(wizardControllerPane.getNormalFinish())
    } // protected void performAddLoggerAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
    protected void performAddContextAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        ContextElementWizardlet contextElementWizardlet = new ContextElementWizardlet(doc);
        Wizardlet[] wizardlets = {contextElementWizardlet};
        WizardControllerPane wizardControllerPane = new WizardControllerPane(wizardlets);
        JDialog dialog = wizardControllerPane.createDialog(parentComponent, "Wizard");
        //System.out.println(wizardControllerPane.getNormalFinish());
        dialog.show();
        
        //System.out.println(wizardControllerPane.getNormalFinish());
        if(wizardControllerPane.getNormalFinish())
        {                      
            Node contextElementNode = (Node) contextElementWizardlet.createUserObject();
            
            nodeObject.appendChild(contextElementNode);
            
            if(refreshListener != null)
                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
        } // if(wizardControllerPane.getNormalFinish())
    } // protected void performAddContextAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
    /*
    protected void performDeleteHostAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        String message = "Delete Host Element?";
        
        if(JOptionPane.showConfirmDialog(parentComponent, message, "msg", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION)
        {
            Node parentNode = hostElementNode.getParentNode();
            parentNode.removeChild(hostElementNode);
            
            if(refreshListener != null)
                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
        } // if(JOptionPane.showConfirmDialog(parentComponent, message, "msg", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION)
        
    } // protected void performDeleteHostAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
     */
    
    public Wizardlet getWizardlet()
    {
        return null;
    } // public Wizardlet getWizardlet()
       
} // public class HostElementNodeObject extends ElementNodeObject