package jp.turbosql.modules.at.app.tomcat4;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------
import jp.turbosql.modules.at.app.wizards.*;

// the GenericWizardlet provides alot of methods we can use directly
public class HostElementWizardlet extends GenericWizardlet
{
    protected String[] allAttr = {"appBase", "className", "name", "debug", "unpackWARs"};                         // holds all the attributes
    protected boolean[] requiredAttr = {true, false, true, false, false};                    // required attributes
    protected String[] attrDefaultValue = {"", "", "", "", ""};
    protected boolean[] hasComboBoxValues = {false, false, false, false, true};
    protected String[][] comboBoxValues = {null, null, null, null, {"true", "false"}/*unpackWARs*/};
    protected boolean[] useFileChooser = {true, false, false, false, false};
    protected boolean[] chooseOnlyDirectories = {true, false, false, false, false};
    
    public HostElementWizardlet(Document doc)
    {
        super();
        super.allAttr = allAttr;
        super.requiredAttr = requiredAttr;
        super.attrDefaultValue = attrDefaultValue;
        super.hasComboBoxValues = hasComboBoxValues;
        super.comboBoxValues = comboBoxValues;
        super.useFileChooser = useFileChooser;
        super.chooseOnlyDirectories = chooseOnlyDirectories;
        this.doc = doc;
        doAllAttrProcessing();
    } // public HostElementWizardlet(Document)
    
    public Object createUserObject()
    {
        Node hostElementNode = doc.createElement("Host");
        NamedNodeMap namedNodeMap = hostElementNode.getAttributes();
        
        //getPropertyValueForPropertyName(String propertyName)
        for(int i = 0; i < allAttr.length; i++)
        {
            String attrValue = getPropertyValueForPropertyName(allAttr[i]);
            
            if(!attrValue.equals(""))
            {
                Node attr = doc.createAttribute(allAttr[i]);
                attr.setNodeValue(attrValue);
                namedNodeMap.setNamedItem(attr);
            } // if(!attrValue.equals(""))
        } // for(int i = 0; i < allAttr.length; i++)
        
        userObject = hostElementNode;
        return userObject;
    } // public Object createUserObject()
    
    public String getStepName()
    {
        return "Enter Host Attributes";
    } // public String getStepName()
} // public class HostElementWizardlet extends Wizardlet